/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import java.nio.file.Path;
import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.NamespaceOperations;
import org.apache.accumulo.core.client.admin.ReplicationOperations;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.security.Authorizations;

public interface AccumuloClient
extends AutoCloseable {
    public BatchScanner createBatchScanner(String var1, Authorizations var2, int var3) throws TableNotFoundException;

    public BatchScanner createBatchScanner(String var1, Authorizations var2) throws TableNotFoundException;

    public BatchScanner createBatchScanner(String var1) throws TableNotFoundException, AccumuloSecurityException, AccumuloException;

    public BatchDeleter createBatchDeleter(String var1, Authorizations var2, int var3, BatchWriterConfig var4) throws TableNotFoundException;

    public BatchDeleter createBatchDeleter(String var1, Authorizations var2, int var3) throws TableNotFoundException;

    public BatchWriter createBatchWriter(String var1, BatchWriterConfig var2) throws TableNotFoundException;

    public BatchWriter createBatchWriter(String var1) throws TableNotFoundException;

    public MultiTableBatchWriter createMultiTableBatchWriter(BatchWriterConfig var1);

    public MultiTableBatchWriter createMultiTableBatchWriter();

    public Scanner createScanner(String var1, Authorizations var2) throws TableNotFoundException;

    public Scanner createScanner(String var1) throws TableNotFoundException, AccumuloSecurityException, AccumuloException;

    public ConditionalWriter createConditionalWriter(String var1, ConditionalWriterConfig var2) throws TableNotFoundException;

    public String whoami();

    public TableOperations tableOperations();

    public NamespaceOperations namespaceOperations();

    public SecurityOperations securityOperations();

    public InstanceOperations instanceOperations();

    public ReplicationOperations replicationOperations();

    public Properties properties();

    @Override
    public void close();

    public static interface FromOptions<T>
    extends ConnectionOptions<T>,
    AuthenticationArgs<T> {
    }

    public static interface ConnectionOptions<T>
    extends ClientFactory<T> {
        public ConnectionOptions<T> zkTimeout(int var1);

        public SslOptions<T> useSsl();

        public SaslOptions<T> useSasl();

        public ConnectionOptions<T> batchWriterConfig(BatchWriterConfig var1);

        public ConnectionOptions<T> batchScannerQueryThreads(int var1);

        public ConnectionOptions<T> scannerBatchSize(int var1);
    }

    public static interface SaslOptions<T>
    extends ClientFactory<T> {
        public SaslOptions<T> primary(CharSequence var1);

        public SaslOptions<T> qop(CharSequence var1);
    }

    public static interface SslOptions<T>
    extends ClientFactory<T> {
        public SslOptions<T> truststore(CharSequence var1);

        public SslOptions<T> truststore(CharSequence var1, CharSequence var2, CharSequence var3);

        public SslOptions<T> keystore(CharSequence var1);

        public SslOptions<T> keystore(CharSequence var1, CharSequence var2, CharSequence var3);

        public SslOptions<T> useJsse();
    }

    public static interface AuthenticationArgs<T> {
        public ConnectionOptions<T> as(CharSequence var1, CharSequence var2);

        public ConnectionOptions<T> as(CharSequence var1, Path var2);

        public ConnectionOptions<T> as(CharSequence var1, AuthenticationToken var2);
    }

    public static interface PropertyOptions<T>
    extends InstanceArgs<T> {
        public FromOptions<T> from(String var1);

        public FromOptions<T> from(Path var1);

        public FromOptions<T> from(Properties var1);
    }

    public static interface InstanceArgs<T> {
        public AuthenticationArgs<T> to(CharSequence var1, CharSequence var2);
    }

    public static interface ClientFactory<T> {
        public T build();
    }
}

