import React from 'react';
import { Schema } from './Schema';
import { SchemaHelpers } from '../helpers';
export var Bindings = function (_a) {
    var _b = _a.name, name = _b === void 0 ? 'Binding specific information' : _b, bindings = _a.bindings;
    if (!bindings || bindings.isEmpty()) {
        return null;
    }
    var renderedBindings = bindings.all().map(function (binding) {
        var bindingValue = binding.value();
        var schema = SchemaHelpers.jsonToSchema(bindingValue);
        var protocol = binding.protocol();
        var schemaName = (React.createElement("div", { className: "inline-block text-sm" },
            React.createElement("span", null, name),
            React.createElement("strong", { className: "bg-teal-500 no-underline text-white uppercase rounded mx-2 px-2 py-1 text-xs" }, protocol)));
        return (schema !== undefined && (React.createElement(Schema, { schemaName: schemaName, schema: schema, key: protocol, onlyTitle: true })));
    });
    return React.createElement(React.Fragment, null, renderedBindings);
};
//# sourceMappingURL=Bindings.js.map