/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl;

import com.intellij.httpClient.execution.impl.engineV2.HttpRequestHandlerV2;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.compress.compressors.brotli.BrotliCompressorInputStream;
import org.apache.commons.compress.compressors.brotli.BrotliUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"createBrotliInputStream", "Ljava/io/InputStream;", "inputStream", "intellij.httpClient.executor"})
@JvmName(name="BrotliLoadingWorkaround")
@SourceDebugExtension(value={"SMAP\nBrotliLoadingWorkaround.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrotliLoadingWorkaround.kt\ncom/intellij/httpClient/execution/impl/BrotliLoadingWorkaround\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,25:1\n1#2:26\n*E\n"})
public final class BrotliLoadingWorkaround {
    @NotNull
    public static final InputStream createBrotliInputStream(@NotNull InputStream inputStream) {
        InputStream inputStream2;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        if (BrotliUtils.isBrotliCompressionAvailable()) {
            inputStream2 = (InputStream)new BrotliCompressorInputStream(inputStream);
        } else {
            Object v4;
            Object object;
            block5: {
                Class<?> brotliCompressInputStream = HttpRequestHandlerV2.class.getClassLoader().loadClass("org.brotli.dec.BrotliInputStream");
                Constructor<?>[] constructorArray = brotliCompressInputStream.getConstructors();
                Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getConstructors(...)");
                for (Object object2 : (Object[])constructorArray) {
                    Constructor it = (Constructor)object2;
                    boolean bl = false;
                    if (!(it.getParameterCount() == 1)) continue;
                    object = object2;
                    break block5;
                }
                object = null;
            }
            Constructor constructor = (Constructor)object;
            if (constructor != null) {
                Object[] objectArray = new Object[]{inputStream};
                v4 = constructor.newInstance(objectArray);
            } else {
                v4 = null;
            }
            Intrinsics.checkNotNull(v4, (String)"null cannot be cast to non-null type java.io.InputStream");
            inputStream2 = v4;
        }
        return inputStream2;
    }
}

