/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 10093458185091L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(285077250 - 32532, -285077250 - -((char)-4867), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(285077250 - 32531, -285077250 - -((char)-21511), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 122837408146270L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.q();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1343467500 + 10053, -1343467500 + -19692, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1343467500 + 10052, -1343467500 + -19276, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1343467500 + 10059, -1343467500 - -11083, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 78496696378776L;
                            Object object = this.lock;
                            synchronized (object) {
                                boolean bl3;
                                bl2 = SshAgentIpcService.q();
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(1874038860 + (char)-32348, 1874038860 + 29612, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1874038860 + (char)-32345, -1874038860 + -32063, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1874038860 + (char)-32346, 1874038860 + (char)-9775, (int)l2));
                                    this.hPipe = hANDLE;
                                    windowsNamedPipeAgentIpc = this;
                                    if (bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1874038860 + (char)-32335, 1874038860 + 28857, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1874038860 + (char)-32336, -1874038860 + -31046, (int)l2) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1874038860 + (char)-32333, 1874038860 + 31566, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1874038860 + (char)-32335, 1874038860 + 28857, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1874038860 + (char)-32334, 1874038860 + (char)-10355, (int)l2));
                            if (ActionTimestamp.q() != null) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.q(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 134598306718600L;
                    bl = SshAgentIpcService.Q();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (!bl) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (!bl) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        boolean bl;
        long l2;
        block27: {
            block28: {
                l2 = 17512932686162L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl2;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            bl = SshAgentIpcService.Q();
                            boolean bl3 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (!bl) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl4 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6485), 1943899170 + (char)-13560, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6489), -1943899170 + -((char)-10737), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6484), -1943899170 + -29927, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl2 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl2) {
                        boolean bl5 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6489), -1943899170 + -((char)-10737), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6483), 1943899170 + (char)-8038, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl6 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6485), 1943899170 + (char)-13560, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6489), -1943899170 + -((char)-10737), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6482), 1943899170 + (char)-13944, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (!bl) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl7 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6485), 1943899170 + (char)-13560, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6489), -1943899170 + -((char)-10737), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6481), 1943899170 + (char)-7891, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6489), -1943899170 + -((char)-10737), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6480), -1943899170 + -((char)-19510), (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl8;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl9 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (!bl) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl8 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl8) {
                boolean bl10 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6489), -1943899170 + -((char)-10737), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6483), 1943899170 + (char)-8038, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl11 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6485), 1943899170 + (char)-13560, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6489), -1943899170 + -((char)-10737), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1943899170 + -((char)-6479), -1943899170 + -((char)-32693), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 27330787054616L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1910214180 - -((char)-17406), -1910214180 - -((char)-15665), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 6338988119787L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(383641890 - (char)-17930, 383641890 - (char)-12997, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00e6\u00b8\u00fe{i\u00ce\"S\u00ad\u0012\u0012\u009c\u00ae\u00ee0R\u00f3c\u00fd\u0014\u00c6,\u00fa\u00ef\u00f2\u009e,\u00dc\u00ee\u00e5\u00bf\u00b6\u00d9R\u001fN\u00fb&\u00fb\u00b7";
                        var4_3 = "\u00e6\u00b8\u00fe{i\u00ce\"S\u00ad\u0012\u0012\u009c\u00ae\u00ee0R\u00f3c\u00fd\u0014\u00c6,\u00fa\u00ef\u00f2\u009e,\u00dc\u00ee\u00e5\u00bf\u00b6\u00d9R\u001fN\u00fb&\u00fb\u00b7".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 62;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 24;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 120;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 12;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 26;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 57;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 11;
                                        break;
                                    }
                                    default: {
                                        v11 = 7;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFB9C6) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 109;
                            case 1 -> 42;
                            case 2 -> 221;
                            case 3 -> 235;
                            case 4 -> 89;
                            case 5 -> 209;
                            case 6 -> 74;
                            case 7 -> 136;
                            case 8 -> 230;
                            case 9 -> 33;
                            case 10 -> 55;
                            case 11 -> 81;
                            case 12 -> 104;
                            case 13 -> 177;
                            case 14 -> 176;
                            case 15 -> 62;
                            case 16 -> 217;
                            case 17 -> 60;
                            case 18 -> 199;
                            case 19 -> 178;
                            case 20 -> 224;
                            case 21 -> 210;
                            case 22 -> 46;
                            case 23 -> 205;
                            case 24 -> 32;
                            case 25 -> 143;
                            case 26 -> 182;
                            case 27 -> 116;
                            case 28 -> 16;
                            case 29 -> 19;
                            case 30 -> 4;
                            case 31 -> 227;
                            case 32 -> 163;
                            case 33 -> 251;
                            case 34 -> 77;
                            case 35 -> 179;
                            case 36 -> 166;
                            case 37 -> 194;
                            case 38 -> 52;
                            case 39 -> 80;
                            case 40 -> 222;
                            case 41 -> 184;
                            case 42 -> 244;
                            case 43 -> 110;
                            case 44 -> 12;
                            case 45 -> 202;
                            case 46 -> 172;
                            case 47 -> 26;
                            case 48 -> 45;
                            case 49 -> 92;
                            case 50 -> 69;
                            case 51 -> 142;
                            case 52 -> 51;
                            case 53 -> 134;
                            case 54 -> 0;
                            case 55 -> 162;
                            case 56 -> 111;
                            case 57 -> 216;
                            case 58 -> 243;
                            case 59 -> 54;
                            case 60 -> 100;
                            case 61 -> 252;
                            case 62 -> 152;
                            case 63 -> 76;
                            case 64 -> 6;
                            case 65 -> 190;
                            case 66 -> 3;
                            case 67 -> 14;
                            case 68 -> 168;
                            case 69 -> 183;
                            case 70 -> 103;
                            case 71 -> 9;
                            case 72 -> 214;
                            case 73 -> 20;
                            case 74 -> 48;
                            case 75 -> 34;
                            case 76 -> 130;
                            case 77 -> 137;
                            case 78 -> 226;
                            case 79 -> 223;
                            case 80 -> 138;
                            case 81 -> 94;
                            case 82 -> 237;
                            case 83 -> 208;
                            case 84 -> 219;
                            case 85 -> 250;
                            case 86 -> 15;
                            case 87 -> 187;
                            case 88 -> 57;
                            case 89 -> 95;
                            case 90 -> 11;
                            case 91 -> 88;
                            case 92 -> 158;
                            case 93 -> 133;
                            case 94 -> 85;
                            case 95 -> 229;
                            case 96 -> 228;
                            case 97 -> 18;
                            case 98 -> 131;
                            case 99 -> 17;
                            case 100 -> 160;
                            case 101 -> 236;
                            case 102 -> 72;
                            case 103 -> 73;
                            case 104 -> 213;
                            case 105 -> 122;
                            case 106 -> 97;
                            case 107 -> 141;
                            case 108 -> 124;
                            case 109 -> 218;
                            case 110 -> 153;
                            case 111 -> 180;
                            case 112 -> 86;
                            case 113 -> 38;
                            case 114 -> 233;
                            case 115 -> 174;
                            case 116 -> 129;
                            case 117 -> 56;
                            case 118 -> 135;
                            case 119 -> 186;
                            case 120 -> 31;
                            case 121 -> 79;
                            case 122 -> 21;
                            case 123 -> 23;
                            case 124 -> 165;
                            case 125 -> 234;
                            case 126 -> 65;
                            case 127 -> 41;
                            case 128 -> 239;
                            case 129 -> 206;
                            case 130 -> 106;
                            case 131 -> 248;
                            case 132 -> 192;
                            case 133 -> 195;
                            case 134 -> 255;
                            case 135 -> 43;
                            case 136 -> 121;
                            case 137 -> 212;
                            case 138 -> 241;
                            case 139 -> 27;
                            case 140 -> 40;
                            case 141 -> 247;
                            case 142 -> 193;
                            case 143 -> 30;
                            case 144 -> 147;
                            case 145 -> 148;
                            case 146 -> 225;
                            case 147 -> 24;
                            case 148 -> 170;
                            case 149 -> 125;
                            case 150 -> 37;
                            case 151 -> 157;
                            case 152 -> 47;
                            case 153 -> 82;
                            case 154 -> 156;
                            case 155 -> 175;
                            case 156 -> 35;
                            case 157 -> 78;
                            case 158 -> 215;
                            case 159 -> 245;
                            case 160 -> 75;
                            case 161 -> 91;
                            case 162 -> 231;
                            case 163 -> 83;
                            case 164 -> 28;
                            case 165 -> 22;
                            case 166 -> 112;
                            case 167 -> 107;
                            case 168 -> 115;
                            case 169 -> 10;
                            case 170 -> 67;
                            case 171 -> 171;
                            case 172 -> 8;
                            case 173 -> 181;
                            case 174 -> 29;
                            case 175 -> 150;
                            case 176 -> 140;
                            case 177 -> 196;
                            case 178 -> 145;
                            case 179 -> 101;
                            case 180 -> 71;
                            case 181 -> 58;
                            case 182 -> 1;
                            case 183 -> 64;
                            case 184 -> 117;
                            case 185 -> 105;
                            case 186 -> 102;
                            case 187 -> 63;
                            case 188 -> 93;
                            case 189 -> 189;
                            case 190 -> 149;
                            case 191 -> 146;
                            case 192 -> 5;
                            case 193 -> 204;
                            case 194 -> 87;
                            case 195 -> 2;
                            case 196 -> 128;
                            case 197 -> 246;
                            case 198 -> 7;
                            case 199 -> 84;
                            case 200 -> 118;
                            case 201 -> 201;
                            case 202 -> 169;
                            case 203 -> 139;
                            case 204 -> 249;
                            case 205 -> 211;
                            case 206 -> 99;
                            case 207 -> 154;
                            case 208 -> 238;
                            case 209 -> 253;
                            case 210 -> 132;
                            case 211 -> 242;
                            case 212 -> 114;
                            case 213 -> 119;
                            case 214 -> 39;
                            case 215 -> 66;
                            case 216 -> 127;
                            case 217 -> 25;
                            case 218 -> 173;
                            case 219 -> 185;
                            case 220 -> 159;
                            case 221 -> 61;
                            case 222 -> 200;
                            case 223 -> 36;
                            case 224 -> 126;
                            case 225 -> 198;
                            case 226 -> 191;
                            case 227 -> 96;
                            case 228 -> 49;
                            case 229 -> 144;
                            case 230 -> 120;
                            case 231 -> 50;
                            case 232 -> 188;
                            case 233 -> 203;
                            case 234 -> 161;
                            case 235 -> 90;
                            case 236 -> 123;
                            case 237 -> 220;
                            case 238 -> 207;
                            case 239 -> 151;
                            case 240 -> 232;
                            case 241 -> 108;
                            case 242 -> 53;
                            case 243 -> 70;
                            case 244 -> 98;
                            case 245 -> 113;
                            case 246 -> 44;
                            case 247 -> 240;
                            case 248 -> 68;
                            case 249 -> 164;
                            case 250 -> 155;
                            case 251 -> 167;
                            case 252 -> 197;
                            case 253 -> 59;
                            case 254 -> 13;
                            default -> 254;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (!bl) {
                ActionTimestamp.q(new String[2]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 103166470735705L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.Q();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (!bl2) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1356312360 - 15344, -1356312360 - -22601, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1356312360 - 15340, 1356312360 - 19300, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1356312360 - 15361, 1356312360 - 14243, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1356312360 - 15344, -1356312360 - -22601, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1356312360 - 15340, 1356312360 - 19300, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1356312360 - 15368, 1356312360 - (char)-31569, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 6838476080936L;
                        boolean bl3 = SshAgentIpcService.q();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(888130320 + 26688, -888130320 + -27817, (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(888130320 + 26691, 888130320 + 13939, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 93484746899004L;
                boolean bl2 = SshAgentIpcService.q();
                this.assertConnectionThread();
                Object object2 = this.lock;
                bl = bl2;
                synchronized (object2) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl4 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(488760030 - (char)-26495, -488760030 - -29474, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(488760030 - (char)-26491, 488760030 - (char)-30659, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(488760030 - (char)-26472, 488760030 - (char)-17731, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(488760030 - (char)-26491, 488760030 - (char)-30659, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(488760030 - (char)-26497, -488760030 - -((char)-29008), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(488760030 - (char)-26495, -488760030 - -29474, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(488760030 - (char)-26491, 488760030 - (char)-30659, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(488760030 - (char)-26475, -488760030 - -((char)-28966), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl7 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(488760030 - (char)-26495, -488760030 - -29474, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(488760030 - (char)-26491, 488760030 - (char)-30659, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(488760030 - (char)-26474, 488760030 - (char)-14563, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl8 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl9 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(488760030 - (char)-26495, -488760030 - -29474, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(488760030 - (char)-26491, 488760030 - (char)-30659, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(488760030 - (char)-26477, 488760030 - (char)-27443, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 109367723492593L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                bl2 = SshAgentIpcService.Q();
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (!bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(676321200 - (char)-22752, -676321200 - -((char)-15815), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(676321200 - (char)-22756, 676321200 - (char)-18620, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(676321200 - (char)-22743, 676321200 - 32756, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(676321200 - (char)-22736, -676321200 - -31866, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(676321200 - (char)-22752, -676321200 - -((char)-15815), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(676321200 - (char)-22756, 676321200 - (char)-18620, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(676321200 - (char)-22737, 676321200 - (char)-20076, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (!bl2) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (!bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(676321200 - (char)-22752, -676321200 - -((char)-15815), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(676321200 - (char)-22756, 676321200 - (char)-18620, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(676321200 - (char)-22738, -676321200 - -((char)-24637), (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(676321200 - (char)-22752, -676321200 - -((char)-15815), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(676321200 - (char)-22756, 676321200 - (char)-18620, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(676321200 - (char)-22739, 676321200 - (char)-31679, (int)l2));
                    if (!bl2) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(676321200 - (char)-22752, -676321200 - -((char)-15815), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(676321200 - (char)-22756, 676321200 - (char)-18620, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(676321200 - (char)-22796, 676321200 - (char)-21658, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(676321200 - (char)-22797, 676321200 - (char)-15889, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00f4\"\u001bB'\u000fH\u00d7\u0014\t\u008e\u009c0)\u00c9&\u0015C\u00dc@\u00dc,\u0090\f\u00aa\u00ff\u00a2\u00a9;\u0006)[\u00a0m:\u00ab\u0018RK\u0097\u00b8\u00ca\u001dXOD\u00ea\u00afj\u00b7\u00b9-\rr?6\u0015\u00f9\u00db\u00a2\u0004\t\u0082\u00fa\u0013?1r?\u00ea\u0094\u0005\u0004\u00ca\u0005_\u0094\b/F`\u00bf\u001a\u0096\u00e9\u0006\u0014\u0091w\u00f7\u0094)U\u0013\u0011\u008b\u0081\u00f2\u00c30\u00d04O\u00ea\u00cd\u00f2\u0094\u0005F\u00cbM\u007f\u009d\u001e\u00b4\u00dc\u0006\u00f9i\u00f1\u008e\u00a8;\u0002\u000b\u00f0o\u00ca\u0094\u0007\u00a4\u00ef>\u00fbT)\u001b\u0097\u001c\u0010\u00f3\u00d3#\u00c6\u0010C\u00b0\u001c\u00b1}\u00ca\u00fa6\u00c8c\u00f8!\u0017\u00a54u\tnnX\u00bc\u000b%^\u009fV\u0010\u0086\u0003\u00a4\u00c7j\u0004\u0018\u00ef\u0094XsFfI\u001a\u00e8?\u00a9\f\u00ad\u00e3\u0011\u00bb\u0004\u008d\u001bwJ\u00a5\u00f8\u0096[\u00b5\u0098\u00dc\u00c4X\u0085\u000fZ5$\u00ac\u00f9\u00f0U\u00f4\u00a6\u00ef\u001cMI\u00da\u00b8;C.\b\u00ec\u00d8\u00db\u00f1\u007f\u0098\u00d73r\"\u00eb\ths\u00df\u00a7`/W\u0001-e\b\u00f1\u00e9\u00bbJa(\u0086\u00d1\f}n:\u00a1L7\u00cd5\u0007KS F*\u0094\u00d0\u00fe\u0011\u00dcfHr\u00e8\u00f7\u0090\u00d98`F\u0003\u00c5\u00b7\u00d4\u00f9\u00cc\u00d6\u007f\u0083\u00ce\u00fe\u00b7\n5w\u00eb\u001a{K=\"\u008a\u00bb\u00dc\u0084\u00a7\u00c2Il\u00a8\u007fP(z'@F\u008b\u008c\u00b8\u00c7\u00f8\u00b5\u00f8a\u00b15\u00cf\u008d\u00d6\u000f1$\u0085\u001f\\\u000e\u001b\u00a3\u00ca\u00ba\u00fa\u00c1\u00b5/\u00daUUc\u00d8\u0083V\u0097\u001d>\u00fb\u00119;9U@\u00b7H\u00bb=\u000bH\u00c4\u009c\u00f4\u0098\u009dW`T\u00ed3\u0015\u000f\u00dct\u00f4\u0082\u00f5\u00f8\u0010\u009f\u0003\u0082\u001b\u00e0\u0006sy\u00d8\\\u0011>L),\u00e4\u0015\u00fe\u000b\u0011\u00c2\u00b4\u00b2\u0081:\u0080M\u00d3E\u0090\u00ba}[\u00c4\u00c36\u00f8\u00c7n\u0083}\u0015\u00c0\u001b\u00ae\u0010\u00df\u00a1\u0095\u00eb\u00e7M\u0088\u008dA\u0007c\u009c\u00f6\u00ebS\u00eeR\u0007\u001b\u00a3\u009d`\u00d9p\u0015(\u00d7\u00fa&\u001c\u00dd'\u00eeUGj\u00ae\u00cb\u00fc;1\u000e3\u0003\u00c4HQ\u0099\u00c5\u00f9Y\u00f8-\u0001\u00fd\u00f9\u00d2U\u00abb\u0085>_\u008a\f\u0086\u000f\u00fd\u00cf-\u0093T\u00baz%\u00a0\u00e9\u00f3\u00ea\u00f7K\u00ce\"\u00a7Xdi%\u00e3\u0007\u00ea\nJ-\u00f9\u00ac\u00f0\u001d:Z\u0001\u00cd\t\u00fb\u008f_\u00a0\t;\\\u00dc\u00c0\u0010\fv\u00a5\u009e\u000eP*\u0098/\u00e2-\u00ac\u00d7z\u00b7\u00a8!\u00908\u001b\u00cd\u00cc,\u00f6\u008f\u00a3\u0094Z*\u0081/\u00e60\u00f6\u00a8\u00ecDq\u00b3\u009b\u000f\u00e9\u00b2\u00ca\u00ff\u001b\u00d7\n\u00adQ\u00e4B\u0082\u00d1\u00e6>\u00cfo\u0018kQ\u00f8H\u0014\u00c8\u00c6i~.g\u008c\u0080\u00e8B\u000en,!I%\u00f8\u00ac\u00bb)\u001b\n\u00f3#\u00d7\u00aaY\u00c3\u00c1oT]\u0084a\u00e3\u00bd\u0010\u00ad\u00d1\u001b\u00a8\u00dd\u00dc\u00b6\u009f?\u00den\u00e7(\u00f1\u00e7\u0011\u0081\u0099{\u00b8{cK<\t\u00e8T\u0088\u00e5\u001b\u00c1\nXa";
                var4_3 = "\u00f4\"\u001bB'\u000fH\u00d7\u0014\t\u008e\u009c0)\u00c9&\u0015C\u00dc@\u00dc,\u0090\f\u00aa\u00ff\u00a2\u00a9;\u0006)[\u00a0m:\u00ab\u0018RK\u0097\u00b8\u00ca\u001dXOD\u00ea\u00afj\u00b7\u00b9-\rr?6\u0015\u00f9\u00db\u00a2\u0004\t\u0082\u00fa\u0013?1r?\u00ea\u0094\u0005\u0004\u00ca\u0005_\u0094\b/F`\u00bf\u001a\u0096\u00e9\u0006\u0014\u0091w\u00f7\u0094)U\u0013\u0011\u008b\u0081\u00f2\u00c30\u00d04O\u00ea\u00cd\u00f2\u0094\u0005F\u00cbM\u007f\u009d\u001e\u00b4\u00dc\u0006\u00f9i\u00f1\u008e\u00a8;\u0002\u000b\u00f0o\u00ca\u0094\u0007\u00a4\u00ef>\u00fbT)\u001b\u0097\u001c\u0010\u00f3\u00d3#\u00c6\u0010C\u00b0\u001c\u00b1}\u00ca\u00fa6\u00c8c\u00f8!\u0017\u00a54u\tnnX\u00bc\u000b%^\u009fV\u0010\u0086\u0003\u00a4\u00c7j\u0004\u0018\u00ef\u0094XsFfI\u001a\u00e8?\u00a9\f\u00ad\u00e3\u0011\u00bb\u0004\u008d\u001bwJ\u00a5\u00f8\u0096[\u00b5\u0098\u00dc\u00c4X\u0085\u000fZ5$\u00ac\u00f9\u00f0U\u00f4\u00a6\u00ef\u001cMI\u00da\u00b8;C.\b\u00ec\u00d8\u00db\u00f1\u007f\u0098\u00d73r\"\u00eb\ths\u00df\u00a7`/W\u0001-e\b\u00f1\u00e9\u00bbJa(\u0086\u00d1\f}n:\u00a1L7\u00cd5\u0007KS F*\u0094\u00d0\u00fe\u0011\u00dcfHr\u00e8\u00f7\u0090\u00d98`F\u0003\u00c5\u00b7\u00d4\u00f9\u00cc\u00d6\u007f\u0083\u00ce\u00fe\u00b7\n5w\u00eb\u001a{K=\"\u008a\u00bb\u00dc\u0084\u00a7\u00c2Il\u00a8\u007fP(z'@F\u008b\u008c\u00b8\u00c7\u00f8\u00b5\u00f8a\u00b15\u00cf\u008d\u00d6\u000f1$\u0085\u001f\\\u000e\u001b\u00a3\u00ca\u00ba\u00fa\u00c1\u00b5/\u00daUUc\u00d8\u0083V\u0097\u001d>\u00fb\u00119;9U@\u00b7H\u00bb=\u000bH\u00c4\u009c\u00f4\u0098\u009dW`T\u00ed3\u0015\u000f\u00dct\u00f4\u0082\u00f5\u00f8\u0010\u009f\u0003\u0082\u001b\u00e0\u0006sy\u00d8\\\u0011>L),\u00e4\u0015\u00fe\u000b\u0011\u00c2\u00b4\u00b2\u0081:\u0080M\u00d3E\u0090\u00ba}[\u00c4\u00c36\u00f8\u00c7n\u0083}\u0015\u00c0\u001b\u00ae\u0010\u00df\u00a1\u0095\u00eb\u00e7M\u0088\u008dA\u0007c\u009c\u00f6\u00ebS\u00eeR\u0007\u001b\u00a3\u009d`\u00d9p\u0015(\u00d7\u00fa&\u001c\u00dd'\u00eeUGj\u00ae\u00cb\u00fc;1\u000e3\u0003\u00c4HQ\u0099\u00c5\u00f9Y\u00f8-\u0001\u00fd\u00f9\u00d2U\u00abb\u0085>_\u008a\f\u0086\u000f\u00fd\u00cf-\u0093T\u00baz%\u00a0\u00e9\u00f3\u00ea\u00f7K\u00ce\"\u00a7Xdi%\u00e3\u0007\u00ea\nJ-\u00f9\u00ac\u00f0\u001d:Z\u0001\u00cd\t\u00fb\u008f_\u00a0\t;\\\u00dc\u00c0\u0010\fv\u00a5\u009e\u000eP*\u0098/\u00e2-\u00ac\u00d7z\u00b7\u00a8!\u00908\u001b\u00cd\u00cc,\u00f6\u008f\u00a3\u0094Z*\u0081/\u00e60\u00f6\u00a8\u00ecDq\u00b3\u009b\u000f\u00e9\u00b2\u00ca\u00ff\u001b\u00d7\n\u00adQ\u00e4B\u0082\u00d1\u00e6>\u00cfo\u0018kQ\u00f8H\u0014\u00c8\u00c6i~.g\u008c\u0080\u00e8B\u000en,!I%\u00f8\u00ac\u00bb)\u001b\n\u00f3#\u00d7\u00aaY\u00c3\u00c1oT]\u0084a\u00e3\u00bd\u0010\u00ad\u00d1\u001b\u00a8\u00dd\u00dc\u00b6\u009f?\u00den\u00e7(\u00f1\u00e7\u0011\u0081\u0099{\u00b8{cK<\t\u00e8T\u0088\u00e5\u001b\u00c1\nXa".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 15;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00ab\u00034\u00d3\u00fee\u00ad\u00eb\u008e\u00bbl\u0016R\u00d9\u00e8{\u00a0\u00a8F\u00ee\u00de\u008d0\u00b3xRbW1\u0014D}\u00e4\u009f\u00f7\u00ed,@\u00d3\u00a7\u0083b\u0085\u0096\u00e8\u00bb\u00b2Q\u00d1\u0094";
                    var4_3 = "\u00ab\u00034\u00d3\u00fee\u00ad\u00eb\u008e\u00bbl\u0016R\u00d9\u00e8{\u00a0\u00a8F\u00ee\u00de\u008d0\u00b3xRbW1\u0014D}\u00e4\u009f\u00f7\u00ed,@\u00d3\u00a7\u0083b\u0085\u0096\u00e8\u00bb\u00b2Q\u00d1\u0094".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 56;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 88;
                            break;
                        }
                        case 1: {
                            v15 = 69;
                            break;
                        }
                        case 2: {
                            v15 = 110;
                            break;
                        }
                        case 3: {
                            v15 = 97;
                            break;
                        }
                        case 4: {
                            v15 = 73;
                            break;
                        }
                        case 5: {
                            v15 = 45;
                            break;
                        }
                        default: {
                            v15 = 69;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x346D) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 141;
                case 1 -> 19;
                case 2 -> 95;
                case 3 -> 185;
                case 4 -> 31;
                case 5 -> 113;
                case 6 -> 71;
                case 7 -> 240;
                case 8 -> 79;
                case 9 -> 34;
                case 10 -> 197;
                case 11 -> 21;
                case 12 -> 50;
                case 13 -> 221;
                case 14 -> 201;
                case 15 -> 70;
                case 16 -> 105;
                case 17 -> 60;
                case 18 -> 18;
                case 19 -> 127;
                case 20 -> 143;
                case 21 -> 65;
                case 22 -> 238;
                case 23 -> 167;
                case 24 -> 75;
                case 25 -> 128;
                case 26 -> 94;
                case 27 -> 200;
                case 28 -> 213;
                case 29 -> 236;
                case 30 -> 152;
                case 31 -> 156;
                case 32 -> 146;
                case 33 -> 66;
                case 34 -> 63;
                case 35 -> 184;
                case 36 -> 195;
                case 37 -> 145;
                case 38 -> 45;
                case 39 -> 1;
                case 40 -> 12;
                case 41 -> 253;
                case 42 -> 232;
                case 43 -> 47;
                case 44 -> 234;
                case 45 -> 89;
                case 46 -> 150;
                case 47 -> 55;
                case 48 -> 209;
                case 49 -> 188;
                case 50 -> 14;
                case 51 -> 216;
                case 52 -> 43;
                case 53 -> 57;
                case 54 -> 117;
                case 55 -> 115;
                case 56 -> 172;
                case 57 -> 62;
                case 58 -> 227;
                case 59 -> 208;
                case 60 -> 231;
                case 61 -> 24;
                case 62 -> 13;
                case 63 -> 137;
                case 64 -> 116;
                case 65 -> 2;
                case 66 -> 163;
                case 67 -> 176;
                case 68 -> 32;
                case 69 -> 179;
                case 70 -> 88;
                case 71 -> 139;
                case 72 -> 69;
                case 73 -> 235;
                case 74 -> 248;
                case 75 -> 246;
                case 76 -> 108;
                case 77 -> 136;
                case 78 -> 5;
                case 79 -> 237;
                case 80 -> 74;
                case 81 -> 49;
                case 82 -> 97;
                case 83 -> 61;
                case 84 -> 121;
                case 85 -> 138;
                case 86 -> 64;
                case 87 -> 126;
                case 88 -> 122;
                case 89 -> 229;
                case 90 -> 162;
                case 91 -> 211;
                case 92 -> 220;
                case 93 -> 38;
                case 94 -> 93;
                case 95 -> 46;
                case 96 -> 199;
                case 97 -> 53;
                case 98 -> 133;
                case 99 -> 111;
                case 100 -> 160;
                case 101 -> 37;
                case 102 -> 144;
                case 103 -> 118;
                case 104 -> 33;
                case 105 -> 9;
                case 106 -> 230;
                case 107 -> 174;
                case 108 -> 233;
                case 109 -> 100;
                case 110 -> 80;
                case 111 -> 72;
                case 112 -> 250;
                case 113 -> 3;
                case 114 -> 183;
                case 115 -> 182;
                case 116 -> 191;
                case 117 -> 203;
                case 118 -> 28;
                case 119 -> 254;
                case 120 -> 171;
                case 121 -> 109;
                case 122 -> 177;
                case 123 -> 223;
                case 124 -> 169;
                case 125 -> 214;
                case 126 -> 104;
                case 127 -> 11;
                case 128 -> 125;
                case 129 -> 30;
                case 130 -> 96;
                case 131 -> 217;
                case 132 -> 140;
                case 133 -> 159;
                case 134 -> 161;
                case 135 -> 242;
                case 136 -> 90;
                case 137 -> 166;
                case 138 -> 91;
                case 139 -> 135;
                case 140 -> 249;
                case 141 -> 155;
                case 142 -> 86;
                case 143 -> 110;
                case 144 -> 123;
                case 145 -> 103;
                case 146 -> 39;
                case 147 -> 76;
                case 148 -> 124;
                case 149 -> 245;
                case 150 -> 212;
                case 151 -> 149;
                case 152 -> 154;
                case 153 -> 243;
                case 154 -> 173;
                case 155 -> 178;
                case 156 -> 83;
                case 157 -> 198;
                case 158 -> 219;
                case 159 -> 129;
                case 160 -> 244;
                case 161 -> 192;
                case 162 -> 130;
                case 163 -> 165;
                case 164 -> 15;
                case 165 -> 247;
                case 166 -> 82;
                case 167 -> 207;
                case 168 -> 119;
                case 169 -> 215;
                case 170 -> 48;
                case 171 -> 68;
                case 172 -> 102;
                case 173 -> 87;
                case 174 -> 54;
                case 175 -> 218;
                case 176 -> 107;
                case 177 -> 73;
                case 178 -> 4;
                case 179 -> 27;
                case 180 -> 153;
                case 181 -> 16;
                case 182 -> 99;
                case 183 -> 42;
                case 184 -> 175;
                case 185 -> 56;
                case 186 -> 255;
                case 187 -> 132;
                case 188 -> 181;
                case 189 -> 131;
                case 190 -> 189;
                case 191 -> 25;
                case 192 -> 158;
                case 193 -> 10;
                case 194 -> 186;
                case 195 -> 196;
                case 196 -> 147;
                case 197 -> 35;
                case 198 -> 0;
                case 199 -> 44;
                case 200 -> 226;
                case 201 -> 164;
                case 202 -> 81;
                case 203 -> 202;
                case 204 -> 59;
                case 205 -> 23;
                case 206 -> 170;
                case 207 -> 180;
                case 208 -> 168;
                case 209 -> 194;
                case 210 -> 148;
                case 211 -> 252;
                case 212 -> 77;
                case 213 -> 8;
                case 214 -> 210;
                case 215 -> 114;
                case 216 -> 239;
                case 217 -> 84;
                case 218 -> 241;
                case 219 -> 22;
                case 220 -> 40;
                case 221 -> 41;
                case 222 -> 157;
                case 223 -> 228;
                case 224 -> 7;
                case 225 -> 142;
                case 226 -> 204;
                case 227 -> 29;
                case 228 -> 106;
                case 229 -> 78;
                case 230 -> 58;
                case 231 -> 120;
                case 232 -> 134;
                case 233 -> 36;
                case 234 -> 206;
                case 235 -> 151;
                case 236 -> 92;
                case 237 -> 6;
                case 238 -> 52;
                case 239 -> 205;
                case 240 -> 51;
                case 241 -> 67;
                case 242 -> 193;
                case 243 -> 112;
                case 244 -> 224;
                case 245 -> 222;
                case 246 -> 20;
                case 247 -> 17;
                case 248 -> 85;
                case 249 -> 187;
                case 250 -> 101;
                case 251 -> 190;
                case 252 -> 26;
                case 253 -> 98;
                case 254 -> 225;
                default -> 251;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 4623853838458L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1825936170 + 25801, 1825936170 + 15704, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 86918906342174L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.Q();
                            try {
                                hANDLE2 = hANDLE;
                                if (!bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (!bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1653185910 - -((char)-26100), 1653185910 - 13446, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1653185910 - -((char)-26101), -1653185910 - -8381, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1653185910 - -((char)-26102), 1653185910 - (char)-30769, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u008d'm\u0019\u00c6g\u00c8q\u0010\u00f1\u0093\u0013.\u00b3:\u009f\u0083\u001f\u008c\u00f9\u00f34C\u00fb\u00d2";
                    var4_3 = "\u008d'm\u0019\u00c6g\u00c8q\u0010\u00f1\u0093\u0013.\u00b3:\u009f\u0083\u001f\u008c\u00f9\u00f34C\u00fb\u00d2".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 36;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "$\u00e7v/\u00fb5\u00ac:p\u00f8\u00e9\u00f7\u00e2\u00bf\u00e9\u009e\u009b_\u00a1\u0012b\\\u00d6\u00fd\u009b\u00c0\u00e0\u001c\u000ft:*\b\u0098~\u009cep\u0099/oR\u00ecwX\u00cd\u00f6-\u0015^j\u00f1\u0018\u00b9\u0005\u00cc\u00a2n\u0089";
                        var4_3 = "$\u00e7v/\u00fb5\u00ac:p\u00f8\u00e9\u00f7\u00e2\u00bf\u00e9\u009e\u009b_\u00a1\u0012b\\\u00d6\u00fd\u009b\u00c0\u00e0\u001c\u000ft:*\b\u0098~\u009cep\u0099/oR\u00ecwX\u00cd\u00f6-\u0015^j\u00f1\u0018\u00b9\u0005\u00cc\u00a2n\u0089".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 70;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 121;
                                break;
                            }
                            case 1: {
                                v15 = 50;
                                break;
                            }
                            case 2: {
                                v15 = 93;
                                break;
                            }
                            case 3: {
                                v15 = 58;
                                break;
                            }
                            case 4: {
                                v15 = 78;
                                break;
                            }
                            case 5: {
                                v15 = 11;
                                break;
                            }
                            default: {
                                v15 = 87;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF9789) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 166;
                    case 1 -> 124;
                    case 2 -> 31;
                    case 3 -> 149;
                    case 4 -> 53;
                    case 5 -> 226;
                    case 6 -> 62;
                    case 7 -> 123;
                    case 8 -> 163;
                    case 9 -> 254;
                    case 10 -> 127;
                    case 11 -> 248;
                    case 12 -> 73;
                    case 13 -> 175;
                    case 14 -> 179;
                    case 15 -> 189;
                    case 16 -> 247;
                    case 17 -> 223;
                    case 18 -> 133;
                    case 19 -> 45;
                    case 20 -> 229;
                    case 21 -> 114;
                    case 22 -> 118;
                    case 23 -> 96;
                    case 24 -> 84;
                    case 25 -> 4;
                    case 26 -> 230;
                    case 27 -> 238;
                    case 28 -> 237;
                    case 29 -> 19;
                    case 30 -> 138;
                    case 31 -> 116;
                    case 32 -> 213;
                    case 33 -> 20;
                    case 34 -> 185;
                    case 35 -> 141;
                    case 36 -> 7;
                    case 37 -> 135;
                    case 38 -> 207;
                    case 39 -> 65;
                    case 40 -> 232;
                    case 41 -> 195;
                    case 42 -> 144;
                    case 43 -> 15;
                    case 44 -> 98;
                    case 45 -> 97;
                    case 46 -> 94;
                    case 47 -> 28;
                    case 48 -> 165;
                    case 49 -> 148;
                    case 50 -> 250;
                    case 51 -> 174;
                    case 52 -> 153;
                    case 53 -> 112;
                    case 54 -> 215;
                    case 55 -> 134;
                    case 56 -> 172;
                    case 57 -> 82;
                    case 58 -> 30;
                    case 59 -> 79;
                    case 60 -> 236;
                    case 61 -> 100;
                    case 62 -> 75;
                    case 63 -> 80;
                    case 64 -> 200;
                    case 65 -> 41;
                    case 66 -> 105;
                    case 67 -> 101;
                    case 68 -> 42;
                    case 69 -> 161;
                    case 70 -> 201;
                    case 71 -> 50;
                    case 72 -> 154;
                    case 73 -> 5;
                    case 74 -> 36;
                    case 75 -> 109;
                    case 76 -> 72;
                    case 77 -> 206;
                    case 78 -> 64;
                    case 79 -> 103;
                    case 80 -> 158;
                    case 81 -> 228;
                    case 82 -> 74;
                    case 83 -> 122;
                    case 84 -> 43;
                    case 85 -> 167;
                    case 86 -> 6;
                    case 87 -> 58;
                    case 88 -> 221;
                    case 89 -> 32;
                    case 90 -> 60;
                    case 91 -> 95;
                    case 92 -> 8;
                    case 93 -> 196;
                    case 94 -> 197;
                    case 95 -> 18;
                    case 96 -> 23;
                    case 97 -> 194;
                    case 98 -> 121;
                    case 99 -> 78;
                    case 100 -> 243;
                    case 101 -> 44;
                    case 102 -> 25;
                    case 103 -> 12;
                    case 104 -> 176;
                    case 105 -> 146;
                    case 106 -> 156;
                    case 107 -> 186;
                    case 108 -> 160;
                    case 109 -> 137;
                    case 110 -> 57;
                    case 111 -> 69;
                    case 112 -> 128;
                    case 113 -> 244;
                    case 114 -> 145;
                    case 115 -> 159;
                    case 116 -> 227;
                    case 117 -> 220;
                    case 118 -> 140;
                    case 119 -> 56;
                    case 120 -> 77;
                    case 121 -> 27;
                    case 122 -> 240;
                    case 123 -> 117;
                    case 124 -> 129;
                    case 125 -> 24;
                    case 126 -> 214;
                    case 127 -> 164;
                    case 128 -> 216;
                    case 129 -> 178;
                    case 130 -> 169;
                    case 131 -> 86;
                    case 132 -> 46;
                    case 133 -> 139;
                    case 134 -> 157;
                    case 135 -> 132;
                    case 136 -> 102;
                    case 137 -> 10;
                    case 138 -> 239;
                    case 139 -> 104;
                    case 140 -> 190;
                    case 141 -> 198;
                    case 142 -> 107;
                    case 143 -> 113;
                    case 144 -> 90;
                    case 145 -> 173;
                    case 146 -> 59;
                    case 147 -> 16;
                    case 148 -> 218;
                    case 149 -> 152;
                    case 150 -> 85;
                    case 151 -> 40;
                    case 152 -> 181;
                    case 153 -> 208;
                    case 154 -> 22;
                    case 155 -> 51;
                    case 156 -> 70;
                    case 157 -> 155;
                    case 158 -> 177;
                    case 159 -> 222;
                    case 160 -> 0;
                    case 161 -> 37;
                    case 162 -> 119;
                    case 163 -> 192;
                    case 164 -> 89;
                    case 165 -> 11;
                    case 166 -> 3;
                    case 167 -> 253;
                    case 168 -> 61;
                    case 169 -> 67;
                    case 170 -> 235;
                    case 171 -> 131;
                    case 172 -> 35;
                    case 173 -> 225;
                    case 174 -> 202;
                    case 175 -> 108;
                    case 176 -> 245;
                    case 177 -> 38;
                    case 178 -> 13;
                    case 179 -> 54;
                    case 180 -> 203;
                    case 181 -> 33;
                    case 182 -> 63;
                    case 183 -> 47;
                    case 184 -> 187;
                    case 185 -> 126;
                    case 186 -> 110;
                    case 187 -> 205;
                    case 188 -> 9;
                    case 189 -> 184;
                    case 190 -> 183;
                    case 191 -> 171;
                    case 192 -> 170;
                    case 193 -> 99;
                    case 194 -> 219;
                    case 195 -> 81;
                    case 196 -> 150;
                    case 197 -> 182;
                    case 198 -> 48;
                    case 199 -> 246;
                    case 200 -> 210;
                    case 201 -> 1;
                    case 202 -> 21;
                    case 203 -> 151;
                    case 204 -> 68;
                    case 205 -> 252;
                    case 206 -> 233;
                    case 207 -> 180;
                    case 208 -> 88;
                    case 209 -> 204;
                    case 210 -> 168;
                    case 211 -> 211;
                    case 212 -> 93;
                    case 213 -> 143;
                    case 214 -> 142;
                    case 215 -> 17;
                    case 216 -> 120;
                    case 217 -> 66;
                    case 218 -> 191;
                    case 219 -> 130;
                    case 220 -> 217;
                    case 221 -> 162;
                    case 222 -> 188;
                    case 223 -> 55;
                    case 224 -> 193;
                    case 225 -> 92;
                    case 226 -> 49;
                    case 227 -> 212;
                    case 228 -> 125;
                    case 229 -> 91;
                    case 230 -> 14;
                    case 231 -> 111;
                    case 232 -> 87;
                    case 233 -> 34;
                    case 234 -> 29;
                    case 235 -> 251;
                    case 236 -> 136;
                    case 237 -> 234;
                    case 238 -> 249;
                    case 239 -> 83;
                    case 240 -> 242;
                    case 241 -> 231;
                    case 242 -> 106;
                    case 243 -> 255;
                    case 244 -> 199;
                    case 245 -> 147;
                    case 246 -> 224;
                    case 247 -> 2;
                    case 248 -> 26;
                    case 249 -> 241;
                    case 250 -> 52;
                    case 251 -> 39;
                    case 252 -> 115;
                    case 253 -> 76;
                    case 254 -> 209;
                    default -> 71;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 69986700757850L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "-gBd*B:t\t*mQng\u0000'h+";
                    var5_4 = "-gBd*B:t\t*mQng\u0000'h+".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 39;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 97;
                                    break;
                                }
                                case 1: {
                                    v11 = 37;
                                    break;
                                }
                                case 2: {
                                    v11 = 23;
                                    break;
                                }
                                case 3: {
                                    v11 = 45;
                                    break;
                                }
                                case 4: {
                                    v11 = 104;
                                    break;
                                }
                                case 5: {
                                    v11 = 9;
                                    break;
                                }
                                default: {
                                    v11 = 46;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 72705309509624L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "8E{^\u0013\u0000e\u0004>[wD\n2D|D\u001f\u0002}\u0018Eu\t2D|D\u001f\u0002}\u0014O\r5BaI\u0015\u000fg\u0014HfC\u0014\u0006";
                    var5_4 = "8E{^\u0013\u0000e\u0004>[wD\n2D|D\u001f\u0002}\u0018Eu\t2D|D\u001f\u0002}\u0014O\r5BaI\u0015\u000fg\u0014HfC\u0014\u0006".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 66;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u001aoUq;'F\u0006\u001aoUq7-";
                        var5_4 = "\u001aoUq;'F\u0006\u001aoUq7-".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 106;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 51;
                                break;
                            }
                            case 1: {
                                v15 = 105;
                                break;
                            }
                            case 2: {
                                v15 = 80;
                                break;
                            }
                            case 3: {
                                v15 = 104;
                                break;
                            }
                            case 4: {
                                v15 = 56;
                                break;
                            }
                            case 5: {
                                v15 = 35;
                                break;
                            }
                            default: {
                                v15 = 75;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 61896082231049L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1308602880 - -((char)-17596), -1308471810 + -((char)-210), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 47213443167590L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00bf\u009e\u00fc\u009c\u00ea\u0003\u00a9\u0086\u008a\u0005e?\u0081l\u00a6\r\u00af\u00a6\u00ee\u0015\u00be\u00f8%V\u001cC\f\u00ca\\\u0010\u00a1\u00d6\u00e8\u00f0A\u00d1\u00f1NO\u00c4\u0085w\u008b\u00e3\u00bc[\u0005,v\u00a8E\u00833\u009d\u0006\u008f<x\f\u00e6\u00e1\u00d0\u00cc\u00fd_B\u00b7\u00a9\u00ce@\u00ec\u009d\u00fc\u0099\u0003\u00f5\u00c0\u00f6\u0080f\u0085\u009388\u00e1P\u00a5\u00a8\u00f6]~\u0086E\u00aex\u0091uT\u00be\u0012d\u00d3\u00d9;";
                    var4_3 = "\u00bf\u009e\u00fc\u009c\u00ea\u0003\u00a9\u0086\u008a\u0005e?\u0081l\u00a6\r\u00af\u00a6\u00ee\u0015\u00be\u00f8%V\u001cC\f\u00ca\\\u0010\u00a1\u00d6\u00e8\u00f0A\u00d1\u00f1NO\u00c4\u0085w\u008b\u00e3\u00bc[\u0005,v\u00a8E\u00833\u009d\u0006\u008f<x\f\u00e6\u00e1\u00d0\u00cc\u00fd_B\u00b7\u00a9\u00ce@\u00ec\u009d\u00fc\u0099\u0003\u00f5\u00c0\u00f6\u0080f\u0085\u009388\u00e1P\u00a5\u00a8\u00f6]~\u0086E\u00aex\u0091uT\u00be\u0012d\u00d3\u00d9;".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 63;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00c8\u00a3\u0011\u008a\u00aaJX\u00e9\u00ae\u00e4m\u00a7B-QVL\u00c1\u00d5\u00c7\u008eZ\u0002(\u008e)\u009b1\u00f1\u00c7ir\u00a7\u00ea\u00c4\u00e3\u00db\u00eaWe<\u0013 +\u0083\u0014e\u00f3\u00f1\u00ed\u009d\u00ba9\u00f9\u008d\u00fc\u0089\u0003\u00c8?\u00ca@C\u008f7FS\u00b5\u0002\u008d\u00fa\u00fb'}\u0099\u00c7\b^Y~h\u00a3^i7\u00a6J\b\u0013Jm\u00fay";
                        var4_3 = "\u00c8\u00a3\u0011\u008a\u00aaJX\u00e9\u00ae\u00e4m\u00a7B-QVL\u00c1\u00d5\u00c7\u008eZ\u0002(\u008e)\u009b1\u00f1\u00c7ir\u00a7\u00ea\u00c4\u00e3\u00db\u00eaWe<\u0013 +\u0083\u0014e\u00f3\u00f1\u00ed\u009d\u00ba9\u00f9\u008d\u00fc\u0089\u0003\u00c8?\u00ca@C\u008f7FS\u00b5\u0002\u008d\u00fa\u00fb'}\u0099\u00c7\b^Y~h\u00a3^i7\u00a6J\b\u0013Jm\u00fay".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 41;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 20;
                                break;
                            }
                            case 1: {
                                v15 = 27;
                                break;
                            }
                            case 2: {
                                v15 = 121;
                                break;
                            }
                            case 3: {
                                v15 = 17;
                                break;
                            }
                            case 4: {
                                v15 = 63;
                                break;
                            }
                            case 5: {
                                v15 = 38;
                                break;
                            }
                            default: {
                                v15 = 49;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF864D) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 72;
                    case 1 -> 24;
                    case 2 -> 223;
                    case 3 -> 103;
                    case 4 -> 20;
                    case 5 -> 29;
                    case 6 -> 234;
                    case 7 -> 78;
                    case 8 -> 102;
                    case 9 -> 94;
                    case 10 -> 145;
                    case 11 -> 6;
                    case 12 -> 248;
                    case 13 -> 216;
                    case 14 -> 14;
                    case 15 -> 180;
                    case 16 -> 51;
                    case 17 -> 172;
                    case 18 -> 109;
                    case 19 -> 39;
                    case 20 -> 4;
                    case 21 -> 15;
                    case 22 -> 168;
                    case 23 -> 43;
                    case 24 -> 217;
                    case 25 -> 48;
                    case 26 -> 98;
                    case 27 -> 27;
                    case 28 -> 194;
                    case 29 -> 67;
                    case 30 -> 196;
                    case 31 -> 69;
                    case 32 -> 174;
                    case 33 -> 225;
                    case 34 -> 91;
                    case 35 -> 16;
                    case 36 -> 55;
                    case 37 -> 176;
                    case 38 -> 189;
                    case 39 -> 201;
                    case 40 -> 35;
                    case 41 -> 245;
                    case 42 -> 129;
                    case 43 -> 214;
                    case 44 -> 197;
                    case 45 -> 73;
                    case 46 -> 119;
                    case 47 -> 149;
                    case 48 -> 30;
                    case 49 -> 0;
                    case 50 -> 124;
                    case 51 -> 210;
                    case 52 -> 22;
                    case 53 -> 95;
                    case 54 -> 96;
                    case 55 -> 150;
                    case 56 -> 49;
                    case 57 -> 166;
                    case 58 -> 147;
                    case 59 -> 178;
                    case 60 -> 211;
                    case 61 -> 106;
                    case 62 -> 244;
                    case 63 -> 199;
                    case 64 -> 65;
                    case 65 -> 183;
                    case 66 -> 46;
                    case 67 -> 215;
                    case 68 -> 26;
                    case 69 -> 61;
                    case 70 -> 82;
                    case 71 -> 1;
                    case 72 -> 226;
                    case 73 -> 158;
                    case 74 -> 74;
                    case 75 -> 186;
                    case 76 -> 64;
                    case 77 -> 252;
                    case 78 -> 236;
                    case 79 -> 207;
                    case 80 -> 224;
                    case 81 -> 25;
                    case 82 -> 250;
                    case 83 -> 135;
                    case 84 -> 205;
                    case 85 -> 107;
                    case 86 -> 80;
                    case 87 -> 133;
                    case 88 -> 93;
                    case 89 -> 56;
                    case 90 -> 114;
                    case 91 -> 17;
                    case 92 -> 162;
                    case 93 -> 97;
                    case 94 -> 44;
                    case 95 -> 13;
                    case 96 -> 101;
                    case 97 -> 193;
                    case 98 -> 138;
                    case 99 -> 19;
                    case 100 -> 151;
                    case 101 -> 100;
                    case 102 -> 41;
                    case 103 -> 104;
                    case 104 -> 117;
                    case 105 -> 232;
                    case 106 -> 137;
                    case 107 -> 195;
                    case 108 -> 146;
                    case 109 -> 134;
                    case 110 -> 222;
                    case 111 -> 251;
                    case 112 -> 125;
                    case 113 -> 84;
                    case 114 -> 212;
                    case 115 -> 42;
                    case 116 -> 3;
                    case 117 -> 167;
                    case 118 -> 8;
                    case 119 -> 181;
                    case 120 -> 58;
                    case 121 -> 122;
                    case 122 -> 77;
                    case 123 -> 31;
                    case 124 -> 127;
                    case 125 -> 12;
                    case 126 -> 144;
                    case 127 -> 169;
                    case 128 -> 237;
                    case 129 -> 220;
                    case 130 -> 163;
                    case 131 -> 130;
                    case 132 -> 255;
                    case 133 -> 7;
                    case 134 -> 66;
                    case 135 -> 10;
                    case 136 -> 115;
                    case 137 -> 9;
                    case 138 -> 208;
                    case 139 -> 116;
                    case 140 -> 140;
                    case 141 -> 63;
                    case 142 -> 187;
                    case 143 -> 110;
                    case 144 -> 238;
                    case 145 -> 53;
                    case 146 -> 165;
                    case 147 -> 105;
                    case 148 -> 228;
                    case 149 -> 213;
                    case 150 -> 230;
                    case 151 -> 229;
                    case 152 -> 89;
                    case 153 -> 157;
                    case 154 -> 191;
                    case 155 -> 88;
                    case 156 -> 239;
                    case 157 -> 79;
                    case 158 -> 253;
                    case 159 -> 198;
                    case 160 -> 18;
                    case 161 -> 173;
                    case 162 -> 21;
                    case 163 -> 246;
                    case 164 -> 154;
                    case 165 -> 92;
                    case 166 -> 45;
                    case 167 -> 185;
                    case 168 -> 235;
                    case 169 -> 68;
                    case 170 -> 128;
                    case 171 -> 143;
                    case 172 -> 23;
                    case 173 -> 76;
                    case 174 -> 227;
                    case 175 -> 2;
                    case 176 -> 231;
                    case 177 -> 75;
                    case 178 -> 62;
                    case 179 -> 87;
                    case 180 -> 141;
                    case 181 -> 126;
                    case 182 -> 5;
                    case 183 -> 123;
                    case 184 -> 177;
                    case 185 -> 85;
                    case 186 -> 112;
                    case 187 -> 40;
                    case 188 -> 37;
                    case 189 -> 164;
                    case 190 -> 152;
                    case 191 -> 52;
                    case 192 -> 120;
                    case 193 -> 206;
                    case 194 -> 36;
                    case 195 -> 219;
                    case 196 -> 156;
                    case 197 -> 121;
                    case 198 -> 132;
                    case 199 -> 240;
                    case 200 -> 108;
                    case 201 -> 160;
                    case 202 -> 202;
                    case 203 -> 179;
                    case 204 -> 184;
                    case 205 -> 34;
                    case 206 -> 118;
                    case 207 -> 38;
                    case 208 -> 148;
                    case 209 -> 50;
                    case 210 -> 209;
                    case 211 -> 57;
                    case 212 -> 28;
                    case 213 -> 243;
                    case 214 -> 159;
                    case 215 -> 182;
                    case 216 -> 200;
                    case 217 -> 11;
                    case 218 -> 47;
                    case 219 -> 221;
                    case 220 -> 81;
                    case 221 -> 86;
                    case 222 -> 33;
                    case 223 -> 99;
                    case 224 -> 218;
                    case 225 -> 153;
                    case 226 -> 139;
                    case 227 -> 111;
                    case 228 -> 83;
                    case 229 -> 136;
                    case 230 -> 32;
                    case 231 -> 192;
                    case 232 -> 203;
                    case 233 -> 233;
                    case 234 -> 242;
                    case 235 -> 254;
                    case 236 -> 170;
                    case 237 -> 247;
                    case 238 -> 142;
                    case 239 -> 70;
                    case 240 -> 241;
                    case 241 -> 204;
                    case 242 -> 60;
                    case 243 -> 54;
                    case 244 -> 71;
                    case 245 -> 90;
                    case 246 -> 190;
                    case 247 -> 155;
                    case 248 -> 188;
                    case 249 -> 131;
                    case 250 -> 249;
                    case 251 -> 171;
                    case 252 -> 113;
                    case 253 -> 175;
                    case 254 -> 59;
                    default -> 161;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 114719241542305L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-665049180 + -19933, 665049180 + 21390, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 104610524584160L;
                    boolean bl = SshAgentIpcService.q();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1993836840 + 4703, -1993836840 + -5673, (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (bl2) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 52800218113236L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "a\u00ackuu\u0003\u00d5\u00dc\u00ab";
                var4_3 = "a\u00ackuu\u0003\u00d5\u00dc\u00ab".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 14;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 28;
                                break;
                            }
                            case 1: {
                                v11 = 61;
                                break;
                            }
                            case 2: {
                                v11 = 35;
                                break;
                            }
                            case 3: {
                                v11 = 109;
                                break;
                            }
                            case 4: {
                                v11 = 14;
                                break;
                            }
                            case 5: {
                                v11 = 37;
                                break;
                            }
                            default: {
                                v11 = 117;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFC366) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 59;
                    case 1 -> 98;
                    case 2 -> 141;
                    case 3 -> 75;
                    case 4 -> 70;
                    case 5 -> 211;
                    case 6 -> 16;
                    case 7 -> 173;
                    case 8 -> 69;
                    case 9 -> 140;
                    case 10 -> 117;
                    case 11 -> 251;
                    case 12 -> 129;
                    case 13 -> 187;
                    case 14 -> 230;
                    case 15 -> 103;
                    case 16 -> 176;
                    case 17 -> 165;
                    case 18 -> 21;
                    case 19 -> 12;
                    case 20 -> 136;
                    case 21 -> 227;
                    case 22 -> 195;
                    case 23 -> 29;
                    case 24 -> 122;
                    case 25 -> 31;
                    case 26 -> 26;
                    case 27 -> 218;
                    case 28 -> 223;
                    case 29 -> 163;
                    case 30 -> 25;
                    case 31 -> 143;
                    case 32 -> 40;
                    case 33 -> 239;
                    case 34 -> 18;
                    case 35 -> 184;
                    case 36 -> 53;
                    case 37 -> 115;
                    case 38 -> 81;
                    case 39 -> 85;
                    case 40 -> 138;
                    case 41 -> 24;
                    case 42 -> 193;
                    case 43 -> 33;
                    case 44 -> 6;
                    case 45 -> 236;
                    case 46 -> 214;
                    case 47 -> 121;
                    case 48 -> 240;
                    case 49 -> 202;
                    case 50 -> 151;
                    case 51 -> 198;
                    case 52 -> 116;
                    case 53 -> 79;
                    case 54 -> 32;
                    case 55 -> 157;
                    case 56 -> 205;
                    case 57 -> 22;
                    case 58 -> 108;
                    case 59 -> 172;
                    case 60 -> 14;
                    case 61 -> 150;
                    case 62 -> 159;
                    case 63 -> 62;
                    case 64 -> 94;
                    case 65 -> 50;
                    case 66 -> 224;
                    case 67 -> 191;
                    case 68 -> 43;
                    case 69 -> 1;
                    case 70 -> 56;
                    case 71 -> 162;
                    case 72 -> 208;
                    case 73 -> 63;
                    case 74 -> 99;
                    case 75 -> 97;
                    case 76 -> 194;
                    case 77 -> 131;
                    case 78 -> 152;
                    case 79 -> 217;
                    case 80 -> 17;
                    case 81 -> 215;
                    case 82 -> 229;
                    case 83 -> 149;
                    case 84 -> 235;
                    case 85 -> 209;
                    case 86 -> 228;
                    case 87 -> 27;
                    case 88 -> 124;
                    case 89 -> 204;
                    case 90 -> 207;
                    case 91 -> 210;
                    case 92 -> 158;
                    case 93 -> 111;
                    case 94 -> 54;
                    case 95 -> 133;
                    case 96 -> 88;
                    case 97 -> 68;
                    case 98 -> 15;
                    case 99 -> 148;
                    case 100 -> 49;
                    case 101 -> 19;
                    case 102 -> 222;
                    case 103 -> 226;
                    case 104 -> 169;
                    case 105 -> 9;
                    case 106 -> 189;
                    case 107 -> 142;
                    case 108 -> 183;
                    case 109 -> 156;
                    case 110 -> 166;
                    case 111 -> 38;
                    case 112 -> 175;
                    case 113 -> 199;
                    case 114 -> 201;
                    case 115 -> 57;
                    case 116 -> 90;
                    case 117 -> 200;
                    case 118 -> 23;
                    case 119 -> 51;
                    case 120 -> 188;
                    case 121 -> 126;
                    case 122 -> 180;
                    case 123 -> 119;
                    case 124 -> 42;
                    case 125 -> 95;
                    case 126 -> 118;
                    case 127 -> 91;
                    case 128 -> 110;
                    case 129 -> 0;
                    case 130 -> 132;
                    case 131 -> 247;
                    case 132 -> 164;
                    case 133 -> 253;
                    case 134 -> 123;
                    case 135 -> 185;
                    case 136 -> 2;
                    case 137 -> 39;
                    case 138 -> 109;
                    case 139 -> 203;
                    case 140 -> 233;
                    case 141 -> 102;
                    case 142 -> 92;
                    case 143 -> 82;
                    case 144 -> 252;
                    case 145 -> 246;
                    case 146 -> 231;
                    case 147 -> 78;
                    case 148 -> 64;
                    case 149 -> 168;
                    case 150 -> 77;
                    case 151 -> 93;
                    case 152 -> 74;
                    case 153 -> 13;
                    case 154 -> 41;
                    case 155 -> 127;
                    case 156 -> 178;
                    case 157 -> 67;
                    case 158 -> 254;
                    case 159 -> 221;
                    case 160 -> 245;
                    case 161 -> 250;
                    case 162 -> 35;
                    case 163 -> 125;
                    case 164 -> 107;
                    case 165 -> 87;
                    case 166 -> 234;
                    case 167 -> 72;
                    case 168 -> 134;
                    case 169 -> 66;
                    case 170 -> 96;
                    case 171 -> 179;
                    case 172 -> 4;
                    case 173 -> 255;
                    case 174 -> 192;
                    case 175 -> 225;
                    case 176 -> 114;
                    case 177 -> 37;
                    case 178 -> 61;
                    case 179 -> 83;
                    case 180 -> 47;
                    case 181 -> 34;
                    case 182 -> 130;
                    case 183 -> 86;
                    case 184 -> 84;
                    case 185 -> 106;
                    case 186 -> 196;
                    case 187 -> 5;
                    case 188 -> 242;
                    case 189 -> 120;
                    case 190 -> 71;
                    case 191 -> 65;
                    case 192 -> 137;
                    case 193 -> 135;
                    case 194 -> 174;
                    case 195 -> 237;
                    case 196 -> 100;
                    case 197 -> 46;
                    case 198 -> 28;
                    case 199 -> 155;
                    case 200 -> 197;
                    case 201 -> 76;
                    case 202 -> 181;
                    case 203 -> 167;
                    case 204 -> 89;
                    case 205 -> 186;
                    case 206 -> 182;
                    case 207 -> 10;
                    case 208 -> 101;
                    case 209 -> 219;
                    case 210 -> 213;
                    case 211 -> 241;
                    case 212 -> 8;
                    case 213 -> 52;
                    case 214 -> 153;
                    case 215 -> 154;
                    case 216 -> 105;
                    case 217 -> 161;
                    case 218 -> 244;
                    case 219 -> 45;
                    case 220 -> 248;
                    case 221 -> 170;
                    case 222 -> 206;
                    case 223 -> 212;
                    case 224 -> 216;
                    case 225 -> 36;
                    case 226 -> 20;
                    case 227 -> 58;
                    case 228 -> 249;
                    case 229 -> 232;
                    case 230 -> 238;
                    case 231 -> 190;
                    case 232 -> 171;
                    case 233 -> 30;
                    case 234 -> 177;
                    case 235 -> 7;
                    case 236 -> 11;
                    case 237 -> 139;
                    case 238 -> 128;
                    case 239 -> 160;
                    case 240 -> 48;
                    case 241 -> 146;
                    case 242 -> 80;
                    case 243 -> 104;
                    case 244 -> 145;
                    case 245 -> 44;
                    case 246 -> 60;
                    case 247 -> 243;
                    case 248 -> 55;
                    case 249 -> 112;
                    case 250 -> 220;
                    case 251 -> 147;
                    case 252 -> 113;
                    case 253 -> 3;
                    case 254 -> 144;
                    default -> 73;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

