/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.connector;

import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.connector.LspServerProcessListenerBase;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.io.IOUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/lsp/impl/connector/LspServerProcessListener;", "Lcom/intellij/platform/lsp/impl/connector/LspServerProcessListenerBase;", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "logStdErr", "Lkotlin/Function1;", "", "", "LspServerProcessListener", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;Lkotlin/jvm/functions/Function1;)V", "pipedOutputStream", "Ljava/io/PipedOutputStream;", "outputStreamWriter", "Ljava/io/OutputStreamWriter;", "pipedInputStream", "Ljava/io/PipedInputStream;", "getPipedInputStream", "()Ljava/io/PipedInputStream;", "onTextAvailable", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "processTerminated", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLsp4jServerConnectorStdio.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lsp4jServerConnectorStdio.kt\ncom/intellij/platform/lsp/impl/connector/LspServerProcessListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,73:1\n1#2:74\n24#3:75\n*S KotlinDebug\n*F\n+ 1 Lsp4jServerConnectorStdio.kt\ncom/intellij/platform/lsp/impl/connector/LspServerProcessListener\n*L\n69#1:75\n*E\n"})
final class LspServerProcessListener
extends LspServerProcessListenerBase {
    @NotNull
    private final LspServerImpl lspServer;
    @NotNull
    private final Function1<String, Unit> logStdErr;
    @NotNull
    private final PipedOutputStream pipedOutputStream;
    @NotNull
    private final OutputStreamWriter outputStreamWriter;
    @NotNull
    private final PipedInputStream pipedInputStream;

    public LspServerProcessListener(@NotNull LspServerImpl lspServer, @NotNull Function1<? super String, Unit> logStdErr) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter(logStdErr, (String)"logStdErr");
        super(lspServer);
        this.lspServer = lspServer;
        this.logStdErr = logStdErr;
        this.pipedOutputStream = new PipedOutputStream();
        this.outputStreamWriter = new OutputStreamWriter((OutputStream)this.pipedOutputStream, StandardCharsets.UTF_8);
        this.pipedInputStream = new PipedInputStream(this.pipedOutputStream);
    }

    @NotNull
    public final PipedInputStream getPipedInputStream() {
        return this.pipedInputStream;
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        if (ProcessOutputType.isStdout(outputType)) {
            try {
                this.outputStreamWriter.write(event.getText());
                this.outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                String[] stringArray = new String[]{"readSide", "writeSide", "closedByReader", "closedByWriter"};
                String string = ReflectionUtil.dumpFields(PipedInputStream.class, (Object)this.pipedInputStream, (String[])stringArray);
                this.lspServer.logError$intellij_platform_lsp_impl("Problem proxying data to the listener: " + iOException.getMessage() + "\nStopping LSP server process: " + event.getProcessHandler() + "\n" + string);
                ExecutionManagerImpl.Companion.stopProcess(event.getProcessHandler());
            }
        } else if (ProcessOutputType.isStderr(outputType)) {
            String string;
            String string2 = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String string3 = string = ((Object)StringsKt.trimEnd((CharSequence)string2)).toString();
            boolean bl = false;
            String string4 = ((CharSequence)string3).length() > 0 ? string : null;
            if (string4 == null) {
                return;
            }
            String string5 = string4;
            this.lspServer.logInfo$intellij_platform_lsp_impl("STDERR: " + string5);
            this.lspServer.appendServerErrorOutput$intellij_platform_lsp_impl(string5);
            this.logStdErr.invoke((Object)string5);
        }
    }

    @Override
    public void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Closeable[] closeableArray = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(LspServerProcessListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        closeableArray = new Closeable[]{this.outputStreamWriter, this.pipedOutputStream};
        IOUtil.closeSafe((Logger)logger, (Closeable[])closeableArray);
        super.processTerminated(event);
    }
}

