/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.CommonBundle;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JSDebuggerCoroutineScopeHolder;
import com.intellij.javascript.debugger.JSDebuggerUiUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.Url;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.debugger.wip.BrowserTerminationPolicy;
import com.jetbrains.debugger.wip.ChromeLocalConnectedTabsService;
import com.jetbrains.debugger.wip.ChromeLocalVmConnection;
import com.jetbrains.debugger.wip.ChromeLocalVmConnectionKt;
import com.jetbrains.debugger.wip.PageConnection;
import com.jetbrains.debugger.wip.WipLocalVmConnection;
import com.jetbrains.debugger.wip.WipRemoteVmConnectionKt;
import com.jetbrains.debugger.wip.WipVmBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.MessagingLogger;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.browser.BrowserKt;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.page.PageKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\f\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0016J\b\u0010#\u001a\u00020\u001aH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020 H\u0002J\u001e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0014J6\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001022\f\u00103\u001a\b\u0012\u0004\u0012\u000205042\f\u00106\u001a\b\u0012\u0004\u0012\u00020-0,H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/jetbrains/debugger/wip/ChromeLocalVmConnection;", "Lcom/jetbrains/debugger/wip/WipLocalVmConnection;", "url", "Lcom/intellij/util/Url;", "reloadReusedPage", "", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "<init>", "(Lcom/intellij/util/Url;ZLcom/intellij/ide/browsers/WebBrowser;Lcom/intellij/xdebugger/XDebugSession;)V", "getReloadReusedPage", "()Z", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "reusedExistingBrowserInstance", "newPageRequested", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "processHandle", "Lkotlinx/coroutines/Deferred;", "Lcom/intellij/execution/process/KillableProcessHandler;", "connect", "", "launchBrowserOnNewPortAndOpen", "project", "Lcom/intellij/openapi/project/Project;", "launchBrowserAndOpen", "remoteDebuggingPort", "", "detachAndClose", "Lorg/jetbrains/concurrency/Promise;", "dispose", "getUserDataPath", "", "port", "createChannelHandler", "Lio/netty/channel/ChannelHandler;", "address", "Ljava/net/InetSocketAddress;", "vmResult", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lorg/jetbrains/wip/WipVm;", "processPageConnections", "context", "Lio/netty/channel/ChannelHandlerContext;", "debugMessageQueue", "Lorg/jetbrains/debugger/MessagingLogger;", "pageConnections", "", "Lcom/jetbrains/debugger/wip/PageConnection;", "result", "intellij.javascript.debugger"})
public class ChromeLocalVmConnection
extends WipLocalVmConnection {
    private final boolean reloadReusedPage;
    @NotNull
    private final WebBrowser browser;
    @NotNull
    private final XDebugSession session;
    private boolean reusedExistingBrowserInstance;
    private boolean newPageRequested;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private volatile Deferred<? extends KillableProcessHandler> processHandle;

    public ChromeLocalVmConnection(@Nullable Url url, boolean reloadReusedPage, @NotNull WebBrowser browser, @NotNull XDebugSession session2) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        super(url);
        this.reloadReusedPage = reloadReusedPage;
        this.browser = browser;
        this.session = session2;
        Project project = this.session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.coroutineScope = JSDebuggerCoroutineScopeHolder.Companion.createChildScope$default(JSDebuggerCoroutineScopeHolder.Companion, project, "Chrome VM Connection", null, false, 12, null);
    }

    public /* synthetic */ ChromeLocalVmConnection(Url url, boolean bl, WebBrowser webBrowser, XDebugSession xDebugSession, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(url, bl, webBrowser, xDebugSession);
    }

    public final boolean getReloadReusedPage() {
        return this.reloadReusedPage;
    }

    @NotNull
    public WebBrowser getBrowser() {
        return this.browser;
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    public final void connect() {
        Project project = this.session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        int savedPort = PropertiesComponent.getInstance().getInt("js.chrome.debugger.port." + this.getBrowser().getId(), -1);
        if (savedPort > 0) {
            this.reusedExistingBrowserInstance = true;
            InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), savedPort);
            AsyncPromise result = new AsyncPromise();
            Ref.ObjectRef f = new Ref.ObjectRef();
            result.onSuccess(arg_0 -> ChromeLocalVmConnection.connect$lambda$1(arg_0 -> ChromeLocalVmConnection.connect$lambda$0(f, this, address, arg_0), arg_0));
            Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> ChromeLocalVmConnection.connect$lambda$3(this, address, result, f, savedPort, project2));
            Intrinsics.checkNotNull((Object)future);
        } else {
            this.launchBrowserOnNewPortAndOpen(project2);
        }
    }

    private final void launchBrowserOnNewPortAndOpen(Project project) {
        int port = NetUtils.findAvailableSocketPort();
        int oldPort = PropertiesComponent.getInstance().getInt("js.chrome.debugger.port." + this.getBrowser().getId(), -1);
        if (oldPort > 0) {
            ChromeLocalVmConnectionKt.access$getLOG$p().warn("Chrome debug port changed from " + oldPort + " to " + port + ".");
        }
        PropertiesComponent.getInstance().setValue("js.chrome.debugger.port." + this.getBrowser().getId(), port, -1);
        this.launchBrowserAndOpen(port, project);
    }

    private final void launchBrowserAndOpen(int remoteDebuggingPort, Project project) {
        String string = PathUtil.toSystemDependentName((String)this.getBrowser().getPath());
        if (string == null) {
            Object[] objectArray = new Object[]{CommonBundle.settingsActionPath()};
            throw new CantRunException(IdeBundle.message((String)"error.please.specify.path.to.web.browser", (Object[])objectArray));
        }
        String browserPath = string;
        BrowserSpecificSettings browserSpecificSettings = this.getBrowser().getSpecificSettings();
        ChromeSettings chromeSettings = browserSpecificSettings instanceof ChromeSettings ? (ChromeSettings)browserSpecificSettings : null;
        if (chromeSettings == null) {
            throw new AssertionError((Object)"Browser is not Chrome. Must be checked in Run configuration.");
        }
        ChromeSettings chromeSettings2 = chromeSettings;
        List additionalParameters = new ArrayList();
        List list = chromeSettings2.getAdditionalParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAdditionalParameters(...)");
        additionalParameters.addAll(list);
        additionalParameters.add("--remote-debugging-port=" + remoteDebuggingPort);
        if (!chromeSettings2.isUseCustomProfile()) {
            String userDataPath = this.getUserDataPath(remoteDebuggingPort);
            additionalParameters.add("--user-data-dir=" + userDataPath);
            additionalParameters.add("--no-first-run");
            additionalParameters.add("--disable-fre");
        }
        additionalParameters.add("--no-default-browser-check");
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(BrowserUtil.getOpenBrowserCommand((String)browserPath, (String)"about:blank", (List)additionalParameters, (boolean)true)).withEnvironment(chromeSettings2.getEnvironmentVariables());
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withEnvironment(...)");
        GeneralCommandLine command = generalCommandLine;
        this.processHandle = BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)new CoroutineName("Chrome process launcher")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super KillableProcessHandler>, Object>(command, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ GeneralCommandLine $command;
            {
                this.$command = $command;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object $this$invokeSuspend_u24lambda_u240;
                        void $this$async;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object = $this$async;
                        Object object2 = this.$command;
                        try {
                            $this$invokeSuspend_u24lambda_u240 = object;
                            boolean bl = false;
                            $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)new KillableProcessHandler(object2));
                        }
                        catch (Throwable bl) {
                            $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                        }
                        object = $this$invokeSuspend_u24lambda_u240;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                        if (throwable != null) {
                            Object it = object2 = throwable;
                            boolean bl = false;
                            ChromeLocalVmConnectionKt.access$getLOG$p().error((Throwable)it);
                        }
                        return Result.isFailure-impl((Object)object) ? null : object;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super KillableProcessHandler> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.reusedExistingBrowserInstance = false;
        Promise openPromise = RemoteVmConnection.open$default((RemoteVmConnection)this, (InetSocketAddress)new InetSocketAddress(InetAddress.getLoopbackAddress(), remoteDebuggingPort), null, (int)2, null);
        new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this).addRequest(() -> ChromeLocalVmConnection.launchBrowserAndOpen$lambda$6(openPromise, remoteDebuggingPort, project, this), TimeUnit.SECONDS.toMillis(9L));
    }

    @NotNull
    public Promise<?> detachAndClose() {
        Function1 function1 = new Function1(this){
            final /* synthetic */ ChromeLocalVmConnection this$0;
            {
                this.this$0 = $receiver;
            }

            public final Promise<?> invoke(Object it) {
                return ChromeLocalVmConnection.access$detachAndClose$s187710434(this.this$0);
            }
        };
        Promise promise2 = Promises.asPromise((Job)BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)new CoroutineName("ChromeLocalVmConnection.detachAndClose")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ ChromeLocalVmConnection this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object $result) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        value$iv = Registry.Companion.get("js.debugger.chrome.termination.policy").getSelectedOption();
                        $i$f$valueOfOrNull = false;
                        v0 = value$iv;
                        if (v0 != null) {
                            it$iv = v0;
                            $i$a$-let-ChromeLocalVmConnectionKt$valueOfOrNull$1$iv = false;
                            try {
                                var7_10 = BrowserTerminationPolicy.valueOf(value$iv);
                            }
                            catch (IllegalArgumentException <unused var>$iv) {
                                var7_10 = null;
                            }
                            v1 = var7_10;
                        } else {
                            v1 = null;
                        }
                        terminationPolicy = (BrowserTerminationPolicy)v1;
                        v2 = (WipVm)this.this$0.getVm();
                        commandProcessor = v2 != null ? v2.getCommandProcessor() : null;
                        v3 = terminationPolicy;
                        switch (v3 == null ? -1 : detachAndClose.WhenMappings.$EnumSwitchMapping$0[v3.ordinal()]) {
                            case -1: 
                            case 1: {
                                return Unit.INSTANCE;
                            }
                            case 2: {
                                v4 = commandProcessor;
                                if (v4 != null) {
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)terminationPolicy);
                                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)commandProcessor);
                                    this.label = 1;
                                    v5 = ChromeLocalVmConnectionKt.access$sendCloseRequest(v4, BrowserKt.Close(), "Error closing browser", (Continuation)this);
                                    if (v5 == var10_2) {
                                        return var10_2;
                                    }
                                }
                                ** GOTO lbl43
                            }
                            case 1: {
                                commandProcessor = (WipCommandProcessor)this.L$1;
                                terminationPolicy = (BrowserTerminationPolicy)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v5 = $result;
lbl43:
                                // 2 sources

                                v6 = ChromeLocalVmConnection.access$getProcessHandle$p(this.this$0);
                                v7 = v6;
                                if (v6 == null) return Unit.INSTANCE;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)terminationPolicy);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)commandProcessor);
                                this.label = 2;
                                v8 = v7.await((Continuation)this);
                                if (v8 == var10_2) {
                                    return var10_2;
                                }
                                ** GOTO lbl58
                            }
                            case 2: {
                                commandProcessor = (WipCommandProcessor)this.L$1;
                                terminationPolicy = (BrowserTerminationPolicy)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v8 = $result;
lbl58:
                                // 2 sources

                                if ((v7 = (KillableProcessHandler)v8) == null) {
                                    return Unit.INSTANCE;
                                }
                                handle = v7;
                                it = handle.getCommandLine();
                                $i$a$-let-ChromeLocalVmConnection$detachAndClose$1$1 = false;
                                Intrinsics.checkNotNull((Object)it);
                                if (StringsKt.startsWith$default((String)it, (String)ExecUtil.getOpenCommandPath(), (boolean)false, (int)2, null)) ** GOTO lbl-1000
                                v9 = CommandLineUtil.getWinShellName();
                                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getWinShellName(...)");
                                if (StringsKt.startsWith$default((String)it, (String)v9, (boolean)false, (int)2, null)) lbl-1000:
                                // 2 sources

                                {
                                    v10 = true;
                                } else {
                                    v10 = false;
                                }
                                if (v10) {
                                    return Unit.INSTANCE;
                                }
                                if (!handle.isProcessTerminating() && !handle.isProcessTerminated()) {
                                    handle.killProcess();
                                    return Unit.INSTANCE;
                                }
                                ChromeLocalVmConnectionKt.access$getLOG$p().warn("Browser process exited before connection was closed. Exit code: " + handle.getExitCode() + ", command: " + handle.getCommandLineForLog());
                                return Unit.INSTANCE;
                            }
                            case 3: {
                                v11 = commandProcessor;
                                if (v11 == null) return Unit.INSTANCE;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)terminationPolicy);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)commandProcessor);
                                this.label = 3;
                                v12 = ChromeLocalVmConnectionKt.access$sendCloseRequest(v11, PageKt.Close(), "Error closing browser", (Continuation)this);
                                v13 = v12;
                                if (v12 != var10_2) return Unit.INSTANCE;
                                return var10_2;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    case 3: {
                        commandProcessor = (WipCommandProcessor)this.L$1;
                        terminationPolicy = (BrowserTerminationPolicy)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v13 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null)).thenAsync(new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object fun(Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"thenAsync(...)");
        return promise2;
    }

    public void dispose() {
        super.dispose();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, (String)"ChromeLocalVmConnection disposed", null, (int)2, null);
    }

    private final String getUserDataPath(int port) {
        String string = PathManager.getSystemPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSystemPath(...)");
        String string2 = string;
        String[] stringArray = new String[]{"chrome-profiles", "chrome-user-data-" + port};
        Path path = Paths.get(string2, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path userDataDir = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(userDataDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathKt.createDirectories((Path)userDataDir);
        }
        return ((Object)userDataDir.toAbsolutePath()).toString();
    }

    @Override
    @NotNull
    protected ChannelHandler createChannelHandler(@NotNull InetSocketAddress address, @NotNull AsyncPromise<WipVm> vmResult) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(vmResult, (String)"vmResult");
        return (ChannelHandler)new SimpleChannelInboundHandlerAdapter<FullHttpResponse>(this, address, vmResult){
            private final long startTimeMillis;
            final /* synthetic */ ChromeLocalVmConnection this$0;
            final /* synthetic */ InetSocketAddress $address;
            final /* synthetic */ AsyncPromise<WipVm> $vmResult;
            {
                this.this$0 = $receiver;
                this.$address = $address;
                this.$vmResult = $vmResult;
                this.startTimeMillis = System.currentTimeMillis();
            }

            public void channelActive(ChannelHandlerContext context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                super.channelActive(context);
                this.this$0.sendGetJson(this.$address, context, this.$vmResult);
            }

            /*
             * WARNING - void declaration
             */
            protected void messageReceived(ChannelHandlerContext context, FullHttpResponse message) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                try {
                    if (ChromeLocalVmConnection.access$getReusedExistingBrowserInstance$p(this.this$0)) {
                        ByteBuf byteBuf = message.content();
                        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"content(...)");
                        if (this.this$0.connectToPage(context, this.$address, byteBuf, this.$vmResult)) {
                            context.pipeline().remove((ChannelHandler)this);
                            if (this.this$0.getReloadReusedPage() && !ChromeLocalVmConnection.access$getNewPageRequested$p(this.this$0)) {
                                this.$vmResult.onSuccess(arg_0 -> createChannelHandler.1.messageReceived$lambda$4(arg_0 -> createChannelHandler.1.messageReceived$lambda$3(this.this$0, arg_0), arg_0));
                            }
                            return;
                        }
                    }
                    if (!ChromeLocalVmConnection.access$getReusedExistingBrowserInstance$p(this.this$0)) {
                        ChromeLocalVmConnection.access$setNewPageRequested$p(this.this$0, true);
                    }
                    if (ChromeLocalVmConnection.access$getNewPageRequested$p(this.this$0)) {
                        ByteBuf byteBuf = message.content();
                        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"content(...)");
                        v2 = !this.this$0.connectToPage(context, this.$address, byteBuf, this.$vmResult) && System.currentTimeMillis() - this.startTimeMillis < 5000L ? context.executor().schedule(() -> createChannelHandler.1.messageReceived$lambda$5(this.this$0, this.$address, context, this.$vmResult), 100L, TimeUnit.MILLISECONDS) : context.pipeline().remove((ChannelHandler)this);
                    } else {
                        void $this$addChannelListener$iv;
                        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/json/new?about:blank");
                        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)WipRemoteVmConnectionKt.toHttpHeaderHostField(this.$address));
                        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT, (Object)"*/*");
                        ChannelFuture channelFuture = context.channel().writeAndFlush((Object)request);
                        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"writeAndFlush(...)");
                        ChannelFuture channelFuture2 = channelFuture;
                        AsyncPromise<WipVm> asyncPromise = this.$vmResult;
                        boolean $i$f$addChannelListener = false;
                        $this$addChannelListener$iv.addListener(new GenericFutureListener(asyncPromise){
                            final /* synthetic */ AsyncPromise $vmResult$inlined;
                            {
                                this.$vmResult$inlined = asyncPromise;
                            }

                            public final void operationComplete(ChannelFuture it) {
                                Intrinsics.checkNotNull((Object)it);
                                ChannelFuture it2 = it;
                                boolean bl = false;
                                if (!it2.isSuccess()) {
                                    Throwable throwable = it2.cause();
                                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"cause(...)");
                                    this.$vmResult$inlined.setError(throwable);
                                }
                            }
                        });
                        ChromeLocalVmConnection.access$setNewPageRequested$p(this.this$0, true);
                        v2 = Unit.INSTANCE;
                    }
                }
                catch (Throwable e) {
                    this.$vmResult.setError(e);
                }
            }

            public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                this.$vmResult.setError(cause);
                context.close();
            }

            private static final Promise messageReceived$lambda$3$lambda$2$lambda$0(WipVm $vm, ChromeLocalVmConnection this$0, Unit it) {
                return $vm.getCommandProcessor().send((Request)DebuggerKt.SetSkipAllPauses(this$0.getSession().areBreakpointsMuted()));
            }

            private static final Promise messageReceived$lambda$3$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
                return (Promise)$tmp0.invoke(p0);
            }

            private static final Unit messageReceived$lambda$3$lambda$2(WipVm $vm, ChromeLocalVmConnection this$0) {
                if (Intrinsics.areEqual((Object)$vm.getCurrentUrl(), (Object)this$0.getUrl())) {
                    v0 = $vm.getCommandProcessor().send((Request)PageKt.Reload$default(true, null, 2, null)).thenAsync(arg_0 -> createChannelHandler.1.messageReceived$lambda$3$lambda$2$lambda$1(arg_0 -> createChannelHandler.1.messageReceived$lambda$3$lambda$2$lambda$0($vm, this$0, arg_0), arg_0));
                } else {
                    Intrinsics.checkNotNull((Object)((Object)$vm));
                    WipVmBootstrap wipVmBootstrap = new WipVmBootstrap($vm);
                    Url url = this$0.getUrl();
                    Intrinsics.checkNotNull((Object)url);
                    v0 = wipVmBootstrap.navigate(url);
                }
                return Unit.INSTANCE;
            }

            private static final Unit messageReceived$lambda$3(ChromeLocalVmConnection this$0, WipVm vm) {
                Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
                vm.addReadyListener((Function0<Unit>)((Function0)() -> createChannelHandler.1.messageReceived$lambda$3$lambda$2(vm, this$0)));
                return Unit.INSTANCE;
            }

            private static final void messageReceived$lambda$4(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }

            private static final void messageReceived$lambda$5(ChromeLocalVmConnection this$0, InetSocketAddress $address, ChannelHandlerContext $context, AsyncPromise $vmResult) {
                this$0.sendGetJson($address, $context, (AsyncPromise<WipVm>)$vmResult);
            }
        };
    }

    @Override
    protected boolean processPageConnections(@NotNull ChannelHandlerContext context, @Nullable MessagingLogger debugMessageQueue, @NotNull List<PageConnection> pageConnections, @NotNull AsyncPromise<WipVm> result) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(pageConnections, (String)"pageConnections");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        RunProfile runProfile = this.session.getRunProfile();
        if (this.newPageRequested) {
            PageConnection p;
            for (PageConnection p2 : CollectionsKt.reversed((Iterable)pageConnections)) {
                if (!Intrinsics.areEqual((Object)p2.getUrl(), (Object)"about:blank")) continue;
                if (p2.getWebSocketDebuggerUrl() == null) {
                    String string = JSDebuggerBundle.message("js.debug.another.debugger.attached", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    result.setError(string);
                    return false;
                }
                if (runProfile != null) {
                    ((ChromeLocalConnectedTabsService)ApplicationManager.getApplication().getService(ChromeLocalConnectedTabsService.class)).addTabToReuse(runProfile, p2);
                }
                this.connectDebugger(p2, context, result, debugMessageQueue);
                if (this.getUrl() != null) {
                    result.onSuccess(arg_0 -> ChromeLocalVmConnection.processPageConnections$lambda$9(arg_0 -> ChromeLocalVmConnection.processPageConnections$lambda$8(this, arg_0), arg_0));
                }
                return false;
            }
            if (pageConnections.size() == 1 && Intrinsics.areEqual((Object)pageConnections.get(0).getTitle(), (Object)"React Native Debugger") && (p = pageConnections.get(0)).getWebSocketDebuggerUrl() != null) {
                this.connectDebugger(p, context, result, debugMessageQueue);
                return false;
            }
        } else if (runProfile != null) {
            for (PageConnection p : pageConnections) {
                PageConnection pageConnection = ((ChromeLocalConnectedTabsService)ApplicationManager.getApplication().getService(ChromeLocalConnectedTabsService.class)).getTabToReuse(runProfile);
                if (!Intrinsics.areEqual((Object)p.getId(), (Object)(pageConnection != null ? pageConnection.getId() : null))) continue;
                if (p.getWebSocketDebuggerUrl() == null) {
                    String string = JSDebuggerBundle.message("js.debug.another.debugger.attached", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    result.setError(string);
                    return false;
                }
                this.connectDebugger(p, context, result, debugMessageQueue);
                return false;
            }
        }
        return true;
    }

    private static final Unit connect$lambda$0(Ref.ObjectRef $f, ChromeLocalVmConnection this$0, InetSocketAddress $address, WipVm it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        ScheduledFuture scheduledFuture = (ScheduledFuture)$f.element;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        this$0.connectionSucceeded((Vm)it, $address);
        return Unit.INSTANCE;
    }

    private static final void connect$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void connect$lambda$3$lambda$2(Channel $channel, ChromeLocalVmConnection this$0, Project $project) {
        $channel.close();
        this$0.launchBrowserOnNewPortAndOpen($project);
    }

    private static final void connect$lambda$3(ChromeLocalVmConnection this$0, InetSocketAddress $address, AsyncPromise $result, Ref.ObjectRef $f, int $savedPort, Project $project) {
        Channel channel = NettyKt.connectRetrying$default((Bootstrap)this$0.createBootstrap($address, (AsyncPromise<WipVm>)$result), (InetSocketAddress)$address, (int)2, null, (int)4, null).getChannel();
        if (channel != null) {
            $f.element = channel.eventLoop().schedule(() -> ChromeLocalVmConnection.connect$lambda$3$lambda$2(channel, this$0, $project), 500L, TimeUnit.MILLISECONDS);
        } else {
            this$0.launchBrowserAndOpen($savedPort, $project);
        }
    }

    private static final Unit launchBrowserAndOpen$lambda$6$lambda$4(Notification $notification, WipVm it) {
        $notification.expire();
        return Unit.INSTANCE;
    }

    private static final void launchBrowserAndOpen$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void launchBrowserAndOpen$lambda$6(Promise $openPromise, int $remoteDebuggingPort, Project $project, ChromeLocalVmConnection this$0) {
        if (Promises.isPending((Promise)$openPromise)) {
            Object object = new Object[]{$remoteDebuggingPort};
            String string = JSDebuggerBundle.message("js.debug.waiting.for.chrome.remote.debug.port", object);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            Notification notification = JSDebuggerUiUtil.INSTANCE.getNOTIFICATION_GROUP().createNotification(message, NotificationType.WARNING);
            object = JSDebuggerBundle.message("js.debug.waiting.for.chrome.remote.debug.port.more.info", new Object[0]);
            notification.addAction((AnAction)new NotificationAction((String)object){

                public void actionPerformed(AnActionEvent e, Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    HelpManager.getInstance().invokeHelp("Configure_Debugging_Chrome_UserData");
                }
            });
            object = JSDebuggerBundle.message("js.debug.try.another.port", new Object[0]);
            notification.addAction((AnAction)new NotificationAction(this$0, (String)object){
                final /* synthetic */ ChromeLocalVmConnection this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void actionPerformed(AnActionEvent e, Notification notification) {
                    ExecutionEnvironment environment;
                    XDebugSessionImpl sessionImpl;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    PropertiesComponent.getInstance().unsetValue("js.chrome.debugger.port." + this.this$0.getBrowser().getId());
                    XDebugSession xDebugSession = this.this$0.getSession();
                    XDebugSessionImpl xDebugSessionImpl = sessionImpl = xDebugSession instanceof XDebugSessionImpl ? (XDebugSessionImpl)xDebugSession : null;
                    if (sessionImpl != null && (environment = sessionImpl.getExecutionEnvironment()) != null) {
                        notification.expire();
                        ExecutionUtil.restart((ExecutionEnvironment)environment);
                    }
                }
            });
            notification.notify($project);
            $openPromise.onProcessed(arg_0 -> ChromeLocalVmConnection.launchBrowserAndOpen$lambda$6$lambda$5(arg_0 -> ChromeLocalVmConnection.launchBrowserAndOpen$lambda$6$lambda$4(notification, arg_0), arg_0));
        }
    }

    private static final Unit processPageConnections$lambda$8$lambda$7(WipVm $it, ChromeLocalVmConnection this$0) {
        Intrinsics.checkNotNull((Object)((Object)$it));
        new WipVmBootstrap($it).navigate(this$0.getUrl());
        return Unit.INSTANCE;
    }

    private static final Unit processPageConnections$lambda$8(ChromeLocalVmConnection this$0, WipVm it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        it.addReadyListener((Function0<Unit>)((Function0)() -> ChromeLocalVmConnection.processPageConnections$lambda$8$lambda$7(it, this$0)));
        return Unit.INSTANCE;
    }

    private static final void processPageConnections$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Deferred access$getProcessHandle$p(ChromeLocalVmConnection $this) {
        return $this.processHandle;
    }

    public static final /* synthetic */ Promise access$detachAndClose$s187710434(ChromeLocalVmConnection $this) {
        return super.detachAndClose();
    }

    public static final /* synthetic */ boolean access$getReusedExistingBrowserInstance$p(ChromeLocalVmConnection $this) {
        return $this.reusedExistingBrowserInstance;
    }

    public static final /* synthetic */ boolean access$getNewPageRequested$p(ChromeLocalVmConnection $this) {
        return $this.newPageRequested;
    }

    public static final /* synthetic */ void access$setNewPageRequested$p(ChromeLocalVmConnection $this, boolean bl) {
        $this.newPageRequested = bl;
    }
}

