/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer;

import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.scripts.ScriptsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebuggerUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0017\u0010\u0005\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0015\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\u00042\u0006\u0010\f\u001a\u00020\u0006H\u0000\u001a\"\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"EDITOR_MARKED", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getSourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "source", "Lcom/intellij/util/Url;", "getFileTitle", "", "file", "createSourceFromProvidedContent", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "url", "script", "Lcom/intellij/openapi/util/UserDataHolder;", "setupEditor", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "intellij.javascript.debugger"})
public final class SourceMapInspectorKt {
    @NotNull
    private static final Key<Boolean> EDITOR_MARKED;

    @Nullable
    public static final VirtualFile getSourceFile(@NotNull Url source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return LocalFileFinder.findFile((String)source.getPath());
    }

    @NotNull
    public static final String getFileTitle(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = JsFileUtil.trimTitle(FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimTitle(...)");
        return string;
    }

    @Nullable
    public static final VirtualFile createSourceFromProvidedContent(@NotNull SourceMap map, @NotNull Url url, @NotNull UserDataHolder script) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        int sourceIndex = map.getSourceResolver().getSourceIndex(url);
        String string = map.getSourceContent(sourceIndex);
        if (string == null) {
            return null;
        }
        String content = string;
        return ScriptsKt.createVmFile(url, script, content, sourceIndex);
    }

    private static final void setupEditor(EditorEx editor) {
        editor.setRendererMode(true);
        editor.getSettings().setLineNumbersShown(true);
        XDebuggerUtil.getInstance().disableValueLookup((Editor)editor);
    }

    public static final /* synthetic */ void access$setupEditor(EditorEx editor) {
        SourceMapInspectorKt.setupEditor(editor);
    }

    public static final /* synthetic */ Key access$getEDITOR_MARKED$p() {
        return EDITOR_MARKED;
    }

    static {
        Key key = Key.create((String)"marked");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        EDITOR_MARKED = key;
    }
}

