/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.ContainerPort;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerContainerStatus;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.DockerStatus;
import com.intellij.docker.DockerTransitionStatus;
import com.intellij.docker.action.containers.ContainerActionBase;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.pipe.DockerLogPipe;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.agent.util.DockerComposeData;
import com.intellij.docker.agent.util.DockerComposeUtilsKt;
import com.intellij.docker.agent.util.DockerUtil;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntimeKt;
import com.intellij.docker.runtimes.DockerContainerRuntime;
import com.intellij.docker.runtimes.DockerImageRuntime;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerRuntimeDetailsProvider;
import com.intellij.docker.ui.scaffold.Scaffold;
import com.intellij.docker.ui.scaffold.ScaffoldKt;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.docker.view.details.DockerAbstractDashboardTabKt;
import com.intellij.docker.view.details.container.DockerContainerDetailsProvider;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010,\u001a\u00020+H\u0014J\u001d\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\b2J\u0015\u00103\u001a\u00020.2\u0006\u00104\u001a\u00020+H\u0000\u00a2\u0006\u0002\b5J\u0015\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0010\u00a2\u0006\u0002\b:J\u0010\u0010;\u001a\u0002012\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010;\u001a\u0002012\u0006\u0010<\u001a\u00020>H\u0002J,\u0010?\u001a\u00020.*\u0002072\n\b\u0002\u0010@\u001a\u0004\u0018\u00010A2\n\b\u0003\u0010B\u001a\u0004\u0018\u00010 2\u0006\u0010C\u001a\u00020 H\u0002J\u0006\u0010D\u001a\u000201J\u0006\u0010E\u001a\u000201J\u0006\u0010F\u001a\u000201J\u000e\u0010G\u001a\u0002012\u0006\u0010H\u001a\u00020IJ\u000e\u0010J\u001a\b\u0012\u0004\u0012\u00020.0KH\u0016J\u000e\u0010L\u001a\b\u0012\u0004\u0012\u00020.0KH\u0016J\u000e\u0010M\u001a\b\u0012\u0004\u0012\u00020.0KH\u0016J\u000e\u0010N\u001a\b\u0012\u0004\u0012\u00020.0KH\u0016J\u000e\u0010O\u001a\b\u0012\u0004\u0012\u00020.0KH\u0016J\u000e\u0010P\u001a\b\u0012\u0004\u0012\u00020.0KH\u0016J\u001e\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0K2\u0006\u0010S\u001a\u0002012\u0006\u0010T\u001a\u00020IH\u0016J\u000e\u0010U\u001a\b\u0012\u0004\u0012\u00020 0KH\u0016J\u000e\u0010V\u001a\b\u0012\u0004\u0012\u00020W0KH\u0016J\u001e\u0010X\u001a\b\u0012\u0004\u0012\u00020W0K2\u0006\u0010Y\u001a\u00020 2\u0006\u0010Z\u001a\u000201H\u0016J)\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0K2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020 0'2\u0006\u0010]\u001a\u000201H\u0016\u00a2\u0006\u0002\u0010^J'\u0010_\u001a\b\u0012\u0004\u0012\u00020.0K2\u0017\u0010`\u001a\u0013\u0012\u0004\u0012\u00020b\u0012\u0004\u0012\u00020.0a\u00a2\u0006\u0002\bcH\u0016J\b\u0010d\u001a\u00020 H\u0016R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000fR\u0013\u0010\u001f\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0013\u0010#\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020 0'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lcom/intellij/docker/runtimes/DockerApplicationRuntime;", "Lcom/intellij/docker/runtimes/DockerContainerRuntime;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "container", "Lcom/intellij/docker/agent/DockerAgentContainer;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/docker/agent/DockerAgentContainer;Lcom/intellij/openapi/project/Project;)V", "myAgentApplication", "myComposeData", "Lcom/intellij/docker/agent/util/DockerComposeData;", "agentApplication", "getAgentApplication", "()Lcom/intellij/docker/agent/DockerAgentContainer;", "detailsProvider", "Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "getDetailsProvider$intellij_clouds_docker", "()Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "getServer", "()Lcom/intellij/remoteServer/configuration/RemoteServer;", "agent", "Lcom/intellij/docker/agent/DockerAgent;", "getAgent", "()Lcom/intellij/docker/agent/DockerAgent;", "agentContainer", "getAgentContainer", "containerName", "", "getContainerName", "()Ljava/lang/String;", "composeData", "getComposeData", "()Lcom/intellij/docker/agent/util/DockerComposeData;", "myContainerNames", "", "getMyContainerNames", "()[Ljava/lang/String;", "myStatus", "Lcom/intellij/docker/DockerStatus;", "doGetStatus", "setAgentApplication", "", "newAgentContainer", "withNewStatus", "", "setAgentApplication$intellij_clouds_docker", "setStatus", "status", "setStatus$intellij_clouds_docker", "getHeaderComponent", "Lcom/intellij/docker/ui/scaffold/Scaffold$SimpleSegment;", "scaffold", "Lcom/intellij/docker/ui/scaffold/Scaffold;", "getHeaderComponent$intellij_clouds_docker", "isVisible", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/docker/action/containers/ContainerActionBase;", "dockerContainerActionButton", "icon", "Ljavax/swing/Icon;", "name", "actionId", "isRunning", "isPaused", "isStopped", "hasExposedPort", "port", "", "startContainer", "Ljava/util/concurrent/CompletableFuture;", "restartContainer", "pauseContainer", "unpauseContainer", "stopContainerAsync", "deleteContainer", "showLog", "Lcom/intellij/docker/agent/pipe/DockerLogPipe;", "showTimestamps", "tail", "processesJson", "attach", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe;", "exec", "command", "asRoot", "captureExecOutput", "", "includeErr", "([Ljava/lang/String;Z)Ljava/util/concurrent/CompletableFuture;", "updateContainer", "modifyConfig", "Lkotlin/Function1;", "Lcom/github/dockerjava/api/command/CreateContainerCmd;", "Lkotlin/ExtensionFunctionType;", "toString", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerApplicationRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerApplicationRuntime.kt\ncom/intellij/docker/runtimes/DockerApplicationRuntime\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n12637#2,2:252\n12637#2,2:254\n1#3:256\n*S KotlinDebug\n*F\n+ 1 DockerApplicationRuntime.kt\ncom/intellij/docker/runtimes/DockerApplicationRuntime\n*L\n160#1:252,2\n181#1:254,2\n*E\n"})
public final class DockerApplicationRuntime
extends DockerContainerRuntime {
    @NotNull
    private volatile DockerAgentContainer myAgentApplication;
    @Nullable
    private volatile DockerComposeData myComposeData;
    @NotNull
    private volatile DockerStatus myStatus;

    public DockerApplicationRuntime(@NotNull DockerRuntimeContext context, @NotNull DockerAgentContainer container, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(context, project);
        this.myAgentApplication = container;
        this.myComposeData = DockerComposeUtilsKt.getComposeData((DockerAgentContainer)container);
        this.myStatus = DockerApplicationRuntimeKt.access$createStatusFromAgentContainer(container);
    }

    @Override
    @NotNull
    public DockerAgentContainer getAgentApplication() {
        return this.myAgentApplication;
    }

    @Override
    @NotNull
    public DockerRuntimeDetailsProvider getDetailsProvider$intellij_clouds_docker() {
        return new DockerContainerDetailsProvider(this);
    }

    @NotNull
    public final RemoteServer<DockerCloudConfiguration> getServer() {
        return this.getContext().getServer();
    }

    @NotNull
    public final DockerAgent getAgent() {
        return this.getContext().getAgent();
    }

    @NotNull
    public final DockerAgentContainer getAgentContainer() {
        return this.getAgentApplication();
    }

    @Nullable
    public final String getContainerName() {
        return this.getAgentApplication().getContainerName();
    }

    @Nullable
    public final DockerComposeData getComposeData() {
        return this.myComposeData;
    }

    private final String[] getMyContainerNames() {
        return this.getAgentApplication().getContainerNames();
    }

    @Override
    @NotNull
    protected DockerStatus doGetStatus() {
        return this.myStatus;
    }

    public final void setAgentApplication$intellij_clouds_docker(@NotNull DockerAgentContainer newAgentContainer, boolean withNewStatus) {
        Intrinsics.checkNotNullParameter((Object)newAgentContainer, (String)"newAgentContainer");
        this.myAgentApplication = newAgentContainer;
        this.myComposeData = DockerComposeUtilsKt.getComposeData((DockerAgentContainer)newAgentContainer);
        if (withNewStatus) {
            this.setStatus$intellij_clouds_docker(DockerApplicationRuntimeKt.access$createStatusFromAgentContainer(newAgentContainer));
        }
    }

    public final void setStatus$intellij_clouds_docker(@NotNull DockerStatus status) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            this.myStatus = status;
            DockerComposeData dockerComposeData = this.myComposeData;
            if (dockerComposeData == null) break block1;
            DockerComposeData it = dockerComposeData;
            boolean bl = false;
            ComposeServiceRuntime composeServiceRuntime = this.getContext().getRuntimesManager().findComposeService(it.getProject(), it.getService());
            if (composeServiceRuntime != null) {
                composeServiceRuntime.updateParentAndSelfStatus$intellij_clouds_docker();
            }
        }
    }

    @Override
    @NotNull
    public Scaffold.SimpleSegment getHeaderComponent$intellij_clouds_docker(@NotNull Scaffold scaffold) {
        Intrinsics.checkNotNullParameter((Object)scaffold, (String)"scaffold");
        DockerApplicationRuntime runtime = this;
        Scaffold $this$getHeaderComponent_u24lambda_u247 = scaffold;
        boolean bl = false;
        return $this$getHeaderComponent_u24lambda_u247.segment((Function1<? super Scaffold.SimpleSegment, Unit>)((Function1)arg_0 -> DockerApplicationRuntime.getHeaderComponent$lambda$7$lambda$6(runtime, this, arg_0)));
    }

    private final boolean isVisible(AnAction action) {
        boolean bl;
        block3: {
            if (action instanceof DefaultActionGroup) {
                AnAction[] anActionArray = ((DefaultActionGroup)action).getChildren(ActionManager.getInstance());
                Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
                Object[] $this$any$iv = anActionArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    AnAction p0 = (AnAction)element$iv;
                    boolean bl2 = false;
                    if (!this.isVisible(p0)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                Intrinsics.checkNotNull((Object)action, (String)"null cannot be cast to non-null type com.intellij.docker.action.containers.ContainerActionBase");
                bl = this.isVisible((ContainerActionBase)action);
            }
        }
        return bl;
    }

    private final boolean isVisible(ContainerActionBase action) {
        return action.isVisible(this) && action.isEnabled(this);
    }

    private final void dockerContainerActionButton(Scaffold.SimpleSegment $this$dockerContainerActionButton, Icon icon, @Nls String name, String actionId) {
        ScaffoldKt.button($this$dockerContainerActionButton, icon, name, actionId, (Function1<? super AnAction, Boolean>)((Function1)new Function1<AnAction, Boolean>((Object)this){

            public final Boolean invoke(AnAction p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DockerApplicationRuntime.access$isVisible((DockerApplicationRuntime)this.receiver, p0);
            }
        }));
    }

    static /* synthetic */ void dockerContainerActionButton$default(DockerApplicationRuntime dockerApplicationRuntime, Scaffold.SimpleSegment simpleSegment, Icon icon, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            icon = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        dockerApplicationRuntime.dockerContainerActionButton(simpleSegment, icon, string, string2);
    }

    public final boolean isRunning() {
        return this.getStatus() instanceof DockerContainerStatus.Up;
    }

    public final boolean isPaused() {
        return this.getStatus() instanceof DockerContainerStatus.Paused;
    }

    public final boolean isStopped() {
        return this.getStatus() instanceof DockerContainerStatus.Stopped;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasExposedPort(int port) {
        Intrinsics.checkNotNullExpressionValue((Object)this.getAgentContainer().getContainer().ports, (String)"ports");
        Object[] $this$any$iv = this.getAgentContainer().getContainer().ports;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            Object element$iv = $this$any$iv[n];
            ContainerPort it = (ContainerPort)element$iv;
            boolean bl = false;
            Integer n3 = it.getPrivatePort();
            int n4 = port;
            if (n3 != null && n3 == n4) {
                Integer n5 = it.getPublicPort();
                n4 = port;
                if (n5 != null && n5 == n4) {
                    return true;
                }
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> startContainer() {
        return this.runStatusTransition(DockerTransitionStatus.STARTING, this.getAgentApplication().startContainer());
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> restartContainer() {
        return this.runStatusTransition(DockerTransitionStatus.STARTING, this.getAgentApplication().restartContainer());
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> pauseContainer() {
        return this.getAgentApplication().pauseContainer();
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> unpauseContainer() {
        return this.getAgentApplication().unpauseContainer();
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> stopContainerAsync() {
        return this.runStatusTransition(DockerTransitionStatus.STOPPING, this.getAgentApplication().stopContainer());
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> deleteContainer() {
        return this.runStatusTransition(DockerTransitionStatus.DELETING, this.getAgentApplication().deleteContainer());
    }

    @Override
    @NotNull
    public CompletableFuture<DockerLogPipe> showLog(boolean showTimestamps, int tail) {
        return this.getAgentApplication().showLog(showTimestamps, tail);
    }

    @Override
    @NotNull
    public CompletableFuture<String> processesJson() {
        return this.getAgentApplication().computeProcessesJson();
    }

    @Override
    @NotNull
    public CompletableFuture<DockerTerminalPipe> attach() {
        return this.getAgentApplication().attach();
    }

    @Override
    @NotNull
    public CompletableFuture<DockerTerminalPipe> exec(@NotNull String command, boolean asRoot) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        DockerAgentContainer dockerAgentContainer = this.getAgentApplication();
        String[] stringArray = ParametersListUtil.parseToArray((String)command);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"parseToArray(...)");
        return DockerAgentContainer.exec$default((DockerAgentContainer)dockerAgentContainer, (String[])stringArray, (String)(asRoot ? "root" : null), null, null, (int)12, null);
    }

    @Override
    @NotNull
    public CompletableFuture<byte[]> captureExecOutput(@NotNull String[] command, boolean includeErr) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return DockerAgentContainer.captureExecOutput$default((DockerAgentContainer)this.getAgentApplication(), (String[])command, (boolean)includeErr, null, (int)4, null);
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> updateContainer(@NotNull Function1<? super CreateContainerCmd, Unit> modifyConfig) {
        Intrinsics.checkNotNullParameter(modifyConfig, (String)"modifyConfig");
        return this.getAgentApplication().updateContainer(modifyConfig);
    }

    @NotNull
    public String toString() {
        String it = this.getId();
        boolean bl = false;
        String hash = DockerUtil.shortedId((String)it);
        String string = Integer.toHexString(this.hashCode());
        String string2 = Arrays.toString(this.getMyContainerNames());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return "@" + string + " id: " + hash + ", [CNT]: " + string2;
    }

    private static final Unit getHeaderComponent$lambda$7$lambda$6$lambda$1(DockerApplicationRuntime $runtime, Scaffold.SimpleSegment.TextFragment $this$textFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
        $this$textFragment.setIcon($runtime.getStatus().getIcon());
        String string = $runtime.getContainerName();
        if (string == null || (string = StringsKt.removePrefix((String)string, (CharSequence)"/")) == null) {
            string = "<unknown>";
        }
        $this$textFragment.append(string, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        $this$textFragment.append(" " + DockerAbstractDashboardTabKt.shortenDockerId($runtime.getId()), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        $this$textFragment.setToolTipText($runtime.getId());
        return Unit.INSTANCE;
    }

    private static final void getHeaderComponent$lambda$7$lambda$6$lambda$3$lambda$2(DockerImageRuntime $imageRuntime) {
        DockerUiUtilsKt.select($imageRuntime);
    }

    private static final Unit getHeaderComponent$lambda$7$lambda$6$lambda$3(DockerImageRuntime $imageRuntime, DockerApplicationRuntime $runtime, Scaffold.SimpleSegment.TextFragment $this$textFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
        $this$textFragment.setIcon(DockerIcons.SingleImage);
        String imageName = $imageRuntime.getPresentableName();
        $this$textFragment.append(imageName, SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, () -> DockerApplicationRuntime.getHeaderComponent$lambda$7$lambda$6$lambda$3$lambda$2($imageRuntime));
        $this$textFragment.setToolTipText($runtime.getImageId());
        return Unit.INSTANCE;
    }

    private static final void getHeaderComponent$lambda$7$lambda$6$lambda$5$lambda$4(ComposeApplicationRuntime $composeProjectRuntime) {
        DockerUiUtilsKt.select($composeProjectRuntime);
    }

    private static final Unit getHeaderComponent$lambda$7$lambda$6$lambda$5(ComposeApplicationRuntime $composeProjectRuntime, Scaffold.SimpleSegment.TextFragment $this$textFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
        $this$textFragment.setIcon($composeProjectRuntime.getStatus().getIcon());
        $this$textFragment.append($composeProjectRuntime.getPresentableName(), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, () -> DockerApplicationRuntime.getHeaderComponent$lambda$7$lambda$6$lambda$5$lambda$4($composeProjectRuntime));
        return Unit.INSTANCE;
    }

    private static final Unit getHeaderComponent$lambda$7$lambda$6(DockerApplicationRuntime $runtime, DockerApplicationRuntime this$0, Scaffold.SimpleSegment $this$segment) {
        DockerComposeData composeData;
        Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
        $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)arg_0 -> DockerApplicationRuntime.getHeaderComponent$lambda$7$lambda$6$lambda$1($runtime, arg_0)));
        DockerImageRuntime imageRuntime = DockerUtils.getImage($runtime);
        if (imageRuntime != null) {
            $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)arg_0 -> DockerApplicationRuntime.getHeaderComponent$lambda$7$lambda$6$lambda$3(imageRuntime, $runtime, arg_0)));
        }
        if ((composeData = $runtime.getComposeData()) != null) {
            String composeProject = composeData.getProject();
            ComposeApplicationRuntime composeProjectRuntime = $runtime.getContext().getRuntimesManager().findComposeProject(composeProject);
            if (composeProjectRuntime != null) {
                $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)arg_0 -> DockerApplicationRuntime.getHeaderComponent$lambda$7$lambda$6$lambda$5(composeProjectRuntime, arg_0)));
            }
        }
        DockerApplicationRuntime.dockerContainerActionButton$default(this$0, $this$segment, null, DockerBundle.message((String)"group.Docker.RemoteServers.OpenProject.text", (Object[])new Object[0]), "Docker.RemoteServers.OpenProject", 1, null);
        DockerApplicationRuntime.dockerContainerActionButton$default(this$0, $this$segment, null, DockerBundle.message((String)"DockerContainerDashboardTab.button.start", (Object[])new Object[0]), "Docker.RemoteServers.StartContainer", 1, null);
        DockerApplicationRuntime.dockerContainerActionButton$default(this$0, $this$segment, null, DockerBundle.message((String)"DockerContainerDashboardTab.button.restart", (Object[])new Object[0]), "Docker.RemoteServers.RestartContainer", 1, null);
        DockerApplicationRuntime.dockerContainerActionButton$default(this$0, $this$segment, null, DockerBundle.message((String)"DockerContainerDashboardTab.button.stop", (Object[])new Object[0]), "Docker.RemoteServers.StopContainer", 1, null);
        DockerApplicationRuntime.dockerContainerActionButton$default(this$0, $this$segment, null, DockerBundle.message((String)"DockerContainerDashboardTab.button.terminal", (Object[])new Object[0]), "Docker.RemoteServers.CreateTerminal", 1, null);
        ScaffoldKt.additionalAction($this$segment, "Docker.RemoteServers.ShowContainerFiles");
        ScaffoldKt.additionalAction($this$segment, "Docker.RemoteServers.InspectContainerOrImage");
        ScaffoldKt.additionalAction($this$segment, "Docker.RemoteServers.CopyContainerImageId");
        ScaffoldKt.additionalAction($this$segment, "Docker.RemoteServers.CopyContainerId");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isVisible(DockerApplicationRuntime $this, AnAction action) {
        return $this.isVisible(action);
    }
}

