/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.anthropic;

import com.intellij.aiplayground.anthropic.AnthropicClientAPI;
import com.intellij.aiplayground.anthropic.AnthropicClientAPIImpl;
import com.intellij.aiplayground.anthropic.AnthropicClientAPIImplKt;
import com.intellij.aiplayground.anthropic.AnthropicModel;
import com.intellij.aiplayground.anthropic.LocalModelsResponse;
import com.intellij.aiplayground.anthropic.ModelInfoDTO;
import com.intellij.aiplayground.models.LlmModelId;
import com.intellij.util.net.PlatformHttpClient;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import kotlinx.serialization.DeserializationStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J+\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0017R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/aiplayground/anthropic/AnthropicClientAPIImpl;", "Lcom/intellij/aiplayground/anthropic/AnthropicClientAPI;", "getEndpointBaseUrl", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getGetEndpointBaseUrl", "()Lkotlin/jvm/functions/Function0;", "url", "path", "filterModelsByCreatedAt", "", "Lcom/intellij/aiplayground/anthropic/ModelInfoDTO;", "models", "filterByCreatedAt", "", "(Ljava/util/List;Ljava/lang/Long;)Ljava/util/List;", "convertToAnthropicModels", "Lcom/intellij/aiplayground/anthropic/AnthropicModel;", "modelInfoDTOs", "listModels", "apiKey", "(Ljava/lang/String;Ljava/lang/Long;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.aiplayground.anthropic"})
@SourceDebugExtension(value={"SMAP\nAnthropicClientAPIImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnthropicClientAPIImpl.kt\ncom/intellij/aiplayground/anthropic/AnthropicClientAPIImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,109:1\n774#2:110\n865#2,2:111\n1563#2:113\n1634#2,3:114\n222#3:117\n116#4,11:118\n*S KotlinDebug\n*F\n+ 1 AnthropicClientAPIImpl.kt\ncom/intellij/aiplayground/anthropic/AnthropicClientAPIImpl\n*L\n54#1:110\n54#1:111,2\n71#1:113\n71#1:114,3\n93#1:117\n96#1:118,11\n*E\n"})
public final class AnthropicClientAPIImpl
implements AnthropicClientAPI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<String> getEndpointBaseUrl;
    @Nullable
    private static List<ModelInfoDTO> cachedModelDTOs;
    private static long cacheTimestamp;
    private static final int cacheDurationMillis;
    @NotNull
    private static final Mutex cacheMutex;

    public AnthropicClientAPIImpl(@NotNull Function0<String> getEndpointBaseUrl) {
        Intrinsics.checkNotNullParameter(getEndpointBaseUrl, (String)"getEndpointBaseUrl");
        this.getEndpointBaseUrl = getEndpointBaseUrl;
    }

    @NotNull
    protected final Function0<String> getGetEndpointBaseUrl() {
        return this.getEndpointBaseUrl;
    }

    private final String url(String path) {
        return this.getEndpointBaseUrl.invoke() + path;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ModelInfoDTO> filterModelsByCreatedAt(List<ModelInfoDTO> models, Long filterByCreatedAt) {
        void $this$filterTo$iv$iv;
        if (filterByCreatedAt == null) {
            return models;
        }
        long currentTimeMillis = System.currentTimeMillis();
        Iterable $this$filter$iv = models;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            ModelInfoDTO modelInfo = (ModelInfoDTO)element$iv$iv;
            boolean bl2 = false;
            try {
                Instant createdAtInstant = Instant.parse(modelInfo.getCreated_at());
                long createdAtMillis = createdAtInstant.toEpochMilli();
                bl = currentTimeMillis - createdAtMillis <= filterByCreatedAt;
            }
            catch (Exception e) {
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AnthropicModel> convertToAnthropicModels(List<ModelInfoDTO> modelInfoDTOs) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = modelInfoDTOs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void modelInfo;
            ModelInfoDTO modelInfoDTO = (ModelInfoDTO)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AnthropicModel(LlmModelId.constructor-impl((String)modelInfo.getId()), null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object listModels(@NotNull String apiKey, @Nullable Long filterByCreatedAt, @NotNull Continuation<? super List<AnthropicModel>> $completion) {
        if (!($completion instanceof listModels.1)) ** GOTO lbl-1000
        var17_4 = $completion;
        if ((var17_4.label & -2147483648) != 0) {
            var17_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                long J$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ AnthropicClientAPIImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.listModels(null, null, (Continuation<? super List<AnthropicModel>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                currentTime = System.currentTimeMillis();
                if (AnthropicClientAPIImpl.cachedModelDTOs != null && currentTime - AnthropicClientAPIImpl.cacheTimestamp < (long)AnthropicClientAPIImpl.cacheDurationMillis) {
                    v0 = AnthropicClientAPIImpl.cachedModelDTOs;
                    Intrinsics.checkNotNull(v0);
                    filteredData = this.filterModelsByCreatedAt(v0, filterByCreatedAt);
                    return this.convertToAnthropicModels(filteredData);
                }
                v1 = PlatformHttpClient.client();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"client(...)");
                client = v1;
                request = PlatformHttpClient.requestBuilder((URI)new URI(this.url("/v1/models"))).header("x-api-key", apiKey).header("anthropic-version", "2023-06-01").build();
                theResponse = PlatformHttpClient.checkResponse(client.send(request, HttpResponse.BodyHandlers.ofString()));
                responseBody = (String)theResponse.body();
                if (responseBody == null) break;
                var11_18 = AnthropicClientAPIImplKt.getAnthropicJson();
                string$iv = responseBody;
                $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                modelsResponse = (LocalModelsResponse)this_$iv.decodeFromString((DeserializationStrategy)LocalModelsResponse.Companion.serializer(), string$iv);
                $this$withLock_u24default$iv = AnthropicClientAPIImpl.cacheMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)apiKey);
                $continuation.L$1 = filterByCreatedAt;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)theResponse);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)responseBody);
                $continuation.L$6 = modelsResponse;
                $continuation.L$7 = $this$withLock_u24default$iv;
                $continuation.J$0 = currentTime;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v2 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v2 == var18_6) {
                    return var18_6;
                }
                ** GOTO lbl63
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                currentTime = $continuation.J$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$7;
                modelsResponse = (LocalModelsResponse)$continuation.L$6;
                responseBody = (String)$continuation.L$5;
                theResponse = (HttpResponse)$continuation.L$4;
                request = (HttpRequest)$continuation.L$3;
                client = (HttpClient)$continuation.L$2;
                filterByCreatedAt = (Long)$continuation.L$1;
                apiKey = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl63:
                // 2 sources

                try {
                    $i$a$-withLock$default-AnthropicClientAPIImpl$listModels$2 = false;
                    AnthropicClientAPIImpl.cachedModelDTOs = modelsResponse.getData();
                    AnthropicClientAPIImpl.cacheTimestamp = System.currentTimeMillis();
                    var15_25 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                filteredData = this.filterModelsByCreatedAt(modelsResponse.getData(), filterByCreatedAt);
                return this.convertToAnthropicModels(filteredData);
            }
        }
        throw new IOException("Failed to list models: empty response body");
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static {
        cacheDurationMillis = 86400000;
        cacheMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/aiplayground/anthropic/AnthropicClientAPIImpl$Companion;", "", "<init>", "()V", "cachedModelDTOs", "", "Lcom/intellij/aiplayground/anthropic/ModelInfoDTO;", "cacheTimestamp", "", "cacheDurationMillis", "", "cacheMutex", "Lkotlinx/coroutines/sync/Mutex;", "intellij.aiplayground.anthropic"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

