/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.impl.util.table.CssTableValueBase;
import com.intellij.psi.css.impl.util.table.CssTableValueVisitor;
import com.intellij.psi.css.impl.util.table.XmlStringWriter;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssTableLoaderValue
extends CssTableValueBase<CssTableLoaderValue, String> {
    @NonNls
    private static final Map<String, String> ourValueTypes = new HashMap<String, String>();
    @NonNls
    private static final List<String> ourDoNotCompleteValues;
    private CssTableLoaderValue myParent;
    static final Set<String> ourUnknownTypes;

    public CssTableLoaderValue(@NotNull CssTableValue.Type type) {
        if (type == null) {
            CssTableLoaderValue.$$$reportNull$$$0(0);
        }
        super(type);
    }

    public CssTableLoaderValue(@Nullable String value) {
        super(value);
    }

    @Nullable
    public CssTableLoaderValue getParent() {
        return this.myParent;
    }

    public void setParent(@Nullable CssTableLoaderValue parent) {
        this.myParent = parent;
    }

    @Override
    public CssTableLoaderValue addChild(@NotNull CssTableLoaderValue child) {
        if (child == null) {
            CssTableLoaderValue.$$$reportNull$$$0(1);
        }
        child.setParent(this);
        return super.addChild(child);
    }

    @Override
    public void removeChild(@NotNull CssTableLoaderValue child) {
        if (child == null) {
            CssTableLoaderValue.$$$reportNull$$$0(2);
        }
        super.removeChild(child);
        child.setParent(null);
    }

    @Override
    protected void removeAllChildren() {
        for (CssTableLoaderValue child : this.getChildren()) {
            child.setParent(null);
        }
        super.removeAllChildren();
    }

    public void write(@NotNull String propertyName, @NotNull XmlStringWriter writer) {
        if (propertyName == null) {
            CssTableLoaderValue.$$$reportNull$$$0(3);
        }
        if (writer == null) {
            CssTableLoaderValue.$$$reportNull$$$0(4);
        }
        this.write(propertyName, writer, (Function<String, String>)((Function)v -> CssTableLoaderValue.getMapKey(v)), (Function<String, String>)((Function)key -> ourValueTypes.get(key)));
    }

    public void write(@NotNull String propertyName, @NotNull XmlStringWriter writer, Function<String, String> map, Function<String, String> vmap) {
        if (propertyName == null) {
            CssTableLoaderValue.$$$reportNull$$$0(5);
        }
        if (writer == null) {
            CssTableLoaderValue.$$$reportNull$$$0(6);
        }
        switch (this.getType()) {
            case ANY: {
                writer.addAttribute("type", StringUtil.toLowerCase((String)CssTableValue.Type.ANY.toString()));
                break;
            }
            case FULL_ANY: {
                writer.addAttribute("type", StringUtil.toLowerCase((String)CssTableValue.Type.FULL_ANY.toString()));
                break;
            }
            case OR: {
                writer.addAttribute("type", StringUtil.toLowerCase((String)CssTableValue.Type.OR.toString()));
                break;
            }
        }
        if (-1 != this.getMinCount()) {
            writer.addAttribute("min", this.getMinCount());
            writer.addAttribute("max", this.getMaxCount());
        }
        if (this.getPrefix() != null) {
            writer.addAttribute("prefix", this.getPrefix());
        }
        if (this.isGroup()) {
            final boolean[] notComplete = new boolean[]{false};
            this.accept(new CssTableValueVisitor<CssTableLoaderValue>(){

                @Override
                public void visit(@NotNull CssTableLoaderValue value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    for (CssTableLoaderValue each : value.getChildren()) {
                        String s = (String)each.getValue();
                        if (s == null || !s.equals("identifier#helpref=syndata.html#value-def-identifier")) continue;
                        notComplete[0] = true;
                        break;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/CssTableLoaderValue$1", "visit"));
                }
            });
            if (notComplete[0]) {
                writer.addAttribute("donotcomplete", "true");
            }
            writer.printlnOpeningTag("group");
            for (CssTableLoaderValue each : this.getChildren()) {
                each.write(propertyName, writer, map, vmap);
            }
            writer.printlnClosingTag();
        } else {
            String functionName;
            String functionName2;
            int funcNdx;
            String v = (String)this.getValue();
            assert (v != null);
            if (ourDoNotCompleteValues.contains(v)) {
                writer.addAttribute("donotcomplete", "true");
            }
            if ((funcNdx = v.indexOf("#func")) >= 0 && (functionName2 = CssTableLoaderValue.getMapKey(v)) != null) {
                writer.addAttribute("vtype", "function");
                writer.addAttribute("function-name", functionName2);
                writer.printlnShortTag("value");
                return;
            }
            int optfuncNdx = v.indexOf("#optfunc");
            if (optfuncNdx >= 0 && (functionName = CssTableLoaderValue.getMapKey(v)) != null) {
                writer.addAttribute("vtype", "optional-function");
                writer.addAttribute("function-name", functionName);
                writer.printlnShortTag("value");
                return;
            }
            int proprefNdx = v.indexOf("#propref");
            boolean forceTypeRef = v.contains("#typeref");
            String key = (String)map.fun((Object)v);
            String valueType = (String)vmap.fun((Object)key);
            if (forceTypeRef && valueType == null) {
                valueType = "identifier";
                ourUnknownTypes.add(key);
            }
            if (valueType != null) {
                writer.addAttribute("vtype", valueType);
                if (-1 != proprefNdx && !propertyName.equals(v.substring(0, proprefNdx))) {
                    writer.addAttribute("refname", v.substring(0, proprefNdx));
                }
                writer.printlnShortTag("value");
            } else {
                int helprefNdx = v.indexOf("#helpref=");
                if (-1 != helprefNdx) {
                    writer.addAttribute("helpRef", v.substring(helprefNdx + "helpref=".length() + 1));
                    writer.printlnFullTag("value", v.substring(0, helprefNdx));
                } else if (-1 != proprefNdx) {
                    writer.addAttribute("vtype", "ref");
                    writer.addAttribute("refname", v.substring(0, proprefNdx));
                    writer.printlnShortTag("value");
                } else {
                    writer.printlnFullTag("value", v);
                }
            }
        }
    }

    @Nullable
    private static String getMapKey(String v) {
        int sharpIndex = v.indexOf(35);
        int parenIndex = v.indexOf(40);
        String key = null;
        if (sharpIndex != -1) {
            int min = parenIndex < sharpIndex && parenIndex != -1 ? parenIndex : sharpIndex;
            key = v.substring(0, min);
        } else if (parenIndex != -1) {
            key = v.substring(0, parenIndex);
        }
        return key;
    }

    static {
        ourValueTypes.put("angle", "angle");
        ourValueTypes.put("resolution", "resolution");
        ourValueTypes.put("percentage", "percentage");
        ourValueTypes.put("length", "length");
        ourValueTypes.put("shape", "shape");
        ourValueTypes.put("uri", "uri");
        ourValueTypes.put("counter", "counter");
        ourValueTypes.put("attr", "attr");
        ourValueTypes.put("string", "string");
        ourValueTypes.put("border-style", "border-style");
        ourValueTypes.put("border-width", "border-width");
        ourValueTypes.put("color", "color");
        ourValueTypes.put("identifier", "identifier");
        ourValueTypes.put("integer", "integer");
        ourValueTypes.put("number", "integer");
        ourValueTypes.put("time", "time");
        ourValueTypes.put("generic-family", "generic-font-family");
        ourValueTypes.put("family-name", "font-family");
        ourValueTypes.put("absolute-size", "absolute-size");
        ourValueTypes.put("relative-size", "relative-size");
        ourValueTypes.put("frequency", "frequency");
        ourValueTypes.put("margin-width", "margin-width");
        ourValueTypes.put("padding-width", "padding-width");
        ourValueTypes.put("non-negative-integer", "integer");
        ourValueTypes.put("image", "image");
        ourValueTypes.put(", family-name#helpref=fonts.html#value-def-family-name", "font-family");
        ourDoNotCompleteValues = new ArrayList<String>();
        ourDoNotCompleteValues.add("string#helpref=syndata.html#value-def-string");
        ourDoNotCompleteValues.add("number#helpref=syndata.html#value-def-number");
        ourUnknownTypes = new HashSet<String>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssTableLoaderValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addChild";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeChild";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

