/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.DirectoryChooser;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewClassOnUmlDialog
extends DialogWrapper {
    private JTextField myClassName;
    private ComboboxWithBrowseButton myDir;
    private JPanel myPanel;
    private JPanel myDirPanel;
    private final PsiPackage myPsiPackage;
    private ReferenceEditorComboWithBrowseButton myPackageName;

    protected NewClassOnUmlDialog(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            NewClassOnUmlDialog.$$$reportNull$$$0(0);
        }
        super(psiPackage.getProject());
        this.myPsiPackage = psiPackage;
        this.$$$setupUI$$$();
        this.init();
    }

    protected JComponent createCenterPanel() {
        this.myDirPanel.add((Component)this.myPackageName, "Center");
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myClassName;
    }

    private void createUIComponents() {
        Project project = this.myPsiPackage.getProject();
        ActionListener packageListener = event -> {
            PackageChooserDialog chooser = new PackageChooserDialog(DiagramJavaBundle.message("new.class.choose.package", new Object[0]), project);
            chooser.selectPackage(this.myPackageName.getText());
            chooser.show();
            PsiPackage aPackage = chooser.getSelectedPackage();
            if (aPackage != null) {
                String name = aPackage.getQualifiedName();
                this.myPackageName.appendItem(name);
                this.myPackageName.setText(name);
            }
        };
        this.myPackageName = new ReferenceEditorComboWithBrowseButton(packageListener, this.myPsiPackage.getQualifiedName(), project, false, "uml.new.java.class");
        DestinationFolderComboBox folderComboBox = new DestinationFolderComboBox(){

            public String getTargetPackage() {
                return NewClassOnUmlDialog.this.myPackageName.getText();
            }
        };
        folderComboBox.setData(project, (PsiDirectory)ArrayUtil.getFirstElement((Object[])new PackageWrapper(this.myPsiPackage).getDirectories()), (EditorComboBox)this.myPackageName.getChildComponent());
        this.myDir = folderComboBox;
    }

    @Nullable
    public PsiDirectory getPsiDirectory() {
        ProjectFileIndex projectFileIndex;
        PsiPackage aPackage;
        PsiDirectory directory;
        DirectoryChooser.ItemWrapper item = (DirectoryChooser.ItemWrapper)this.myDir.getComboBox().getSelectedItem();
        PsiDirectory psiDirectory = directory = item == null ? null : item.getDirectory();
        if (directory == null && (aPackage = JavaPsiFacade.getInstance((Project)this.myPsiPackage.getProject()).findPackage(this.myPackageName.getText())) != null && (directory = (PsiDirectory)ArrayUtil.getFirstElement((Object[])aPackage.getDirectories())) != null && (projectFileIndex = ProjectRootManager.getInstance((Project)this.myPsiPackage.getProject()).getFileIndex()).isInLibraryClasses(directory.getVirtualFile())) {
            return null;
        }
        return directory;
    }

    @NotNull
    public String getClassName() {
        String string = this.myClassName.getText();
        if (string == null) {
            NewClassOnUmlDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getPackage() {
        String string = this.myPackageName.getText();
        if (string == null) {
            NewClassOnUmlDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected ValidationInfo doValidate() {
        String className = this.myClassName.getText();
        if (!PsiNameHelper.getInstance((Project)this.myPsiPackage.getProject()).isIdentifier(className)) {
            return new ValidationInfo(DiagramJavaBundle.message("validation.info.bad.class.name", new Object[0]), (JComponent)this.myClassName);
        }
        PsiDirectory directory = this.getPsiDirectory();
        if (directory == null) {
            return new ValidationInfo(DiagramJavaBundle.message("validation.info.directory.shouldn.t.be.empty", new Object[0]), (JComponent)this.myDir);
        }
        String name = className + ".java";
        if (directory.findFile(name) != null || directory.findSubdirectory(name) != null) {
            return new ValidationInfo(DiagramJavaBundle.message("validation.info.0.already.exists", name), (JComponent)this.myClassName);
        }
        return super.doValidate();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DiagramJavaBundle", NewClassOnUmlDialog.class).getString("new.class.dialog.name"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DiagramJavaBundle", NewClassOnUmlDialog.class).getString("new.class.dialog.package"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DiagramJavaBundle", NewClassOnUmlDialog.class).getString("new.class.dialog.target.dir"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null, 1));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myDir;
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myClassName = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
        this.myDirPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor((Component)comboboxWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/actions/NewClassOnUmlDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/actions/NewClassOnUmlDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

