/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.java;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import java.util.List;
import ru.adelf.idea.dotenv.java.JavaEnvironmentClasses;

final class JavaPsiHelper {
    JavaPsiHelper() {
    }

    static boolean isEnvStringLiteral(PsiLiteralExpression literal) {
        PsiElement parent = literal.getParent();
        if (parent instanceof PsiExpressionList) {
            PsiExpression[] expressions = ((PsiExpressionList)parent).getExpressions();
            if (expressions.length < 1) {
                return false;
            }
            if (expressions[0] != literal) {
                return false;
            }
            PsiElement methodCall = parent.getParent();
            if (!(methodCall instanceof PsiMethodCallExpression)) {
                return false;
            }
            return JavaPsiHelper.isEnvMethodCall((PsiMethodCallExpression)methodCall);
        }
        return false;
    }

    static boolean isEnvMethodCall(PsiMethodCallExpression methodCallExpression) {
        PsiElement nameElement = methodCallExpression.getMethodExpression().getReferenceNameElement();
        if (nameElement == null) {
            return false;
        }
        String methodName = nameElement.getText();
        if (JavaEnvironmentClasses.isDirectMethodCall(methodName)) {
            return true;
        }
        List<String> classNames = JavaEnvironmentClasses.getClassNames(methodName);
        if (classNames == null) {
            return false;
        }
        for (JavaResolveResult result : methodCallExpression.multiResolve(true)) {
            PsiMethod method;
            PsiClass psiClass;
            PsiElement psiElement = result.getElement();
            if (!(psiElement instanceof PsiMethod) || (psiClass = (method = (PsiMethod)psiElement).getContainingClass()) == null || !classNames.contains(psiClass.getName())) continue;
            return true;
        }
        return false;
    }
}

