/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.datum;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.locationtech.proj4j.datum.Grid;
import org.locationtech.proj4j.util.FloatPolarCoordinate;
import org.locationtech.proj4j.util.IntPolarCoordinate;
import org.locationtech.proj4j.util.PolarCoordinate;

public final class NTV1 {
    private static final byte[] magic1 = "HEADER".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] magic2 = "W GRID".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] magic3 = "TO      NAD83   ".getBytes(StandardCharsets.US_ASCII);

    public static boolean testHeader(byte[] header) {
        return NTV1.containsAt(magic1, header, 0) && NTV1.containsAt(magic2, header, 96) && NTV1.containsAt(magic3, header, 144);
    }

    public static Grid.ConversionTable init(DataInputStream definition) throws IOException {
        byte[] header = new byte[160];
        definition.readFully(header);
        if (!NTV1.testHeader(header)) {
            throw new Error("Not a NTV1 file");
        }
        int recordCount = NTV1.intFromBytes(header, 8);
        if (recordCount != 12) {
            throw new Error(String.format("NTv1 grid shift file has wrong record count, corrupt? $0%08X $0", recordCount));
        }
        Grid.ConversionTable table = new Grid.ConversionTable();
        table.id = "NTv1 Grid Shift File";
        table.ll = new PolarCoordinate(-NTV1.doubleFromBytes(header, 72), NTV1.doubleFromBytes(header, 24));
        PolarCoordinate ur = new PolarCoordinate(-NTV1.doubleFromBytes(header, 56), NTV1.doubleFromBytes(header, 40));
        table.del = new PolarCoordinate(NTV1.doubleFromBytes(header, 104), NTV1.doubleFromBytes(header, 88));
        table.lim = new IntPolarCoordinate((int)(Math.abs(ur.lam - table.ll.lam) / table.del.lam + 0.5) + 1, (int)(Math.abs(ur.phi - table.ll.phi) / table.del.phi + 0.5) + 1);
        table.ll.lam *= Math.PI / 180;
        table.ll.phi *= Math.PI / 180;
        table.del.lam *= Math.PI / 180;
        table.del.phi *= Math.PI / 180;
        return table;
    }

    public static void load(DataInputStream definition, Grid grid) throws IOException {
        definition.skip(176L);
        double[] row_buff = new double[grid.table.lim.lam * 2];
        FloatPolarCoordinate[] tmp_cvs = new FloatPolarCoordinate[grid.table.lim.lam * grid.table.lim.phi];
        for (int row = 0; row < grid.table.lim.phi; ++row) {
            byte[] byteBuff = new byte[8 * row_buff.length];
            definition.readFully(byteBuff);
            ByteBuffer.wrap(byteBuff).order(ByteOrder.BIG_ENDIAN).asDoubleBuffer().get(row_buff);
            for (int i2 = 0; i2 < grid.table.lim.lam; ++i2) {
                tmp_cvs[row * grid.table.lim.lam + grid.table.lim.lam - i2 - 1] = new FloatPolarCoordinate((float)(row_buff[2 * i2] * Math.PI / 180.0 / 3600.0), (float)(row_buff[2 * i2 + 1] * Math.PI / 180.0 / 3600.0));
            }
        }
        grid.table.cvs = tmp_cvs;
    }

    private static boolean containsAt(byte[] needle, byte[] haystack, int offset) {
        if (needle == null || haystack == null) {
            return false;
        }
        int maxoffset = Math.min(needle.length - 1, haystack.length - offset - 1);
        for (int i2 = 0; i2 < maxoffset; ++i2) {
            if (needle[i2] == haystack[offset + i2]) continue;
            return false;
        }
        return true;
    }

    private static double doubleFromBytes(byte[] b, int offset) {
        return ByteBuffer.wrap(b, offset, 8).order(ByteOrder.BIG_ENDIAN).getDouble();
    }

    private static int intFromBytes(byte[] b, int offset) {
        return ByteBuffer.wrap(b, offset, 4).order(ByteOrder.BIG_ENDIAN).getInt();
    }
}

