/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.proj4j.datum.Datum;
import org.locationtech.proj4j.datum.Ellipsoid;
import org.locationtech.proj4j.proj.AiryProjection;
import org.locationtech.proj4j.proj.AitoffProjection;
import org.locationtech.proj4j.proj.AlbersProjection;
import org.locationtech.proj4j.proj.AugustProjection;
import org.locationtech.proj4j.proj.BipolarProjection;
import org.locationtech.proj4j.proj.BoggsProjection;
import org.locationtech.proj4j.proj.BonneProjection;
import org.locationtech.proj4j.proj.CassiniProjection;
import org.locationtech.proj4j.proj.CentralCylindricalProjection;
import org.locationtech.proj4j.proj.CollignonProjection;
import org.locationtech.proj4j.proj.CrasterProjection;
import org.locationtech.proj4j.proj.CylindricalEqualAreaProjection;
import org.locationtech.proj4j.proj.DenoyerProjection;
import org.locationtech.proj4j.proj.Eckert1Projection;
import org.locationtech.proj4j.proj.Eckert2Projection;
import org.locationtech.proj4j.proj.Eckert4Projection;
import org.locationtech.proj4j.proj.Eckert5Projection;
import org.locationtech.proj4j.proj.Eckert6Projection;
import org.locationtech.proj4j.proj.EquidistantAzimuthalProjection;
import org.locationtech.proj4j.proj.EquidistantConicProjection;
import org.locationtech.proj4j.proj.EulerProjection;
import org.locationtech.proj4j.proj.ExtendedTransverseMercatorProjection;
import org.locationtech.proj4j.proj.FaheyProjection;
import org.locationtech.proj4j.proj.FoucautProjection;
import org.locationtech.proj4j.proj.FoucautSinusoidalProjection;
import org.locationtech.proj4j.proj.GallProjection;
import org.locationtech.proj4j.proj.GeocentProjection;
import org.locationtech.proj4j.proj.GeostationarySatelliteProjection;
import org.locationtech.proj4j.proj.GnomonicAzimuthalProjection;
import org.locationtech.proj4j.proj.GoodeProjection;
import org.locationtech.proj4j.proj.HammerProjection;
import org.locationtech.proj4j.proj.HatanoProjection;
import org.locationtech.proj4j.proj.KavraiskyVProjection;
import org.locationtech.proj4j.proj.KrovakProjection;
import org.locationtech.proj4j.proj.LagrangeProjection;
import org.locationtech.proj4j.proj.LambertAzimuthalEqualAreaProjection;
import org.locationtech.proj4j.proj.LambertConformalConicProjection;
import org.locationtech.proj4j.proj.LambertEqualAreaConicProjection;
import org.locationtech.proj4j.proj.LandsatProjection;
import org.locationtech.proj4j.proj.LarriveeProjection;
import org.locationtech.proj4j.proj.LaskowskiProjection;
import org.locationtech.proj4j.proj.LongLatProjection;
import org.locationtech.proj4j.proj.LoximuthalProjection;
import org.locationtech.proj4j.proj.McBrydeThomasFlatPolarParabolicProjection;
import org.locationtech.proj4j.proj.McBrydeThomasFlatPolarQuarticProjection;
import org.locationtech.proj4j.proj.McBrydeThomasFlatPolarSine2Projection;
import org.locationtech.proj4j.proj.MercatorProjection;
import org.locationtech.proj4j.proj.MillerProjection;
import org.locationtech.proj4j.proj.MolleweideProjection;
import org.locationtech.proj4j.proj.Murdoch1Projection;
import org.locationtech.proj4j.proj.Murdoch2Projection;
import org.locationtech.proj4j.proj.Murdoch3Projection;
import org.locationtech.proj4j.proj.NellProjection;
import org.locationtech.proj4j.proj.NewZealandMapGridProjection;
import org.locationtech.proj4j.proj.NicolosiProjection;
import org.locationtech.proj4j.proj.ObliqueMercatorProjection;
import org.locationtech.proj4j.proj.ObliqueStereographicAlternativeProjection;
import org.locationtech.proj4j.proj.OrthographicAzimuthalProjection;
import org.locationtech.proj4j.proj.PerspectiveConicProjection;
import org.locationtech.proj4j.proj.PerspectiveProjection;
import org.locationtech.proj4j.proj.PlateCarreeProjection;
import org.locationtech.proj4j.proj.PolyconicProjection;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.proj.PutninsP2Projection;
import org.locationtech.proj4j.proj.PutninsP4Projection;
import org.locationtech.proj4j.proj.PutninsP5PProjection;
import org.locationtech.proj4j.proj.PutninsP5Projection;
import org.locationtech.proj4j.proj.QuarticAuthalicProjection;
import org.locationtech.proj4j.proj.RectangularPolyconicProjection;
import org.locationtech.proj4j.proj.RobinsonProjection;
import org.locationtech.proj4j.proj.SinusoidalProjection;
import org.locationtech.proj4j.proj.StereographicAzimuthalProjection;
import org.locationtech.proj4j.proj.SwissObliqueMercatorProjection;
import org.locationtech.proj4j.proj.TransverseCylindricalEqualArea;
import org.locationtech.proj4j.proj.TransverseMercatorProjection;
import org.locationtech.proj4j.proj.TranverseCentralCylindricalProjection;
import org.locationtech.proj4j.proj.UrmaevFlatPolarSinusoidalProjection;
import org.locationtech.proj4j.proj.VanDerGrintenProjection;
import org.locationtech.proj4j.proj.VitkovskyProjection;
import org.locationtech.proj4j.proj.Wagner1Projection;
import org.locationtech.proj4j.proj.Wagner2Projection;
import org.locationtech.proj4j.proj.Wagner3Projection;
import org.locationtech.proj4j.proj.Wagner4Projection;
import org.locationtech.proj4j.proj.Wagner5Projection;
import org.locationtech.proj4j.proj.Wagner7Projection;
import org.locationtech.proj4j.proj.WerenskioldProjection;
import org.locationtech.proj4j.proj.WinkelTripelProjection;

public class Registry {
    public static final Datum[] datums = new Datum[]{Datum.WGS84, Datum.GGRS87, Datum.NAD27, Datum.NAD83, Datum.POTSDAM, Datum.CARTHAGE, Datum.HERMANNSKOGEL, Datum.IRE65, Datum.NZGD49, Datum.OSGB36};
    public static final Ellipsoid[] ellipsoids = new Ellipsoid[]{Ellipsoid.SPHERE, new Ellipsoid("MERIT", 6378137.0, 0.0, 298.257, "MERIT 1983"), new Ellipsoid("SGS85", 6378136.0, 0.0, 298.257, "Soviet Geodetic System 85"), Ellipsoid.GRS80, new Ellipsoid("IAU76", 6378140.0, 0.0, 298.257, "IAU 1976"), Ellipsoid.AIRY, Ellipsoid.MOD_AIRY, new Ellipsoid("APL4.9", 6378137.0, 0.0, 298.25, "Appl. Physics. 1965"), new Ellipsoid("NWL9D", 6378145.0, 298.25, 0.0, "Naval Weapons Lab., 1965"), new Ellipsoid("andrae", 6377104.43, 300.0, 0.0, "Andrae 1876 (Den., Iclnd.)"), new Ellipsoid("aust_SA", 6378160.0, 0.0, 298.25, "Australian Natl & S. Amer. 1969"), new Ellipsoid("GRS67", 6378160.0, 0.0, 298.247167427, "GRS 67 (IUGG 1967)"), Ellipsoid.BESSEL, new Ellipsoid("bess_nam", 6377483.865, 0.0, 299.1528128, "Bessel 1841 (Namibia)"), Ellipsoid.CLARKE_1866, Ellipsoid.CLARKE_1880, new Ellipsoid("CPM", 6375738.7, 0.0, 334.29, "Comm. des Poids et Mesures 1799"), new Ellipsoid("delmbr", 6376428.0, 0.0, 311.5, "Delambre 1810 (Belgium)"), new Ellipsoid("engelis", 6378136.05, 0.0, 298.2566, "Engelis 1985"), Ellipsoid.EVEREST, new Ellipsoid("evrst48", 6377304.063, 0.0, 300.8017, "Everest 1948"), new Ellipsoid("evrst56", 6377301.243, 0.0, 300.8017, "Everest 1956"), new Ellipsoid("evrst69", 6377295.664, 0.0, 300.8017, "Everest 1969"), new Ellipsoid("evrstSS", 6377298.556, 0.0, 300.8017, "Everest (Sabah & Sarawak)"), new Ellipsoid("fschr60", 6378166.0, 0.0, 298.3, "Fischer (Mercury Datum) 1960"), new Ellipsoid("fschr60m", 6378155.0, 0.0, 298.3, "Modified Fischer 1960"), new Ellipsoid("fschr68", 6378150.0, 0.0, 298.3, "Fischer 1968"), new Ellipsoid("helmert", 6378200.0, 0.0, 298.3, "Helmert 1906"), new Ellipsoid("hough", 6378270.0, 0.0, 297.0, "Hough"), Ellipsoid.INTERNATIONAL, Ellipsoid.INTERNATIONAL_1967, Ellipsoid.KRASSOVSKY, new Ellipsoid("kaula", 6378163.0, 0.0, 298.24, "Kaula 1961"), new Ellipsoid("lerch", 6378139.0, 0.0, 298.257, "Lerch 1979"), new Ellipsoid("mprts", 6397300.0, 0.0, 191.0, "Maupertius 1738"), new Ellipsoid("plessis", 6376523.0, 6355863.0, 0.0, "Plessis 1817 France)"), new Ellipsoid("SEasia", 6378155.0, 6356773.3205, 0.0, "Southeast Asia"), new Ellipsoid("walbeck", 6376896.0, 6355834.8467, 0.0, "Walbeck"), Ellipsoid.WGS60, Ellipsoid.WGS66, Ellipsoid.WGS72, Ellipsoid.WGS84, new Ellipsoid("NAD27", 6378249.145, 0.0, 293.4663, "NAD27: Clarke 1880 mod."), new Ellipsoid("NAD83", 6378137.0, 0.0, 298.257222101, "NAD83: GRS 1980 (IUGG, 1980)")};
    private Map<String, Class> projRegistry;

    public Registry() {
        this.initialize();
    }

    public Datum getDatum(String code) {
        for (int i2 = 0; i2 < datums.length; ++i2) {
            if (!datums[i2].getCode().equals(code)) continue;
            return datums[i2];
        }
        return null;
    }

    public Ellipsoid getEllipsoid(String name2) {
        for (int i2 = 0; i2 < ellipsoids.length; ++i2) {
            if (!Registry.ellipsoids[i2].shortName.equals(name2)) continue;
            return ellipsoids[i2];
        }
        return null;
    }

    private void register(String name2, Class cls, String description) {
        this.projRegistry.put(name2, cls);
    }

    public Projection getProjection(String name2) {
        Class cls = this.projRegistry.get(name2);
        if (cls != null) {
            try {
                Projection projection = (Projection)cls.newInstance();
                if (projection != null) {
                    projection.setName(name2);
                }
                return projection;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                System.err.println("Cannot instantiate projection " + name2 + " [" + cls.getName() + "]");
                e.printStackTrace();
            }
        }
        return null;
    }

    public List<Projection> getProjections() {
        ArrayList<Projection> projections = new ArrayList<Projection>();
        for (String name2 : this.projRegistry.keySet()) {
            Projection projection = this.getProjection(name2);
            if (projection == null) continue;
            projections.add(projection);
        }
        return projections;
    }

    private synchronized void initialize() {
        if (this.projRegistry != null) {
            return;
        }
        this.projRegistry = new HashMap<String, Class>();
        this.register("aea", AlbersProjection.class, "Albers Equal Area");
        this.register("aeqd", EquidistantAzimuthalProjection.class, "Azimuthal Equidistant");
        this.register("airy", AiryProjection.class, "Airy");
        this.register("aitoff", AitoffProjection.class, "Aitoff");
        this.register("alsk", Projection.class, "Mod. Stereographics of Alaska");
        this.register("apian", Projection.class, "Apian Globular I");
        this.register("august", AugustProjection.class, "August Epicycloidal");
        this.register("bacon", Projection.class, "Bacon Globular");
        this.register("bipc", BipolarProjection.class, "Bipolar conic of western hemisphere");
        this.register("boggs", BoggsProjection.class, "Boggs Eumorphic");
        this.register("bonne", BonneProjection.class, "Bonne (Werner lat_1=90)");
        this.register("cass", CassiniProjection.class, "Cassini");
        this.register("cc", CentralCylindricalProjection.class, "Central Cylindrical");
        this.register("cea", CylindricalEqualAreaProjection.class, "Equal Area Cylindrical");
        this.register("collg", CollignonProjection.class, "Collignon");
        this.register("crast", CrasterProjection.class, "Craster Parabolic (Putnins P4)");
        this.register("denoy", DenoyerProjection.class, "Denoyer Semi-Elliptical");
        this.register("eck1", Eckert1Projection.class, "Eckert I");
        this.register("eck2", Eckert2Projection.class, "Eckert II");
        this.register("eck4", Eckert4Projection.class, "Eckert IV");
        this.register("eck5", Eckert5Projection.class, "Eckert V");
        this.register("eck6", Eckert6Projection.class, "Eckert VI");
        this.register("eqc", PlateCarreeProjection.class, "Equidistant Cylindrical (Plate Caree)");
        this.register("eqdc", EquidistantConicProjection.class, "Equidistant Conic");
        this.register("euler", EulerProjection.class, "Euler");
        this.register("fahey", FaheyProjection.class, "Fahey");
        this.register("fouc", FoucautProjection.class, "Foucaut");
        this.register("fouc_s", FoucautSinusoidalProjection.class, "Foucaut Sinusoidal");
        this.register("gall", GallProjection.class, "Gall (Gall Stereographic)");
        this.register("geocent", GeocentProjection.class, "Geocentric");
        this.register("geos", GeostationarySatelliteProjection.class, "Geostationary Satellite");
        this.register("gnom", GnomonicAzimuthalProjection.class, "Gnomonic");
        this.register("goode", GoodeProjection.class, "Goode Homolosine");
        this.register("hammer", HammerProjection.class, "Hammer & Eckert-Greifendorff");
        this.register("hatano", HatanoProjection.class, "Hatano Asymmetrical Equal Area");
        this.register("kav5", KavraiskyVProjection.class, "Kavraisky V");
        this.register("krovak", KrovakProjection.class, "Krovak");
        this.register("laea", LambertAzimuthalEqualAreaProjection.class, "Lambert Azimuthal Equal Area");
        this.register("lagrng", LagrangeProjection.class, "Lagrange");
        this.register("larr", LarriveeProjection.class, "Larrivee");
        this.register("lask", LaskowskiProjection.class, "Laskowski");
        this.register("latlong", LongLatProjection.class, "Lat/Long (Geodetic alias)");
        this.register("longlat", LongLatProjection.class, "Lat/Long (Geodetic alias)");
        this.register("latlon", LongLatProjection.class, "Lat/Long (Geodetic alias)");
        this.register("lonlat", LongLatProjection.class, "Lat/Long (Geodetic)");
        this.register("lcc", LambertConformalConicProjection.class, "Lambert Conformal Conic");
        this.register("leac", LambertEqualAreaConicProjection.class, "Lambert Equal Area Conic");
        this.register("loxim", LoximuthalProjection.class, "Loximuthal");
        this.register("lsat", LandsatProjection.class, "Space oblique for LANDSAT");
        this.register("mbt_fps", McBrydeThomasFlatPolarSine2Projection.class, "McBryde-Thomas Flat-Pole Sine (No. 2)");
        this.register("mbtfpp", McBrydeThomasFlatPolarParabolicProjection.class, "McBride-Thomas Flat-Polar Parabolic");
        this.register("mbtfpq", McBrydeThomasFlatPolarQuarticProjection.class, "McBryde-Thomas Flat-Polar Quartic");
        this.register("merc", MercatorProjection.class, "Mercator");
        this.register("mill", MillerProjection.class, "Miller Cylindrical");
        this.register("moll", MolleweideProjection.class, "Mollweide");
        this.register("murd1", Murdoch1Projection.class, "Murdoch I");
        this.register("murd2", Murdoch2Projection.class, "Murdoch II");
        this.register("murd3", Murdoch3Projection.class, "Murdoch III");
        this.register("nell", NellProjection.class, "Nell");
        this.register("nicol", NicolosiProjection.class, "Nicolosi Globular");
        this.register("nsper", PerspectiveProjection.class, "Near-sided perspective");
        this.register("nzmg", NewZealandMapGridProjection.class, "New Zealand Map Grid");
        this.register("omerc", ObliqueMercatorProjection.class, "Oblique Mercator");
        this.register("ortho", OrthographicAzimuthalProjection.class, "Orthographic");
        this.register("pconic", PerspectiveConicProjection.class, "Perspective Conic");
        this.register("poly", PolyconicProjection.class, "Polyconic (American)");
        this.register("putp2", PutninsP2Projection.class, "Putnins P2");
        this.register("putp4p", PutninsP4Projection.class, "Putnins P4'");
        this.register("putp5", PutninsP5Projection.class, "Putnins P5");
        this.register("putp5p", PutninsP5PProjection.class, "Putnins P5'");
        this.register("qua_aut", QuarticAuthalicProjection.class, "Quartic Authalic");
        this.register("robin", RobinsonProjection.class, "Robinson");
        this.register("rpoly", RectangularPolyconicProjection.class, "Rectangular Polyconic");
        this.register("sinu", SinusoidalProjection.class, "Sinusoidal (Sanson-Flamsteed)");
        this.register("somerc", SwissObliqueMercatorProjection.class, "Swiss Oblique Mercator");
        this.register("stere", StereographicAzimuthalProjection.class, "Stereographic");
        this.register("sterea", ObliqueStereographicAlternativeProjection.class, "Oblique Stereographic Alternative");
        this.register("tcc", TranverseCentralCylindricalProjection.class, "Transverse Central Cylindrical");
        this.register("tcea", TransverseCylindricalEqualArea.class, "Transverse Cylindrical Equal Area");
        this.register("tmerc", TransverseMercatorProjection.class, "Transverse Mercator");
        this.register("etmerc", ExtendedTransverseMercatorProjection.class, "Extended Transverse Mercator");
        this.register("urmfps", UrmaevFlatPolarSinusoidalProjection.class, "Urmaev Flat-Polar Sinusoidal");
        this.register("utm", ExtendedTransverseMercatorProjection.class, "Universal Transverse Mercator (UTM)");
        this.register("vandg", VanDerGrintenProjection.class, "van der Grinten (I)");
        this.register("vitk1", VitkovskyProjection.class, "Vitkovsky I");
        this.register("wag1", Wagner1Projection.class, "Wagner I (Kavraisky VI)");
        this.register("wag2", Wagner2Projection.class, "Wagner II");
        this.register("wag3", Wagner3Projection.class, "Wagner III");
        this.register("wag4", Wagner4Projection.class, "Wagner IV");
        this.register("wag5", Wagner5Projection.class, "Wagner V");
        this.register("wag7", Wagner7Projection.class, "Wagner VII");
        this.register("weren", WerenskioldProjection.class, "Werenskiold I");
        this.register("wintri", WinkelTripelProjection.class, "Winkel Tripel");
    }
}

