/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

public class CommonBits {
    private boolean isFirst = true;
    private int commonMantissaBitsCount = 53;
    private long commonBits = 0L;
    private long commonSignExp;

    public static long signExpBits(long num) {
        return num >> 52;
    }

    public static int numCommonMostSigMantissaBits(long num1, long num2) {
        int count = 0;
        for (int i2 = 52; i2 >= 0; --i2) {
            if (CommonBits.getBit(num1, i2) != CommonBits.getBit(num2, i2)) {
                return count;
            }
            ++count;
        }
        return 52;
    }

    public static long zeroLowerBits(long bits, int nBits) {
        long invMask = (1L << nBits) - 1L;
        long mask = invMask ^ 0xFFFFFFFFFFFFFFFFL;
        long zeroed = bits & mask;
        return zeroed;
    }

    public static int getBit(long bits, int i2) {
        long mask = 1L << i2;
        return (bits & mask) != 0L ? 1 : 0;
    }

    public void add(double num) {
        long numBits = Double.doubleToLongBits(num);
        if (this.isFirst) {
            this.commonBits = numBits;
            this.commonSignExp = CommonBits.signExpBits(this.commonBits);
            this.isFirst = false;
            return;
        }
        long numSignExp = CommonBits.signExpBits(numBits);
        if (numSignExp != this.commonSignExp) {
            this.commonBits = 0L;
            return;
        }
        this.commonMantissaBitsCount = CommonBits.numCommonMostSigMantissaBits(this.commonBits, numBits);
        this.commonBits = CommonBits.zeroLowerBits(this.commonBits, 64 - (12 + this.commonMantissaBitsCount));
    }

    public double getCommon() {
        return Double.longBitsToDouble(this.commonBits);
    }

    public String toString(long bits) {
        double x = Double.longBitsToDouble(bits);
        String numStr = Long.toBinaryString(bits);
        String padStr = "0000000000000000000000000000000000000000000000000000000000000000" + numStr;
        String bitStr = padStr.substring(padStr.length() - 64);
        String str = bitStr.substring(0, 1) + "  " + bitStr.substring(1, 12) + "(exp) " + bitStr.substring(12) + " [ " + x + " ]";
        return str;
    }
}

