/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis.delegates.stream;

import com.intellij.database.dialects.redis.delegates.RedisHookUpHelperDelegate;
import com.intellij.database.dialects.redis.generator.dml.UtilKt;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.redis.RedisTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/redis/delegates/stream/RedisStreamHookUpHelperDelegate;", "Lcom/intellij/database/dialects/redis/delegates/RedisHookUpHelperDelegate;", "<init>", "()V", "kind", "Lcom/intellij/database/model/ObjectKind;", "getKind", "()Lcom/intellij/database/model/ObjectKind;", "isFilterApplicable", "", "()Z", "getFilterPrefix", "", "table", "Lcom/intellij/database/model/DasObject;", "filterElementType", "Lcom/intellij/psi/tree/IElementType;", "getFilterElementType", "()Lcom/intellij/psi/tree/IElementType;", "intellij.database.dialects.redis"})
public final class RedisStreamHookUpHelperDelegate
extends RedisHookUpHelperDelegate {
    @NotNull
    public static final RedisStreamHookUpHelperDelegate INSTANCE = new RedisStreamHookUpHelperDelegate();

    private RedisStreamHookUpHelperDelegate() {
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.STREAM;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"STREAM");
        return objectKind;
    }

    @Override
    public boolean isFilterApplicable() {
        return true;
    }

    @Override
    @NotNull
    public String getFilterPrefix(@Nullable DasObject table) {
        return "XRANGE " + UtilKt.keyScrName(table, this.getKind());
    }

    @Override
    @Nullable
    public IElementType getFilterElementType() {
        return RedisTypes.REDIS_STREAM_FILTER_CLAUSE;
    }
}

