/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.TRegexUtil;

public final class LazyRegexResultArray
extends AbstractConstantArray {
    public static final LazyRegexResultArray LAZY_REGEX_RESULT_ARRAY = (LazyRegexResultArray)new LazyRegexResultArray(0, LazyRegexResultArray.createCache()).maybePreinitializeCache();

    public static LazyRegexResultArray createLazyRegexResultArray() {
        return LAZY_REGEX_RESULT_ARRAY;
    }

    private LazyRegexResultArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    private static Object[] getArray(JSDynamicObject object) {
        return (Object[])JSAbstractArray.arrayGetArray(object);
    }

    public static Object materializeGroup(JSContext context, JSDynamicObject object, int index, DynamicObjectLibrary lazyRegexResultNode, DynamicObjectLibrary lazyRegexResultOriginalInputNode, Node node, TruffleString.SubstringByteIndexNode substringNode, TRegexUtil.InvokeGetGroupBoundariesMethodNode getStartNode, TRegexUtil.InvokeGetGroupBoundariesMethodNode getEndNode) {
        Object[] internalArray = LazyRegexResultArray.getArray(object);
        if (internalArray[index] == null) {
            Object regexResult = JSAbstractArray.arrayGetRegexResult(object, lazyRegexResultNode);
            TruffleString originalInputString = JSAbstractArray.arrayGetRegexResultOriginalInput(object, lazyRegexResultOriginalInputNode);
            internalArray[index] = TRegexUtil.TRegexMaterializeResult.materializeGroup(context, regexResult, index, originalInputString, node, substringNode, getStartNode, getEndNode);
        }
        return internalArray[index];
    }

    public ScriptArray createWritable(JSContext context, JSDynamicObject object, long index, Object value, DynamicObjectLibrary lazyRegexResultNode, DynamicObjectLibrary lazyRegexResultOriginalInputNode, Node node, TruffleString.SubstringByteIndexNode substringNode, TRegexUtil.InvokeGetGroupBoundariesMethodNode getStartNode, TRegexUtil.InvokeGetGroupBoundariesMethodNode getEndNode) {
        for (int i = 0; i < this.lengthInt(object); ++i) {
            LazyRegexResultArray.materializeGroup(context, object, i, lazyRegexResultNode, lazyRegexResultOriginalInputNode, node, substringNode, getStartNode, getEndNode);
        }
        Object[] internalArray = LazyRegexResultArray.getArray(object);
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, internalArray.length, internalArray.length, internalArray, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            LazyRegexResultArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public Object getElementInBounds(JSDynamicObject object, int index) {
        Object[] internalArray = LazyRegexResultArray.getArray(object);
        if (internalArray[index] == null) {
            Object regexResult = JSAbstractArray.arrayGetRegexResult(object, DynamicObjectLibrary.getUncached());
            TruffleString originalInputString = JSAbstractArray.arrayGetRegexResultOriginalInput(object, DynamicObjectLibrary.getUncached());
            internalArray[index] = TRegexUtil.TRegexMaterializeResult.materializeGroupUncached(regexResult, index, originalInputString);
        }
        return internalArray[index];
    }

    @Override
    public boolean hasElement(JSDynamicObject object, long index) {
        return index >= 0L && index < (long)this.lengthInt(object);
    }

    @Override
    public int lengthInt(JSDynamicObject object) {
        return (int)JSAbstractArray.arrayGetLength(object);
    }

    @Override
    public AbstractObjectArray createWriteableObject(JSDynamicObject object, long index, Object value, Node node, ScriptArray.CreateWritableProfileAccess profile) {
        Object regexResult = JSAbstractArray.arrayGetRegexResult(object, DynamicObjectLibrary.getUncached());
        int length = this.lengthInt(object);
        TruffleString originalInputString = JSAbstractArray.arrayGetRegexResultOriginalInput(object, DynamicObjectLibrary.getUncached());
        Object[] array = TRegexUtil.TRegexMaterializeResult.materializeFullUncached(regexResult, length, originalInputString);
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, array.length, array.length, array, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            LazyRegexResultArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public AbstractObjectArray createWriteableInt(JSDynamicObject object, long index, int value, Node node, ScriptArray.CreateWritableProfileAccess profile) {
        return this.createWriteableObject(object, index, value, node, profile);
    }

    @Override
    public AbstractObjectArray createWriteableDouble(JSDynamicObject object, long index, double value, Node node, ScriptArray.CreateWritableProfileAccess profile) {
        return this.createWriteableObject(object, index, value, node, profile);
    }

    @Override
    public AbstractObjectArray createWriteableJSObject(JSDynamicObject object, long index, JSDynamicObject value, Node node, ScriptArray.CreateWritableProfileAccess profile) {
        return this.createWriteableObject(object, index, value, node, profile);
    }

    @Override
    public ScriptArray deleteElementImpl(JSDynamicObject object, long index, boolean strict) {
        return this.createWriteableObject(object, index, null, null, ScriptArray.CreateWritableProfileAccess.getUncached()).deleteElementImpl(object, index, strict);
    }

    @Override
    public ScriptArray setLengthImpl(JSDynamicObject object, long length, Node node, ScriptArray.SetLengthProfileAccess profile) {
        return this.createWriteableObject(object, length - 1L, null, node, profile).setLengthImpl(object, length, node, profile);
    }

    @Override
    public ScriptArray addRangeImpl(JSDynamicObject object, long offset, int size) {
        return this.createWriteableObject(object, offset, null, null, ScriptArray.CreateWritableProfileAccess.getUncached()).addRangeImpl(object, offset, size);
    }

    @Override
    public ScriptArray removeRangeImpl(JSDynamicObject object, long start, long end) {
        return this.createWriteableObject(object, start, null, null, ScriptArray.CreateWritableProfileAccess.getUncached()).removeRangeImpl(object, start, end);
    }

    @Override
    public Object cloneArray(JSDynamicObject object) {
        return LazyRegexResultArray.getArray(object);
    }

    @Override
    protected DynamicArray withIntegrityLevel(int newIntegrityLevel) {
        return new LazyRegexResultArray(newIntegrityLevel, this.cache);
    }
}

