/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.WrapForValidIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSWrapForValidIterator;
import com.oracle.truffle.js.runtime.builtins.JSWrapForValidIteratorObject;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class WrapForValidIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<WrapForIterator> {
    public static final JSBuiltinsContainer BUILTINS = new WrapForValidIteratorPrototypeBuiltins();
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("%WrapForValidIteratorPrototype%");

    protected WrapForValidIteratorPrototypeBuiltins() {
        super(PROTOTYPE_NAME, WrapForIterator.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, WrapForIterator builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return WrapForValidIteratorPrototypeBuiltinsFactory.WrapForIteratorNextNodeGen.create(context, builtin, WrapForValidIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return WrapForValidIteratorPrototypeBuiltinsFactory.WrapForIteratorReturnNodeGen.create(context, builtin, WrapForValidIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum WrapForIterator implements BuiltinEnum<WrapForIterator>
    {
        next(0),
        return_(0);

        private final int length;

        private WrapForIterator(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    @ImportStatic(value={JSWrapForValidIterator.class})
    public static abstract class WrapForIteratorNextNode
    extends JSBuiltinNode {
        @Node.Child
        private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();

        public WrapForIteratorNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object next(JSWrapForValidIteratorObject thisObj) {
            IteratorRecord iterated = thisObj.getIterated();
            return this.callNode.executeCall(JSArguments.createZeroArg(iterated.getIterator(), iterated.getNextMethod()));
        }

        @Specialization(guards={"!isWrapForIterator(thisObj)"})
        protected final Object incompatible(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getName(), thisObj);
        }
    }

    @ImportStatic(value={JSWrapForValidIterator.class, Strings.class})
    public static abstract class WrapForIteratorReturnNode
    extends JSBuiltinNode {
        public WrapForIteratorReturnNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doReturn(VirtualFrame frame, JSWrapForValidIteratorObject thisObj, @Cached(value="create(getContext(), RETURN)") GetMethodNode getReturnNode, @Cached(value="createCall()") JSFunctionCallNode methodCallNode, @Cached(value="create(getContext())") CreateIterResultObjectNode createIterResultObjectNode) {
            Object returnMethod = getReturnNode.executeWithTarget(thisObj.getIterated().getIterator());
            if (returnMethod == Undefined.instance) {
                return createIterResultObjectNode.execute(frame, Undefined.instance, true);
            }
            return methodCallNode.executeCall(JSArguments.createZeroArg(thisObj.getIterated().getIterator(), returnMethod));
        }

        @Specialization(guards={"!isWrapForIterator(thisObj)"})
        protected final Object incompatible(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getName(), thisObj);
        }
    }
}

