/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.inspections.DropPsiFixBase;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\f0\u0003\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/inspections/DropPsiListItemFix;", "Lcom/intellij/sql/inspections/DropPsiFixBase;", "kind", "", "elementClass", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "isPreview", "", "<init>", "(Ljava/lang/String;Ljava/lang/Class;Z)V", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getPreviewFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.database.sql.impl"})
public final class DropPsiListItemFix
extends DropPsiFixBase {
    @NotNull
    private final String kind;
    @NotNull
    private final Class<? extends PsiElement> elementClass;

    public DropPsiListItemFix(@NotNull String kind, @NotNull Class<? extends PsiElement> elementClass, boolean isPreview) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        super(isPreview);
        this.kind = kind;
        this.elementClass = elementClass;
    }

    public /* synthetic */ DropPsiListItemFix(String string, Class clazz, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(string, clazz, bl);
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.kind};
        String string = SqlBundle.message((String)"intention.family.name.delete", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public LocalQuickFix getPreviewFix() {
        return this.isPreview() ? (LocalQuickFix)this : (LocalQuickFix)new DropPsiListItemFix(this.kind, this.elementClass, true);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement psiElement;
        PsiElement deleteFrom;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement startElement = descriptor2.getStartElement();
        PsiElement endElement = descriptor2.getEndElement();
        PsiElement prevItem = PsiTreeUtil.getPrevSiblingOfType((PsiElement)startElement, this.elementClass);
        PsiElement nextItem = PsiTreeUtil.getNextSiblingOfType((PsiElement)endElement, this.elementClass);
        if (nextItem == null) {
            v0 = prevItem;
            if (v0 == null || (v0 = v0.getNextSibling()) == null) {
                v0 = startElement;
            }
        } else {
            v0 = deleteFrom = startElement;
        }
        if ((psiElement = nextItem) == null || (psiElement = psiElement.getPrevSibling()) == null) {
            psiElement = endElement;
        }
        PsiElement deleteTo = psiElement;
        Intrinsics.checkNotNull((Object)deleteFrom);
        Intrinsics.checkNotNull((Object)deleteTo);
        this.dropRange(deleteFrom, deleteTo);
    }
}

