/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.hsql;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.hsql.HsqlTokens;
import com.intellij.sql.dialects.hsql.HsqlTypes;
import com.intellij.sql.dialects.hsql.refactoring.HsqlExtractFunctionHelper;
import com.intellij.sql.dialects.hsql.refactoring.HsqlExtractVariableHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HsqlDialect
extends SqlLanguageDialectBase {
    public static final HsqlDialect INSTANCE = new HsqlDialect();

    private HsqlDialect() {
        super("HSQLDB");
    }

    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(HsqlTokens.class);
        if (tokensHelper == null) {
            HsqlDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.HSQL;
        if (dbms == null) {
            HsqlDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            HsqlDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        ObjectName publicName = ObjectName.plain((String)"public");
        DasNamespace namespace = HsqlDialect.getDefaultNamespace((DbDataSource)dataSource, (ObjectName)publicName);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern((ObjectName[])dsNames, (DasObject)namespace, (TreePatternNode.Group[])new TreePatternNode.Group[]{namespace.getKind() == ObjectKind.SCHEMA ? null : TreePatternUtils.create((ObjectName)publicName, (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])});
            if (treePattern == null) {
                HsqlDialect.$$$reportNull$$$0(3);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources((ObjectName[])dsNames, (TreePatternNode.Group[])new TreePatternNode.Group[]{SqlImportUtil.createPositiveDatabase((ObjectName)publicName, (TreePatternNode.Group[])new TreePatternNode.Group[]{TreePatternUtils.create((ObjectName)publicName, (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])})}));
    }

    public boolean supportsJoinUsing() {
        return true;
    }

    public boolean supportsNaturalJoin() {
        return true;
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            HsqlDialect.$$$reportNull$$$0(4);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlDeleteStatement.class, SqlUpdateStatement.class, SqlMergeStatement.class}) != null;
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            HsqlDialect.$$$reportNull$$$0(5);
        }
        return 128;
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return HsqlExtractVariableHelper.INSTANCE;
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return HsqlExtractFunctionHelper.INSTANCE;
    }

    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SqlCloseBlockProcessorImpl.SubstitutionDescriptor[]{new SubstitutionDescriptorImpl(new IElementType[]{HsqlTypes.HSQL_DO, SqlCompositeElementTypes.SQL_FOR_LOOP_STATEMENT}, "", "end for;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_FOR, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlTokens.SQL_END, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{HsqlTypes.HSQL_ATOMIC, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlTokens.SQL_END, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_REPEAT, SqlCompositeElementTypes.SQL_REPEAT_LOOP_STATEMENT}, "", "until  end repeat;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_REPEAT, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{HsqlTypes.HSQL_DO, SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end while;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlTokens.SQL_END, HsqlTypes.HSQL_WHILE, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_IF, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false})})});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/hsql/HsqlDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/hsql/HsqlDialect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars((SqlLanguageDialect)INSTANCE));
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_INTERVAL, SqlTokens.SQL_OP_LOGICAL_AND, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.SQL_OP_LOGICAL_OR, SqlTokens.SQL_OP_BITWISE_XOR, SqlTokens.SQL_OP_NULLSAFE_EQ, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_NOT2, SqlTokens.SQL_OP_ASSIGN, SqlTokens.SQL_AT, SqlTokens.SQL_SECOND, SqlTokens.SQL_MINUTE, SqlTokens.SQL_HOUR, SqlTokens.SQL_DAY, SqlTokens.SQL_MONTH, SqlTokens.SQL_YEAR, SqlTokens.SQL_LEFT_BRACKET);

        LazyData() {
        }
    }
}

