/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.applier;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.state.DbGenNameModelState;
import com.intellij.database.schemaEditor.model.state.DbNameModelState;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbNameModelApplier<E extends BasicElement>
extends DbEditorModelBase.ApplierBase<E, DbNameModelState> {
    public DbNameModelApplier() {
        super((BasicMetaId)BasicModNamedElement.NAME);
    }

    @Override
    public void copyState(@NotNull DbEditorModel<E, DbNameModelState> from, @NotNull DbEditorModel<E, DbNameModelState> to) {
        if (from == null) {
            DbNameModelApplier.$$$reportNull$$$0(0);
        }
        if (to == null) {
            DbNameModelApplier.$$$reportNull$$$0(1);
        }
        super.copyState(from, to);
        to.getState().setValue((String)from.getState().getValue());
        to.getState().setScriptedQuoted(from.getState().getScriptedQuoted());
        DbNameModelState dbNameModelState = from.getState();
        if (dbNameModelState instanceof DbGenNameModelState) {
            DbGenNameModelState fState = (DbGenNameModelState)dbNameModelState;
            dbNameModelState = to.getState();
            if (dbNameModelState instanceof DbGenNameModelState) {
                DbGenNameModelState tState = (DbGenNameModelState)dbNameModelState;
                tState.setGenerated(fState.isGenerated());
            }
        }
    }

    @Override
    public void applyImpl(@NotNull DbEditorModel<E, DbNameModelState> model, @NotNull ElementOwner owner, @NotNull E e) {
        BasicModNamedElement named;
        if (model == null) {
            DbNameModelApplier.$$$reportNull$$$0(2);
        }
        if (owner == null) {
            DbNameModelApplier.$$$reportNull$$$0(3);
        }
        if (e == null) {
            DbNameModelApplier.$$$reportNull$$$0(4);
        }
        if ((named = (BasicModNamedElement)ObjectUtils.tryCast(e, BasicModNamedElement.class)) == null) {
            return;
        }
        String text = StringUtil.notNullize((String)((String)model.getState().getValue()));
        ElementMatcher matcher = model.getController().getMatcher();
        ElementOwner oOwner = matcher.getOriginalOwner();
        BasicNamedElement editedNamed = oOwner == null ? null : (BasicNamedElement)ObjectUtils.tryCast((Object)oOwner.find(model.getIdentity()), BasicNamedElement.class);
        NamingService ns = this.getNamingService(model, (BasicElement)e);
        Couple<@NotNull Boolean> scriptedQuoted = model.getState().getScriptedQuoted();
        if (scriptedQuoted != null) {
            named.setName(ns.unquoteIdentifier(text));
            named.setNameScripted(((Boolean)scriptedQuoted.first).booleanValue());
            named.setNameQuoted(((Boolean)scriptedQuoted.second).booleanValue());
        } else {
            DbNameModelApplier.setNameFromText(ns, named, editedNamed, text, false);
        }
    }

    @Override
    public void resolveImpl(@NotNull DbEditorModel<E, DbNameModelState> model, @NotNull ElementOwner owner, @NotNull E e) {
        DbGenNameModelState gState;
        if (model == null) {
            DbNameModelApplier.$$$reportNull$$$0(5);
        }
        if (owner == null) {
            DbNameModelApplier.$$$reportNull$$$0(6);
        }
        if (e == null) {
            DbNameModelApplier.$$$reportNull$$$0(7);
        }
        super.resolveImpl(model, owner, e);
        DbNameModelState dbNameModelState = model.getState();
        if (dbNameModelState instanceof DbGenNameModelState && (gState = (DbGenNameModelState)dbNameModelState).isGenerated()) {
            gState.setText(DbNameModelApplier.generateName(e, gState));
            this.applyImpl(model, owner, e);
        }
    }

    @NotNull
    private static String generateName(@NotNull BasicElement e, DbGenNameModelState gState) {
        if (e == null) {
            DbNameModelApplier.$$$reportNull$$$0(8);
        }
        String generated = gState.getTemplate().getName((DasObject)e);
        Family pf = e.getParentFamily();
        return pf == null ? generated : DbNameModelApplier.generateUniqueName(generated, pf.jbi().filterMap(o -> o == e ? null : o.getName()).toList());
    }

    @Override
    public void resetImpl(@NotNull DbEditorModel<E, DbNameModelState> model, @NotNull ElementOwner owner, @NotNull E e) {
        DbGenNameModelState gState;
        if (model == null) {
            DbNameModelApplier.$$$reportNull$$$0(9);
        }
        if (owner == null) {
            DbNameModelApplier.$$$reportNull$$$0(10);
        }
        if (e == null) {
            DbNameModelApplier.$$$reportNull$$$0(11);
        }
        String text = DbNameModelApplier.getIdentifier(this.getNamingService(model, (BasicElement)e), e);
        DbNameModelState state = model.getState();
        state.setValue(text);
        BasicModNamedElement named = (BasicModNamedElement)ObjectUtils.tryCast(e, BasicModNamedElement.class);
        if (named != null) {
            state.setScriptedQuoted((Couple<Boolean>)Couple.of((Object)named.isNameScripted(), (Object)named.isNameQuoted()));
        }
        if ((gState = (DbGenNameModelState)ObjectUtils.tryCast((Object)state, DbGenNameModelState.class)) != null) {
            ElementOwner original = model.getController().getMatcher().getOriginalOwner();
            boolean isNew = original == null || original.find(model.getIdentity()) == null;
            gState.setGenerated(isNew && e.getName().isEmpty() || DbNameModelApplier.nameMatchesGenerated(e, gState));
        }
    }

    private static boolean nameMatchesGenerated(@NotNull BasicElement e, DbGenNameModelState gState) {
        if (e == null) {
            DbNameModelApplier.$$$reportNull$$$0(12);
        }
        String genName = DbNameModelApplier.generateName(e, gState);
        return genName.equals(e.getName());
    }

    @Override
    public boolean differsFromImpl(@NotNull DbEditorModel<E, DbNameModelState> model, @NotNull ElementOwner owner, @NotNull E e) {
        if (model == null) {
            DbNameModelApplier.$$$reportNull$$$0(13);
        }
        if (owner == null) {
            DbNameModelApplier.$$$reportNull$$$0(14);
        }
        if (e == null) {
            DbNameModelApplier.$$$reportNull$$$0(15);
        }
        return !Objects.equals(DbNameModelApplier.getIdentifier(this.getNamingService(model, (BasicElement)e), e), model.getState().getValue());
    }

    @Override
    public boolean isEnabled(@NotNull DbEditorModel<E, DbNameModelState> model, @NotNull ElementOwner owner, @Nullable E e) {
        if (model == null) {
            DbNameModelApplier.$$$reportNull$$$0(16);
        }
        if (owner == null) {
            DbNameModelApplier.$$$reportNull$$$0(17);
        }
        return DbNameModelApplier.isEnabledImpl(model, owner, e, (BasicMetaId)BasicModNamedElement.NAME);
    }

    @NotNull
    protected NamingService getNamingService(@NotNull DbEditorModel<E, DbNameModelState> model, @NotNull BasicElement e) {
        if (model == null) {
            DbNameModelApplier.$$$reportNull$$$0(18);
        }
        if (e == null) {
            DbNameModelApplier.$$$reportNull$$$0(19);
        }
        NamingService namingService = NamingServices.getNamingService((Dbms)model.getDbms(), (BasicModel)e.getModel(), (BasicDatabase)e.getDatabase());
        if (namingService == null) {
            DbNameModelApplier.$$$reportNull$$$0(20);
        }
        return namingService;
    }

    @NlsSafe
    @NotNull
    public static String generateUniqueName(@NotNull String defaultName, @NotNull Collection<String> existingNames) {
        if (defaultName == null) {
            DbNameModelApplier.$$$reportNull$$$0(21);
        }
        if (existingNames == null) {
            DbNameModelApplier.$$$reportNull$$$0(22);
        }
        String string = UniqueNameGenerator.generateUniqueName((String)defaultName, (String)"", (String)"", (String)"_", (String)"", x -> !existingNames.contains(x));
        if (string == null) {
            DbNameModelApplier.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String extractBase(@NotNull String name2) {
        if (name2 == null) {
            DbNameModelApplier.$$$reportNull$$$0(24);
        }
        for (int i = name2.length() - 1; i > 0; --i) {
            char c2 = name2.charAt(i);
            if (Character.isDigit(c2)) continue;
            if (c2 != '_' || i == name2.length() - 1) break;
            String string = name2.substring(0, i);
            if (string == null) {
                DbNameModelApplier.$$$reportNull$$$0(25);
            }
            return string;
        }
        String string = name2;
        if (string == null) {
            DbNameModelApplier.$$$reportNull$$$0(26);
        }
        return string;
    }

    public static void setNameFromText(NamingService namingService, BasicModNamedElement named, BasicNamedElement edited, String text, boolean mixedIsQuoted) {
        boolean quoted = namingService.isQuoted(text);
        String name2 = namingService.unquoteIdentifier(text);
        boolean isSql = DbImplUtilCore.treatAsPlainIdentifier((String)name2, (boolean)quoted, (BasicNamedElement)edited, (boolean)mixedIsQuoted);
        named.setName(name2);
        named.setNameScripted(isSql);
        named.setNameSurrogate(DbNameModelApplier.isNameSurrogate(named, quoted, edited));
        named.setNameQuoted(isSql && quoted);
    }

    private static boolean isNameSurrogate(@NotNull BasicModNamedElement named, boolean quoted, @Nullable BasicNamedElement edited) {
        if (named == null) {
            DbNameModelApplier.$$$reportNull$$$0(27);
        }
        if (edited != null && named.getName().equals(edited.getName())) {
            return edited.isNameSurrogate();
        }
        return !quoted && StringUtil.isEmpty((String)named.getName());
    }

    @NotNull
    public static String getIdentifier(NamingService namingService, @NotNull BasicElement object) {
        if (object == null) {
            DbNameModelApplier.$$$reportNull$$$0(28);
        }
        String name2 = object.getName();
        if (!DbSqlUtilCore.isSqlObject((DasObject)object) || !DbSqlUtilCore.isQuoted((DasObject)object)) {
            String string = name2;
            if (string == null) {
                DbNameModelApplier.$$$reportNull$$$0(29);
            }
            return string;
        }
        String string = namingService.enquote(name2, object.getKind());
        if (string == null) {
            DbNameModelApplier.$$$reportNull$$$0(30);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 20, 23, 25, 26, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/applier/DbNameModelApplier";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "named";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/applier/DbNameModelApplier";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamingService";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "extractBase";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyState";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "nameMatchesGenerated";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "differsFromImpl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNamingService";
                break;
            }
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 30: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "generateUniqueName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "extractBase";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isNameSurrogate";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 20, 23, 25, 26, 29, 30 -> new IllegalStateException(string);
        };
    }
}

