/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.migration;

import com.intellij.database.model.migration.DbMigrationDialog;
import com.intellij.database.model.migration.DbMigrationDialogKt;
import com.intellij.database.model.migration.DbMigrationDiffDivider;
import com.intellij.database.model.migration.DbMigrationDiffPanelBase;
import com.intellij.database.model.migration.DbMigrationDiffPanelKt;
import com.intellij.database.model.migration.DbMigrationRequest;
import com.intellij.database.model.migration.DbMigrationSideTree;
import com.intellij.database.model.migration.DbMigrationTreeModel;
import com.intellij.database.model.migration.DiffStatus;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.HashSet;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0002J \u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0001H\u0002J\b\u0010(\u001a\u00020\u001eH\u0002J\u0012\u0010)\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0012\u0010,\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u000bH\u0002J\u0010\u0010/\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u000bH\u0002J\u000e\u00100\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"J\u000e\u00101\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"J\b\u00102\u001a\u00020\u001eH\u0016J\b\u00103\u001a\u00020\u001eH\u0016J\b\u00104\u001a\u00020\u001eH\u0016J\b\u00105\u001a\u00020\u001eH\u0017J\b\u00106\u001a\u00020\u001eH\u0016J\u000e\u00107\u001a\b\u0018\u000108R\u00020\u001aH\u0016J\b\u00109\u001a\u00020\u001eH\u0016J\b\u0010:\u001a\u00020\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006;"}, d2={"Lcom/intellij/database/model/migration/DbMigrationDiffPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/database/model/migration/DbMigrationDiffPanelBase;", "Ljavax/swing/event/TreeSelectionListener;", "migrationDialog", "Lcom/intellij/database/model/migration/DbMigrationDialog;", "<init>", "(Lcom/intellij/database/model/migration/DbMigrationDialog;)V", "originLabel", "targetLabel", "originPresentableTree", "Lcom/intellij/ui/treeStructure/Tree;", "getOriginPresentableTree", "()Lcom/intellij/ui/treeStructure/Tree;", "targetPresentableTree", "getTargetPresentableTree", "originScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "targetScrollPane", "diffDivider", "Lcom/intellij/database/model/migration/DbMigrationDiffDivider;", "request", "Lcom/intellij/database/model/migration/DbMigrationRequest;", "getRequest", "()Lcom/intellij/database/model/migration/DbMigrationRequest;", "migrationTree", "Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "getMigrationTree", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "addSourceLabels", "", "addSourceLabel", "label", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "createPresentableTree", "addPresentableTree", "tree", "scrollPane", "addDiffDivider", "addForallPanel", "valueChanged", "e", "Ljavax/swing/event/TreeSelectionEvent;", "updateOppositeTree", "clearSelection", "opposite", "getSide", "getPresentableTree", "getScrollPane", "expandMappingNodes", "expandAll", "collapseAll", "refreshTreesUI", "repaintDivider", "getSelectedNode", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "swapSourceLabels", "doRepaint", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbMigrationDiffPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationDiffPanel.kt\ncom/intellij/database/model/migration/DbMigrationDiffPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n1869#2,2:265\n1869#2,2:267\n*S KotlinDebug\n*F\n+ 1 DbMigrationDiffPanel.kt\ncom/intellij/database/model/migration/DbMigrationDiffPanel\n*L\n218#1:265,2\n219#1:267,2\n*E\n"})
public final class DbMigrationDiffPanel
extends JPanel
implements DbMigrationDiffPanelBase,
TreeSelectionListener {
    @NotNull
    private final DbMigrationDialog migrationDialog;
    @NotNull
    private JPanel originLabel;
    @NotNull
    private JPanel targetLabel;
    @NotNull
    private final Tree originPresentableTree;
    @NotNull
    private final Tree targetPresentableTree;
    @NotNull
    private final JBScrollPane originScrollPane;
    @NotNull
    private final JBScrollPane targetScrollPane;
    @NotNull
    private final DbMigrationDiffDivider diffDivider;

    public DbMigrationDiffPanel(@NotNull DbMigrationDialog migrationDialog) {
        Intrinsics.checkNotNullParameter((Object)((Object)migrationDialog), (String)"migrationDialog");
        super((LayoutManager)DbMigrationDiffPanelKt.access$layout());
        this.migrationDialog = migrationDialog;
        this.originLabel = DbMigrationDiffPanelKt.createSourceLabel(this.getRequest(), DbMigrationTreeModel.Side.ORIGIN);
        this.targetLabel = DbMigrationDiffPanelKt.createSourceLabel(this.getRequest(), DbMigrationTreeModel.Side.TARGET);
        this.addSourceLabels();
        this.originPresentableTree = this.createPresentableTree(DbMigrationTreeModel.Side.ORIGIN);
        this.targetPresentableTree = this.createPresentableTree(DbMigrationTreeModel.Side.TARGET);
        this.originScrollPane = new JBScrollPane((Component)this.originPresentableTree);
        this.targetScrollPane = new JBScrollPane((Component)this.targetPresentableTree);
        this.addPresentableTree(this.originPresentableTree, this.originScrollPane, DbMigrationTreeModel.Side.ORIGIN);
        this.addPresentableTree(this.targetPresentableTree, this.targetScrollPane, DbMigrationTreeModel.Side.TARGET);
        this.expandMappingNodes();
        this.diffDivider = new DbMigrationDiffDivider(this, this.migrationDialog);
        this.addDiffDivider(this.diffDivider);
        this.addForallPanel();
    }

    @NotNull
    public final Tree getOriginPresentableTree() {
        return this.originPresentableTree;
    }

    @NotNull
    public final Tree getTargetPresentableTree() {
        return this.targetPresentableTree;
    }

    private final DbMigrationRequest getRequest() {
        return this.migrationDialog.getRequest();
    }

    private final DbMigrationTreeModel getMigrationTree() {
        return this.migrationDialog.getMigrationTree();
    }

    private final void addSourceLabels() {
        this.addSourceLabel(this.originLabel, DbMigrationTreeModel.Side.ORIGIN);
        this.addSourceLabel(this.targetLabel, DbMigrationTreeModel.Side.TARGET);
    }

    private final void addSourceLabel(JPanel label, DbMigrationTreeModel.Side side) {
        GridConstraints gridConstraints;
        GridConstraints $this$addSourceLabel_u24lambda_u240 = gridConstraints = new GridConstraints();
        boolean bl = false;
        $this$addSourceLabel_u24lambda_u240.setRow(0);
        $this$addSourceLabel_u24lambda_u240.setColumn(switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1 -> 0;
            case 2 -> 2;
            default -> throw new NoWhenBranchMatchedException();
        });
        $this$addSourceLabel_u24lambda_u240.setVSizePolicy(0);
        $this$addSourceLabel_u24lambda_u240.setFill(1);
        GridConstraints constraints = gridConstraints;
        this.add((Component)label, constraints);
    }

    private final Tree createPresentableTree(DbMigrationTreeModel.Side side) {
        DbMigrationTreeModel.PresentableTreeModel projectionTreeModel = switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1 -> this.getMigrationTree().getOriginTreeModel();
            case 2 -> this.getMigrationTree().getTargetTreeModel();
            default -> throw new NoWhenBranchMatchedException();
        };
        DbMigrationSideTree tree = new DbMigrationSideTree(this.getRequest().getProject(), (TreeModel)((Object)projectionTreeModel), side);
        tree.addTreeExpansionListener(new TreeExpansionListener(this){
            final /* synthetic */ DbMigrationDiffPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void treeExpanded(TreeExpansionEvent event) {
                this.this$0.repaint();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                this.this$0.repaint();
            }
        });
        return tree;
    }

    private final void addPresentableTree(Tree tree, JBScrollPane scrollPane, DbMigrationTreeModel.Side side) {
        GridConstraints gridConstraints;
        tree.addTreeSelectionListener((TreeSelectionListener)this);
        GridConstraints $this$addPresentableTree_u24lambda_u241 = gridConstraints = new GridConstraints();
        boolean bl = false;
        $this$addPresentableTree_u24lambda_u241.setRow(1);
        $this$addPresentableTree_u24lambda_u241.setColumn(switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1 -> 0;
            case 2 -> 2;
            default -> throw new NoWhenBranchMatchedException();
        });
        $this$addPresentableTree_u24lambda_u241.setFill(3);
        GridConstraints originTreeConstraints = gridConstraints;
        scrollPane.getViewport().addChangeListener(arg_0 -> DbMigrationDiffPanel.addPresentableTree$lambda$2(this, arg_0));
        scrollPane.setPreferredSize((Dimension)new JBDimension(420, 480));
        this.add((Component)scrollPane, originTreeConstraints);
    }

    private final void addDiffDivider(JPanel diffDivider) {
        GridConstraints gridConstraints;
        GridConstraints $this$addDiffDivider_u24lambda_u243 = gridConstraints = new GridConstraints();
        boolean bl = false;
        $this$addDiffDivider_u24lambda_u243.setRow(1);
        $this$addDiffDivider_u24lambda_u243.setColumn(1);
        $this$addDiffDivider_u24lambda_u243.setFill(3);
        $this$addDiffDivider_u24lambda_u243.setHSizePolicy(0);
        GridConstraints diffDividerConstraints = gridConstraints;
        this.add((Component)diffDivider, diffDividerConstraints);
    }

    private final void addForallPanel() {
        GridConstraints gridConstraints;
        GridConstraints $this$addForallPanel_u24lambda_u244 = gridConstraints = new GridConstraints();
        boolean bl = false;
        $this$addForallPanel_u24lambda_u244.setRow(0);
        $this$addForallPanel_u24lambda_u244.setColumn(1);
        $this$addForallPanel_u24lambda_u244.setHSizePolicy(0);
        $this$addForallPanel_u24lambda_u244.setVSizePolicy(0);
        $this$addForallPanel_u24lambda_u244.setFill(3);
        GridConstraints constraints = gridConstraints;
        this.add((Component)this.diffDivider.getForallPanel(), constraints);
    }

    @Override
    public void valueChanged(@Nullable TreeSelectionEvent e) {
        this.updateOppositeTree(e);
        this.migrationDialog.updateCurrentPreviewPage(this.getSelectedNode());
    }

    private final void updateOppositeTree(TreeSelectionEvent e) {
        DbMigrationTreeModel.Node node;
        TreeSelectionEvent treeSelectionEvent = e;
        Object object = treeSelectionEvent != null ? treeSelectionEvent.getSource() : null;
        Tree tree = object instanceof Tree ? (Tree)object : null;
        if (tree == null) {
            return;
        }
        Tree currentTree = tree;
        object = currentTree.getLastSelectedPathComponent();
        DbMigrationTreeModel.Node node2 = node = object instanceof DbMigrationTreeModel.Node ? (DbMigrationTreeModel.Node)object : null;
        if (node != null) {
            DbMigrationTreeModel.Side currentSide = this.getSide(currentTree);
            DbMigrationTreeModel.Side oppositeSide = currentSide.getOpposite();
            Tree oppositeTree = this.getPresentableTree(oppositeSide);
            this.clearSelection(oppositeTree);
            if (oppositeTree.getPathBounds(e.getPath()) != null) {
                JScrollBar currentScrollBar = this.getScrollPane(currentSide).getVerticalScrollBar();
                JScrollBar oppositeScrollBar = this.getScrollPane(oppositeSide).getVerticalScrollBar();
                TreePath treePath = e.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"getPath(...)");
                Rectangle rectangle = DbMigrationDialogKt.nodeBounds(currentTree, treePath);
                if (rectangle == null) {
                    return;
                }
                Rectangle currentNodeBounds = rectangle;
                TreePath treePath2 = e.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)treePath2, (String)"getPath(...)");
                Rectangle rectangle2 = DbMigrationDialogKt.nodeBounds(oppositeTree, treePath2);
                if (rectangle2 == null) {
                    return;
                }
                Rectangle oppositeNodeBounds = rectangle2;
                int currentY = currentNodeBounds.y - currentScrollBar.getValue();
                int oppositeY = oppositeNodeBounds.y - oppositeScrollBar.getValue();
                oppositeScrollBar.setValue(oppositeScrollBar.getValue() - (currentY - oppositeY));
            }
        }
    }

    private final void clearSelection(Tree opposite) {
        opposite.removeTreeSelectionListener((TreeSelectionListener)this);
        opposite.clearSelection();
        opposite.addTreeSelectionListener((TreeSelectionListener)this);
    }

    private final DbMigrationTreeModel.Side getSide(Tree tree) {
        DbMigrationTreeModel.Side side;
        Tree tree2 = tree;
        if (Intrinsics.areEqual((Object)tree2, (Object)this.originPresentableTree)) {
            side = DbMigrationTreeModel.Side.ORIGIN;
        } else if (Intrinsics.areEqual((Object)tree2, (Object)this.targetPresentableTree)) {
            side = DbMigrationTreeModel.Side.TARGET;
        } else {
            throw new AssertionError();
        }
        return side;
    }

    @NotNull
    public final Tree getPresentableTree(@NotNull DbMigrationTreeModel.Side side) {
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        return switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1 -> this.originPresentableTree;
            case 2 -> this.targetPresentableTree;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final JBScrollPane getScrollPane(@NotNull DbMigrationTreeModel.Side side) {
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        return switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1 -> this.originScrollPane;
            case 2 -> this.targetScrollPane;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public void expandMappingNodes() {
        TreePath p0;
        Iterable $this$forEach$iv;
        HashSet<TreePath> originPathsToExpand = new HashSet<TreePath>();
        HashSet<TreePath> targetPathsToExpand = new HashSet<TreePath>();
        for (DbMigrationTreeModel.MappingItem item : this.getMigrationTree().getDividerMapping()) {
            TreePath path = item.getPath();
            DbMigrationTreeModel.Node node = DbMigrationDialogKt.last(path);
            if (node.getStatus() != DiffStatus.DELETED) {
                originPathsToExpand.add(path.getParentPath());
            }
            targetPathsToExpand.add(path.getParentPath());
        }
        Iterable iterable = originPathsToExpand;
        Tree tree = this.originPresentableTree;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (TreePath)element$iv;
            boolean bl = false;
            tree.expandPath(p0);
        }
        $this$forEach$iv = targetPathsToExpand;
        tree = this.targetPresentableTree;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (TreePath)element$iv;
            boolean bl = false;
            tree.expandPath(p0);
        }
    }

    @Override
    public void expandAll() {
        TreeUtil.promiseExpandAll((JTree)((JTree)this.originPresentableTree));
        TreeUtil.promiseExpandAll((JTree)((JTree)this.targetPresentableTree));
    }

    @Override
    public void collapseAll() {
        TreeUtil.collapseAll((JTree)((JTree)this.originPresentableTree), (int)-1);
        TreeUtil.collapseAll((JTree)((JTree)this.targetPresentableTree), (int)-1);
    }

    @Override
    @RequiresEdt
    public void refreshTreesUI() {
        this.originPresentableTree.setModel((TreeModel)((Object)this.getMigrationTree().getOriginTreeModel()));
        this.targetPresentableTree.setModel((TreeModel)((Object)this.getMigrationTree().getTargetTreeModel()));
        this.expandMappingNodes();
        this.originPresentableTree.repaint();
        this.targetPresentableTree.repaint();
        this.diffDivider.repaint();
    }

    @Override
    public void repaintDivider() {
        this.diffDivider.repaint();
    }

    @Override
    @Nullable
    public DbMigrationTreeModel.Node getSelectedNode() {
        TreePath path;
        TreePath treePath = this.originPresentableTree.getSelectionPath();
        if (treePath == null) {
            treePath = this.targetPresentableTree.getSelectionPath();
        }
        TreePath treePath2 = path = treePath;
        return treePath2 != null ? DbMigrationDialogKt.last(treePath2) : null;
    }

    @Override
    public void swapSourceLabels() {
        this.remove(this.originLabel);
        this.remove(this.targetLabel);
        JPanel temp = this.originLabel;
        this.originLabel = this.targetLabel;
        this.targetLabel = temp;
        this.addSourceLabels();
        this.revalidate();
    }

    @Override
    public void doRepaint() {
        this.repaint();
    }

    private static final void addPresentableTree$lambda$2(DbMigrationDiffPanel this$0, ChangeEvent it) {
        this$0.repaint();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DbMigrationTreeModel.Side.values().length];
            try {
                nArray[DbMigrationTreeModel.Side.ORIGIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DbMigrationTreeModel.Side.TARGET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

