/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dialects.oracle.debugger.OraNamespace;
import com.intellij.database.dialects.oracle.debugger.OraPosition;
import com.intellij.database.dialects.oracle.debugger.OraProgram;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B)\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\rJ\b\u0010\u0017\u001a\u00020\u000bH\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\f\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraProgramPosition;", "Lcom/intellij/database/dialects/oracle/debugger/OraPosition;", "program", "Lcom/intellij/database/dialects/oracle/debugger/OraProgram;", "lineNr", "", "<init>", "(Lcom/intellij/database/dialects/oracle/debugger/OraProgram;I)V", "namespace", "Lcom/intellij/database/dialects/oracle/debugger/OraNamespace;", "schemaName", "", "programName", "(Lcom/intellij/database/dialects/oracle/debugger/OraNamespace;Ljava/lang/String;Ljava/lang/String;I)V", "getProgram", "()Lcom/intellij/database/dialects/oracle/debugger/OraProgram;", "getLineNr", "()I", "getNamespace", "()Lcom/intellij/database/dialects/oracle/debugger/OraNamespace;", "getSchemaName", "()Ljava/lang/String;", "getProgramName", "toString", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "intellij.database.dialects.oracle.ex"})
public final class OraProgramPosition
extends OraPosition {
    @NotNull
    private final OraProgram program;
    private final int lineNr;

    public OraProgramPosition(@NotNull OraProgram program, int lineNr) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        super(null);
        this.program = program;
        this.lineNr = lineNr;
    }

    @NotNull
    public final OraProgram getProgram() {
        return this.program;
    }

    @Override
    public int getLineNr() {
        return this.lineNr;
    }

    @Override
    @NotNull
    public OraNamespace getNamespace() {
        return this.program.getNamespace();
    }

    @Override
    @NotNull
    public String getSchemaName() {
        return this.program.getSchemaName();
    }

    @Override
    @NotNull
    public String getProgramName() {
        return this.program.getProgramName();
    }

    public OraProgramPosition(@NotNull OraNamespace namespace, @NotNull String schemaName, @NotNull String programName, int lineNr) {
        Intrinsics.checkNotNullParameter((Object)((Object)namespace), (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
        Intrinsics.checkNotNullParameter((Object)programName, (String)"programName");
        this(new OraProgram(namespace, schemaName, programName), lineNr);
    }

    @NotNull
    public String toString() {
        return this.getNamespace().displayName + ":" + this.getSchemaName() + "." + this.getProgramName() + ":" + this.getLineNr();
    }

    @NotNull
    public final OraProgram component1() {
        return this.program;
    }

    public final int component2() {
        return this.lineNr;
    }

    @NotNull
    public final OraProgramPosition copy(@NotNull OraProgram program, int lineNr) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        return new OraProgramPosition(program, lineNr);
    }

    public static /* synthetic */ OraProgramPosition copy$default(OraProgramPosition oraProgramPosition, OraProgram oraProgram, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            oraProgram = oraProgramPosition.program;
        }
        if ((n2 & 2) != 0) {
            n = oraProgramPosition.lineNr;
        }
        return oraProgramPosition.copy(oraProgram, n);
    }

    public int hashCode() {
        int result = this.program.hashCode();
        result = result * 31 + Integer.hashCode(this.lineNr);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OraProgramPosition)) {
            return false;
        }
        OraProgramPosition oraProgramPosition = (OraProgramPosition)other;
        if (!Intrinsics.areEqual((Object)this.program, (Object)oraProgramPosition.program)) {
            return false;
        }
        return this.lineNr == oraProgramPosition.lineNr;
    }
}

