/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.AbstractNamingService;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.Casing;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/exasol/generator/ExaNamingService;", "Lcom/intellij/database/dialects/base/generator/AbstractNamingService;", "<init>", "()V", "matchesCasing", "", "c", "", "openingQuotes", "", "getOpeningQuotes", "()Ljava/lang/String;", "closingQuotes", "getClosingQuotes", "Provider", "intellij.database.dialects.exasol"})
public final class ExaNamingService
extends AbstractNamingService {
    @NotNull
    public static final ExaNamingService INSTANCE = new ExaNamingService();

    private ExaNamingService() {
        Dbms dbms = Dbms.EXASOL;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"EXASOL");
        Pattern pattern = Pattern.compile("[\\p{Ll}\\p{Lt}\\p{Lu}\\p{Lm}\\p{Lo}\\p{Nl}][\\p{Ll}\\p{Lt}\\p{Lu}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}\\p{Cf}\\u00B7]*");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Casing casing = CasingProvider.UPPER_CASING;
        Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"UPPER_CASING");
        super(dbms, pattern, casing);
    }

    protected boolean matchesCasing(char c2) {
        return !Character.isTitleCase(c2) && !Character.isLowerCase(c2);
    }

    @NotNull
    public String getOpeningQuotes() {
        return "\"[";
    }

    @NotNull
    public String getClosingQuotes() {
        return "\"]";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/exasol/generator/ExaNamingService$Provider;", "Lcom/intellij/database/script/generator/NamingService$Provider;", "<init>", "()V", "getNamingService", "Lcom/intellij/database/script/generator/NamingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "intellij.database.dialects.exasol"})
    public static final class Provider
    implements NamingService.Provider {
        @NotNull
        public NamingService getNamingService(@Nullable BasicModel model, @Nullable BasicDatabase database) {
            return (NamingService)INSTANCE;
        }
    }
}

