/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.CliRunTargetProvider;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.io.File;
import java.nio.file.Files;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\"\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\rH\u0016J\u0010\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u00152\u0006\u00100\u001a\u000201H\u0002J\u0012\u00103\u001a\u00020\r2\b\b\u0001\u00104\u001a\u00020\rH\u0017J\u0016\u00105\u001a\u0004\u0018\u00010\r2\n\b\u0001\u00106\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H\u0016J\b\u0010:\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006;"}, d2={"Lcom/intellij/database/cli/CliRunTarget;", "Lcom/intellij/openapi/Disposable;", "provider", "Lcom/intellij/database/cli/CliRunTargetProvider;", "<init>", "(Lcom/intellij/database/cli/CliRunTargetProvider;)V", "getProvider", "()Lcom/intellij/database/cli/CliRunTargetProvider;", "serialize", "", "properties", "Lcom/intellij/ide/util/PropertiesComponent;", "keyPrefix", "", "deserialize", "componentMap", "", "Ljavax/swing/JComponent;", "getComponentMap", "()Ljava/util/Map;", "supportsCommandLineValidation", "", "getSupportsCommandLineValidation", "()Z", "createExecutableFileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "createPathChooserDescriptor", "patchFileChooserDescriptor", "descriptor", "addRunTargetChangeListener", "runnable", "Ljava/lang/Runnable;", "createPathChooser", "Lcom/intellij/openapi/fileChooser/PathChooserDialog;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "getPresentableUrl", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "validateModel", "Lcom/intellij/openapi/ui/ValidationInfo;", "model", "Lcom/intellij/database/cli/CliModel;", "validateFilePath", "path", "checkFileStrict", "file", "Ljava/io/File;", "checkWslSymlink", "patchPathLabel", "label", "getPort", "defaultPort", "adjustCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "commandLine", "dispose", "intellij.database.impl"})
public abstract class CliRunTarget
implements Disposable {
    @NotNull
    private final CliRunTargetProvider provider;

    public CliRunTarget(@NotNull CliRunTargetProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.provider = provider;
    }

    @NotNull
    public final CliRunTargetProvider getProvider() {
        return this.provider;
    }

    public void serialize(@NotNull PropertiesComponent properties, @NotNull String keyPrefix) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
    }

    public void deserialize(@NotNull PropertiesComponent properties, @NotNull String keyPrefix) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
    }

    @NotNull
    public Map<String, JComponent> getComponentMap() {
        return MapsKt.emptyMap();
    }

    public boolean getSupportsCommandLineValidation() {
        return true;
    }

    @Nullable
    public final FileChooserDescriptor createExecutableFileChooserDescriptor() {
        return this.patchFileChooserDescriptor(new FileChooserDescriptor(FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor()));
    }

    @Nullable
    public final FileChooserDescriptor createPathChooserDescriptor() {
        return this.patchFileChooserDescriptor(new FileChooserDescriptor(FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor()));
    }

    @Nullable
    public FileChooserDescriptor patchFileChooserDescriptor(@NotNull FileChooserDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return descriptor2;
    }

    public void addRunTargetChangeListener(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
    }

    @NotNull
    public PathChooserDialog createPathChooser(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project, @NotNull Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        PathChooserDialog pathChooserDialog = FileChooserFactory.getInstance().createPathChooser(descriptor2, project, parentComponent);
        Intrinsics.checkNotNullExpressionValue((Object)pathChooserDialog, (String)"createPathChooser(...)");
        return pathChooserDialog;
    }

    @NotNull
    public String getPresentableUrl(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        String string = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @Nullable
    public ValidationInfo validateModel(@NotNull CliModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return null;
    }

    public boolean validateFilePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(path);
        return this.checkFileStrict(file) || this.checkWslSymlink(file);
    }

    private final boolean checkFileStrict(File file) {
        return file.exists() && file.isFile() && Files.isExecutable(file.toPath());
    }

    private final boolean checkWslSymlink(File file) {
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (!WslPath.Companion.isWslUncPath(string)) {
            return false;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return false;
        }
        File parent = file2;
        String fileName = file.getName();
        File[] files2 = parent.listFiles((arg_0, arg_1) -> CliRunTarget.checkWslSymlink$lambda$0(fileName, arg_0, arg_1));
        return files2 != null && files2.length == 1;
    }

    @NlsSafe
    @NotNull
    public String patchPathLabel(@NlsSafe @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return label;
    }

    @Nullable
    public String getPort(@Nullable String defaultPort) {
        return defaultPort;
    }

    @NotNull
    public GeneralCommandLine adjustCommandLine(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return commandLine;
    }

    public void dispose() {
    }

    private static final boolean checkWslSymlink$lambda$0(String $fileName, File file, String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return Intrinsics.areEqual((Object)name2, (Object)$fileName);
    }
}

