/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.docker.remote;

import com.google.common.net.HostAndPort;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.debugger.PositionConverterProvider;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.remote.vfs.PyRemotePositionConverter;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.RemoteProcessControl;
import com.jetbrains.python.run.PythonProcessHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B#\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/python/docker/remote/PyDockerComposeProcessHandler;", "Lcom/jetbrains/python/run/PythonProcessHandler;", "Lcom/jetbrains/python/remote/RemoteProcessControl;", "Lcom/jetbrains/python/debugger/PositionConverterProvider;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "remoteSocketProvider", "Lcom/jetbrains/python/remote/PyRemoteSocketToLocalHostProvider;", "<init>", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/jetbrains/python/remote/PyRemotePathMapper;Lcom/jetbrains/python/remote/PyRemoteSocketToLocalHostProvider;)V", "fileMappings", "", "Lcom/intellij/util/PathMappingSettings$PathMapping;", "isFirstKillProcessInvocation", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getMappingSettings", "Lcom/intellij/util/PathMapper;", "getRemoteSocket", "Lcom/intellij/openapi/util/Pair;", "", "", "localPort", "getLocalTunnel", "Lcom/google/common/net/HostAndPort;", "remotePort", "getFileMappings", "createPositionConverter", "Lcom/jetbrains/python/debugger/PyPositionConverter;", "debugProcess", "Lcom/jetbrains/python/debugger/PyDebugProcess;", "destroyProcessGracefully", "", "killProcess", "", "intellij.python.docker"})
public final class PyDockerComposeProcessHandler
extends PythonProcessHandler
implements RemoteProcessControl,
PositionConverterProvider {
    @NotNull
    private final PyRemoteSocketToLocalHostProvider remoteSocketProvider;
    @NotNull
    private final PyRemotePathMapper pathMapper;
    @NotNull
    private final List<PathMappingSettings.PathMapping> fileMappings;
    @NotNull
    private final AtomicBoolean isFirstKillProcessInvocation;

    public PyDockerComposeProcessHandler(@NotNull GeneralCommandLine commandLine, @Nullable PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)remoteSocketProvider, (String)"remoteSocketProvider");
        super(commandLine);
        this.fileMappings = new ArrayList();
        this.isFirstKillProcessInvocation = new AtomicBoolean(true);
        this.remoteSocketProvider = remoteSocketProvider;
        PyRemotePathMapper pyRemotePathMapper = pathMapper;
        if (pyRemotePathMapper == null) {
            pyRemotePathMapper = new PyRemotePathMapper();
        }
        this.pathMapper = pyRemotePathMapper;
    }

    @NotNull
    public PathMapper getMappingSettings() {
        return (PathMapper)this.pathMapper;
    }

    @NotNull
    public Pair<String, Integer> getRemoteSocket(int localPort) {
        Pair pair = this.remoteSocketProvider.getRemoteSocket(localPort);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"getRemoteSocket(...)");
        return pair;
    }

    @NotNull
    public HostAndPort getLocalTunnel(int remotePort) {
        HostAndPort hostAndPort = HostAndPort.fromParts((String)"localhost", (int)remotePort);
        Intrinsics.checkNotNullExpressionValue((Object)hostAndPort, (String)"fromParts(...)");
        return hostAndPort;
    }

    @NotNull
    public List<PathMappingSettings.PathMapping> getFileMappings() {
        return this.fileMappings;
    }

    @NotNull
    public PyPositionConverter createPositionConverter(@NotNull PyDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        return (PyPositionConverter)new PyRemotePositionConverter(debugProcess, this.pathMapper);
    }

    protected boolean destroyProcessGracefully() {
        if (SystemInfo.isWindows) {
            return super.destroyProcessGracefully();
        }
        if (SystemInfo.isUnix) {
            UnixProcessManager.sendSignal((int)UnixProcessManager.getProcessId((Process)this.getProcess()), (int)2);
            return true;
        }
        return false;
    }

    public void killProcess() {
        if (this.isFirstKillProcessInvocation.compareAndSet(true, false)) {
            this.destroyProcessGracefully();
        } else {
            super.killProcess();
        }
    }
}

