/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.RunExecutorSettings;
import com.intellij.execution.impl.DefaultExecutorGroup;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.ProfilerExecutorBase;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.api.configurations.ProfilerConfigurationStateKt;
import com.intellij.profiler.api.configurations.ProfilerConfigurationType;
import com.intellij.profiler.api.configurations.ProfilerRunConfigurationsManager;
import com.intellij.profiler.api.configurations.ProfilerRunConfigurationsManagerListener;
import com.intellij.profiler.api.configurations.ProfilerStarter;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\u0015\u0010\u0014\u001a\u00070\t\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0016J\r\u0010\u0017\u001a\u00070\t\u00a2\u0006\u0002\b\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/profiler/DefaultProfilerExecutorGroup;", "Lcom/intellij/execution/impl/DefaultExecutorGroup;", "Lcom/intellij/profiler/DefaultProfilerExecutorGroup$ProfilerExecutorSettings;", "<init>", "()V", "childExecutors", "", "Lcom/intellij/execution/Executor;", "getId", "", "getContextActionId", "getToolWindowId", "getToolWindowIcon", "Ljavax/swing/Icon;", "getIcon", "getDisabledIcon", "getDescription", "getActionName", "getHelpId", "getStartActionText", "getRunToolbarActionText", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "param", "getRunToolbarChooserText", "isSupportedOnTarget", "", "ProfilerExecutorSettings", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nDefaultProfilerExecutorGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultProfilerExecutorGroup.kt\ncom/intellij/profiler/DefaultProfilerExecutorGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1869#2,2:87\n*S KotlinDebug\n*F\n+ 1 DefaultProfilerExecutorGroup.kt\ncom/intellij/profiler/DefaultProfilerExecutorGroup\n*L\n19#1:87,2\n*E\n"})
public final class DefaultProfilerExecutorGroup
extends DefaultExecutorGroup<ProfilerExecutorSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String EXECUTOR_ID = "Profiler";

    public DefaultProfilerExecutorGroup() {
        Iterable $this$forEach$iv = ProfilerRunConfigurationsManager.Companion.getInstance().getConfigurations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProfilerConfigurationState it = (ProfilerConfigurationState)element$iv;
            boolean bl = false;
            this.registerSettings(new ProfilerExecutorSettings(it));
        }
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProfilerRunConfigurationsManagerListener.Companion.getTOPIC(), (Object)new ProfilerRunConfigurationsManagerListener(){

            @Override
            public void profilerRunConfigurationsListChanged(List<? extends ProfilerConfigurationState> old, List<? extends ProfilerConfigurationState> list) {
                Iterable $this$forEach$iv;
                Intrinsics.checkNotNullParameter(old, (String)"old");
                Intrinsics.checkNotNullParameter(list, (String)"new");
                Iterable iterable = this.allRegisteredSettings();
                DefaultProfilerExecutorGroup defaultProfilerExecutorGroup = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    ProfilerExecutorSettings setting = (ProfilerExecutorSettings)pair.component2();
                    defaultProfilerExecutorGroup.unregisterSettings(setting);
                }
                $this$forEach$iv = list;
                defaultProfilerExecutorGroup = this;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ProfilerConfigurationState it = (ProfilerConfigurationState)element$iv;
                    boolean bl = false;
                    defaultProfilerExecutorGroup.registerSettings(new ProfilerExecutorSettings(it));
                }
            }
        });
    }

    @NotNull
    public List<Executor> childExecutors() {
        return CollectionsKt.plus((Collection)super.childExecutors(), (Iterable)ProfilerExecutorBase.Companion.customExecutors());
    }

    @NotNull
    public String getId() {
        return EXECUTOR_ID;
    }

    @NotNull
    public String getContextActionId() {
        return "DefaultProfilerExecutorGroupContextActionId";
    }

    @NotNull
    public String getToolWindowId() {
        return "Run";
    }

    @NotNull
    public Icon getToolWindowIcon() {
        Icon icon = AllIcons.Toolwindows.ToolWindowRun;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ToolWindowRun");
        return icon;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Actions.Profile;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Profile");
        return icon;
    }

    @Nullable
    public Icon getDisabledIcon() {
        return null;
    }

    @NotNull
    public String getDescription() {
        return CommonProfilerBundleKt.profilerMessage("run.profiler.action.description", new Object[0]);
    }

    @NotNull
    public String getActionName() {
        return CommonProfilerBundleKt.profilerMessage("run.profiler.name", new Object[0]);
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    @NotNull
    public String getStartActionText() {
        return CommonProfilerBundleKt.profilerMessage("run.profiler.action", new Object[0]);
    }

    @NotNull
    public String getRunToolbarActionText(@NotNull String param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        Object[] objectArray = new Object[]{param};
        return CommonProfilerBundleKt.profilerMessage("run.toolbar.profiler.run.with", objectArray);
    }

    @NotNull
    public String getRunToolbarChooserText() {
        return CommonProfilerBundleKt.profilerMessage("run.toolbar.profiler.choose.action", new Object[0]);
    }

    public boolean isSupportedOnTarget() {
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/DefaultProfilerExecutorGroup$Companion;", "", "<init>", "()V", "EXECUTOR_ID", "", "getInstance", "Lcom/intellij/profiler/DefaultProfilerExecutorGroup;", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DefaultProfilerExecutorGroup getInstance() {
            Executor executor = ExecutorRegistry.getInstance().getExecutorById(DefaultProfilerExecutorGroup.EXECUTOR_ID);
            return executor instanceof DefaultProfilerExecutorGroup ? (DefaultProfilerExecutorGroup)executor : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/profiler/DefaultProfilerExecutorGroup$ProfilerExecutorSettings;", "Lcom/intellij/execution/executors/RunExecutorSettings;", "state", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "<init>", "(Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;)V", "getState", "()Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "actionName", "", "Lorg/jetbrains/annotations/Nls;", "getActionName", "()Ljava/lang/String;", "startActionText", "getStartActionText", "configurationName", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "canRun", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "intellij.profiler.common"})
    public static final class ProfilerExecutorSettings
    implements RunExecutorSettings {
        @NotNull
        private final ProfilerConfigurationState state;
        @NotNull
        private final String actionName;
        @NotNull
        private final String startActionText;

        public ProfilerExecutorSettings(@NotNull ProfilerConfigurationState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.state = state;
            Object[] objectArray = new Object[2];
            objectArray[0] = "";
            String string = this.state.getDisplayName();
            if (string == null) {
                string = "unnamed";
            }
            objectArray[1] = string;
            this.actionName = CommonProfilerBundleKt.profilerMessage("run.with.profiler.action", objectArray);
            this.startActionText = this.getActionName();
        }

        @NotNull
        public final ProfilerConfigurationState getState() {
            return this.state;
        }

        @NotNull
        public Icon getIcon() {
            ProfilerConfigurationType<ProfilerConfigurationState> profilerConfigurationType = ProfilerConfigurationStateKt.getConfigurationType(this.state);
            if (profilerConfigurationType == null || (profilerConfigurationType = profilerConfigurationType.getIcon()) == null) {
                Icon icon = AllIcons.Actions.Profile;
                profilerConfigurationType = icon;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Profile");
            }
            return profilerConfigurationType;
        }

        @NotNull
        public String getActionName() {
            return this.actionName;
        }

        @NotNull
        public String getStartActionText() {
            return this.startActionText;
        }

        @NotNull
        public String getStartActionText(@NotNull String configurationName) {
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            String string = StringUtil.escapeMnemonics((String)configurationName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeMnemonics(...)");
            String configurationNameEscaped = string;
            String configName = StringUtil.isEmpty((String)configurationNameEscaped) ? "" : " '" + Executor.shortenNameIfNeeded((String)configurationNameEscaped) + "'";
            Object[] objectArray = new Object[2];
            objectArray[0] = configName;
            String string2 = this.state.getDisplayName();
            if (string2 == null) {
                string2 = "unnamed";
            }
            objectArray[1] = string2;
            return CommonProfilerBundleKt.profilerMessage("run.with.profiler.action", objectArray);
        }

        public boolean isApplicable(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ProfilerStarter profilerStarter = ProfilerConfigurationStateKt.createStarter(this.state);
            return profilerStarter != null ? profilerStarter.isApplicable(project) : false;
        }

        public boolean canRun(@NotNull RunProfile profile) {
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            ProfilerStarter profilerStarter = ProfilerConfigurationStateKt.createStarter(this.state);
            return profilerStarter != null ? profilerStarter.canRun(profile) : false;
        }
    }
}

