/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.navigation.plugins;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetExtFunctionInfo {
    public static final DataExternalizer<PuppetExtFunctionInfo> EXTERNALIZER = new MyExternalizer();
    private final int myOffsetInFile;
    @NotNull
    private final List<PuppetExtParamInfo> myParamInfos;

    public PuppetExtFunctionInfo(int offsetInFile, @NotNull List<PuppetExtParamInfo> paramInfos) {
        if (paramInfos == null) {
            PuppetExtFunctionInfo.$$$reportNull$$$0(0);
        }
        this.myOffsetInFile = offsetInFile;
        this.myParamInfos = paramInfos;
    }

    public int getOffsetInFile() {
        return this.myOffsetInFile;
    }

    @NotNull
    public List<PuppetExtParamInfo> getParamInfos() {
        List<PuppetExtParamInfo> list = this.myParamInfos;
        if (list == null) {
            PuppetExtFunctionInfo.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PuppetExtFunctionInfo info = (PuppetExtFunctionInfo)o;
        if (this.myOffsetInFile != info.myOffsetInFile) {
            return false;
        }
        return this.myParamInfos.equals(info.myParamInfos);
    }

    public int hashCode() {
        int result = this.myOffsetInFile;
        result = 31 * result + this.myParamInfos.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramInfos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/PuppetExtFunctionInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/PuppetExtFunctionInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class MyExternalizer
    implements DataExternalizer<PuppetExtFunctionInfo> {
        private MyExternalizer() {
        }

        public void save(@NotNull DataOutput out, PuppetExtFunctionInfo value) throws IOException {
            if (out == null) {
                MyExternalizer.$$$reportNull$$$0(0);
            }
            EnumeratorIntegerDescriptor.INSTANCE.save(out, (Object)value.myOffsetInFile);
            out.writeInt(value.myParamInfos.size());
            for (PuppetExtParamInfo info : value.myParamInfos) {
                out.writeInt(info.myOffsetInFile);
                out.writeUTF(info.myParamName);
                out.writeUTF(StringUtil.notNullize((String)info.myDescription));
            }
        }

        public PuppetExtFunctionInfo read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyExternalizer.$$$reportNull$$$0(1);
            }
            Integer offset = (Integer)EnumeratorIntegerDescriptor.INSTANCE.read(in);
            int numberOfParams = in.readInt();
            ArrayList<PuppetExtParamInfo> paramInfos = numberOfParams == 0 ? Collections.emptyList() : new ArrayList<PuppetExtParamInfo>(numberOfParams);
            for (int i = 0; i < numberOfParams; ++i) {
                int fileOffset = in.readInt();
                String paramName = in.readUTF();
                String desc = StringUtil.nullize((String)in.readUTF());
                paramInfos.add(new PuppetExtParamInfo(fileOffset, paramName, desc));
            }
            return new PuppetExtFunctionInfo(offset, paramInfos);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/PuppetExtFunctionInfo$MyExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PuppetExtParamInfo {
        private final int myOffsetInFile;
        @NotNull
        private final String myParamName;
        @Nullable
        private final String myDescription;

        public PuppetExtParamInfo(int offsetInFile, @NotNull String paramName, @Nullable String description) {
            if (paramName == null) {
                PuppetExtParamInfo.$$$reportNull$$$0(0);
            }
            this.myOffsetInFile = offsetInFile;
            this.myParamName = paramName;
            this.myDescription = description;
        }

        public int getOffsetInFile() {
            return this.myOffsetInFile;
        }

        @NotNull
        public String getParamName() {
            String string = this.myParamName;
            if (string == null) {
                PuppetExtParamInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public String getDescription() {
            return this.myDescription;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PuppetExtParamInfo info = (PuppetExtParamInfo)o;
            if (this.myOffsetInFile != info.myOffsetInFile) {
                return false;
            }
            if (!this.myParamName.equals(info.myParamName)) {
                return false;
            }
            return Objects.equals(this.myDescription, info.myDescription);
        }

        public int hashCode() {
            int result = this.myOffsetInFile;
            result = 31 * result + this.myParamName.hashCode();
            result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paramName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/PuppetExtFunctionInfo$PuppetExtParamInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/PuppetExtFunctionInfo$PuppetExtParamInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParamName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

