/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.ClientData;
import org.jetbrains.idea.perforce.application.ClientRootsCache;
import org.jetbrains.idea.perforce.application.ConnectionInfo;
import org.jetbrains.idea.perforce.application.P4RootsInformation;
import org.jetbrains.idea.perforce.application.P4RootsInformationHolder;
import org.jetbrains.idea.perforce.application.PerforceClientRootsChecker;
import org.jetbrains.idea.perforce.application.PerforceInfoAndClient;
import org.jetbrains.idea.perforce.perforce.PerforceAuthenticationException;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

@Service(value={Service.Level.PROJECT})
public final class PerforceBaseInfoWorker {
    private static final Logger LOG = Logger.getInstance(PerforceBaseInfoWorker.class);
    private long myLastValidTime;
    private final PerforceConnectionManagerI myConnectionManager;
    private final PerforceSettings mySettings;
    private PerforceClientRootsChecker myChecker;
    private Map<P4Connection, ConnectionInfo> myInfos;
    private final Object myInfoLock;
    private final Object myRefreshLock;
    private boolean myIsDirty;
    private boolean myStop;
    private final PerforceConnectionProblemsNotifier myNotifier;
    private final PerforceLoginManager myLoginManager;
    private volatile boolean myInsideRefresh;

    public PerforceBaseInfoWorker(@NotNull Project project) {
        if (project == null) {
            PerforceBaseInfoWorker.$$$reportNull$$$0(0);
        }
        this.myLastValidTime = -1L;
        this.myChecker = new PerforceClientRootsChecker();
        this.myInfos = new WeakHashMap<P4Connection, ConnectionInfo>();
        this.myInfoLock = new Object();
        this.myRefreshLock = new Object();
        this.myNotifier = PerforceConnectionProblemsNotifier.getInstance(project);
        this.myLoginManager = PerforceLoginManager.getInstance(project);
        this.myLoginManager.addSuccessfulLoginListener(() -> {
            Object object = this.myInfoLock;
            synchronized (object) {
                if (this.myChecker.hasNotAuthorized()) {
                    this.scheduleRefresh();
                }
            }
        });
        this.myConnectionManager = (PerforceConnectionManagerI)project.getService(PerforceConnectionManagerI.class);
        this.mySettings = PerforceSettings.getSettings(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<P4Connection, ConnectionInfo> refreshInfo() {
        PerforceInfoAndClient.RefreshInfo refreshInfo;
        Map<P4Connection, ConnectionInfo> old;
        if (!this.mySettings.ENABLED) {
            return Collections.emptyMap();
        }
        Object object = this.myInfoLock;
        synchronized (object) {
            old = this.myInfos;
            if (!this.myIsDirty) {
                return old;
            }
        }
        Object object2 = this.myRefreshLock;
        synchronized (object2) {
            this.myInsideRefresh = true;
            try {
                refreshInfo = this.doRefreshInfo(old);
            }
            finally {
                this.myInsideRefresh = false;
            }
        }
        return refreshInfo.newInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerforceInfoAndClient.RefreshInfo doRefreshInfo(Map<P4Connection, ConnectionInfo> old) {
        Map<VirtualFile, P4Connection> allConnections = this.myConnectionManager.getAllConnections();
        PerforceInfoAndClient.RefreshInfo refreshInfo = this.recalculateInfo(allConnections, old);
        PerforceClientRootsChecker checker = new PerforceClientRootsChecker(refreshInfo.newInfo, allConnections);
        Object object = this.myInfoLock;
        synchronized (object) {
            this.myIsDirty = false;
            this.myInfos = new WeakHashMap<P4Connection, ConnectionInfo>();
            this.myInfos.putAll(refreshInfo.newInfo);
            this.myChecker = checker;
            if (!refreshInfo.hasAnyErrorsBesidesAuthentication) {
                this.myLastValidTime = System.currentTimeMillis();
            }
        }
        LOG.debug("info+client calculated: " + String.valueOf(refreshInfo));
        this.notifyAboutErrors(checker, refreshInfo);
        return refreshInfo;
    }

    private PerforceInfoAndClient.RefreshInfo recalculateInfo(Map<VirtualFile, P4Connection> allConnections, Map<P4Connection, ConnectionInfo> old) {
        Project project = this.mySettings.getProject();
        PerforceRunner runner = PerforceRunner.getInstance(project);
        ClientRootsCache cache = ClientRootsCache.getClientRootsCache(project);
        return PerforceInfoAndClient.recalculateInfos(old, allConnections.values(), runner, cache);
    }

    private void notifyAboutErrors(PerforceClientRootsChecker checker, PerforceInfoAndClient.RefreshInfo refreshInfo) {
        if (checker.isServerUnavailable()) {
            this.myNotifier.setProblems(true, true);
        } else {
            this.myNotifier.setProblems(false, checker.hasAnyErrors() || refreshInfo.hasAnyErrorsBesidesAuthentication);
        }
        if (checker.hasNotAuthorized()) {
            for (Map.Entry<P4Connection, PerforceAuthenticationException> connection : checker.getNotAuthorized().entrySet()) {
                this.myLoginManager.getNotifier().ensureNotify(connection.getKey(), connection.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRefresh() {
        if (this.myInsideRefresh) {
            return;
        }
        LOG.debug("Schedule refresh: ", new Throwable());
        Object object = this.myInfoLock;
        synchronized (object) {
            this.myLastValidTime = -1L;
            this.myIsDirty = true;
        }
    }

    @Nullable
    public Map<String, List<String>> getInfo(P4Connection connection) throws VcsException {
        ConnectionInfo info = this.getInfoAndClient(connection);
        return info == null ? null : info.getInfo();
    }

    @Nullable
    public ClientData getClient(P4Connection connection) throws VcsException {
        ConnectionInfo info = this.getInfoAndClient(connection);
        return info == null ? null : info.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Map<String, List<String>> getCachedInfo(P4Connection connection) throws VcsException {
        Object object = this.myInfoLock;
        synchronized (object) {
            ConnectionInfo info;
            if (this.myStop) {
                return null;
            }
            ConnectionInfo connectionInfo = info = connection == null ? null : this.myInfos.get(connection);
            if (info == null) {
                LOG.debug("No info for " + String.valueOf(connection) + "; infos=" + String.valueOf(this.myInfos));
                return null;
            }
            return info.getInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ClientData getCachedClient(P4Connection connection) throws VcsException {
        Object object = this.myInfoLock;
        synchronized (object) {
            if (this.myStop) {
                return null;
            }
            ConnectionInfo info = connection == null ? null : this.myInfos.get(connection);
            return info == null ? null : info.getClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ConnectionInfo getInfoAndClient(P4Connection connection) throws VcsException {
        boolean dirty;
        ConnectionInfo info;
        Object object = this.myInfoLock;
        synchronized (object) {
            if (this.myStop) {
                return null;
            }
            info = connection == null ? null : this.myInfos.get(connection);
            dirty = this.myIsDirty;
            if (!dirty && info != null) {
                return info;
            }
        }
        if (dirty) {
            info = this.refreshInfo().get(connection);
        }
        if (info == null) {
            Project project = this.mySettings.getProject();
            info = PerforceInfoAndClient.calcInfo(connection, PerforceRunner.getInstance(project), ClientRootsCache.getClientRootsCache(project));
            Object object2 = this.myInfoLock;
            synchronized (object2) {
                this.myInfos.put(connection, info);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOG.debug("stop", new Throwable());
        Object object = this.myInfoLock;
        synchronized (object) {
            this.myStop = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LOG.debug("start", new Throwable());
        Object object = this.myInfoLock;
        synchronized (object) {
            this.myStop = false;
            this.myLastValidTime = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastValidTime() {
        Object object = this.myInfoLock;
        synchronized (object) {
            return this.myLastValidTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P4RootsInformation getCheckerResults() {
        Object object = this.myInfoLock;
        synchronized (object) {
            return new P4RootsInformationHolder(this.myChecker.getErrors(), this.myChecker.getMap(), this.myChecker.getNotAuthorized(), this.myChecker.hasNoConnections());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/perforce/application/PerforceBaseInfoWorker", "<init>"));
    }
}

