/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookVisualizationCoroutine;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ui.EDT;
import java.awt.Rectangle;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 12\u00020\u0001:\u0003/01B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0017\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0002\u0010\u001cJ#\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\u00a2\u0006\u0002\u0010\u001eJ#\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u0019J\u000e\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\"J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u001bH\u0002J\u001f\u0010(\u001a\u0002H)\"\u0004\b\u0000\u0010)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H)0+\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020.2\u0006\u0010%\u001a\u00020\"H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00062"}, d2={"Lcom/intellij/notebooks/visualization/ui/NotebookPositionKeeper;", "Lcom/intellij/openapi/Disposable$Default;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "forgetJob", "Lkotlinx/coroutines/Job;", "internalScroll", "Ljava/util/concurrent/atomic/AtomicBoolean;", "visibleArea", "Ljava/awt/Rectangle;", "Lorg/jetbrains/annotations/NotNull;", "getVisibleArea", "()Ljava/awt/Rectangle;", "rememberRunNextCellScrollKeep", "", "intervalPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "forgetToKeepCell", "forgetToKeepCellWithDelay", "scrollToAppearCell", "scrollToKeepCell", "", "maximumHeight", "", "(Ljava/lang/Integer;)Z", "calculateRangeToKeepCellVisible", "(Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Ljava/lang/Integer;)Ljava/awt/Rectangle;", "calculateScrollToMakeCellVisible", "(Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Ljava/lang/Integer;)Ljava/lang/Integer;", "getPosition", "Lcom/intellij/notebooks/visualization/ui/NotebookPositionKeeper$Position;", "useCaretPositon", "restorePosition", "position", "scrollToY", "newY", "keepScrollingPositionWhile", "T", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getOffsetProvider", "Lcom/intellij/notebooks/visualization/ui/NotebookPositionKeeper$OffsetProvider;", "OffsetProvider", "Position", "Companion", "intellij.notebooks.visualization"})
public final class NotebookPositionKeeper
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @Nullable
    private Job forgetJob;
    @NotNull
    private final AtomicBoolean internalScroll;
    @NotNull
    private static final Key<NotebookIntervalPointer> RUN_NEXT_CELL_SCROLL_KEEPER_INTERVAL = new Key("RUN_NEXT_CELL_SCROLL_KEEPER");
    private static final double MAXIMUM_HEIGH_OF_SCROLL_KEEPING_CELL = 0.25;

    public NotebookPositionKeeper(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.internalScroll = new AtomicBoolean(false);
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            public void bulkUpdateStarting(Document document) {
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                this.forgetToKeepCell();
            }

            public void beforeDocumentChange(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.forgetToKeepCell();
            }
        }, (Disposable)this);
        this.editor.getScrollingModel().addVisibleAreaListener(arg_0 -> NotebookPositionKeeper._init_$lambda$0(this, arg_0), (Disposable)this);
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    private final Rectangle getVisibleArea() {
        Rectangle rectangle = this.editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleAreaOnScrollingFinished(...)");
        return rectangle;
    }

    public final void rememberRunNextCellScrollKeep(@NotNull NotebookIntervalPointer intervalPointer) {
        Intrinsics.checkNotNullParameter((Object)intervalPointer, (String)"intervalPointer");
        Job job = this.forgetJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.forgetJob = null;
        this.forgetToKeepCell();
        if (intervalPointer.get() == null) {
            return;
        }
        this.editor.putUserData(RUN_NEXT_CELL_SCROLL_KEEPER_INTERVAL, (Object)intervalPointer);
    }

    public final void forgetToKeepCell() {
        Job job = this.forgetJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.forgetJob = null;
        RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)this.editor), RUN_NEXT_CELL_SCROLL_KEEPER_INTERVAL);
    }

    public final void forgetToKeepCellWithDelay() {
        Job job = this.forgetJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.forgetJob = NotebookVisualizationCoroutine.Utils.INSTANCE.launchBackground((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NotebookPositionKeeper this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DelayKt.delay((long)1500L, (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.this$0.forgetToKeepCell();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public final void scrollToAppearCell(@NotNull NotebookIntervalPointer intervalPointer) {
        Intrinsics.checkNotNullParameter((Object)intervalPointer, (String)"intervalPointer");
        Integer n = NotebookPositionKeeper.calculateScrollToMakeCellVisible$default(this, intervalPointer, null, 2, null);
        if (n == null) {
            return;
        }
        int y = n;
        this.scrollToY(y);
    }

    public final boolean scrollToKeepCell(@Nullable Integer maximumHeight) {
        NotebookIntervalPointer notebookIntervalPointer = (NotebookIntervalPointer)this.editor.getUserData(RUN_NEXT_CELL_SCROLL_KEEPER_INTERVAL);
        if (notebookIntervalPointer == null) {
            return false;
        }
        NotebookIntervalPointer intervalPointer = notebookIntervalPointer;
        Integer n = this.calculateScrollToMakeCellVisible(intervalPointer, maximumHeight);
        if (n == null) {
            return false;
        }
        int y = n;
        this.scrollToY(y);
        return true;
    }

    public static /* synthetic */ boolean scrollToKeepCell$default(NotebookPositionKeeper notebookPositionKeeper, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return notebookPositionKeeper.scrollToKeepCell(n);
    }

    private final Rectangle calculateRangeToKeepCellVisible(NotebookIntervalPointer intervalPointer, Integer maximumHeight) {
        NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.get((Editor)this.editor);
        EditorCell editorCell = notebookCellInlayManager != null ? notebookCellInlayManager.getCell(intervalPointer) : null;
        Object object = editorCell;
        if (object == null || (object = ((EditorCell)object).getView()) == null || (object = ((EditorCellView)object).calculateBounds()) == null) {
            return null;
        }
        Object bounds = object;
        int visibleAreaHeight = (int)((double)this.getVisibleArea().height * 0.25);
        Integer n = maximumHeight;
        int height = Math.min(n != null ? n : Integer.MAX_VALUE, Math.min(visibleAreaHeight, ((Rectangle)bounds).height));
        return new Rectangle(((Rectangle)bounds).x, ((Rectangle)bounds).y, ((Rectangle)bounds).width, height);
    }

    static /* synthetic */ Rectangle calculateRangeToKeepCellVisible$default(NotebookPositionKeeper notebookPositionKeeper, NotebookIntervalPointer notebookIntervalPointer, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return notebookPositionKeeper.calculateRangeToKeepCellVisible(notebookIntervalPointer, n);
    }

    private final Integer calculateScrollToMakeCellVisible(NotebookIntervalPointer intervalPointer, Integer maximumHeight) {
        Rectangle rectangle = this.calculateRangeToKeepCellVisible(intervalPointer, maximumHeight);
        if (rectangle == null) {
            return null;
        }
        Rectangle cellRectangle = rectangle;
        Rectangle visibleArea = this.getVisibleArea();
        if (visibleArea.contains(cellRectangle)) {
            return null;
        }
        int bottomCellY = cellRectangle.y + cellRectangle.height;
        int scrollToPosition = Math.max(0, bottomCellY - visibleArea.height);
        return scrollToPosition;
    }

    static /* synthetic */ Integer calculateScrollToMakeCellVisible$default(NotebookPositionKeeper notebookPositionKeeper, NotebookIntervalPointer notebookIntervalPointer, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return notebookPositionKeeper.calculateScrollToMakeCellVisible(notebookIntervalPointer, n);
    }

    @NotNull
    public final Position getPosition(boolean useCaretPositon) {
        int n;
        Rectangle visibleArea = this.getVisibleArea();
        if (useCaretPositon) {
            int caretY = this.editor.visualLineToY(this.editor.getCaretModel().getVisualPosition().line);
            n = visibleArea.height > 0 && (caretY + this.editor.getLineHeight() <= visibleArea.y || caretY >= visibleArea.y + visibleArea.height) ? this.editor.logicalPositionToOffset(this.editor.xyToLogicalPosition(visibleArea.getLocation())) : this.editor.getCaretModel().getOffset();
        } else {
            n = this.editor.logicalPositionToOffset(this.editor.xyToLogicalPosition(visibleArea.getLocation()));
        }
        int topLeftCornerOffset = n;
        int viewportShift = this.editor.offsetToXY((int)topLeftCornerOffset).y - visibleArea.y;
        Position position = new Position(topLeftCornerOffset, viewportShift);
        return position;
    }

    public static /* synthetic */ Position getPosition$default(NotebookPositionKeeper notebookPositionKeeper, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return notebookPositionKeeper.getPosition(bl);
    }

    public final void restorePosition(@NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        int topLeftCornerOffset = position.component1();
        int viewportShift = position.component2();
        int newY = this.editor.offsetToXY((int)topLeftCornerOffset).y - viewportShift;
        if (this.getVisibleArea().y == newY) {
            return;
        }
        this.scrollToY(newY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scrollToY(int newY) {
        if (this.getVisibleArea().y == newY) {
            return;
        }
        EDT.assertIsEdt();
        ScrollingModelEx scrollingModelEx = this.editor.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModelEx, (String)"getScrollingModel(...)");
        ScrollingModelEx scrollingModel = scrollingModelEx;
        try {
            this.internalScroll.set(true);
            scrollingModel.disableAnimation();
            scrollingModel.scrollVertically(newY);
        }
        finally {
            this.internalScroll.set(false);
            scrollingModel.enableAnimation();
        }
    }

    public final <T> T keepScrollingPositionWhile(@NotNull Function0<? extends T> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        return (T)WriteIntentReadAction.compute(() -> NotebookPositionKeeper.keepScrollingPositionWhile$lambda$2(this, task));
    }

    private final OffsetProvider getOffsetProvider(Position position) {
        return this.editor.getCaretModel().getOffset() == position.getTopLeftCornerOffset() ? (OffsetProvider)new OffsetProvider(this){
            final /* synthetic */ NotebookPositionKeeper this$0;
            {
                this.this$0 = $receiver;
            }

            public int getOffset() {
                return this.this$0.getEditor().getCaretModel().getOffset();
            }

            public void close() {
            }
        } : (OffsetProvider)new OffsetProvider(this, position){
            private final RangeMarker myTopLeftCornerMarker;
            {
                RangeMarker rangeMarker = $receiver.getEditor().getDocument().createRangeMarker($position.getTopLeftCornerOffset(), $position.getTopLeftCornerOffset());
                Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
                this.myTopLeftCornerMarker = rangeMarker;
            }

            public final RangeMarker getMyTopLeftCornerMarker() {
                return this.myTopLeftCornerMarker;
            }

            public int getOffset() {
                return this.myTopLeftCornerMarker.getStartOffset();
            }

            public void close() {
                this.myTopLeftCornerMarker.dispose();
            }
        };
    }

    private static final void _init_$lambda$0(NotebookPositionKeeper this$0, VisibleAreaEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Rectangle rectangle = it.getOldRectangle();
        boolean bl = rectangle != null ? rectangle.y == it.getNewRectangle().y : false;
        if (bl) {
            return;
        }
        if (!this$0.internalScroll.get()) {
            this$0.forgetToKeepCell();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object keepScrollingPositionWhile$lambda$2(NotebookPositionKeeper this$0, Function0 $task) {
        Pair pair;
        if (this$0.editor.isDisposed()) {
            return $task.invoke();
        }
        Position position = this$0.getPosition(false);
        AutoCloseable autoCloseable = this$0.getOffsetProvider(position);
        Throwable throwable = null;
        try {
            OffsetProvider offsetProvider = (OffsetProvider)autoCloseable;
            boolean bl = false;
            pair = TuplesKt.to((Object)$task.invoke(), (Object)offsetProvider.getOffset());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Pair pair2 = pair;
        Object r = pair2.component1();
        int newOffset = ((Number)pair2.component2()).intValue();
        if (this$0.scrollToKeepCell(null)) {
            return r;
        }
        this$0.restorePosition(new Position(newOffset, position.getViewportShift()));
        return r;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/notebooks/visualization/ui/NotebookPositionKeeper$Companion;", "", "<init>", "()V", "RUN_NEXT_CELL_SCROLL_KEEPER_INTERVAL", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "MAXIMUM_HEIGH_OF_SCROLL_KEEPING_CELL", "", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bb\u0018\u00002\u00060\u0001j\u0002`\u0002J\b\u0010\u0003\u001a\u00020\u0004H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/intellij/notebooks/visualization/ui/NotebookPositionKeeper$OffsetProvider;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "getOffset", "", "intellij.notebooks.visualization"})
    private static interface OffsetProvider
    extends AutoCloseable {
        public int getOffset();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/notebooks/visualization/ui/NotebookPositionKeeper$Position;", "", "topLeftCornerOffset", "", "viewportShift", "<init>", "(II)V", "getTopLeftCornerOffset", "()I", "getViewportShift", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.notebooks.visualization"})
    public static final class Position {
        private final int topLeftCornerOffset;
        private final int viewportShift;

        public Position(int topLeftCornerOffset, int viewportShift) {
            this.topLeftCornerOffset = topLeftCornerOffset;
            this.viewportShift = viewportShift;
        }

        public final int getTopLeftCornerOffset() {
            return this.topLeftCornerOffset;
        }

        public final int getViewportShift() {
            return this.viewportShift;
        }

        public final int component1() {
            return this.topLeftCornerOffset;
        }

        public final int component2() {
            return this.viewportShift;
        }

        @NotNull
        public final Position copy(int topLeftCornerOffset, int viewportShift) {
            return new Position(topLeftCornerOffset, viewportShift);
        }

        public static /* synthetic */ Position copy$default(Position position, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = position.topLeftCornerOffset;
            }
            if ((n3 & 2) != 0) {
                n2 = position.viewportShift;
            }
            return position.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Position(topLeftCornerOffset=" + this.topLeftCornerOffset + ", viewportShift=" + this.viewportShift + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.topLeftCornerOffset);
            result = result * 31 + Integer.hashCode(this.viewportShift);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Position)) {
                return false;
            }
            Position position = (Position)other;
            if (this.topLeftCornerOffset != position.topLeftCornerOffset) {
                return false;
            }
            return this.viewportShift == position.viewportShift;
        }
    }
}

