/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.java.jdk;

import com.intellij.indexing.shared.ultimate.java.jdk.JdkDownloadItem;
import com.intellij.indexing.shared.ultimate.java.jdk.JdkItemPaths;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerEel;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerWSL;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListDownloader;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.OsAbstractionForJdkInstaller;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.util.io.Decompressor;
import com.intellij.warmup.util.ConsoleLog;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\b2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002\u001a6\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\b2\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\u000e\b\u0004\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0!H\u0086\b\u00f8\u0001\u0000\u001a \u0010\"\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002\u001a\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u000eH\u0002\u001a\u001c\u0010&\u001a\u00020\u001b*\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000eH\u0002\u001a\u0018\u0010+\u001a\u00020,2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0010\u0010-\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"!\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006."}, d2={"allJdks", "", "Lcom/intellij/indexing/shared/ultimate/java/jdk/JdkDownloadItem;", "getAllJdks", "()Ljava/util/List;", "allJdks$delegate", "Lkotlin/Lazy;", "EDITION", "", "jdkDownloadItem", "version", "jdks", "", "determineTargetJdkHome", "Ljava/nio/file/Path;", "jdk", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "listJDKs", "predicate", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPredicate;", "MINIMUM_JDK_FILES_COUNT", "", "shouldDownloadJdk", "", "targetJdkHome", "targetHomeMarker", "retry", "", "count", "message", "delay", "Ljava/time/Duration;", "conditionBlock", "Lkotlin/Function0;", "downloadAndInstallJdk", "downloadFileFromUrl", "urlString", "destinationPath", "installJdk", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller;", "request", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallRequest;", "markerFile", "downloadJdkItem", "Lcom/intellij/indexing/shared/ultimate/java/jdk/JdkItemPaths;", "getJavaBin", "intellij.indexing.shared.ultimate.java"})
@SourceDebugExtension(value={"SMAP\njdkDownloads.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jdkDownloads.kt\ncom/intellij/indexing/shared/ultimate/java/jdk/JdkDownloadsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n62#1,24:197\n669#2,11:174\n1563#2:185\n1634#2,3:186\n1563#2:189\n1634#2,3:190\n1563#2:193\n1634#2,3:194\n*S KotlinDebug\n*F\n+ 1 jdkDownloads.kt\ncom/intellij/indexing/shared/ultimate/java/jdk/JdkDownloadsKt\n*L\n88#1:197,24\n35#1:174,11\n45#1:185\n45#1:186,3\n47#1:189\n47#1:190,3\n50#1:193\n50#1:194,3\n*E\n"})
public final class JdkDownloadsKt {
    @NotNull
    private static final Lazy allJdks$delegate = LazyKt.lazy(JdkDownloadsKt::allJdks_delegate$lambda$0);
    @NotNull
    private static final String EDITION = "corretto";
    private static final int MINIMUM_JDK_FILES_COUNT = 42;

    private static final List<JdkDownloadItem> getAllJdks() {
        Lazy lazy = allJdks$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public static final JdkDownloadItem jdkDownloadItem(@NotNull String version, @NotNull Iterable<JdkDownloadItem> jdks) {
        JdkDownloadItem jdkDownloadItem;
        block3: {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(jdks, (String)"jdks");
            Iterable<JdkDownloadItem> $this$singleOrNull$iv = jdks;
            boolean $i$f$singleOrNull = false;
            JdkDownloadItem single$iv = null;
            boolean found$iv = false;
            Iterator<JdkDownloadItem> iterator = $this$singleOrNull$iv.iterator();
            while (iterator.hasNext()) {
                JdkDownloadItem element$iv;
                JdkDownloadItem it = element$iv = iterator.next();
                boolean bl = false;
                if (!it.getJdk().getSharedIndexAliases().contains("corretto-" + version)) continue;
                if (found$iv) {
                    jdkDownloadItem = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            jdkDownloadItem = !found$iv ? null : single$iv;
        }
        JdkDownloadItem jdkDownloadItem2 = jdkDownloadItem;
        if (jdkDownloadItem2 == null) {
            throw new RuntimeException("Unable to find required JDK version " + version);
        }
        return jdkDownloadItem2;
    }

    public static /* synthetic */ JdkDownloadItem jdkDownloadItem$default(String string, Iterable iterable, int n, Object object) {
        if ((n & 2) != 0) {
            iterable = JdkDownloadsKt.getAllJdks();
        }
        return JdkDownloadsKt.jdkDownloadItem(string, iterable);
    }

    private static final Path determineTargetJdkHome(JdkItem jdk) {
        Path path = PathManager.getSystemDir().resolve("tmp").resolve(jdk.getInstallFolderName());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JdkDownloadItem> listJDKs(@NotNull JdkPredicate predicate) {
        Iterable $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        List allJDKs = new JdkListDownloader().downloadModelForJdkInstaller(null, predicate);
        Iterable iterable = allJDKs;
        Object object = ConsoleLog.INSTANCE;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            JdkItem jdkItem = (JdkItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFullPresentationText());
        }
        object.info("Total JDKs: " + (List)destination$iv$iv);
        Iterable $this$map$iv2 = allJDKs;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JdkItem bl = (JdkItem)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.add(it.getJdkVersion());
        }
        SortedSet allVersions = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv2));
        ConsoleLog.INSTANCE.info("JDK versions: " + allVersions);
        $this$map$iv2 = allJDKs;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void jdk;
            JdkItem it = (JdkItem)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(new JdkDownloadItem((JdkItem)jdk, (Function0<JdkItemPaths>)((Function0)() -> JdkDownloadsKt.listJDKs$lambda$5$lambda$4((JdkItem)jdk, predicate))));
        }
        return (List)destination$iv$iv2;
    }

    private static final boolean shouldDownloadJdk(Path targetJdkHome, Path targetHomeMarker) {
        return !Files.isRegularFile(targetHomeMarker, new LinkOption[0]) || Files.list(targetJdkHome).count() < 42L;
    }

    public static final void retry(int count, @NotNull String message, @NotNull Duration delay, @NotNull Function0<Unit> conditionBlock) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Intrinsics.checkNotNullParameter(conditionBlock, (String)"conditionBlock");
        boolean $i$f$retry = false;
        Exception lastAssertError = null;
        int i = 1;
        int n = count + 1;
        if (i <= n) {
            while (true) {
                if (i == count + 1) {
                    throw new RuntimeException(message, lastAssertError);
                }
                try {
                    conditionBlock.invoke();
                }
                catch (Exception e) {
                    lastAssertError = e;
                    Thread.sleep(delay.toMillis());
                    if (i == n) break;
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    public static /* synthetic */ void retry$default(int count, String message, Duration delay, Function0 conditionBlock, int n, Object object) {
        if ((n & 4) != 0) {
            Duration duration = Duration.of(100L, ChronoUnit.MILLIS);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"of(...)");
            delay = duration;
        }
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Intrinsics.checkNotNullParameter((Object)conditionBlock, (String)"conditionBlock");
        boolean $i$f$retry = false;
        Exception lastAssertError = null;
        int i = 1;
        int n2 = count + 1;
        if (i <= n2) {
            while (true) {
                if (i == count + 1) {
                    throw new RuntimeException(message, lastAssertError);
                }
                try {
                    conditionBlock.invoke();
                }
                catch (Exception e) {
                    lastAssertError = e;
                    Thread.sleep(delay.toMillis());
                    if (i == n2) break;
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void downloadAndInstallJdk(JdkItem jdk, Path targetJdkHome, Path targetHomeMarker) {
        void count$iv;
        int n = 5;
        String message$iv = "Failure on downloading/installing JDK";
        Duration duration = Duration.of(100L, ChronoUnit.MILLIS);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"of(...)");
        Duration delay$iv = duration;
        boolean $i$f$retry = false;
        Exception lastAssertError$iv = null;
        int i$iv = 1;
        void var9_9 = count$iv + true;
        if (i$iv <= var9_9) {
            while (true) {
                if (i$iv == count$iv + true) {
                    throw new RuntimeException(message$iv, lastAssertError$iv);
                }
                try {
                    boolean bl = false;
                    ConsoleLog.INSTANCE.info("Downloading JDK at " + targetJdkHome);
                    Files.deleteIfExists(targetJdkHome);
                    JdkInstaller jdkInstaller = new JdkInstaller();
                    JdkInstallRequest request = jdkInstaller.prepareJdkInstallationDirect(jdk, targetJdkHome);
                    JdkDownloadsKt.installJdk(jdkInstaller, request, targetHomeMarker);
                }
                catch (Exception e$iv) {
                    lastAssertError$iv = e$iv;
                    Thread.sleep(delay$iv.toMillis());
                    if (i$iv == var9_9) break;
                    ++i$iv;
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void downloadFileFromUrl(String urlString, Path destinationPath) {
        Files.createDirectories(destinationPath, new FileAttribute[0]);
        Closeable closeable = new URL(urlString).openConnection().getInputStream();
        Throwable throwable = null;
        try {
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            long l = Files.copy(inputStream, destinationPath, copyOptionArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void installJdk(JdkInstaller $this$installJdk, JdkInstallRequest request, Path markerFile) {
        OsAbstractionForJdkInstaller.Wsl wslDistribution;
        JdkItem item = request.getItem();
        Path targetDir = request.getInstallDir();
        OsAbstractionForJdkInstaller.Eel eel = $this$installJdk.eelFromPath(targetDir);
        EelApi eel2 = eel != null ? eel.getEel() : null;
        OsAbstractionForJdkInstaller.Wsl wsl = wslDistribution = eel2 == null ? $this$installJdk.wslDistributionFromPath(targetDir) : null;
        if (wslDistribution != null && !Intrinsics.areEqual((Object)item.getOs(), (Object)"linux")) {
            throw new IllegalStateException(("Cannot install non-linux JDK into WSL environment to " + targetDir + " from " + item).toString());
        }
        String temp = ((Object)PathManager.getSystemDir().resolve("tmp").resolve("jdk").toAbsolutePath()).toString();
        String[] stringArray = new String[]{"jdk-" + System.nanoTime() + "-" + item.getArchiveFileName()};
        Path downloadFile = Paths.get(temp, stringArray);
        try {
            try {
                String string = item.getUrl();
                Intrinsics.checkNotNull((Object)downloadFile);
                JdkDownloadsKt.downloadFileFromUrl(string, downloadFile);
                if (!downloadFile.toFile().isFile()) {
                    throw new RuntimeException("Downloaded file does not exist: " + downloadFile);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to download " + item.getFullPresentationText() + " from " + item.getUrl() + ": " + t.getMessage(), t);
            }
            try {
                if (eel2 != null) {
                    EelPath targetDirEel = EelNioBridgeServiceKt.asEelPath((Path)targetDir);
                    JdkInstallerEel.INSTANCE.unpackJdkOnEel(eel2, downloadFile, targetDirEel, item.getPackageRootPrefix());
                } else if (wslDistribution != null) {
                    JdkInstallerWSL.INSTANCE.unpackJdkOnWsl(wslDistribution, item.getPackageType(), downloadFile, targetDir, item.getPackageRootPrefix());
                } else {
                    Decompressor it = item.getPackageType().openDecompressor(downloadFile);
                    boolean bl = false;
                    char[] cArray = new char[]{'/'};
                    String fullMatchPath = StringsKt.trim((String)item.getPackageRootPrefix(), (char[])cArray);
                    (StringsKt.isBlank((CharSequence)fullMatchPath) ? it : it.removePrefixPath(fullMatchPath)).extract(targetDir);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to extract " + item.getFullPresentationText() + ". " + t.getMessage(), t);
            }
            Files.writeString(markerFile, (CharSequence)((Object)request.getJavaHome().toRealPath(new LinkOption[0])).toString(), Charsets.UTF_8, new OpenOption[0]);
        }
        finally {
            Files.deleteIfExists(downloadFile);
        }
    }

    private static final JdkItemPaths downloadJdkItem(JdkItem jdk, JdkPredicate predicate) {
        File javaHome;
        Path targetJdkHome = JdkDownloadsKt.determineTargetJdkHome(jdk);
        Path targetHomeMarker = targetJdkHome.resolve("home.link");
        ConsoleLog.INSTANCE.info("Checking JDK at " + targetJdkHome);
        Intrinsics.checkNotNull((Object)targetHomeMarker);
        if (JdkDownloadsKt.shouldDownloadJdk(targetJdkHome, targetHomeMarker)) {
            JdkDownloadsKt.downloadAndInstallJdk(jdk, targetJdkHome, targetHomeMarker);
        }
        if (!FilesKt.resolve((File)(javaHome = new File(Files.readString(targetHomeMarker))), (String)JdkDownloadsKt.getJavaBin(predicate)).isFile()) {
            boolean bl = false;
            Files.deleteIfExists(targetJdkHome);
            String string = "corrupted JDK home: " + targetJdkHome + " (now deleted)";
            throw new IllegalArgumentException(string.toString());
        }
        Path path = javaHome.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return new JdkItemPaths(path, targetJdkHome);
    }

    private static final String getJavaBin(JdkPredicate predicate) {
        return "bin/java" + (SystemInfo.isWindows && !Intrinsics.areEqual((Object)predicate, (Object)JdkPredicate.Companion.forWSL(null)) ? ".exe" : "");
    }

    private static final List allJdks_delegate$lambda$0() {
        return JdkDownloadsKt.listJDKs(JdkPredicate.Companion.forCurrentProcess());
    }

    private static final JdkItemPaths listJDKs$lambda$5$lambda$4(JdkItem $jdk, JdkPredicate $predicate) {
        return JdkDownloadsKt.downloadJdkItem($jdk, $predicate);
    }
}

