/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.testRunner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.python.django.DjangoRunnerUtilsKt;
import com.intellij.python.django.testRunner.DjangoTestUtil;
import com.intellij.python.django.testRunner.DjangoTestsCommandLineState;
import com.intellij.python.django.testRunner.DjangoTestsConfigurationEditor;
import com.intellij.python.django.util.DjangoUtil;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.PyPsiLocationWithFixedClass;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTestsRunConfiguration
extends AbstractPythonTestRunConfiguration<DjangoTestsRunConfiguration> {
    private String myTarget;
    private String mySettingsFile;
    private boolean useCustomSettings;
    private boolean useOptions;
    private String myOptions;
    @NonNls
    private static final String TARGET_FIELD = "TARGET";
    @NonNls
    private static final String SETTINGS_FILE_FIELD = "SETTINGS_FILE";
    @NonNls
    private static final String CUSTOM_SETTINGS = "CUSTOM_SETTINGS";
    @NonNls
    private static final String OPTIONS = "OPTIONS";
    @NonNls
    private static final String USE_OPTIONS = "USE_OPTIONS";

    public String getDjangoOptions() {
        return this.myOptions;
    }

    public void setDjangoOptions(String options) {
        this.myOptions = options;
    }

    public DjangoTestsRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory, "Django");
        this.setUnbufferedEnv();
    }

    protected SettingsEditor<DjangoTestsRunConfiguration> createConfigurationEditor() {
        return new DjangoTestsConfigurationEditor(this);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        Module module;
        if (executor == null) {
            DjangoTestsRunConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            DjangoTestsRunConfiguration.$$$reportNull$$$0(1);
        }
        if ((module = this.getModule()) == null) {
            throw new ExecutionException(DjangoBundle.message((String)"django.dialog.message.no.module.provided", (Object[])new Object[0]));
        }
        if (this.useCustomSettings() && DjangoUtil.getCustomTestSettingsFile(module, this) == null) {
            throw new ExecutionException(DjangoBundle.message((String)"django.dialog.message.custom.settings.enabled.but.cant.resolve", (Object[])new Object[]{this.mySettingsFile}));
        }
        return new DjangoTestsCommandLineState(this, env);
    }

    public boolean isUseOptions() {
        return this.useOptions;
    }

    public void setUseOptions(boolean useOptions) {
        this.useOptions = useOptions;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        Module module = this.getConfigurationModule().getModule();
        if (module == null || !DjangoFacet.isPresent((Module)module)) {
            DjangoRunnerUtilsKt.reportNoDjangoOnModule(this.getProject());
        }
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            DjangoTestsRunConfiguration.$$$reportNull$$$0(2);
        }
        super.readExternal(element);
        this.myTarget = JDOMExternalizerUtil.readField((Element)element, (String)TARGET_FIELD);
        this.mySettingsFile = JDOMExternalizerUtil.readField((Element)element, (String)SETTINGS_FILE_FIELD);
        this.useCustomSettings = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)CUSTOM_SETTINGS));
        this.myOptions = JDOMExternalizerUtil.readField((Element)element, (String)OPTIONS);
        this.useOptions = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)USE_OPTIONS));
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            DjangoTestsRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)TARGET_FIELD, (String)this.myTarget);
        JDOMExternalizerUtil.writeField((Element)element, (String)SETTINGS_FILE_FIELD, (String)this.mySettingsFile);
        JDOMExternalizerUtil.writeField((Element)element, (String)CUSTOM_SETTINGS, (String)String.valueOf(this.useCustomSettings));
        JDOMExternalizerUtil.writeField((Element)element, (String)USE_OPTIONS, (String)String.valueOf(this.useOptions));
        JDOMExternalizerUtil.writeField((Element)element, (String)OPTIONS, (String)this.myOptions);
    }

    public boolean useCustomSettings() {
        return this.useCustomSettings;
    }

    public void useCustomSettings(boolean useCustomSettings) {
        this.useCustomSettings = useCustomSettings;
    }

    public String getTarget() {
        return this.myTarget;
    }

    public void setTarget(String target) {
        this.myTarget = target;
    }

    @NlsSafe
    public String getSettingsFile() {
        return this.mySettingsFile;
    }

    public void setSettingsFile(String settingsFile) {
        this.mySettingsFile = settingsFile;
    }

    @Nullable
    public String getTestSpec(@NotNull Location<?> location, @NotNull AbstractTestProxy failedTest) {
        Module module;
        if (location == null) {
            DjangoTestsRunConfiguration.$$$reportNull$$$0(4);
        }
        if (failedTest == null) {
            DjangoTestsRunConfiguration.$$$reportNull$$$0(5);
        }
        if ((module = location.getModule()) == null) {
            return null;
        }
        PsiElement testElement = location.getPsiElement();
        String appName = DjangoTestUtil.getAppNameForLocation(module, testElement);
        return location instanceof PyPsiLocationWithFixedClass ? DjangoTestUtil.buildTargetFromLocation(module, appName, ((PyPsiLocationWithFixedClass)location).getFixedClass(), testElement) : DjangoTestUtil.buildTargetFromLocation(module, appName, testElement);
    }

    @ApiStatus.Internal
    protected @Nullable Function<@NotNull TargetEnvironment, @NotNull @Nls String> createTargetEnvFunction(@NotNull VirtualFile virtualFile, @Nullable String className, @Nullable String funName) {
        if (virtualFile == null) {
            DjangoTestsRunConfiguration.$$$reportNull$$$0(6);
        }
        return this.createTargetEnvFun(virtualFile, className, funName, ".");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedTest";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/django/testRunner/DjangoTestsRunConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestSpec";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createTargetEnvFunction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

