/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.js.nodejs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.polySymbols.webTypes.WebTypesSymbol;
import com.intellij.polySymbols.webTypes.json.SourceBase;
import com.intellij.polySymbols.webTypes.json.SourceFileOffset;
import com.intellij.polySymbols.webTypes.json.SourceSymbol;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/polySymbols/js/nodejs/PackageJsonSourceLocationResolver;", "", "<init>", "()V", "getSymbolLocation", "Lcom/intellij/polySymbols/webTypes/WebTypesSymbol$Location;", "source", "Lcom/intellij/polySymbols/webTypes/json/SourceBase;", "defaultModuleName", "", "context", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.javascript.web"})
public final class PackageJsonSourceLocationResolver {
    @NotNull
    public static final PackageJsonSourceLocationResolver INSTANCE = new PackageJsonSourceLocationResolver();

    private PackageJsonSourceLocationResolver() {
    }

    @Nullable
    public final WebTypesSymbol.Location getSymbolLocation(@NotNull SourceBase source, @NotNull String defaultModuleName, @NotNull List<? extends VirtualFile> context2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)defaultModuleName, (String)"defaultModuleName");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        SourceBase sourceBase = source;
        if (sourceBase instanceof SourceSymbol) {
            String symbolName;
            String moduleName;
            String string = ((SourceSymbol)source).getModule();
            if (string == null) {
                string = moduleName = defaultModuleName;
            }
            if ((symbolName = ((SourceSymbol)source).getSymbol()) != null) {
                if (StringsKt.startsWith$default((String)moduleName, (String)"./", (boolean)false, (int)2, null)) {
                    return (WebTypesSymbol.Location)WebTypesSymbol.FileExport.Companion.create(moduleName, symbolName, context2);
                }
                return (WebTypesSymbol.Location)WebTypesSymbol.ModuleExport.Companion.create(moduleName, symbolName);
            }
        } else if (sourceBase instanceof SourceFileOffset) {
            String file = ((SourceFileOffset)source).getFile();
            Integer offset = ((SourceFileOffset)source).getOffset();
            if (file != null && offset != null) {
                return (WebTypesSymbol.Location)WebTypesSymbol.FileOffset.Companion.create(file, offset.intValue(), context2);
            }
        }
        return null;
    }
}

