/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.ProjectFileDirMacro;
import com.intellij.ide.macro.ProjectNameMacro;
import com.intellij.ide.macro.ProjectPathMacro;
import com.intellij.ide.macro.UnixSeparatorsMacro;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.JSNodeServiceOutOfMemoryDetector;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceInitialStateObject;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty0;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 L2\u00020\u0001:\u0002KLB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0000\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0004J\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0 H\u0014\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0#H\u0014J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0004J\b\u0010%\u001a\u00020\nH\u0004J\u0018\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,H\u0014J\u0010\u0010-\u001a\u00020.2\u0006\u0010'\u001a\u00020\bH\u0002J\u0010\u00103\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,H\u0014J\b\u00104\u001a\u00020.H\u0004J\b\u00105\u001a\u00020.H\u0004J \u00106\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\n072\u0006\u00104\u001a\u00020.H\u0004J\u001b\u0010:\u001a\u00020.2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\n0 H\u0004\u00a2\u0006\u0002\u0010<J\u0010\u0010?\u001a\u00020@2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0012\u0010A\u001a\u00020\u001a2\b\u0010B\u001a\u0004\u0018\u00010CH\u0016J\u0010\u0010H\u001a\u00020\u001a2\u0006\u0010I\u001a\u00020JH\u0014R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010/\u001a\u0004\u0018\u0001008TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00108\u001a\u00020\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u001eR\u0016\u0010=\u001a\u0004\u0018\u00010\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u001eR\u0014\u0010D\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010\u001eR\u0014\u0010F\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010\u001e\u00a8\u0006M"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerSettings;", "eventConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswer;", "serviceName", "", "tsServicePath", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerSettings;Ljava/util/function/Consumer;Ljava/lang/String;Ljava/lang/String;)V", "myServiceFilePath", "Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "myPackageJson", "mySettings", "oomDetector", "Lcom/intellij/lang/javascript/service/JSNodeServiceOutOfMemoryDetector;", "myEventConsumer", "myCancellationTokenDir", "Ljava/io/File;", "createState", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptServiceInitialStateObject;", "fillState", "", "state", "defaultConfigPath", "getDefaultConfigPath", "()Ljava/lang/String;", "getProbeLocations", "", "()[Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "getGlobalPlugins", "", "setManualOptions", "expandOutputDirectoryMacro", "processAnswer", "answer", "text", "", "prepareTargetRun", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "processAsEventCompletion", "", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "getInterpreter", "()Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "addNodeProcessAdditionalArguments", "hasMainFile", "hasOutputDirectory", "getOutInformation", "Lcom/intellij/openapi/util/Pair;", "projectPathString", "getProjectPathString", "checkExistsCommandLineOut", "parse", "([Ljava/lang/String;)Z", "workingDirectory", "getWorkingDirectory", "getNodeCommandLineConfiguratorOptions", "Lcom/intellij/javascript/nodejs/interpreter/NodeCommandLineConfigurator$Options;", "cancelCommand", "cancellationToken", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceProtocol$CancellationToken;", "commandLineArgsFromRegistry", "getCommandLineArgsFromRegistry", "nodePathFromRegistry", "getNodePathFromRegistry", "registerResponseHandlers", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "RemovePipeCallback", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptServiceStandardOutputProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptServiceStandardOutputProtocol.kt\ncom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,484:1\n37#2:485\n36#2,3:486\n37#2:493\n36#2,3:494\n37#2:501\n36#2,3:502\n1563#3:489\n1634#3,3:490\n1563#3:497\n1634#3,3:498\n1#4:505\n12637#5,2:506\n*S KotlinDebug\n*F\n+ 1 TypeScriptServiceStandardOutputProtocol.kt\ncom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol\n*L\n138#1:485\n138#1:486,3\n158#1:493\n158#1:494,3\n201#1:501\n201#1:502,3\n158#1:489\n158#1:490,3\n201#1:497\n201#1:498,3\n368#1:506,2\n*E\n"})
public class TypeScriptServiceStandardOutputProtocol
extends JSLanguageServiceNodeStdProtocolBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalFilePath myServiceFilePath;
    @Nullable
    private final LocalFilePath myPackageJson;
    @NotNull
    private final TypeScriptCompilerSettings mySettings;
    @NotNull
    private final JSNodeServiceOutOfMemoryDetector oomDetector;
    @NotNull
    private final Consumer<? super JSLanguageServiceAnswer> myEventConsumer;
    @Nullable
    private File myCancellationTokenDir;
    @NotNull
    public static final String EVENT_TYPE = "event";
    @NotNull
    public static final String EVENT_PROPERTY = "event";
    @NotNull
    public static final String REQUEST_COMPLETED = "requestCompleted";
    @NotNull
    public static final String BODY = "body";
    @NotNull
    private static final Set<Macro> PROJECT_LEVEL_MACRO;
    @NotNull
    private static final String CANCELLATION_PIPE_NAME_PREFIX = "cmd";

    public TypeScriptServiceStandardOutputProtocol(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings, @NotNull Consumer<? super JSLanguageServiceAnswer> eventConsumer, @NotNull String serviceName, @NotNull String tsServicePath) {
        String packageJsonPath;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter(eventConsumer, (String)"eventConsumer");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)tsServicePath, (String)"tsServicePath");
        super(serviceName, project, null, 4, null);
        this.oomDetector = new JSNodeServiceOutOfMemoryDetector(this.myProject, serviceName, null);
        String actualTsServicePath = tsServicePath;
        this.mySettings = settings;
        this.myEventConsumer = eventConsumer;
        YarnPnpNodePackage yarnPnpNodePackage = YarnPnpNodePackage.createFromText(actualTsServicePath);
        String packageJson = null;
        if (yarnPnpNodePackage != null && (packageJsonPath = yarnPnpNodePackage.getPackageJsonPath(this.myProject)) != null) {
            packageJson = packageJsonPath;
            String string = yarnPnpNodePackage.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-name>(...)");
            actualTsServicePath = string;
        }
        this.myServiceFilePath = LocalFilePath.Companion.asLocalFilePath$intellij_javascript_impl(actualTsServicePath);
        String string = packageJson;
        this.myPackageJson = string != null ? LocalFilePath.Companion.asLocalFilePath$intellij_javascript_impl(string) : null;
        try {
            this.myCancellationTokenDir = FileUtil.createTempDirectory((String)"tsServerCancellationPipes", (String)"", (boolean)true);
        }
        catch (IOException exception) {
            JSLanguageServiceQueue.Holder.LOGGER.error((Throwable)exception);
        }
    }

    @Override
    @NotNull
    public TypeScriptServiceInitialStateObject createState() {
        TypeScriptServiceInitialStateObject state = new TypeScriptServiceInitialStateObject();
        this.fillState(state);
        return state;
    }

    protected final void fillState(@NotNull TypeScriptServiceInitialStateObject state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        state.pluginName = "typescript";
        String string = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), "typescript/ts-plugin").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        state.pluginPath = LocalFilePath.Companion.asLocalFilePath$intellij_javascript_impl(this.getFilePath(string));
        state.serverFolderPath = this.myServiceFilePath;
        state.packageJson = this.myPackageJson;
        state.sessionId = String.valueOf(this.mySessionId);
        state.isUseSingleInferredProject = this.mySettings.getUseSingleInferredProject();
        String string2 = this.getDefaultConfigPath();
        state.defaultConfig = string2 != null ? LocalFilePath.Companion.asLocalFilePath$intellij_javascript_impl(string2) : null;
        this.setManualOptions(state);
    }

    private final String getDefaultConfigPath() {
        return TypeScriptLanguageServiceUtil.getDefaultConfigPath(this.myProject);
    }

    @NotNull
    protected LocalFilePath[] getProbeLocations() {
        String path2;
        File nodeModulesParentFile;
        File nodeModulesFile;
        File typescriptPackageFile;
        Set pluginProbeLocations = new HashSet();
        File tsserverFile = new File(this.myServiceFilePath.getPath());
        File file = typescriptPackageFile = tsserverFile.getParentFile();
        File file2 = nodeModulesFile = file != null ? file.getParentFile() : null;
        File file3 = nodeModulesParentFile = file2 != null ? file2.getParentFile() : null;
        if (nodeModulesParentFile != null) {
            String string = nodeModulesParentFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            pluginProbeLocations.add(LocalFilePath.Companion.asLocalFilePath$intellij_javascript_impl(string));
        }
        String string = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), "typescript").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        pluginProbeLocations.add(LocalFilePath.Companion.asLocalFilePath$intellij_javascript_impl(this.getFilePath(string)));
        VirtualFile dir = ProjectUtil.guessProjectDir((Project)this.myProject);
        if (dir != null && (path2 = this.getFilePath(dir)) != null) {
            pluginProbeLocations.add(LocalFilePath.Companion.asLocalFilePath$intellij_javascript_impl(path2));
        }
        Collection $this$toTypedArray$iv = pluginProbeLocations;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new LocalFilePath[0]);
    }

    @NotNull
    protected List<String> getGlobalPlugins() {
        return CollectionsKt.listOf((Object)"tsc-ide-plugin");
    }

    /*
     * Unable to fully structure code
     */
    protected final void setManualOptions(@NotNull TypeScriptServiceInitialStateObject state) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            state.hasManualParams = this.mySettings.getUseDeprecatedSettings();
            params = this.mySettings.getDefaultServiceOptions();
            var4_3 = params;
            v0 = emptyOrSpaces = var4_3 == null || StringsKt.isBlank((CharSequence)var4_3) != false;
            if (emptyOrSpaces && !state.hasManualParams) {
                return;
            }
            parsedParams = emptyOrSpaces != false ? ArrayUtilRt.EMPTY_STRING_ARRAY : ParametersList.parse((String)params);
            paramList = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(parsedParams, parsedParams.length));
            if (!state.hasManualParams) {
                if (!paramList.isEmpty()) {
                    var6_6 = paramList;
                    var18_8 = state;
                    $i$f$map = false;
                    var8_12 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var13_24 = (String)item$iv$iv;
                        var19_28 = destination$iv$iv;
                        $i$a$-map-TypeScriptServiceStandardOutputProtocol$setManualOptions$1 = false;
                        Intrinsics.checkNotNull((Object)it);
                        var19_28.add(LocalFilePath.Companion.asLocalFilePath$intellij_javascript_impl((String)it));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    var18_8.commandLineArguments = thisCollection$iv.toArray(new LocalFilePath[0]);
                }
                return;
            }
            outFile = null;
            hasMainFile = this.hasMainFile();
            if (!this.hasOutputDirectory()) break block13;
            state.projectPath = LocalFilePath.Companion.asLocalFilePath$intellij_javascript_impl(this.getProjectPathString());
            pair = null;
            try {
                pair = this.getOutInformation(hasMainFile);
            }
            catch (Exception e) {
                JSLanguageServiceQueue.Holder.LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (pair == null) break block13;
            outFile = (String)pair.first;
            outDir = (String)pair.second;
            if (StringUtil.isEmpty((String)outDir)) break block13;
            if (outFile != null) ** GOTO lbl-1000
            v1 = outDir;
            Intrinsics.checkNotNull((Object)v1);
            if (!StringsKt.contains$default((CharSequence)((CharSequence)v1), (CharSequence)"$", (boolean)false, (int)2, null)) {
                paramList.add("--outDir");
                paramList.add(FileUtilRt.toSystemDependentName((String)outDir));
            } else lbl-1000:
            // 2 sources

            {
                v2 = (String)pair.second;
                state.outPath = v2 != null ? LocalFilePath.Companion.asLocalFilePath$intellij_javascript_impl(v2) : null;
            }
        }
        Intrinsics.checkNotNull((Object)parsedParams);
        existsCommandLineOutParam = this.checkExistsCommandLineOut(parsedParams);
        if (!StringUtil.isEmpty(outFile) && !existsCommandLineOutParam) {
            paramList.add("--outFile");
            v3 = outFile;
            Intrinsics.checkNotNull(v3);
            paramList.add(FileUtilRt.toSystemDependentName(v3));
        }
        if (this.mySettings.getGenerateSourceMap()) {
            paramList.add("--sourceMap");
        }
        if (!paramList.isEmpty()) {
            outDir = paramList;
            var18_9 = state;
            $i$f$map = false;
            var11_21 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var16_31 = (String)item$iv$iv;
                var19_29 = destination$iv$iv;
                $i$a$-map-TypeScriptServiceStandardOutputProtocol$setManualOptions$2 = false;
                Intrinsics.checkNotNull((Object)it);
                var19_29.add(LocalFilePath.Companion.asLocalFilePath$intellij_javascript_impl((String)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            var18_9.commandLineArguments = thisCollection$iv.toArray(new LocalFilePath[0]);
        }
        if (hasMainFile) {
            v4 = this.mySettings.getMainFilePath();
            state.mainFilePath = v4 != null ? LocalFilePath.Companion.asLocalFilePath$intellij_javascript_impl(v4) : null;
        }
    }

    @NotNull
    protected final String expandOutputDirectoryMacro() throws Macro.ExecutionCancelledException {
        String string = this.mySettings.getOutDirectory();
        Intrinsics.checkNotNull((Object)string);
        String string2 = FileUtil.toSystemIndependentName((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
        String outWithExpandedProjectMacro = string2;
        DataContext dataContext = SimpleDataContext.getProjectContext((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getProjectContext(...)");
        DataContext context2 = dataContext;
        for (Macro macro : PROJECT_LEVEL_MACRO) {
            String macroName = "$" + macro.getName() + "$";
            if (!StringsKt.contains$default((CharSequence)outWithExpandedProjectMacro, (CharSequence)macroName, (boolean)false, (int)2, null)) continue;
            String expand = macro.expand(context2);
            if (expand == null) {
                expand = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.replace((String)outWithExpandedProjectMacro, (String)macroName, (String)expand), (String)"replace(...)");
        }
        return outWithExpandedProjectMacro;
    }

    @Override
    protected void processAnswer(@NotNull JSLanguageServiceAnswer answer2, @NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)answer2, (String)"answer");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (Intrinsics.areEqual((Object)"event", (Object)answer2.getType())) {
            if (!this.processAsEventCompletion(answer2)) {
                this.myEventConsumer.accept(answer2);
            }
            return;
        }
        super.processAnswer(answer2, text);
    }

    @Override
    protected void prepareTargetRun(@NotNull NodeTargetRun targetRun) {
        List<String> plugins;
        Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
        super.prepareTargetRun(targetRun);
        Object[] locations = this.getProbeLocations();
        List targetLocations = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])locations), TypeScriptServiceStandardOutputProtocol::prepareTargetRun$lambda$2), arg_0 -> TypeScriptServiceStandardOutputProtocol.prepareTargetRun$lambda$3(targetRun, arg_0)));
        TargetedCommandLineBuilder builder2 = targetRun.getCommandLineBuilder();
        if (!targetLocations.isEmpty()) {
            builder2.addParameter("--pluginProbeLocations");
            TargetValue targetValue = TargetValue.composite((Collection)targetLocations, arg_0 -> TypeScriptServiceStandardOutputProtocol.prepareTargetRun$lambda$5(TypeScriptServiceStandardOutputProtocol::prepareTargetRun$lambda$4, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"composite(...)");
            builder2.addParameter(targetValue);
        }
        if (!(plugins = this.getGlobalPlugins()).isEmpty()) {
            builder2.addParameter("--globalPlugins");
            String string = StringUtil.join((Collection)plugins, (String)",");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
            builder2.addParameter(string);
        }
        if (this.myCancellationTokenDir != null) {
            builder2.addParameter("--cancellationPipeName");
            builder2.addParameter(this.myCancellationTokenDir + File.separator + "cmd*");
        }
        if (!AdvancedSettings.Companion.getBoolean("js.fallback.to.old.eval.outside.of.import.graph")) {
            builder2.addParameter("--noFallbackToOldEvalOutsideOfImportGraph");
        }
    }

    private final boolean processAsEventCompletion(JSLanguageServiceAnswer answer2) {
        Object object;
        block11: {
            block10: {
                JsonElement jsonElement2;
                Object object2;
                block9: {
                    block8: {
                        JsonElement jsonElement3;
                        String property = answer2.getProperty("event");
                        if (!Intrinsics.areEqual((Object)REQUEST_COMPLETED, (Object)property)) {
                            return false;
                        }
                        object2 = answer2.getElement().get(BODY);
                        if (object2 == null) break block8;
                        JsonElement it = jsonElement3 = object2;
                        boolean bl = false;
                        object2 = it.isJsonObject() ? jsonElement3 : null;
                        if (object2 != null) break block9;
                    }
                    return false;
                }
                JsonElement body = object2;
                JsonObject object3 = body.getAsJsonObject();
                object = object3.get("request_seq");
                if (object == null) break block10;
                JsonElement it = jsonElement2 = object;
                boolean bl = false;
                object = it.isJsonPrimitive() ? jsonElement2 : null;
                if (object != null) break block11;
            }
            return false;
        }
        JsonElement seq = object;
        int intSeq = seq.getAsInt();
        JSLanguageServiceAnswerConsumer jSLanguageServiceAnswerConsumer = (JSLanguageServiceAnswerConsumer)this.myCallbacks.remove(intSeq);
        if (jSLanguageServiceAnswerConsumer == null) {
            return false;
        }
        JSLanguageServiceAnswerConsumer callback = jSLanguageServiceAnswerConsumer;
        callback.consume(answer2);
        return true;
    }

    @Override
    @Nullable
    protected NodeJsInterpreter getInterpreter() {
        return TypeScriptLanguageServiceUtil.getNodeInterpreter(this.myProject);
    }

    @Override
    protected void addNodeProcessAdditionalArguments(@NotNull NodeTargetRun targetRun) {
        Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
        super.addNodeProcessAdditionalArguments(targetRun);
        TargetedCommandLineBuilder commandLineBuilder = targetRun.getCommandLineBuilder();
        if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
            TargetValue<String> path2 = targetRun.path(this.myProject.getBasePath() + "/.log" + this.mySessionId);
            commandLineBuilder.addEnvironmentVariable("TSS_LOG", TargetValue.map(path2, arg_0 -> TypeScriptServiceStandardOutputProtocol.addNodeProcessAdditionalArguments$lambda$9(TypeScriptServiceStandardOutputProtocol::addNodeProcessAdditionalArguments$lambda$8, arg_0)));
        }
        commandLineBuilder.addEnvironmentVariable("TS_TSLINT_ENABLE_WORKSPACE_LIBRARY_EXECUTION", "true");
        JSLanguageServiceUtil.addNodeProcessArgumentsFromRegistry(commandLineBuilder, this.getServiceName(), () -> TypeScriptServiceStandardOutputProtocol.addNodeProcessAdditionalArguments$lambda$10((KProperty0)new PropertyReference0Impl(this){

            public Object get() {
                return TypeScriptServiceStandardOutputProtocol.access$getCommandLineArgsFromRegistry((TypeScriptServiceStandardOutputProtocol)this.receiver);
            }
        }));
        JSLanguageServiceUtil.addNodePathFromRegistry(commandLineBuilder, () -> TypeScriptServiceStandardOutputProtocol.addNodeProcessAdditionalArguments$lambda$11((KProperty0)new PropertyReference0Impl(this){

            public Object get() {
                return TypeScriptServiceStandardOutputProtocol.access$getNodePathFromRegistry((TypeScriptServiceStandardOutputProtocol)this.receiver);
            }
        }));
        if (!(targetRun.getInterpreter() instanceof NodeJsLocalInterpreter)) {
            Object object = ReadAction.compute(() -> TypeScriptServiceStandardOutputProtocol.addNodeProcessAdditionalArguments$lambda$12(this));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
            TypeScriptServiceStandardOutputProtocol.Companion.registerUploadVolumes(targetRun, (TypeScriptServiceInitialStateObject)object);
        }
    }

    protected final boolean hasMainFile() {
        return this.mySettings.shouldUseMainFile() && !StringUtil.isEmpty((String)this.mySettings.getMainFilePath());
    }

    protected final boolean hasOutputDirectory() {
        return this.mySettings.getHasOutDirectory() && !StringUtil.isEmpty((String)this.mySettings.getOutDirectory());
    }

    @NotNull
    protected final Pair<String, String> getOutInformation(boolean hasMainFile) throws Macro.ExecutionCancelledException {
        CharSequence indexOfDot2;
        String outFile = null;
        String outWithExpandedProjectMacro = this.expandOutputDirectoryMacro();
        if (hasMainFile) {
            int indexOfSeparator;
            String string = outWithExpandedProjectMacro;
            Intrinsics.checkNotNull((Object)string);
            int indexOfDot2 = StringsKt.lastIndexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (indexOfDot2 > 0 && indexOfDot2 > (indexOfSeparator = StringsKt.lastIndexOf$default((CharSequence)outWithExpandedProjectMacro, (char)'/', (int)0, (boolean)false, (int)6, null))) {
                if (indexOfSeparator >= 0) {
                    outFile = VfsUtil.extractFileName((String)outWithExpandedProjectMacro);
                    outWithExpandedProjectMacro = VfsUtil.getParentDir((String)outWithExpandedProjectMacro);
                } else {
                    outFile = outWithExpandedProjectMacro;
                    outWithExpandedProjectMacro = null;
                }
            }
        }
        if (!((indexOfDot2 = (CharSequence)outWithExpandedProjectMacro) == null || indexOfDot2.length() == 0)) {
            String string = FileUtil.toSystemDependentName((String)outWithExpandedProjectMacro);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
            String path2 = string;
            Pair pair = Pair.create(outFile, (Object)path2);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
            return pair;
        }
        Pair pair = Pair.create(outFile, null);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
        return pair;
    }

    @NotNull
    protected final String getProjectPathString() {
        String path2 = this.myProject.getBasePath();
        String string = path2;
        if (string == null) {
            string = "";
        }
        String string2 = FileUtil.toSystemDependentName((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
        return string2;
    }

    protected final boolean checkExistsCommandLineOut(@NotNull String[] parse) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)parse, (String)"parse");
            String[] $this$any$iv = parse;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)"-out")) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @Nullable
    protected String getWorkingDirectory() {
        if (this.myPackageJson != null) {
            return PathUtil.getParentPath((String)this.myPackageJson.getPath());
        }
        return super.getWorkingDirectory();
    }

    @Override
    @NotNull
    protected NodeCommandLineConfigurator.Options getNodeCommandLineConfiguratorOptions(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        YarnPnpNodePackage yarnPackage = YarnPnpNodePackage.createFromText(this.myServiceFilePath.getPath());
        if (yarnPackage != null) {
            NodeCommandLineConfigurator.Options options = NodeCommandLineConfigurator.defaultOptions(project).withRequiredNodePackage(yarnPackage);
            Intrinsics.checkNotNullExpressionValue((Object)options, (String)"withRequiredNodePackage(...)");
            return options;
        }
        return super.getNodeCommandLineConfiguratorOptions(project);
    }

    @Override
    public void cancelCommand(@Nullable JSLanguageServiceProtocol.CancellationToken cancellationToken) {
        if (cancellationToken instanceof JSLanguageServiceNodeStdProtocolBase.CommandIdCancellationToken) {
            File pipeFile = new File(this.myCancellationTokenDir, CANCELLATION_PIPE_NAME_PREFIX + ((JSLanguageServiceNodeStdProtocolBase.CommandIdCancellationToken)cancellationToken).id());
            if (pipeFile.exists()) {
                return;
            }
            JSLanguageServiceAnswerConsumer existingCallback = this.myCallbacks.put(((JSLanguageServiceNodeStdProtocolBase.CommandIdCancellationToken)cancellationToken).id(), new RemovePipeCallback(pipeFile));
            if (existingCallback instanceof RemovePipeCallback) {
                return;
            }
            if (existingCallback != null) {
                try {
                    File folder = pipeFile.getParentFile();
                    if (!folder.exists() && !folder.mkdirs()) {
                        throw new IOException("Cannot create directory " + folder);
                    }
                    if (pipeFile.createNewFile() && JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
                        JSLanguageServiceQueue.Holder.LOGGER.trace("Cancellation pipe file created: " + pipeFile);
                    }
                    if (!this.myCallbacks.containsKey(((JSLanguageServiceNodeStdProtocolBase.CommandIdCancellationToken)cancellationToken).id())) {
                        pipeFile.delete();
                    }
                }
                catch (IOException e) {
                    JSLanguageServiceQueue.Holder.LOGGER.error("Cannot create file " + pipeFile, (Throwable)e);
                }
                existingCallback.consume(null);
            } else {
                this.myCallbacks.remove(((JSLanguageServiceNodeStdProtocolBase.CommandIdCancellationToken)cancellationToken).id());
            }
        } else {
            super.cancelCommand(cancellationToken);
        }
    }

    private final String getCommandLineArgsFromRegistry() {
        return Registry.Companion.stringValue("typescript.service.node.arguments");
    }

    private final String getNodePathFromRegistry() {
        return Registry.Companion.stringValue("typescript.service.node.path");
    }

    @Override
    protected void registerResponseHandlers(@NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        super.registerResponseHandlers(processHandler);
        processHandler.addProcessListener(this.oomDetector.getProcessListener());
    }

    private static final String prepareTargetRun$lambda$2(LocalFilePath el) {
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        return el.getPath();
    }

    private static final TargetValue prepareTargetRun$lambda$3(NodeTargetRun $targetRun, String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        return $targetRun.path(localPath);
    }

    private static final String prepareTargetRun$lambda$4(Collection targetPaths) {
        return StringUtil.join((Collection)targetPaths, (String)",");
    }

    private static final String prepareTargetRun$lambda$5(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String addNodeProcessAdditionalArguments$lambda$8(String targetPathValue) {
        return "-level verbose -file \"" + targetPathValue + "\"";
    }

    private static final String addNodeProcessAdditionalArguments$lambda$9(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String addNodeProcessAdditionalArguments$lambda$10(KProperty0 $tmp0) {
        return (String)((Function0)$tmp0).invoke();
    }

    private static final String addNodeProcessAdditionalArguments$lambda$11(KProperty0 $tmp0) {
        return (String)((Function0)$tmp0).invoke();
    }

    private static final TypeScriptServiceInitialStateObject addNodeProcessAdditionalArguments$lambda$12(TypeScriptServiceStandardOutputProtocol this$0) {
        return this$0.createState();
    }

    public static final /* synthetic */ String access$getCommandLineArgsFromRegistry(TypeScriptServiceStandardOutputProtocol $this) {
        return $this.getCommandLineArgsFromRegistry();
    }

    public static final /* synthetic */ String access$getNodePathFromRegistry(TypeScriptServiceStandardOutputProtocol $this) {
        return $this.getNodePathFromRegistry();
    }

    static {
        Object[] objectArray = new Macro[]{new UnixSeparatorsMacro(), new ProjectFileDirMacro(), new ProjectNameMacro(), new ProjectPathMacro()};
        PROJECT_LEVEL_MACRO = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol$Companion;", "", "<init>", "()V", "EVENT_TYPE", "", "EVENT_PROPERTY", "REQUEST_COMPLETED", "BODY", "PROJECT_LEVEL_MACRO", "", "Lcom/intellij/ide/macro/Macro;", "CANCELLATION_PIPE_NAME_PREFIX", "registerUploadVolumes", "", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "initialState", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptServiceInitialStateObject;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void registerUploadVolumes(NodeTargetRun targetRun, TypeScriptServiceInitialStateObject initialState2) {
            targetRun.path(initialState2.serverFolderPath.getPath());
            if (initialState2.projectPath != null) {
                LocalFilePath localFilePath = initialState2.projectPath;
                Intrinsics.checkNotNull((Object)localFilePath);
                targetRun.path(localFilePath.getPath());
            }
            if (initialState2.defaultConfig != null) {
                targetRun.path(initialState2.defaultConfig.getPath());
            }
            if (initialState2.packageJson != null) {
                targetRun.path(initialState2.packageJson.getPath());
            }
            String string = PathUtil.getParentPath((String)initialState2.pluginPath.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
            targetRun.path(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol$RemovePipeCallback;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswerConsumer;", "pipeFile", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getPipeFile", "()Ljava/io/File;", "consume", "", "message", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswer;", "intellij.javascript.impl"})
    private static final class RemovePipeCallback
    implements JSLanguageServiceAnswerConsumer {
        @NotNull
        private final File pipeFile;

        public RemovePipeCallback(@NotNull File pipeFile) {
            Intrinsics.checkNotNullParameter((Object)pipeFile, (String)"pipeFile");
            this.pipeFile = pipeFile;
        }

        @NotNull
        public final File getPipeFile() {
            return this.pipeFile;
        }

        @Override
        public void consume(@Nullable JSLanguageServiceAnswer message) {
            if (this.pipeFile.delete()) {
                if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
                    JSLanguageServiceQueue.Holder.LOGGER.trace("Cancellation pipe file deleted: " + this.pipeFile);
                }
            } else if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
                JSLanguageServiceQueue.Holder.LOGGER.trace("Failed to delete pipe file: " + this.pipeFile);
            }
        }
    }
}

