/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.stubs.factories;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlAttributeImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSXmlAttributeStubImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.stub.XmlAttributeStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubElementFactory;
import com.intellij.psi.xml.XmlTokenType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0010\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\tH\u0016J\u0016\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/javascript/stubs/factories/JSXmlAttributeStubFactory;", "Lcom/intellij/psi/stubs/StubElementFactory;", "Lcom/intellij/psi/impl/source/xml/stub/XmlAttributeStub;", "Lcom/intellij/lang/javascript/psi/e4x/impl/JSXmlAttributeImpl;", "<init>", "()V", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "createPsi", "stub", "shouldCreateStub", "", "node", "Lcom/intellij/lang/ASTNode;", "intellij.javascript.psi.impl"})
public final class JSXmlAttributeStubFactory
implements StubElementFactory<XmlAttributeStub<JSXmlAttributeImpl>, JSXmlAttributeImpl> {
    @NotNull
    public XmlAttributeStub<JSXmlAttributeImpl> createStub(@NotNull JSXmlAttributeImpl psi, @Nullable StubElement<? extends PsiElement> parentStub) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        return new JSXmlAttributeStubImpl(psi, parentStub, JSStubElementTypes.XML_ATTRIBUTE);
    }

    @NotNull
    public JSXmlAttributeImpl createPsi(@NotNull XmlAttributeStub<JSXmlAttributeImpl> stub) {
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        JSXmlAttributeImpl jSXmlAttributeImpl = ((JSXmlAttributeStubImpl)stub).createPsi();
        Intrinsics.checkNotNullExpressionValue((Object)jSXmlAttributeImpl, (String)"createPsi(...)");
        return jSXmlAttributeImpl;
    }

    public boolean shouldCreateStub(@NotNull ASTNode node) {
        ASTNode nameAst;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ASTNode treeParent = node.getTreeParent();
        if (treeParent.getElementType() != JSElementTypes.JSX_XML_LITERAL_EXPRESSION) {
            return false;
        }
        ASTNode aSTNode = nameAst = treeParent.findChildByType(XmlTokenType.XML_TAG_NAME);
        return JSXResolveUtil.isComponentName(aSTNode != null ? aSTNode.getText() : null);
    }
}

