/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocCommentVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocDescription;
import com.intellij.lang.javascript.psi.jsdoc.JSDocDescriptionProcessor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagDefinition;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentCachedData;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentCachedDataBuilder;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.stubs.JSDocCommentStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JSDocCommentImpl
extends JSImplicitElementProviderImpl<JSDocCommentStub>
implements JSDocComment {
    @Nullable
    private JSDocCommentCachedData myCachedData;
    private static final Key<ParameterizedCachedValue<PsiReference[], JSDocCommentImpl>> REFERENCES_KEY = Key.create((String)"js.doc.references");
    private static final ParameterizedCachedValueProvider<PsiReference[], JSDocCommentImpl> REFERENCES_PROVIDER = param -> CachedValueProvider.Result.create((Object)ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)param), (Object[])new Object[]{param});

    public JSDocCommentImpl(ASTNode node) {
        super(node);
    }

    public JSDocCommentImpl(JSDocCommentStub stub, IElementType signature) {
        super(stub, signature);
    }

    @NotNull
    public IElementType getTokenType() {
        IElementType iElementType = this.getNode().getElementType();
        if (iElementType == null) {
            JSDocCommentImpl.$$$reportNull$$$0(0);
        }
        return iElementType;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSDocCommentImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDocComment(this);
        } else {
            visitor.visitComment((PsiComment)this);
        }
    }

    @Override
    public JSDocTag @NotNull [] getTags() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild instanceof JSDocComment) {
            JSDocTag[] jSDocTagArray = ((JSDocComment)firstChild).getTags();
            if (jSDocTagArray == null) {
                JSDocCommentImpl.$$$reportNull$$$0(2);
            }
            return jSDocTagArray;
        }
        JSDocTag[] jSDocTagArray = (JSDocTag[])this.findChildrenByType(JSDocTokenTypes.DOC_TAG, JSDocTag.class);
        if (jSDocTagArray == null) {
            JSDocCommentImpl.$$$reportNull$$$0(3);
        }
        return jSDocTagArray;
    }

    @Override
    public @Unmodifiable @NotNull List<JSDocTag> findTags(@NotNull String name) {
        if (name == null) {
            JSDocCommentImpl.$$$reportNull$$$0(4);
        }
        List list = ContainerUtil.filter((Object[])this.getTags(), it -> it.is(name));
        if (list == null) {
            JSDocCommentImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public @Unmodifiable @NotNull List<JSDocTag> findTags(@NotNull JSDocTagDefinition tag) {
        if (tag == null) {
            JSDocCommentImpl.$$$reportNull$$$0(6);
        }
        List list = ContainerUtil.filter((Object[])this.getTags(), it -> it.is(tag));
        if (list == null) {
            JSDocCommentImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @Nullable
    public JSDocDescription getDescription() {
        return (JSDocDescription)this.findChildByClass(JSDocDescription.class);
    }

    @Override
    @NotNull
    public String getDescriptionText(@NotNull JSDocDescriptionProcessor descriptionProcessor) {
        JSDocDescription description;
        if (descriptionProcessor == null) {
            JSDocCommentImpl.$$$reportNull$$$0(8);
        }
        return (description = this.getDescription()) != null ? description.getDescriptionText(descriptionProcessor) : "";
    }

    @Override
    public void acceptChildren(@NotNull JSDocCommentVisitor visitor) {
        JSDocTag[] tags;
        JSDocDescription description;
        if (visitor == null) {
            JSDocCommentImpl.$$$reportNull$$$0(9);
        }
        if ((description = this.getDescription()) != null) {
            visitor.visitDescription(description);
        }
        for (JSDocTag tag : tags = this.getTags()) {
            JSDocBlockTags.visitTag$intellij_javascript_psi_impl(tag, visitor);
        }
        visitor.finishVisiting(tags.length > 0 ? tags[tags.length - 1] : null);
    }

    public PsiElement getOwner() {
        PsiElement associatedElement = JSDocumentationUtils.findAssociatedElement(this);
        return associatedElement != null ? associatedElement : this;
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences());
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, REFERENCES_KEY, REFERENCES_PROVIDER, false, (Object)this);
        if (psiReferenceArray == null) {
            JSDocCommentImpl.$$$reportNull$$$0(10);
        }
        return psiReferenceArray;
    }

    @Override
    @NotNull
    public @NotNull List<Pair<@NotNull String, @Nullable String>> getGenericParameters() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            List<Pair<String, String>> list = stub.getGenericParameters();
            if (list == null) {
                JSDocCommentImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<Pair<String, String>> list = this.getCachedData().getGenericParameters();
        if (list == null) {
            JSDocCommentImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    @Nullable
    public JSAttributeList.AccessType getAccessType() {
        return this.getCachedData().getAccessType();
    }

    @Override
    @Nullable
    public String getExplicitName() {
        JSDocCommentCachedData cachedData = this.getCachedData();
        JSQualifiedName className = cachedData.getClassName();
        return className != null ? className.getName() : cachedData.getExplicitName();
    }

    @Override
    @Nullable
    public JSQualifiedName getNamespace() {
        return this.getCachedData().getNamespace();
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return this.getCachedData().isNamespaceExplicitlyDeclared();
    }

    @Override
    @Nullable
    public String getType() {
        return this.getCachedData().getType();
    }

    @Override
    @Nullable
    public Map<JSQualifiedName, String> getProperties() {
        return this.getCachedData().getProperties();
    }

    @Override
    @NotNull
    public JSContext getJSContext() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                JSDocCommentImpl.$$$reportNull$$$0(13);
            }
            return jSContext;
        }
        JSContext jSContext = this.getCachedData().getContext();
        if (jSContext == null) {
            JSDocCommentImpl.$$$reportNull$$$0(14);
        }
        return jSContext;
    }

    @Override
    public boolean isClassExplicitly() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.isClassExplicitly();
        }
        return this.getCachedData().isClassExplicitly();
    }

    @Override
    public boolean hasInterfaceTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasInterfaceTag();
        }
        return this.getCachedData().isInterface();
    }

    @Override
    public boolean hasDeprecatedTag() {
        return this.getCachedData().hasDeprecatedTag();
    }

    @Override
    @Nullable
    public String getDeprecationMessage() {
        return this.getCachedData().getDeprecationMessage();
    }

    @Override
    @Nullable
    public String getSinceMessage() {
        return this.getCachedData().getSinceMessage();
    }

    @Override
    public boolean hasConstructsTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasConstructsTag();
        }
        return this.getCachedData().hasConstructsTag();
    }

    @Override
    public boolean hasConstructorLikeTag() {
        return this.getCachedData().hasConstructorLikeTag();
    }

    @Override
    @NotNull
    public JSDocComment.BrowserFamily getBrowserFamily() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            JSDocComment.BrowserFamily browserFamily = stub.getBrowserFamily();
            if (browserFamily == null) {
                JSDocCommentImpl.$$$reportNull$$$0(15);
            }
            return browserFamily;
        }
        JSDocComment.BrowserFamily browserFamily = this.getCachedData().getBrowserFamily();
        if (browserFamily == null) {
            JSDocCommentImpl.$$$reportNull$$$0(16);
        }
        return browserFamily;
    }

    @Override
    public boolean hasNamespaceTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasNamespaceTag();
        }
        return this.getCachedData().hasNamespaceTag();
    }

    @Override
    public boolean hasAbstractTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasAbstractTag();
        }
        return this.getCachedData().hasAbstractTag();
    }

    @Override
    @Nullable
    public String getDefaultValue(@NotNull JSQualifiedName parameterName) {
        if (parameterName == null) {
            JSDocCommentImpl.$$$reportNull$$$0(17);
        }
        return this.getCachedData().getDefaultValue(parameterName);
    }

    @Override
    @Nullable
    public JSElementIndexingData calculateIndexingData() {
        if (DialectDetector.isTypeScript((PsiElement)this) && ContainerUtil.find((Object[])this.getTags(), t -> "typedef".equals(t.getName())) == null) {
            return this.processHandlers(null);
        }
        JSDocCommentCachedData cachedData = this.getCachedData();
        JSElementIndexingDataImpl indexingData = new JSElementIndexingDataImpl();
        @Nullable PsiElement attachedElement = JSDocumentationUtils.findAttachedElementFromComment(this);
        JSNamespace providedNs = attachedElement instanceof JSElementBase ? JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)attachedElement, true) : null;
        providedNs = providedNs != null ? providedNs.copyWithTypeContext(JSTypeContext.UNKNOWN) : null;
        this.addTypedefs(cachedData, indexingData);
        providedNs = this.processClassName(cachedData, indexingData, attachedElement, providedNs);
        providedNs = this.processExplicitNameAndNamespace(cachedData, indexingData, attachedElement, providedNs);
        this.addBaseTypes(cachedData, indexingData, providedNs);
        this.addEnumType(cachedData, indexingData, providedNs);
        this.addProperties(cachedData, indexingData, providedNs);
        return this.processHandlers(indexingData);
    }

    @Nullable
    private JSNamespace processClassName(@NotNull JSDocCommentCachedData cachedData, @NotNull JSElementIndexingDataImpl indexingData, @Nullable PsiElement attachedElement, @Nullable JSNamespace providedNs) {
        boolean addClassFromComment;
        JSQualifiedName className;
        if (cachedData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(18);
        }
        if (indexingData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(19);
        }
        if ((className = cachedData.getClassName()) == null) {
            return providedNs;
        }
        String classNameTag = className.getQualifiedName();
        boolean classNameIsMorePrecise = providedNs == null || providedNs.getQualifiedName() == null || !providedNs.getQualifiedName().getQualifiedName().endsWith(classNameTag);
        boolean bl = addClassFromComment = attachedElement == null || classNameIsMorePrecise;
        if (classNameIsMorePrecise) {
            providedNs = JSNamedTypeFactory.createNamespace(className, JSContext.INSTANCE, null, true);
        }
        JSQualifiedName providedNsQName = providedNs.getQualifiedName();
        if (addClassFromComment || providedNsQName != null) {
            SmartList elements = indexingData.getImplicitElements();
            if (elements == null) {
                elements = new SmartList();
                indexingData.setImplicitElements((Collection<JSImplicitElement>)elements);
            }
            if (addClassFromComment && providedNsQName != null) {
                JSImplicitElementImpl.Builder builder2 = new JSImplicitElementImpl.Builder(providedNsQName, (PsiElement)this).setType(JSImplicitElement.Type.Class).setProperties(JSImplicitElement.Property.MinorImportance);
                indexingData.addImplicitElement(new JSImplicitElementImpl(builder2));
            }
            JSStubIndexingUtils.addImplicitNamespaces(providedNsQName != null ? providedNsQName.getParent() : null, (Collection<? super JSImplicitElement>)elements, (PsiElement)this);
        }
        return providedNs;
    }

    @Nullable
    private JSNamespace processExplicitNameAndNamespace(@NotNull JSDocCommentCachedData cachedData, @NotNull JSElementIndexingDataImpl indexingData, @Nullable PsiElement attachedElement, @Nullable JSNamespace providedNs) {
        JSQualifiedName qName;
        if (cachedData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(20);
        }
        if (indexingData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(21);
        }
        String nameFromDoc = cachedData.getExplicitName();
        JSQualifiedName nsFromDoc = cachedData.getNamespace();
        if (!(nameFromDoc != null || attachedElement instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpression((JSReferenceExpression)attachedElement))) {
            return providedNs;
        }
        if (nameFromDoc == null) {
            JSQualifiedName nameFromReference = (JSQualifiedName)ObjectUtils.coalesce((Object)JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)attachedElement)), (Object)JSQualifiedNameImpl.EMPTY);
            providedNs = JSNamedTypeFactory.createNamespace(nameFromReference, JSContext.STATIC, null, true);
        } else {
            JSNamespace evaluated = nsFromDoc == null && attachedElement instanceof JSExpression && !(attachedElement instanceof JSReferenceExpression) ? JSSymbolUtil.evaluateNamespaceLocally((JSExpression)attachedElement) : null;
            providedNs = evaluated != null ? evaluated : JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.create(nameFromDoc, nsFromDoc), JSContext.UNKNOWN, null, true);
        }
        JSImplicitElement.Type elementType = JSDocCommentImpl.getImplicitElementType(cachedData);
        if (attachedElement instanceof JSReferenceExpression) {
            attachedElement = attachedElement.getParent();
        }
        if (!((qName = providedNs.getQualifiedName()) == null || attachedElement instanceof JSNamedElement && qName.getName().equals(((JSNamedElement)attachedElement).getName()) || JSDocCommentImpl.isPredefinedIncorrectJSDocElement(qName.getName(), qName.getParent()))) {
            JSImplicitElement implicitElement = this.buildImplicitElement(qName.getName(), qName.getParent(), elementType);
            indexingData.addImplicitElement(implicitElement);
        }
        if (!cachedData.seemsToBeFunction() && elementType == JSImplicitElement.Type.Namespace) {
            SmartList elements = indexingData.getImplicitElements();
            if (elements == null) {
                elements = new SmartList();
                indexingData.setImplicitElements((Collection<JSImplicitElement>)elements);
            }
            JSStubIndexingUtils.addImplicitNamespaces(providedNs.getQualifiedName(), (Collection<? super JSImplicitElement>)elements, (PsiElement)this);
        }
        return providedNs;
    }

    private void addProperties(@NotNull JSDocCommentCachedData cachedData, @NotNull JSElementIndexingDataImpl indexingData, @Nullable JSNamespace providedNs) {
        JSRecordType mergedParametersType;
        Object propertiesType;
        if (cachedData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(22);
        }
        if (indexingData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(23);
        }
        JSQualifiedName qualifiedName = providedNs != null ? providedNs.getQualifiedName() : null;
        Map<JSQualifiedName, String> properties2 = cachedData.getProperties();
        if (!(properties2 == null || properties2.size() == 1 && qualifiedName != null && qualifiedName.getName().equals(((JSQualifiedName)ContainerUtil.getFirstItem(properties2.keySet())).getName()) || (propertiesType = JSTypeUtils.buildRecordTypeFromProperties(this.getProject(), properties2, cachedData.getOptionals(), JSTypeSource.EMPTY)) == null)) {
            Collection<JSImplicitElement> elements = JSDocCommentImpl.getImplicitMembersFromRecordType((JSRecordType)propertiesType, providedNs, (PsiElement)this);
            indexingData.addImplicitElements(elements);
        }
        if (providedNs != null) {
            this.processRecordType(indexingData, cachedData.getType(), providedNs);
        }
        for (Pair<String, String> typedef : cachedData.getTypedefs()) {
            String elementName;
            String typedefName = (String)typedef.first;
            JSQualifiedName providedQName = providedNs != null ? providedNs.getQualifiedName() : null;
            String string = elementName = providedQName != null ? providedQName.getName() : null;
            if (typedefName == null || typedefName.equals(elementName)) continue;
            JSQualifiedNameImpl typedefQName = JSQualifiedNameImpl.fromNamepath(typedefName);
            JSImplicitElementImpl.Builder builder2 = new JSImplicitElementImpl.Builder(typedefQName, (PsiElement)this).setType(JSImplicitElement.Type.Interface);
            indexingData.addImplicitElement(builder2.toImplicitElement());
            this.processRecordType(indexingData, (String)typedef.second, JSNamedTypeFactory.createNamespace(typedefQName, JSContext.UNKNOWN, null));
        }
        List<Pair<JSQualifiedName, String>> parameters2 = cachedData.getParametersWithOptions();
        if (parameters2 != null && (mergedParametersType = JSTypeUtils.buildRecordTypeFromQualifiedNames(this.getProject(), parameters2, Collections.emptySet(), JSTypeSource.EMPTY)) != null) {
            for (JSRecordType.TypeMember member : mergedParametersType.getTypeMembers()) {
                Collection<JSImplicitElement> members;
                JSType type2;
                if (!(member instanceof JSRecordType.PropertySignature) || !((type2 = ((JSRecordType.PropertySignature)member).getJSType()) instanceof JSRecordType) || (members = JSDocCommentImpl.getImplicitMembersFromRecordType((JSRecordType)type2, null, (PsiElement)this)).isEmpty()) continue;
                indexingData.addImplicitElements(members);
            }
        }
    }

    private void addEnumType(@NotNull JSDocCommentCachedData cachedData, @NotNull JSElementIndexingDataImpl indexingData, @Nullable JSNamespace providedNs) {
        JSType parse;
        JSQualifiedName providedQName;
        String enumType;
        if (cachedData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(24);
        }
        if (indexingData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(25);
        }
        if ((enumType = cachedData.getEnumType()) != null && providedNs != null && (providedQName = providedNs.getQualifiedName()) != null && ((parse = new JSTypeParser(this.getProject(), enumType, JSTypeSource.EMPTY).parse()) instanceof JSTypeImpl || parse instanceof JSSpecialNamedTypeImpl)) {
            indexingData.addBaseType(providedQName.getQualifiedName(), parse.getTypeText(JSType.TypeTextFormat.SIMPLE));
        }
    }

    private void addTypedefs(@NotNull JSDocCommentCachedData cachedData, @NotNull JSElementIndexingDataImpl indexingData) {
        if (cachedData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(26);
        }
        if (indexingData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(27);
        }
        for (Pair<String, String> typedef : cachedData.getTypedefs()) {
            if (typedef.second == null) continue;
            String name = (String)typedef.first;
            if (name == null) {
                name = this.findNameOfClassAppliedTo();
            }
            if (name == null) continue;
            indexingData.addTypedef(name, (String)typedef.second);
        }
    }

    private void addBaseTypes(@NotNull JSDocCommentCachedData cachedData, @NotNull JSElementIndexingDataImpl indexingData, @Nullable JSNamespace providedNs) {
        if (cachedData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(28);
        }
        if (indexingData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(29);
        }
        Collection<String> baseTypes = cachedData.getBaseTypes();
        Collection<String> staticBaseTypes = cachedData.getStaticBaseTypes();
        if (baseTypes.isEmpty() && staticBaseTypes.isEmpty()) {
            return;
        }
        JSQualifiedName currentName = null;
        if (cachedData.hasConstructsTag()) {
            String explicitName;
            PsiComment parentComment;
            JSObjectLiteralExpression parent = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)this, JSObjectLiteralExpression.class);
            if (parent != null && (parentComment = JSDocumentationUtils.findDocComment((PsiElement)parent)) instanceof JSDocComment && (explicitName = ((JSDocComment)parentComment).getExplicitName()) != null) {
                currentName = JSQualifiedNameImpl.create(explicitName, ((JSDocComment)parentComment).getNamespace());
            }
        } else if (providedNs != null) {
            currentName = providedNs.getQualifiedName();
        }
        if (currentName != null) {
            for (String baseType : baseTypes) {
                indexingData.addBaseType(JSBaseTypesIndex.serializeHierarchyElement(currentName, JSContext.INSTANCE), baseType);
            }
            for (String staticBaseType : staticBaseTypes) {
                indexingData.addBaseType(JSBaseTypesIndex.serializeHierarchyElement(currentName, JSContext.STATIC), staticBaseType);
            }
        }
    }

    private static boolean isPredefinedIncorrectJSDocElement(String name, JSQualifiedName namespace) {
        return "_".equals(name) && namespace == null;
    }

    private JSElementIndexingData processHandlers(@Nullable JSElementIndexingDataImpl indexingData) {
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions((PsiElement)this)) {
            indexingData = (JSElementIndexingDataImpl)handler.processJSDocComment(this, indexingData);
        }
        return indexingData == null || indexingData.isEmpty() ? null : indexingData;
    }

    @Nullable
    public JSImplicitElement buildImplicitElement(@NotNull String name) {
        if (name == null) {
            JSDocCommentImpl.$$$reportNull$$$0(30);
        }
        JSDocCommentCachedData cachedData = this.getCachedData();
        JSImplicitElement.Type elementType = JSDocCommentImpl.getImplicitElementType(cachedData);
        return this.buildImplicitElement(name, cachedData.getNamespace(), elementType);
    }

    @NotNull
    private static JSImplicitElement.Type getImplicitElementType(@NotNull JSDocCommentCachedData cachedData) {
        if (cachedData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(31);
        }
        JSImplicitElement.Type type2 = cachedData.isInterface() ? JSImplicitElement.Type.Interface : (cachedData.isClassExplicitly() ? JSImplicitElement.Type.Class : (cachedData.hasNamespaceTag() ? JSImplicitElement.Type.Namespace : (cachedData.isMember() ? (cachedData.seemsToBeFunction() ? JSImplicitElement.Type.Method : JSImplicitElement.Type.Property) : (cachedData.seemsToBeFunction() ? JSImplicitElement.Type.Function : JSImplicitElement.Type.Variable))));
        if (type2 == null) {
            JSDocCommentImpl.$$$reportNull$$$0(32);
        }
        return type2;
    }

    @NotNull
    private JSImplicitElement buildImplicitElement(@NotNull String name, @Nullable JSQualifiedName namespace, @NotNull JSImplicitElement.Type elementType) {
        if (name == null) {
            JSDocCommentImpl.$$$reportNull$$$0(33);
        }
        if (elementType == null) {
            JSDocCommentImpl.$$$reportNull$$$0(34);
        }
        JSDocCommentCachedData cachedData = this.getCachedData();
        JSImplicitElementImpl.Builder builder2 = new JSImplicitElementImpl.Builder(name, (PsiElement)this).setNamespace(JSNamedTypeFactory.createNamespace(namespace, JSTypeSourceFactory.empty(JSTypeSource.SourceLanguage.JS, true), JSTypeContext.fromJSContext(cachedData.getContext(), false), false));
        if (namespace == null && cachedData.isMember() && JSUseScopeProvider.getLexicalScope((PsiElement)this) != null) {
            builder2.setNamespaceExplicitlyDeclared(false);
        }
        if (cachedData.getAccessType() != null) {
            builder2.setAccessType(cachedData.getAccessType());
        }
        if (cachedData.seemsToBeFunction()) {
            builder2.setType(JSImplicitElement.Type.Function).setJSType(JSTypeParser.createTypeFromJSDoc(this.getProject(), cachedData.getReturnType(), JSTypeSource.EMPTY));
            List<Pair<String, String>> preparedParameters = cachedData.getParameters();
            if (preparedParameters != null) {
                ArrayList<JSImplicitParameterStructure> parameters2 = new ArrayList<JSImplicitParameterStructure>();
                for (Pair<String, String> pair : preparedParameters) {
                    JSType type2;
                    JSParameterTypeDecorator decorator = JSTypeParser.createParameterType(this.getProject(), (String)pair.second, JSTypeSource.EXPLICITLY_DECLARED);
                    if (decorator == null) {
                        decorator = JSParameterTypeDecoratorImpl.EMPTY;
                    }
                    String typeText = (type2 = decorator.getSimpleType()) != null ? type2.getTypeText(JSType.TypeTextFormat.SIMPLE) : null;
                    JSImplicitParameterStructure structure = new JSImplicitParameterStructure((String)pair.first, typeText, decorator.isOptional(), decorator.isRest(), true);
                    parameters2.add(structure);
                }
                builder2.setParameters(parameters2);
            }
        } else {
            builder2.setType(elementType).setJSType(JSTypeParser.createTypeFromJSDoc(this.getProject(), cachedData.getType(), JSTypeSource.EMPTY));
        }
        JSImplicitElementImpl jSImplicitElementImpl = builder2.toImplicitElement();
        if (jSImplicitElementImpl == null) {
            JSDocCommentImpl.$$$reportNull$$$0(35);
        }
        return jSImplicitElementImpl;
    }

    private void processRecordType(@NotNull JSElementIndexingDataImpl data2, @Nullable String typeName, @NotNull JSNamespace namespace) {
        Collection<JSImplicitElement> members;
        JSType extendingType;
        JSType type2;
        if (data2 == null) {
            JSDocCommentImpl.$$$reportNull$$$0(36);
        }
        if (namespace == null) {
            JSDocCommentImpl.$$$reportNull$$$0(37);
        }
        if ((type2 = JSTypeParser.createType(this.getProject(), typeName, JSTypeSource.EMPTY)) != null && (extendingType = JSTypeUtils.getExtendingType(type2)) != null) {
            type2 = extendingType;
        }
        if (type2 instanceof JSRecordType && !(members = JSDocCommentImpl.getImplicitMembersFromRecordType((JSRecordType)type2, namespace, (PsiElement)this)).isEmpty()) {
            data2.addImplicitElements(members);
        }
    }

    @NotNull
    private static Collection<JSImplicitElement> getImplicitMembersFromRecordType(@NotNull JSRecordType type2, @Nullable JSNamespace namespace, @Nullable PsiElement parent) {
        if (type2 == null) {
            JSDocCommentImpl.$$$reportNull$$$0(38);
        }
        SmartList elements = new SmartList();
        for (JSRecordType.TypeMember member : type2.getTypeMembers()) {
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            String name = ((JSRecordType.PropertySignature)member).getMemberName();
            JSImplicitElementImpl.Builder builder2 = new JSImplicitElementImpl.Builder(name, parent).setProperties(JSImplicitElement.Property.MinorImportance).setType(JSImplicitElement.Type.Property).setNamespaceExplicitlyDeclared(namespace != null);
            builder2.setNamespace(namespace != null ? namespace : JSAnyType.get(parent));
            JSType jsType = ((JSRecordType.PropertySignature)member).getJSType();
            if (jsType instanceof JSRecordType) {
                JSNamespace childNs = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.create(name, namespace != null ? namespace.getQualifiedName() : null), JSContext.UNKNOWN, null, true);
                Collection<JSImplicitElement> childElements = JSDocCommentImpl.getImplicitMembersFromRecordType((JSRecordType)jsType, childNs, parent);
                elements.addAll(childElements);
            }
            if (jsType != null) {
                builder2.setJSType(jsType);
            }
            JSImplicitElementImpl element2 = new JSImplicitElementImpl(builder2);
            elements.add((Object)element2);
        }
        SmartList smartList = elements;
        if (smartList == null) {
            JSDocCommentImpl.$$$reportNull$$$0(39);
        }
        return smartList;
    }

    public static boolean shouldCreateStub(ASTNode node) {
        return true;
    }

    private JSDocCommentCachedData calculateCachedData(ASTNode node) {
        JSDocCommentCachedData cachedData = new JSDocCommentCachedData();
        JSDocumentationUtils.processDocumentationTextFromComment((PsiElement)this, node, new JSDocCommentCachedDataBuilder(cachedData));
        return cachedData;
    }

    @NotNull
    public JSDocCommentCachedData getCachedData() {
        JSDocCommentCachedData cachedData = this.myCachedData;
        if (cachedData != null) {
            JSDocCommentCachedData jSDocCommentCachedData = cachedData;
            if (jSDocCommentCachedData == null) {
                JSDocCommentImpl.$$$reportNull$$$0(40);
            }
            return jSDocCommentCachedData;
        }
        cachedData = this.calculateCachedData(this.getNode());
        List<Pair<String, String>> typedefs = cachedData.getTypedefs();
        for (int i = 0; i < typedefs.size(); ++i) {
            Pair<String, String> typedef = typedefs.get(i);
            String typedefName = (String)typedef.first;
            String typedefType = (String)typedef.second;
            Map<JSQualifiedName, String> properties2 = cachedData.getProperties();
            HashMap<String, String> genericParameters = new HashMap<String, String>();
            for (Pair<String, String> pair : cachedData.getGenericParameters()) {
                genericParameters.put((String)pair.getFirst(), (String)pair.getSecond());
            }
            if (properties2 != null && !properties2.isEmpty()) {
                JSType newType = JSTypeUtils.buildRecordTypeFromProperties(this.getProject(), properties2, cachedData.getOptionals(), JSTypeSource.EMPTY);
                assert (newType != null);
                JSType typedefJSType = JSTypeParser.createTypeFromJSDoc(this.getProject(), typedefType, JSTypeSource.EMPTY);
                if (!(typedefJSType instanceof JSObjectType) && typedefJSType != null) {
                    newType = JSTypeUtils.createExtendsType(newType, typedefJSType);
                }
                newType = JSTypeUtils.addJSGenericParameters(this.getProject(), newType, genericParameters);
                typedefType = JSTypeUtils.serializeType(newType);
                cachedData.clearProperties();
            } else if (cachedData.seemsToBeFunction() && typedefs.size() == 1) {
                SmartList decorators = new SmartList();
                List preparedParameters = (List)ObjectUtils.coalesce(cachedData.getParameters(), Collections.emptyList());
                for (Pair pair : preparedParameters) {
                    JSParameterTypeDecorator decorator = JSTypeParser.createParameterType(this.getProject(), (String)pair.second, JSTypeSource.EXPLICITLY_DECLARED);
                    if (decorator != null && !genericParameters.isEmpty()) {
                        decorator = new JSParameterTypeDecoratorImpl(JSTypeUtils.addJSGenericParameters(this.getProject(), decorator.getSimpleType(), genericParameters), decorator.isOptional(), decorator.isRest(), decorator.isExplicitlyDeclared());
                    }
                    if (decorator == null) {
                        decorator = JSParameterTypeDecoratorImpl.EMPTY;
                    }
                    if (pair.first != null) {
                        decorator = JSParameterTypeDecoratorImpl.withName(decorator, (String)pair.first);
                    }
                    decorators.add(decorator);
                }
                JSType returnType2 = JSTypeParser.createType(this.getProject(), cachedData.getReturnType(), JSTypeSource.EMPTY);
                returnType2 = JSTypeUtils.addJSGenericParameters(this.getProject(), returnType2, genericParameters);
                if (!decorators.isEmpty() || returnType2 != null) {
                    JSFunctionTypeImpl functionType = new JSFunctionTypeImpl(JSTypeSource.EMPTY, (List<? extends JSParameterTypeDecorator>)decorators, returnType2);
                    typedefType = JSTypeUtils.serializeType(functionType);
                }
            }
            typedefs.set(i, (Pair<String, String>)Pair.create((Object)typedefName, (Object)(typedefType != null ? typedefType : "*")));
        }
        this.myCachedData = cachedData;
        JSDocCommentCachedData jSDocCommentCachedData = cachedData;
        if (jSDocCommentCachedData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(41);
        }
        return jSDocCommentCachedData;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedData = null;
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String newText) {
        ASTNode newTree;
        if (newText == null) {
            JSDocCommentImpl.$$$reportNull$$$0(42);
        }
        return (newTree = JSChangeUtil.createJSTreeFromText(this.getProject(), newText)).getElementType() == JSStubElementTypes.DOC_COMMENT ? (JSDocComment)newTree.getPsi() : this;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        LiteralTextEscaper literalTextEscaper = LiteralTextEscaper.createSimple((PsiLanguageInjectionHost)this);
        if (literalTextEscaper == null) {
            JSDocCommentImpl.$$$reportNull$$$0(43);
        }
        return literalTextEscaper;
    }

    @Override
    @Nullable
    public String getThisType() {
        return this.getCachedData().getThisType();
    }

    @Override
    public boolean hasConstTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasConstTag();
        }
        return this.getCachedData().hasConstTag();
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getTypedefs() {
        List<Pair<String, String>> list = this.getCachedData().getTypedefs();
        if (list == null) {
            JSDocCommentImpl.$$$reportNull$$$0(44);
        }
        return list;
    }

    @Override
    @Nullable
    public String getEnumType() {
        return this.getCachedData().getEnumType();
    }

    @Override
    @Nullable
    public String findNameOfClassAppliedTo() {
        return this.findNameOfClassAppliedTo(this.getCachedData());
    }

    @Nullable
    private String findNameOfClassAppliedTo(@NotNull JSDocCommentCachedData cachedData) {
        PsiElement namedElement;
        JSQualifiedName qName;
        if (cachedData == null) {
            JSDocCommentImpl.$$$reportNull$$$0(45);
        }
        if ((qName = cachedData.getClassName()) == null) {
            String explicitName = cachedData.getExplicitName();
            JSQualifiedName jSQualifiedName = qName = explicitName != null ? JSQualifiedNameImpl.create(explicitName, cachedData.getNamespace()) : null;
        }
        if ((namedElement = JSDocumentationUtils.findAttachedElementFromComment(this)) instanceof JSFunction && ((JSFunction)namedElement).isConstructor() && namedElement.getContext() instanceof JSClass) {
            namedElement = namedElement.getContext();
        }
        String codeName = JSDocumentationUtils.getQualifiedNameFromPsi(namedElement);
        return qName == null || codeName != null && codeName.endsWith(qName.getQualifiedName()) ? codeName : JSQualifiedNameImpl.toString(qName);
    }

    @Override
    @Nullable
    public String getReturnType() {
        return this.getCachedData().getReturnType();
    }

    @Override
    public boolean hasInstanceTag() {
        return this.getCachedData().hasInstanceTag();
    }

    @Override
    @Nullable
    public String getAlias() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getGreenStub();
        if (stub != null) {
            return stub.getAlias();
        }
        return this.getCachedData().getAlias();
    }

    @Override
    @Nullable
    public String getLendsTagValue() {
        return this.getCachedData().getLendsTagValue();
    }

    @Override
    @Nullable
    public List<Pair<JSQualifiedName, String>> getParametersWithOptions() {
        return this.getCachedData().getParametersWithOptions();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 6, 8, 9, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33, 34, 36, 37, 38, 42, 45 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionProcessor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedData";
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingData";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenType";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findTags";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericParameters";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowserFamily";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitElementType";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "buildImplicitElement";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitMembersFromRecordType";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedData";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralTextEscaper";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedefs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTags";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processClassName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processExplicitNameAndNamespace";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addProperties";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addEnumType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addTypedefs";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addBaseTypes";
                break;
            }
            case 30: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "buildImplicitElement";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitElementType";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processRecordType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitMembersFromRecordType";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findNameOfClassAppliedTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 6, 8, 9, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33, 34, 36, 37, 38, 42, 45 -> new IllegalArgumentException(string);
        };
    }
}

