/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.text.SemVer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeInterpreterUtil {
    private NodeInterpreterUtil() {
    }

    @Contract(value="null -> !null")
    @InspectionMessage
    public static String validateAndGetErrorMessage(@Nullable NodeJsInterpreter interpreter2) {
        return NodeInterpreterUtil.validateAndGetErrorMessage(interpreter2, null);
    }

    @Contract(value="null,_ -> !null")
    @InspectionMessage
    private static String validateAndGetErrorMessage(@Nullable NodeJsInterpreter interpreter2, @Nullable Project project) {
        if (interpreter2 == null) {
            return JavaScriptBundle.message("node.interpreter.unspecified.error.text", new Object[0]);
        }
        return interpreter2.validate(project);
    }

    public static void checkForRunConfiguration(@Nullable NodeJsInterpreter interpreter2) throws RuntimeConfigurationError {
        NodeInterpreterUtil.checkForRunConfiguration(interpreter2, null);
    }

    public static void checkForRunConfiguration(@Nullable NodeJsInterpreter interpreter2, @Nullable Project project) throws RuntimeConfigurationError {
        String errorMessage = NodeInterpreterUtil.validateAndGetErrorMessage(interpreter2, project);
        if (errorMessage != null) {
            throw new RuntimeConfigurationError(errorMessage);
        }
    }

    @Deprecated
    @NotNull
    public static String convertLocalPathToRemote(@NotNull String path2, @Nullable NodeJsInterpreter interpreter2) {
        if (path2 == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(0);
        }
        if (interpreter2 instanceof WslNodeInterpreter) {
            WSLDistribution distribution = ((WslNodeInterpreter)interpreter2).getDistribution();
            String wslPath = distribution.getWslPath(path2);
            if (wslPath != null) {
                String string = wslPath;
                if (string == null) {
                    NodeInterpreterUtil.$$$reportNull$$$0(1);
                }
                return string;
            }
            String uncPathToWsl = WslCommandLineConfigurator.convertUncPathToWsl(path2, distribution);
            if (uncPathToWsl != null) {
                String string = uncPathToWsl;
                if (string == null) {
                    NodeInterpreterUtil.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (!path2.startsWith("\\\\")) {
                String string = FileUtil.toSystemIndependentName((String)path2);
                if (string == null) {
                    NodeInterpreterUtil.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        String string = path2;
        if (string == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static String toSystemDependentNameAndTrim(@Nullable String path2) {
        return StringUtil.nullize((String)StringUtil.notNullize((String)PathUtil.toSystemDependentName((String)path2)).trim());
    }

    @NotNull
    public static NodeJsInterpreter getValidInterpreterOrThrow(@Nullable NodeJsInterpreter interpreter2) throws ExecutionException {
        String error = NodeInterpreterUtil.validateAndGetErrorMessage(interpreter2);
        if (error != null) {
            throw new InvalidNodeInterpreter(error);
        }
        NodeJsInterpreter nodeJsInterpreter = interpreter2;
        if (nodeJsInterpreter == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(5);
        }
        return nodeJsInterpreter;
    }

    @NotNull
    public static String toRemoteName(@NotNull String path2, @NotNull NodeTargetRun targetRun) {
        Platform target2;
        if (path2 == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(6);
        }
        if (targetRun == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(7);
        }
        if ((target2 = targetRun.getRequest().getTargetPlatform().getPlatform()) == Platform.UNIX && Platform.current() == Platform.WINDOWS) {
            String string = FileUtil.toSystemIndependentName((String)path2);
            if (string == null) {
                NodeInterpreterUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = path2;
        if (string == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static boolean supportsNodeOptions(@Nullable NodeJsInterpreter interpreter2, @Nullable SemVer nodeVersion) {
        NodeJsLocalInterpreter localInterpreter = (NodeJsLocalInterpreter)ObjectUtils.tryCast((Object)interpreter2, NodeJsLocalInterpreter.class);
        if (localInterpreter != null && localInterpreter.isElectron()) {
            return true;
        }
        return nodeVersion == null || nodeVersion.isGreaterOrEqualThan(8, 0, 0);
    }

    public static boolean checkPermissionsToFetchNodeVersionSilently(@NotNull Project project) {
        if (project == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(10);
        }
        if (!TrustedProjects.isProjectTrusted((Project)project)) {
            Logger.getInstance(NodeInterpreterUtil.class).info("Skipped fetching node version silently in the untrusted project");
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeInterpreterUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeInterpreterUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLocalPathToRemote";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidInterpreterOrThrow";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toRemoteName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertLocalPathToRemote";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toRemoteName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkPermissionsToFetchNodeVersionSilently";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 8, 9 -> new IllegalStateException(string);
        };
    }

    public static class InvalidNodeInterpreter
    extends ExecutionException {
        public InvalidNodeInterpreter(@NlsContexts.DialogMessage String message) {
            super(message);
        }
    }
}

