/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.codeInsight.documentation;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.FakePsiElement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.codeInsight.documentation.VueItemDocumentation;
import org.jetbrains.vuejs.codeInsight.refs.VueExprReferenceExpressionResolver;
import org.jetbrains.vuejs.lang.expr.psi.VueJSFilterReferenceExpression;
import org.jetbrains.vuejs.model.VueFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J$\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J,\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J#\u0010\u0014\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J(\u0010\u0015\u001a\u0004\u0018\u00010\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J(\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b\u0018\u00010\u001b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001cH\u0003\u00a8\u0006 "}, d2={"Lorg/jetbrains/vuejs/codeInsight/documentation/VueDocumentationProvider;", "Lcom/intellij/lang/documentation/DocumentationProvider;", "<init>", "()V", "getQuickNavigateInfo", "", "Lorg/jetbrains/annotations/Nls;", "element", "Lcom/intellij/psi/PsiElement;", "originalElement", "getUrlFor", "", "getCustomDocumentationElement", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "contextElement", "targetOffset", "", "generateDoc", "getDocumentationElementForLookupItem", "psiManager", "Lcom/intellij/psi/PsiManager;", "object", "", "getVueDocumentedItem", "Lkotlin/Pair;", "Lorg/jetbrains/vuejs/codeInsight/documentation/VueItemDocumentation;", "offset", "item", "PsiWrappedVueDocumentedItem", "intellij.vuejs"})
@SourceDebugExtension(value={"SMAP\nVueDocumentationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueDocumentationProvider.kt\norg/jetbrains/vuejs/codeInsight/documentation/VueDocumentationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1#2:104\n19#3:105\n19#3:106\n1869#4,2:107\n*S KotlinDebug\n*F\n+ 1 VueDocumentationProvider.kt\norg/jetbrains/vuejs/codeInsight/documentation/VueDocumentationProvider\n*L\n42#1:105\n44#1:106\n83#1:107,2\n*E\n"})
public final class VueDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        return null;
    }

    @Nullable
    public List<String> getUrlFor(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        Object object;
        block4: {
            block2: {
                block3: {
                    PsiWrappedVueDocumentedItem psiWrappedVueDocumentedItem = element instanceof PsiWrappedVueDocumentedItem ? (PsiWrappedVueDocumentedItem)element : null;
                    if (psiWrappedVueDocumentedItem == null) break block2;
                    PsiWrappedVueDocumentedItem it = psiWrappedVueDocumentedItem;
                    boolean bl = false;
                    object = it.getItem().getDocUrl();
                    if (object == null) break block3;
                    String url = object;
                    boolean bl2 = false;
                    Object[] objectArray = new String[]{url};
                    List list = CollectionsKt.mutableListOf((Object[])objectArray);
                    object = list;
                    if (list != null) break block4;
                }
                object = new ArrayList();
                break block4;
            }
            object = null;
        }
        return object;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        PsiWrappedVueDocumentedItem psiWrappedVueDocumentedItem;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Pair<VueItemDocumentation, PsiElement> pair = this.getVueDocumentedItem(contextElement, targetOffset);
        if (pair != null) {
            Pair<VueItemDocumentation, PsiElement> it = pair;
            boolean bl = false;
            psiWrappedVueDocumentedItem = new PsiWrappedVueDocumentedItem((VueItemDocumentation)it.getFirst(), (PsiElement)it.getSecond());
        } else {
            psiWrappedVueDocumentedItem = null;
        }
        return (PsiElement)psiWrappedVueDocumentedItem;
    }

    @Nullable
    public String generateDoc(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        String string;
        PsiWrappedVueDocumentedItem psiWrappedVueDocumentedItem;
        PsiWrappedVueDocumentedItem psiWrappedVueDocumentedItem2 = psiWrappedVueDocumentedItem = element instanceof PsiWrappedVueDocumentedItem ? (PsiWrappedVueDocumentedItem)element : null;
        if (psiWrappedVueDocumentedItem != null) {
            PsiWrappedVueDocumentedItem it = psiWrappedVueDocumentedItem;
            boolean bl = false;
            string = this.generateDoc(it.getItem());
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public PsiElement getDocumentationElementForLookupItem(@Nullable PsiManager psiManager, @Nullable Object object, @Nullable PsiElement element) {
        void $this$asSafely$iv;
        Pair pair;
        if (object == null) return null;
        Object $this$asSafely$iv2 = object;
        boolean $i$f$asSafely22 = false;
        Object object2 = $this$asSafely$iv2;
        if (!(object2 instanceof Pair)) {
            object2 = null;
        }
        if ((pair = (Pair)object2) == null) return null;
        Object object3 = pair.getFirst();
        if (object3 == null) return null;
        Object $i$f$asSafely22 = object3;
        boolean $i$f$asSafely = false;
        Object v1 = $this$asSafely$iv;
        if (!(v1 instanceof VueItemDocumentation)) {
            v1 = null;
        }
        VueItemDocumentation vueItemDocumentation = v1;
        VueItemDocumentation documentationItem = vueItemDocumentation;
        if (documentationItem == null) return null;
        if (element == null) return null;
        return (PsiElement)new PsiWrappedVueDocumentedItem(documentationItem, element);
    }

    private final Pair<VueItemDocumentation, PsiElement> getVueDocumentedItem(PsiElement originalElement, int offset) {
        Pair pair;
        PsiElement docSource;
        PsiElement psiElement = originalElement;
        if (Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)JSTokenTypes.IDENTIFIER)) {
            PsiElement psiElement2 = originalElement;
            v2 = psiElement2 != null ? psiElement2.getParent() : null;
        } else {
            v2 = docSource = originalElement;
        }
        if (docSource instanceof VueJSFilterReferenceExpression) {
            VueFilter vueFilter = (VueFilter)CollectionsKt.getOrNull(VueExprReferenceExpressionResolver.Companion.resolveFiltersFromReferenceExpression((VueJSFilterReferenceExpression)docSource), (int)0);
            if (vueFilter != null) {
                VueFilter it = vueFilter;
                boolean bl = false;
                pair = new Pair((Object)it.getDocumentation(), (Object)docSource);
            } else {
                pair = null;
            }
        } else {
            pair = null;
        }
        return pair;
    }

    @Nls
    private final String generateDoc(VueItemDocumentation item) {
        String name;
        StringBuilder result = new StringBuilder().append("<div class='definition'><pre>");
        String string = item.getDefaultName();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder = StringsKt.isBlank((CharSequence)(name = string)) ? result.append(VueBundle.message("vue.documentation.vue", new Object[0]) + " ").append(item.getType()) : result.append(name);
        result.append("</pre></div>");
        String string2 = item.getDescription();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            result.append("<div class='content'>").append(it).append("</div>");
        }
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>(item.getCustomSections());
        String string3 = item.getLibrary();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            ((Map)details).put(VueBundle.message("vue.documentation.section.library", new Object[0]), "<p>" + (Intrinsics.areEqual((Object)it, (Object)"vue") ? "Vue" : it));
        }
        if (!((Map)details).isEmpty()) {
            result.append("<table class='sections'>");
            Set<Map.Entry<String, String>> set = details.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)entry);
                String name2 = (String)entry.getKey();
                String value = (String)entry.getValue();
                result.append("<tr><td valign='top' class='section'><p>").append(name2).append("</td><td valign='top'>").append(value).append("</td>");
            }
            result.append("</table>");
        }
        String string4 = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/vuejs/codeInsight/documentation/VueDocumentationProvider$PsiWrappedVueDocumentedItem;", "Lcom/intellij/psi/impl/FakePsiElement;", "Lcom/intellij/psi/PsiNamedElement;", "item", "Lorg/jetbrains/vuejs/codeInsight/documentation/VueItemDocumentation;", "source", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lorg/jetbrains/vuejs/codeInsight/documentation/VueItemDocumentation;Lcom/intellij/psi/PsiElement;)V", "getItem", "()Lorg/jetbrains/vuejs/codeInsight/documentation/VueItemDocumentation;", "getParent", "getName", "", "intellij.vuejs"})
    private static final class PsiWrappedVueDocumentedItem
    extends FakePsiElement
    implements PsiNamedElement {
        @NotNull
        private final VueItemDocumentation item;
        @NotNull
        private final PsiElement source;

        public PsiWrappedVueDocumentedItem(@NotNull VueItemDocumentation item, @NotNull PsiElement source) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.item = item;
            this.source = source;
        }

        @NotNull
        public final VueItemDocumentation getItem() {
            return this.item;
        }

        @NotNull
        public PsiElement getParent() {
            return this.source;
        }

        @NotNull
        public String getName() {
            Object object = this.item.getDefaultName();
            if (object == null) {
                object = VueBundle.message("vue.documentation.vue", new Object[0]) + " " + this.item.getType();
            }
            return object;
        }
    }
}

