/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageLogger;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.LineMarkerRendererWithErrorStripe;
import com.intellij.coverage.actions.HideCoverageInfoAction;
import com.intellij.coverage.actions.ShowCoveringTestsAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.FillingLineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.pages.GeneralColorsPage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CoverageLineMarkerRenderer
implements ActiveGutterRenderer,
FillingLineMarkerRenderer,
LineMarkerRendererWithErrorStripe {
    private static final int THICKNESS = 8;
    private final TextAttributesKey myKey;
    @Nullable
    private final String myClassName;
    @NotNull
    private final TreeMap<Integer, LineData> myLines;
    private final boolean myCoverageByTestApplicable;
    private final Function<? super Integer, Integer> myOldToNewConverter;
    private final CoverageSuitesBundle myCoverageSuite;
    private final boolean mySubCoverageActive;
    private final int myOldLine;

    protected CoverageLineMarkerRenderer(int oldLine, @Nullable String className, @NotNull TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, CoverageSuitesBundle coverageSuite, boolean subCoverageActive) {
        if (lines == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(0);
        }
        this.myKey = CoverageLineMarkerRenderer.getAttributesKey(oldLine, lines);
        this.myOldLine = oldLine;
        this.myClassName = className;
        this.myLines = lines;
        this.myCoverageByTestApplicable = coverageByTestApplicable;
        this.myOldToNewConverter = oldToNewConverter;
        this.myCoverageSuite = coverageSuite;
        this.mySubCoverageActive = subCoverageActive;
    }

    @Nullable
    public Icon getIcon() {
        LineData lineData = this.getLineData(this.myOldLine);
        if (lineData != null && lineData.isCoveredByOneTest()) {
            return AllIcons.Gutter.Unique;
        }
        return null;
    }

    @NotNull
    public TextAttributesKey getTextAttributesKey() {
        TextAttributesKey textAttributesKey = this.myKey;
        if (textAttributesKey == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(1);
        }
        return textAttributesKey;
    }

    @Nullable
    public Integer getMaxWidth() {
        return 8;
    }

    public static CoverageLineMarkerRenderer getRenderer(int lineNumber, @Nullable String className, @NotNull TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        if (lines == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(2);
        }
        if (coverageSuite == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(3);
        }
        return new CoverageLineMarkerRenderer(lineNumber, className, lines, coverageByTestApplicable, newToOldConverter, oldToNewConverter, coverageSuite, subCoverageActive);
    }

    public static TextAttributesKey getAttributesKey(int oldLine, @NotNull TreeMap<Integer, LineData> lines) {
        if (lines == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(4);
        }
        return CoverageLineMarkerRenderer.getAttributesKey(lines.get(oldLine));
    }

    private static TextAttributesKey getAttributesKey(LineData lineData) {
        int status = lineData == null ? 0 : lineData.getStatus();
        return switch (status) {
            case 2 -> CodeInsightColors.LINE_FULL_COVERAGE;
            case 1 -> CodeInsightColors.LINE_PARTIAL_COVERAGE;
            default -> CodeInsightColors.LINE_NONE_COVERAGE;
        };
    }

    private int oldToNew(int line) {
        return this.myOldToNewConverter == null ? line : (Integer)this.myOldToNewConverter.fun((Object)line);
    }

    public boolean canDoAction(@NotNull MouseEvent e) {
        Component component;
        if (e == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(5);
        }
        if ((component = e.getComponent()) instanceof EditorGutterComponentEx) {
            EditorGutterComponentEx gutter = (EditorGutterComponentEx)component;
            return e.getX() > gutter.getLineMarkerAreaOffset() && e.getX() < gutter.getIconAreaOffset();
        }
        return false;
    }

    public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
        if (editor == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(6);
        }
        if (e == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(7);
        }
        e.consume();
        this.showHint(editor, this.myOldLine);
    }

    private void showHint(Editor editor, int oldLine) {
        Editor uEditor;
        String report;
        int lineInCurrent = this.oldToNew(oldLine);
        if (lineInCurrent < 0) {
            return;
        }
        JBColor borderColor = new JBColor((Color)Gray._206, (Color)Gray._75);
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(0));
        panel.setBorder(JBUI.Borders.customLine((Color)borderColor));
        final Disposable unregisterActionsDisposable = Disposer.newDisposable();
        panel.add(this.createActionsToolbar(editor, oldLine, unregisterActionsDisposable));
        LineData lineData = this.getLineData(oldLine);
        Project project = editor.getProject();
        if (!this.mySubCoverageActive && (report = CoverageLineMarkerRenderer.getReport(lineData, lineInCurrent, editor, this.myCoverageSuite)) != null) {
            EditorFactory factory = EditorFactory.getInstance();
            Document doc = factory.createDocument((CharSequence)report);
            doc.setReadOnly(true);
            uEditor = factory.createViewer(doc, project, EditorKind.PREVIEW);
            EditorFragmentComponent component = EditorFragmentComponent.createEditorFragmentComponent((Editor)uEditor, (int)0, (int)doc.getLineCount(), (boolean)false, (boolean)false);
            component.setBorder((Border)JBUI.Borders.empty((int)4, (int)8));
            JPanel hintPanel = new JPanel(new BorderLayout());
            hintPanel.add((Component)component);
            hintPanel.setBorder(JBUI.Borders.customLine((Color)borderColor, (int)1, (int)0, (int)0, (int)0));
            panel.add(hintPanel);
        } else {
            uEditor = null;
        }
        LightweightHint hint = new LightweightHint(panel){

            public void hide() {
                if (uEditor != null) {
                    EditorFactory.getInstance().releaseEditor(uEditor);
                }
                Disposer.dispose((Disposable)unregisterActionsDisposable);
                super.hide();
            }
        };
        int coverage = lineData == null ? 0 : lineData.getStatus();
        CoverageLogger.logGutterPopup(project, coverage, this.myCoverageByTestApplicable && ShowCoveringTestsAction.isEnabled(project, this.myCoverageSuite, lineData));
        int hideFlags = 58;
        HintHint hintInfo = new HintHint(editor, new Point());
        HintManagerImpl.getInstanceImpl().showGutterHint(hint, editor, lineInCurrent, 8, hideFlags, -1, false, hintInfo);
    }

    @Nullable
    public static String getReport(LineData lineData, int lineInCurrent, Editor editor, CoverageSuitesBundle bundle) {
        Document document = editor.getDocument();
        Project project = editor.getProject();
        assert (project != null);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        int lineStartOffset = document.getLineStartOffset(lineInCurrent);
        int lineEndOffset = document.getLineEndOffset(lineInCurrent);
        TextRange textRange = TextRange.create((int)lineStartOffset, (int)lineEndOffset);
        return bundle.getCoverageEngine().generateBriefReport(bundle, editor, psiFile, textRange, lineData);
    }

    protected JComponent createActionsToolbar(Editor editor, int oldLine, Disposable parent) {
        AnAction byteCodeViewAction;
        JComponent editorComponent = editor.getComponent();
        DefaultActionGroup group = new DefaultActionGroup();
        GotoPreviousCoveredLineAction prevAction = new GotoPreviousCoveredLineAction(editor, oldLine);
        GotoNextCoveredLineAction nextAction = new GotoNextCoveredLineAction(editor, oldLine);
        group.add((AnAction)prevAction);
        group.add((AnAction)nextAction);
        prevAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(38, 9)), editorComponent);
        nextAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(40, 9)), editorComponent);
        Disposer.register((Disposable)parent, () -> {
            prevAction.unregisterCustomShortcutSet(editorComponent);
            nextAction.unregisterCustomShortcutSet(editorComponent);
        });
        LineData lineData = this.getLineData(oldLine);
        if (this.myCoverageByTestApplicable) {
            group.add((AnAction)new ShowCoveringTestsAction(editor.getProject(), this.myCoverageSuite, this.myClassName, lineData));
        }
        if ((byteCodeViewAction = ActionManager.getInstance().getAction("BytecodeViewer")) != null) {
            group.add(byteCodeViewAction);
        }
        group.add((AnAction)new EditCoverageColorsAction(editor, oldLine));
        group.add((AnAction)new HideCoverageInfoAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CoverageHintToolbar", (ActionGroup)group, true);
        toolbar.setTargetComponent(editorComponent);
        return toolbar.getComponent();
    }

    public void moveToLine(int lineNumber, Editor editor) {
        int firstOffset = editor.getDocument().getLineStartOffset(lineNumber);
        editor.getCaretModel().moveToOffset(firstOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        editor.getScrollingModel().runActionOnScrollingFinished(() -> this.showHint(editor, lineNumber));
    }

    @Nullable
    public LineData getLineData(int oldLine) {
        return this.myLines.get(oldLine);
    }

    @Override
    public Color getErrorStripeColor(Editor editor) {
        return editor.getColorsScheme().getAttributes(this.myKey).getErrorStripeColor();
    }

    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.LEFT;
        if (position == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(8);
        }
        return position;
    }

    @NotNull
    public String getAccessibleName() {
        String string = CoverageBundle.message("marker.code.coverage", new Object[0]);
        if (string == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageLineMarkerRenderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributesKey";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesKey";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canDoAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8, 9 -> new IllegalStateException(string);
        };
    }

    private class GotoPreviousCoveredLineAction
    extends BaseGotoCoveredLineAction {
        GotoPreviousCoveredLineAction(Editor editor, int lineNumber) {
            super(editor, lineNumber);
            ActionUtil.copyFrom((AnAction)this, (String)"PreviousOccurence");
            this.getTemplatePresentation().setText(CoverageBundle.message("coverage.previous.mark", new Object[0]));
        }

        @Override
        protected int next(int idx, int size) {
            if (idx <= 0) {
                return size - 1;
            }
            return idx - 1;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GotoPreviousCoveredLineAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            String nextChange = this.getNextChange();
            if (nextChange != null) {
                e.getPresentation().setText(CoverageBundle.message("coverage.previous.place", nextChange));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/CoverageLineMarkerRenderer$GotoPreviousCoveredLineAction", "update"));
        }
    }

    private class GotoNextCoveredLineAction
    extends BaseGotoCoveredLineAction {
        GotoNextCoveredLineAction(Editor editor, int lineNumber) {
            super(editor, lineNumber);
            this.copyFrom(ActionManager.getInstance().getAction("NextOccurence"));
            this.getTemplatePresentation().setText(CoverageBundle.message("coverage.next.mark", new Object[0]));
        }

        @Override
        protected int next(int idx, int size) {
            if (idx == size - 1) {
                return 0;
            }
            return idx + 1;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GotoNextCoveredLineAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            String nextChange = this.getNextChange();
            if (nextChange != null) {
                e.getPresentation().setText(CoverageBundle.message("coverage.next.place", nextChange));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/CoverageLineMarkerRenderer$GotoNextCoveredLineAction", "update"));
        }
    }

    private final class EditCoverageColorsAction
    extends AnAction {
        private final Editor myEditor;
        private final int myLineNumber;

        private EditCoverageColorsAction(Editor editor, int lineNumber) {
            super(CoverageBundle.message("coverage.edit.colors.action.name", new Object[0]), CoverageBundle.message("coverage.edit.colors.description", new Object[0]), AllIcons.General.Settings);
            this.myEditor = editor;
            this.myLineNumber = lineNumber;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EditCoverageColorsAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setVisible(CoverageLineMarkerRenderer.this.getLineData(this.myLineNumber) != null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditCoverageColorsAction.$$$reportNull$$$0(1);
            }
            final GeneralColorsPage colorsPage = new GeneralColorsPage();
            final String fullDisplayName = CoverageBundle.message("configurable.name.editor.colors.page", ApplicationBundle.message((String)"title.colors.and.fonts", (Object[])new Object[0]), colorsPage.getDisplayName());
            ColorAndFontOptions colorAndFontOptions = new ColorAndFontOptions(){

                protected List<ColorAndFontPanelFactory> createPanelFactories() {
                    ColorAndFontPanelFactory panelFactory = new ColorAndFontPanelFactory(){

                        @NotNull
                        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
                            if (options == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            SimpleEditorPreview preview = new SimpleEditorPreview(options, (ColorSettingsPage)colorsPage);
                            NewColorAndFontPanel newColorAndFontPanel = NewColorAndFontPanel.create((PreviewPanel)preview, (String)colorsPage.getDisplayName(), (ColorAndFontOptions)options, null, (ColorSettingsPage)colorsPage);
                            if (newColorAndFontPanel == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return newColorAndFontPanel;
                        }

                        @NlsContexts.ConfigurableName
                        @NotNull
                        public String getPanelDisplayName() {
                            String string = fullDisplayName;
                            if (string == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return string;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[switch (n) {
                                default -> 3;
                                case 1, 2 -> 2;
                            }];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "options";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/coverage/CoverageLineMarkerRenderer$EditCoverageColorsAction$1$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer$EditCoverageColorsAction$1$1";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "createPanel";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getPanelDisplayName";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "createPanel";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    break;
                                }
                            }
                            String string = String.format(v0, objectArray);
                            throw switch (n) {
                                default -> new IllegalArgumentException(string);
                                case 1, 2 -> new IllegalStateException(string);
                            };
                        }
                    };
                    return Collections.singletonList(panelFactory);
                }
            };
            Configurable[] configurables = colorAndFontOptions.buildConfigurables();
            try {
                NewColorAndFontPanel page = colorAndFontOptions.findPage(fullDisplayName);
                SearchableConfigurable general = colorAndFontOptions.findSubConfigurable(GeneralColorsPage.class);
                if (general != null && page != null) {
                    LineData lineData = CoverageLineMarkerRenderer.this.getLineData(this.myLineNumber);
                    ShowSettingsUtil.getInstance().editConfigurable(this.myEditor.getProject(), (Configurable)general, () -> page.selectOptionByType(CoverageLineMarkerRenderer.getAttributesKey(lineData).getExternalName()));
                }
            }
            finally {
                for (Configurable configurable : configurables) {
                    configurable.disposeUIResources();
                }
                colorAndFontOptions.disposeUIResources();
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                EditCoverageColorsAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coverage/CoverageLineMarkerRenderer$EditCoverageColorsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer$EditCoverageColorsAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private abstract class BaseGotoCoveredLineAction
    extends AnAction {
        private final Editor myEditor;
        private final int myOldLine;

        BaseGotoCoveredLineAction(Editor editor, int oldLine) {
            this.myEditor = editor;
            this.myOldLine = oldLine;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Integer nextOldLine;
            if (e == null) {
                BaseGotoCoveredLineAction.$$$reportNull$$$0(0);
            }
            if ((nextOldLine = this.getLineEntry()) != null) {
                CoverageLineMarkerRenderer.this.moveToLine(nextOldLine, this.myEditor);
            }
        }

        protected abstract int next(int var1, int var2);

        @Nullable
        private Integer getLineEntry() {
            int nextLine;
            LineData lineData;
            List oldLines = ContainerUtil.sorted(CoverageLineMarkerRenderer.this.myLines.keySet());
            int size = oldLines.size();
            LineData data = CoverageLineMarkerRenderer.this.getLineData(this.myOldLine);
            int currentStatus = data != null ? data.getStatus() : 0;
            int idx = oldLines.indexOf(this.myOldLine);
            if (idx < 0) {
                return null;
            }
            do {
                if ((nextLine = ((Integer)oldLines.get(idx = this.next(idx, size))).intValue()) != this.myOldLine) continue;
                return null;
            } while ((lineData = CoverageLineMarkerRenderer.this.getLineData(nextLine)) == null || lineData.getStatus() == currentStatus || CoverageLineMarkerRenderer.this.oldToNew(nextLine) < 0);
            return nextLine;
        }

        @Nullable
        protected String getNextChange() {
            LineData lineData;
            Integer nextOldLine = this.getLineEntry();
            if (nextOldLine != null && (lineData = CoverageLineMarkerRenderer.this.getLineData(nextOldLine)) != null) {
                return switch (lineData.getStatus()) {
                    case 0 -> CoverageBundle.message("coverage.next.change.uncovered", new Object[0]);
                    case 1 -> CoverageBundle.message("coverage.next.change.partial.covered", new Object[0]);
                    case 2 -> CoverageBundle.message("coverage.next.change.fully.covered", new Object[0]);
                    default -> null;
                };
            }
            return null;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                BaseGotoCoveredLineAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.getLineEntry() != null);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                BaseGotoCoveredLineAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coverage/CoverageLineMarkerRenderer$BaseGotoCoveredLineAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer$BaseGotoCoveredLineAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

