package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListQualityResultsByRule invokes the dataworks_public.ListQualityResultsByRule API synchronously
func (client *Client) ListQualityResultsByRule(request *ListQualityResultsByRuleRequest) (response *ListQualityResultsByRuleResponse, err error) {
	response = CreateListQualityResultsByRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ListQualityResultsByRuleWithChan invokes the dataworks_public.ListQualityResultsByRule API asynchronously
func (client *Client) ListQualityResultsByRuleWithChan(request *ListQualityResultsByRuleRequest) (<-chan *ListQualityResultsByRuleResponse, <-chan error) {
	responseChan := make(chan *ListQualityResultsByRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListQualityResultsByRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListQualityResultsByRuleWithCallback invokes the dataworks_public.ListQualityResultsByRule API asynchronously
func (client *Client) ListQualityResultsByRuleWithCallback(request *ListQualityResultsByRuleRequest, callback func(response *ListQualityResultsByRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListQualityResultsByRuleResponse
		var err error
		defer close(result)
		response, err = client.ListQualityResultsByRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListQualityResultsByRuleRequest is the request struct for api ListQualityResultsByRule
type ListQualityResultsByRuleRequest struct {
	*requests.RpcRequest
	ProjectName string           `position:"Body" name:"ProjectName"`
	EndDate     string           `position:"Body" name:"EndDate"`
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	RuleId      requests.Integer `position:"Body" name:"RuleId"`
	StartDate   string           `position:"Body" name:"StartDate"`
	PageNumber  requests.Integer `position:"Body" name:"PageNumber"`
}

// ListQualityResultsByRuleResponse is the response struct for api ListQualityResultsByRule
type ListQualityResultsByRuleResponse struct {
	*responses.BaseResponse
	HttpStatusCode int                            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage   string                         `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string                         `json:"RequestId" xml:"RequestId"`
	ErrorCode      string                         `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool                           `json:"Success" xml:"Success"`
	Data           DataInListQualityResultsByRule `json:"Data" xml:"Data"`
}

// CreateListQualityResultsByRuleRequest creates a request to invoke ListQualityResultsByRule API
func CreateListQualityResultsByRuleRequest() (request *ListQualityResultsByRuleRequest) {
	request = &ListQualityResultsByRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListQualityResultsByRule", "", "")
	request.Method = requests.POST
	return
}

// CreateListQualityResultsByRuleResponse creates a response to parse from ListQualityResultsByRule response
func CreateListQualityResultsByRuleResponse() (response *ListQualityResultsByRuleResponse) {
	response = &ListQualityResultsByRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
