package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCall invokes the cloudcallcenter.QueryCall API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/querycall.html
func (client *Client) QueryCall(request *QueryCallRequest) (response *QueryCallResponse, err error) {
	response = CreateQueryCallResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCallWithChan invokes the cloudcallcenter.QueryCall API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/querycall.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCallWithChan(request *QueryCallRequest) (<-chan *QueryCallResponse, <-chan error) {
	responseChan := make(chan *QueryCallResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCall(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCallWithCallback invokes the cloudcallcenter.QueryCall API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/querycall.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCallWithCallback(request *QueryCallRequest, callback func(response *QueryCallResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCallResponse
		var err error
		defer close(result)
		response, err = client.QueryCall(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCallRequest is the request struct for api QueryCall
type QueryCallRequest struct {
	*requests.RpcRequest
	TaskId *[]string `position:"Query" name:"TaskId"  type:"Repeated"`
}

// QueryCallResponse is the response struct for api QueryCall
type QueryCallResponse struct {
	*responses.BaseResponse
	RequestId      string                    `json:"RequestId" xml:"RequestId"`
	Success        bool                      `json:"Success" xml:"Success"`
	Code           string                    `json:"Code" xml:"Code"`
	Message        string                    `json:"Message" xml:"Message"`
	HttpStatusCode int                       `json:"HttpStatusCode" xml:"HttpStatusCode"`
	CallStatusList CallStatusListInQueryCall `json:"callStatusList" xml:"callStatusList"`
}

// CreateQueryCallRequest creates a request to invoke QueryCall API
func CreateQueryCallRequest() (request *QueryCallRequest) {
	request = &QueryCallRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "QueryCall", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryCallResponse creates a response to parse from QueryCall response
func CreateQueryCallResponse() (response *QueryCallResponse) {
	response = &QueryCallResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
