/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.List;
import java.util.Optional;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.CastingTarget;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;

public interface UnionType
extends ItemType,
CastingTarget {
    public StructuredQName getTypeName();

    default public StructuredQName getStructuredQName() {
        return this.getTypeName();
    }

    public boolean containsListType() throws MissingComponentException;

    public List<? extends PlainType> getPlainMemberTypes() throws MissingComponentException;

    public SequenceType getResultTypeOfCast();

    public AtomicSequence getTypedValue(UnicodeString var1, NamespaceResolver var2, ConversionRules var3) throws ValidationException;

    public ValidationFailure checkAgainstFacets(AtomicValue var1, ConversionRules var2);

    @Override
    default public Optional<String> explainMismatch(Item item, TypeHierarchy th) {
        if (item.getGenre() == Genre.ATOMIC) {
            String message = "This is a union type, and the supplied value " + Err.depict(item) + " of type " + ((AtomicValue)item).getItemType().getDescription() + " does not match any of its member types";
            return Optional.of(message);
        }
        return Optional.empty();
    }

    default public String getDescription() {
        if (this instanceof SimpleType) {
            return ((SimpleType)((Object)this)).getDescription();
        }
        return this.toString();
    }
}

