// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use ::aws_smithy_runtime_api::client::endpoint::EndpointFuture;
pub use ::aws_smithy_runtime_api::client::endpoint::SharedEndpointResolver;
pub use ::aws_smithy_types::endpoint::Endpoint;

#[cfg(test)]
mod test {

    /// region is not a valid DNS-suffix
    #[test]
    fn test_1() {
        let params = crate::config::endpoint::Params::builder()
            .region("a b".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid region: region was not a valid DNS name. [region is not a valid DNS-suffix]");
        assert_eq!(format!("{}", error), "Invalid region: region was not a valid DNS name.")
    }

    /// Invalid access point ARN: Not S3
    #[test]
    fn test_2() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .bucket("arn:aws:not-s3:us-west-2:123456789012:accesspoint:myendpoint".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Invalid ARN: The ARN was not for the S3 service, found: not-s3 [Invalid access point ARN: Not S3]");
        assert_eq!(format!("{}", error), "Invalid ARN: The ARN was not for the S3 service, found: not-s3")
    }

    /// Invalid access point ARN: invalid resource
    #[test]
    fn test_3() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint:more-data".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: The ARN may only contain a single resource component after `accesspoint`. [Invalid access point ARN: invalid resource]");
        assert_eq!(
            format!("{}", error),
            "Invalid ARN: The ARN may only contain a single resource component after `accesspoint`."
        )
    }

    /// Invalid access point ARN: invalid no ap name
    #[test]
    fn test_4() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided [Invalid access point ARN: invalid no ap name]");
        assert_eq!(
            format!("{}", error),
            "Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided"
        )
    }

    /// Invalid access point ARN: AccountId is invalid
    #[test]
    fn test_5() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .bucket("arn:aws:s3:us-west-2:123456_789012:accesspoint:apname".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123456_789012` [Invalid access point ARN: AccountId is invalid]");
        assert_eq!(
            format!("{}", error),
            "Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123456_789012`"
        )
    }

    /// Invalid access point ARN: access point name is invalid
    #[test]
    fn test_6() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:ap_name".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `ap_name` [Invalid access point ARN: access point name is invalid]");
        assert_eq!(
            format!("{}", error),
            "Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `ap_name`"
        )
    }

    /// Access points (disable access points explicitly false)
    #[test]
    fn test_7() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .disable_access_points(false)
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// Access points: partition does not support FIPS
    #[test]
    fn test_8() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .bucket("arn:aws:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Partition does not support FIPS [Access points: partition does not support FIPS]");
        assert_eq!(format!("{}", error), "Partition does not support FIPS")
    }

    /// Bucket region is invalid
    #[test]
    fn test_9() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .disable_access_points(false)
            .bucket("arn:aws:s3:us-west -2:123456789012:accesspoint:myendpoint".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid region in ARN: `us-west -2` (invalid DNS name) [Bucket region is invalid]");
        assert_eq!(format!("{}", error), "Invalid region in ARN: `us-west -2` (invalid DNS name)")
    }

    /// Access points when Access points explicitly disabled (used for CreateBucket)
    #[test]
    fn test_10() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .disable_access_points(true)
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Access points are not supported for this operation [Access points when Access points explicitly disabled (used for CreateBucket)]");
        assert_eq!(format!("{}", error), "Access points are not supported for this operation")
    }

    /// missing arn type
    #[test]
    fn test_11() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .disable_access_points(true)
            .bucket("arn:aws:s3:us-west-2:123456789012:".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: `arn:aws:s3:us-west-2:123456789012:` was not a valid ARN [missing arn type]");
        assert_eq!(
            format!("{}", error),
            "Invalid ARN: `arn:aws:s3:us-west-2:123456789012:` was not a valid ARN"
        )
    }

    /// SDK::Host + access point + Dualstack is an error
    #[test]
    fn test_12() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .endpoint("https://beta.example.com".to_string())
            .region("cn-north-1".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err(
            "expected error: Cannot set dual-stack in combination with a custom endpoint. [SDK::Host + access point + Dualstack is an error]",
        );
        assert_eq!(format!("{}", error), "Cannot set dual-stack in combination with a custom endpoint.")
    }

    /// Access point ARN with FIPS & Dualstack
    #[test]
    fn test_13() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .accelerate(false)
            .disable_access_points(false)
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// Access point ARN with Dualstack
    #[test]
    fn test_14() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .accelerate(false)
            .disable_access_points(false)
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myendpoint-123456789012.s3-accesspoint.dualstack.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myendpoint-123456789012.s3-accesspoint.dualstack.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// vanilla MRAP
    #[test]
    fn test_15() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_string())
            .region("us-east-1".to_string())
            .disable_multi_region_access_points(false)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mfzwi23gnjvgw.mrap.accesspoint.s3-global.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mfzwi23gnjvgw.mrap.accesspoint.s3-global.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4a".to_string().into());
                        out.insert("signingRegionSet".to_string(), vec!["*".to_string().into()].into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// MRAP does not support FIPS
    #[test]
    fn test_16() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_string())
            .region("us-east-1".to_string())
            .disable_multi_region_access_points(false)
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3 MRAP does not support FIPS [MRAP does not support FIPS]");
        assert_eq!(format!("{}", error), "S3 MRAP does not support FIPS")
    }

    /// MRAP does not support DualStack
    #[test]
    fn test_17() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_string())
            .region("us-east-1".to_string())
            .disable_multi_region_access_points(false)
            .use_fips(false)
            .use_dual_stack(true)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3 MRAP does not support dual-stack [MRAP does not support DualStack]");
        assert_eq!(format!("{}", error), "S3 MRAP does not support dual-stack")
    }

    /// MRAP does not support S3 Accelerate
    #[test]
    fn test_18() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_string())
            .region("us-east-1".to_string())
            .disable_multi_region_access_points(false)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3 MRAP does not support S3 Accelerate [MRAP does not support S3 Accelerate]");
        assert_eq!(format!("{}", error), "S3 MRAP does not support S3 Accelerate")
    }

    /// MRAP explicitly disabled
    #[test]
    fn test_19() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_string())
            .region("us-east-1".to_string())
            .disable_multi_region_access_points(true)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Invalid configuration: Multi-Region Access Point ARNs are disabled. [MRAP explicitly disabled]");
        assert_eq!(
            format!("{}", error),
            "Invalid configuration: Multi-Region Access Point ARNs are disabled."
        )
    }

    /// Dual-stack endpoint with path-style forced
    #[test]
    fn test_20() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("bucketname".to_string())
            .region("us-west-2".to_string())
            .force_path_style(true)
            .use_fips(false)
            .accelerate(false)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.dualstack.us-west-2.amazonaws.com/bucketname");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.dualstack.us-west-2.amazonaws.com/bucketname")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// Dual-stack endpoint + SDK::Host is error
    #[test]
    fn test_21() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("bucketname".to_string())
            .region("us-west-2".to_string())
            .force_path_style(true)
            .use_fips(false)
            .accelerate(false)
            .use_dual_stack(true)
            .endpoint("https://abc.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [Dual-stack endpoint + SDK::Host is error]");
        assert_eq!(format!("{}", error), "Cannot set dual-stack in combination with a custom endpoint.")
    }

    /// path style + ARN bucket
    #[test]
    fn test_22() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_string())
            .force_path_style(true)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Path-style addressing cannot be used with ARN buckets [path style + ARN bucket]");
        assert_eq!(format!("{}", error), "Path-style addressing cannot be used with ARN buckets")
    }

    /// implicit path style bucket + dualstack
    #[test]
    fn test_23() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("99_ab".to_string())
            .region("us-west-2".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.dualstack.us-west-2.amazonaws.com/99_ab");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.dualstack.us-west-2.amazonaws.com/99_ab")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// implicit path style bucket + dualstack
    #[test]
    fn test_24() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("99_ab".to_string())
            .region("us-west-2".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .endpoint("http://abc.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [implicit path style bucket + dualstack]");
        assert_eq!(format!("{}", error), "Cannot set dual-stack in combination with a custom endpoint.")
    }

    /// don't allow URL injections in the bucket
    #[test]
    fn test_25() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("example.com#".to_string())
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.us-west-2.amazonaws.com/example.com%23");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.us-west-2.amazonaws.com/example.com%23")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// URI encode bucket names in the path
    #[test]
    fn test_26() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("bucket name".to_string())
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.us-west-2.amazonaws.com/bucket%20name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.us-west-2.amazonaws.com/bucket%20name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// scheme is respected
    #[test]
    fn test_27() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("99_ab".to_string())
            .endpoint("http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/99_ab");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/99_ab")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// scheme is respected (virtual addressing)
    #[test]
    fn test_28() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucketname".to_string())
            .endpoint("http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/foo".to_string())
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://bucketname.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/foo");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://bucketname.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/foo")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// path style + implicit private link
    #[test]
    fn test_29() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("99_ab".to_string())
            .endpoint("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/99_ab");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/99_ab")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// invalid Endpoint override
    #[test]
    fn test_30() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucketname".to_string())
            .endpoint("abcde://nota#url".to_string())
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Custom endpoint `abcde://nota#url` was not a valid URI [invalid Endpoint override]");
        assert_eq!(format!("{}", error), "Custom endpoint `abcde://nota#url` was not a valid URI")
    }

    /// using an IPv4 address forces path style
    #[test]
    fn test_31() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucketname".to_string())
            .endpoint("https://123.123.0.1".to_string())
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.123.0.1/bucketname");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.123.0.1/bucketname")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// vanilla access point arn with region mismatch and UseArnRegion=false
    #[test]
    fn test_32() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3:us-east-1:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .use_arn_region(false)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false` [vanilla access point arn with region mismatch and UseArnRegion=false]");
        assert_eq!(
            format!("{}", error),
            "Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`"
        )
    }

    /// vanilla access point arn with region mismatch and UseArnRegion unset
    #[test]
    fn test_33() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .region("us-east-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// vanilla access point arn with region mismatch and UseArnRegion=true
    #[test]
    fn test_34() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .use_arn_region(true)
            .region("us-east-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// subdomains are not allowed in virtual buckets
    #[test]
    fn test_35() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("bucket.name".to_string())
            .region("us-east-1".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.us-east-1.amazonaws.com/bucket.name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.us-east-1.amazonaws.com/bucket.name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// bucket names with 3 characters are allowed in virtual buckets
    #[test]
    fn test_36() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("aaa".to_string())
            .region("us-east-1".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://aaa.s3.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://aaa.s3.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// bucket names with fewer than 3 characters are not allowed in virtual host
    #[test]
    fn test_37() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("aa".to_string())
            .region("us-east-1".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.us-east-1.amazonaws.com/aa");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.us-east-1.amazonaws.com/aa")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// bucket names with uppercase characters are not allowed in virtual host
    #[test]
    fn test_38() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("BucketName".to_string())
            .region("us-east-1".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.us-east-1.amazonaws.com/BucketName");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.us-east-1.amazonaws.com/BucketName")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// subdomains are allowed in virtual buckets on http endpoints
    #[test]
    fn test_39() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("bucket.name".to_string())
            .region("us-east-1".to_string())
            .endpoint("http://example.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://bucket.name.example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://bucket.name.example.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// no region set
    #[test]
    fn test_40() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("bucket-name".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: A region must be set when sending requests to S3. [no region set]");
        assert_eq!(format!("{}", error), "A region must be set when sending requests to S3.")
    }

    /// UseGlobalEndpoints=true, region=us-east-1 uses the global endpoint
    #[test]
    fn test_41() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_global_endpoint(true)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// UseGlobalEndpoints=true, region=us-west-2 uses the regional endpoint
    #[test]
    fn test_42() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_global_endpoint(true)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// UseGlobalEndpoints=true, region=cn-north-1 uses the regional endpoint
    #[test]
    fn test_43() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .use_global_endpoint(true)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.cn-north-1.amazonaws.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.cn-north-1.amazonaws.com.cn")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "cn-north-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// UseGlobalEndpoints=true, region=us-east-1, fips=true uses the regional endpoint with fips
    #[test]
    fn test_44() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_global_endpoint(true)
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// UseGlobalEndpoints=true, region=us-east-1, dualstack=true uses the regional endpoint with dualstack
    #[test]
    fn test_45() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_global_endpoint(true)
            .use_fips(false)
            .use_dual_stack(true)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.dualstack.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.dualstack.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// UseGlobalEndpoints=true, region=us-east-1, dualstack and fips uses the regional endpoint with fips/dualstack
    #[test]
    fn test_46() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_global_endpoint(true)
            .use_fips(true)
            .use_dual_stack(true)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.dualstack.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.dualstack.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// UseGlobalEndpoints=true, region=us-east-1 with custom endpoint, uses custom
    #[test]
    fn test_47() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .endpoint("https://example.com".to_string())
            .use_global_endpoint(true)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://example.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// UseGlobalEndpoints=true, region=us-west-2 with custom endpoint, uses custom
    #[test]
    fn test_48() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .endpoint("https://example.com".to_string())
            .use_global_endpoint(true)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://example.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// UseGlobalEndpoints=true, region=us-east-1 with accelerate on non bucket case uses the global endpoint and ignores accelerate
    #[test]
    fn test_49() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_global_endpoint(true)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// aws-global region uses the global endpoint
    #[test]
    fn test_50() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// aws-global region with fips uses the regional endpoint
    #[test]
    fn test_51() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// aws-global region with dualstack uses the regional endpoint
    #[test]
    fn test_52() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.dualstack.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.dualstack.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// aws-global region with fips and dualstack uses the regional endpoint
    #[test]
    fn test_53() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.dualstack.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.dualstack.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// aws-global region with accelerate on non-bucket case, uses global endpoint and ignores accelerate
    #[test]
    fn test_54() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// aws-global region with custom endpoint, uses custom
    #[test]
    fn test_55() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .endpoint("https://example.com".to_string())
            .use_global_endpoint(false)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://example.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing, aws-global region uses the global endpoint
    #[test]
    fn test_56() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket-name".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing, aws-global region with Prefix, and Key uses the global endpoint. Prefix and Key parameters should not be used in endpoint evaluation.
    #[test]
    fn test_57() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket-name".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .prefix("prefix".to_string())
            .key("key".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing, aws-global region with Copy Source, and Key uses the global endpoint. Copy Source and Key parameters should not be used in endpoint evaluation.
    #[test]
    fn test_58() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket-name".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .copy_source("/copy/source".to_string())
            .key("key".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing, aws-global region with fips uses the regional fips endpoint
    #[test]
    fn test_59() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket-name".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3-fips.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing, aws-global region with dualstack uses the regional dualstack endpoint
    #[test]
    fn test_60() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket-name".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3.dualstack.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3.dualstack.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing, aws-global region with fips/dualstack uses the regional fips/dualstack endpoint
    #[test]
    fn test_61() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket-name".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3-fips.dualstack.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3-fips.dualstack.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing, aws-global region with accelerate uses the global accelerate endpoint
    #[test]
    fn test_62() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket-name".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3-accelerate.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3-accelerate.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing, aws-global region with custom endpoint
    #[test]
    fn test_63() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .endpoint("https://example.com".to_string())
            .bucket("bucket-name".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.example.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing, UseGlobalEndpoint and us-east-1 region uses the global endpoint
    #[test]
    fn test_64() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_global_endpoint(true)
            .bucket("bucket-name".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing, UseGlobalEndpoint and us-west-2 region uses the regional endpoint
    #[test]
    fn test_65() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_global_endpoint(true)
            .bucket("bucket-name".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing, UseGlobalEndpoint and us-east-1 region and fips uses the regional fips endpoint
    #[test]
    fn test_66() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_global_endpoint(true)
            .bucket("bucket-name".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3-fips.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing, UseGlobalEndpoint and us-east-1 region and dualstack uses the regional dualstack endpoint
    #[test]
    fn test_67() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_global_endpoint(true)
            .bucket("bucket-name".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3.dualstack.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3.dualstack.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing, UseGlobalEndpoint and us-east-1 region and accelerate uses the global accelerate endpoint
    #[test]
    fn test_68() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_global_endpoint(true)
            .bucket("bucket-name".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3-accelerate.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3-accelerate.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing, UseGlobalEndpoint and us-east-1 region with custom endpoint
    #[test]
    fn test_69() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .endpoint("https://example.com".to_string())
            .use_global_endpoint(true)
            .bucket("bucket-name".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.example.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// ForcePathStyle, aws-global region uses the global endpoint
    #[test]
    fn test_70() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.amazonaws.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.amazonaws.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// ForcePathStyle, aws-global region with fips is invalid
    #[test]
    fn test_71() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.us-east-1.amazonaws.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.us-east-1.amazonaws.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// ForcePathStyle, aws-global region with dualstack uses regional dualstack endpoint
    #[test]
    fn test_72() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .use_fips(false)
            .use_dual_stack(true)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.dualstack.us-east-1.amazonaws.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.dualstack.us-east-1.amazonaws.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// ForcePathStyle, aws-global region custom endpoint uses the custom endpoint
    #[test]
    fn test_73() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .endpoint("https://example.com".to_string())
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://example.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://example.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// ForcePathStyle, UseGlobalEndpoint us-east-1 region uses the global endpoint
    #[test]
    fn test_74() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket-name".to_string())
            .use_global_endpoint(true)
            .force_path_style(true)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.amazonaws.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.amazonaws.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// ForcePathStyle, UseGlobalEndpoint us-west-2 region uses the regional endpoint
    #[test]
    fn test_75() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("bucket-name".to_string())
            .use_global_endpoint(true)
            .force_path_style(true)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.us-west-2.amazonaws.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.us-west-2.amazonaws.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// ForcePathStyle, UseGlobalEndpoint us-east-1 region, dualstack uses the regional dualstack endpoint
    #[test]
    fn test_76() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket-name".to_string())
            .use_global_endpoint(true)
            .force_path_style(true)
            .use_fips(false)
            .use_dual_stack(true)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.dualstack.us-east-1.amazonaws.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.dualstack.us-east-1.amazonaws.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// ForcePathStyle, UseGlobalEndpoint us-east-1 region custom endpoint uses the custom endpoint
    #[test]
    fn test_77() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket-name".to_string())
            .endpoint("https://example.com".to_string())
            .use_global_endpoint(true)
            .force_path_style(true)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://example.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://example.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// ARN with aws-global region and  UseArnRegion uses the regional endpoint
    #[test]
    fn test_78() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .use_arn_region(true)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .bucket("arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/accesspoint/reports".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://reports-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://reports-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4a".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegionSet".to_string(), vec!["*".to_string().into()].into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into(),
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into()
                    ]
                )
                .build()
        );
    }

    /// cross partition MRAP ARN is an error
    #[test]
    fn test_79() {
        let params = crate::config::endpoint::Params::builder()
            .bucket("arn:aws-cn:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_string())
            .region("us-west-1".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Client was configured for partition `aws` but bucket referred to partition `aws-cn` [cross partition MRAP ARN is an error]");
        assert_eq!(
            format!("{}", error),
            "Client was configured for partition `aws` but bucket referred to partition `aws-cn`"
        )
    }

    /// Endpoint override, accesspoint with HTTP, port
    #[test]
    fn test_80() {
        let params = crate::config::endpoint::Params::builder()
            .endpoint("http://beta.example.com:1234".to_string())
            .region("us-west-2".to_string())
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://myendpoint-123456789012.beta.example.com:1234");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://myendpoint-123456789012.beta.example.com:1234")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// Endpoint override, accesspoint with http, path, query, and port
    #[test]
    fn test_81() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_string())
            .endpoint("http://beta.example.com:1234/path".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://myendpoint-123456789012.beta.example.com:1234/path");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://myendpoint-123456789012.beta.example.com:1234/path")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// non-bucket endpoint override with FIPS = error
    #[test]
    fn test_82() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .endpoint("http://beta.example.com:1234/path".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: A custom endpoint cannot be combined with FIPS [non-bucket endpoint override with FIPS = error]");
        assert_eq!(format!("{}", error), "A custom endpoint cannot be combined with FIPS")
    }

    /// FIPS + dualstack + custom endpoint
    #[test]
    fn test_83() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .endpoint("http://beta.example.com:1234/path".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [FIPS + dualstack + custom endpoint]");
        assert_eq!(format!("{}", error), "Cannot set dual-stack in combination with a custom endpoint.")
    }

    /// dualstack + custom endpoint
    #[test]
    fn test_84() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .endpoint("http://beta.example.com:1234/path".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [dualstack + custom endpoint]");
        assert_eq!(format!("{}", error), "Cannot set dual-stack in combination with a custom endpoint.")
    }

    /// custom endpoint without FIPS/dualstack
    #[test]
    fn test_85() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .endpoint("http://beta.example.com:1234/path".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://beta.example.com:1234/path");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://beta.example.com:1234/path")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// s3 object lambda with access points disabled
    #[test]
    fn test_86() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:myendpoint".to_string())
            .disable_access_points(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Access points are not supported for this operation [s3 object lambda with access points disabled]");
        assert_eq!(format!("{}", error), "Access points are not supported for this operation")
    }

    /// non bucket + FIPS
    #[test]
    fn test_87() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// standard non bucket endpoint
    #[test]
    fn test_88() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// non bucket endpoint with FIPS + Dualstack
    #[test]
    fn test_89() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.dualstack.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.dualstack.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// non bucket endpoint with dualstack
    #[test]
    fn test_90() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.dualstack.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.dualstack.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// use global endpoint + IP address endpoint override
    #[test]
    fn test_91() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .endpoint("http://127.0.0.1".to_string())
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://127.0.0.1/bucket");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://127.0.0.1/bucket")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// non-dns endpoint + global endpoint
    #[test]
    fn test_92() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket!".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.amazonaws.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.amazonaws.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// endpoint override + use global endpoint
    #[test]
    fn test_93() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket!".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .use_global_endpoint(true)
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://foo.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://foo.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// FIPS + dualstack + non-bucket endpoint
    #[test]
    fn test_94() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket!".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// FIPS + dualstack + non-DNS endpoint
    #[test]
    fn test_95() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket!".to_string())
            .force_path_style(true)
            .use_fips(true)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// endpoint override + FIPS + dualstack (BUG)
    #[test]
    fn test_96() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket!".to_string())
            .force_path_style(true)
            .use_fips(true)
            .use_dual_stack(false)
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: A custom endpoint cannot be combined with FIPS [endpoint override + FIPS + dualstack (BUG)]");
        assert_eq!(format!("{}", error), "A custom endpoint cannot be combined with FIPS")
    }

    /// endpoint override + non-dns bucket + FIPS (BUG)
    #[test]
    fn test_97() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket!".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: A custom endpoint cannot be combined with FIPS [endpoint override + non-dns bucket + FIPS (BUG)]");
        assert_eq!(format!("{}", error), "A custom endpoint cannot be combined with FIPS")
    }

    /// FIPS + bucket endpoint + force path style
    #[test]
    fn test_98() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket!".to_string())
            .force_path_style(true)
            .use_fips(true)
            .use_dual_stack(false)
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.us-east-1.amazonaws.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.us-east-1.amazonaws.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// bucket + FIPS + force path style
    #[test]
    fn test_99() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket".to_string())
            .force_path_style(true)
            .use_fips(true)
            .use_dual_stack(true)
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// FIPS + dualstack + use global endpoint
    #[test]
    fn test_100() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket.s3-fips.dualstack.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket.s3-fips.dualstack.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// URI encoded bucket + use global endpoint
    #[test]
    fn test_101() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket!".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .use_global_endpoint(true)
            .endpoint("https://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: A custom endpoint cannot be combined with FIPS [URI encoded bucket + use global endpoint]");
        assert_eq!(format!("{}", error), "A custom endpoint cannot be combined with FIPS")
    }

    /// FIPS + path based endpoint
    #[test]
    fn test_102() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket!".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.us-east-1.amazonaws.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.us-east-1.amazonaws.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// accelerate + dualstack + global endpoint
    #[test]
    fn test_103() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .accelerate(true)
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket.s3-accelerate.dualstack.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket.s3-accelerate.dualstack.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// dualstack + global endpoint + non URI safe bucket
    #[test]
    fn test_104() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket!".to_string())
            .accelerate(false)
            .use_dual_stack(true)
            .use_fips(false)
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.dualstack.us-east-1.amazonaws.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.dualstack.us-east-1.amazonaws.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// FIPS + uri encoded bucket
    #[test]
    fn test_105() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket!".to_string())
            .force_path_style(true)
            .accelerate(false)
            .use_dual_stack(false)
            .use_fips(true)
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.us-east-1.amazonaws.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.us-east-1.amazonaws.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// endpoint override + non-uri safe endpoint + force path style
    #[test]
    fn test_106() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket!".to_string())
            .force_path_style(true)
            .accelerate(false)
            .use_dual_stack(false)
            .use_fips(true)
            .endpoint("http://foo.com".to_string())
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err(
            "expected error: A custom endpoint cannot be combined with FIPS [endpoint override + non-uri safe endpoint + force path style]",
        );
        assert_eq!(format!("{}", error), "A custom endpoint cannot be combined with FIPS")
    }

    /// FIPS + Dualstack + global endpoint + non-dns bucket
    #[test]
    fn test_107() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("bucket!".to_string())
            .accelerate(false)
            .use_dual_stack(true)
            .use_fips(true)
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// endpoint override + FIPS + dualstack
    #[test]
    fn test_108() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_dual_stack(true)
            .use_fips(true)
            .use_global_endpoint(true)
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [endpoint override + FIPS + dualstack]");
        assert_eq!(format!("{}", error), "Cannot set dual-stack in combination with a custom endpoint.")
    }

    /// non-bucket endpoint override + dualstack + global endpoint
    #[test]
    fn test_109() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .use_global_endpoint(true)
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [non-bucket endpoint override + dualstack + global endpoint]");
        assert_eq!(format!("{}", error), "Cannot set dual-stack in combination with a custom endpoint.")
    }

    /// Endpoint override + UseGlobalEndpoint + us-east-1
    #[test]
    fn test_110() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .use_global_endpoint(true)
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: A custom endpoint cannot be combined with FIPS [Endpoint override + UseGlobalEndpoint + us-east-1]");
        assert_eq!(format!("{}", error), "A custom endpoint cannot be combined with FIPS")
    }

    /// non-FIPS partition with FIPS set + custom endpoint
    #[test]
    fn test_111() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Partition does not support FIPS [non-FIPS partition with FIPS set + custom endpoint]");
        assert_eq!(format!("{}", error), "Partition does not support FIPS")
    }

    /// aws-global signs as us-east-1
    #[test]
    fn test_112() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket!".to_string())
            .use_fips(true)
            .accelerate(false)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// aws-global signs as us-east-1
    #[test]
    fn test_113() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .accelerate(false)
            .endpoint("https://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket.foo.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket.foo.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// aws-global + dualstack + path-only bucket
    #[test]
    fn test_114() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket!".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.dualstack.us-east-1.amazonaws.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.dualstack.us-east-1.amazonaws.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// aws-global + path-only bucket
    #[test]
    fn test_115() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket!".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.amazonaws.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.amazonaws.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// aws-global + fips + custom endpoint
    #[test]
    fn test_116() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket!".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .accelerate(false)
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: A custom endpoint cannot be combined with FIPS [aws-global + fips + custom endpoint]");
        assert_eq!(format!("{}", error), "A custom endpoint cannot be combined with FIPS")
    }

    /// aws-global, endpoint override & path only-bucket
    #[test]
    fn test_117() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket!".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .accelerate(false)
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://foo.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://foo.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// aws-global + dualstack + custom endpoint
    #[test]
    fn test_118() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .accelerate(false)
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [aws-global + dualstack + custom endpoint]");
        assert_eq!(format!("{}", error), "Cannot set dual-stack in combination with a custom endpoint.")
    }

    /// accelerate, dualstack + aws-global
    #[test]
    fn test_119() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .accelerate(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket.s3-accelerate.dualstack.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket.s3-accelerate.dualstack.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// FIPS + aws-global + path only bucket. This is not supported by S3 but we allow garbage in garbage out
    #[test]
    fn test_120() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket!".to_string())
            .force_path_style(true)
            .use_dual_stack(true)
            .use_fips(true)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// aws-global + FIPS + endpoint override.
    #[test]
    fn test_121() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .use_fips(true)
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: A custom endpoint cannot be combined with FIPS [aws-global + FIPS + endpoint override.]");
        assert_eq!(format!("{}", error), "A custom endpoint cannot be combined with FIPS")
    }

    /// force path style, FIPS, aws-global & endpoint override
    #[test]
    fn test_122() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket!".to_string())
            .force_path_style(true)
            .use_fips(true)
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: A custom endpoint cannot be combined with FIPS [force path style, FIPS, aws-global & endpoint override]");
        assert_eq!(format!("{}", error), "A custom endpoint cannot be combined with FIPS")
    }

    /// ip address causes path style to be forced
    #[test]
    fn test_123() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket".to_string())
            .endpoint("http://192.168.1.1".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://192.168.1.1/bucket");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://192.168.1.1/bucket")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// endpoint override with aws-global region
    #[test]
    fn test_124() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [endpoint override with aws-global region]");
        assert_eq!(format!("{}", error), "Cannot set dual-stack in combination with a custom endpoint.")
    }

    /// FIPS + path-only (TODO: consider making this an error)
    #[test]
    fn test_125() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .bucket("bucket!".to_string())
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.us-east-1.amazonaws.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.us-east-1.amazonaws.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// empty arn type
    #[test]
    fn test_126() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("arn:aws:not-s3:us-west-2:123456789012::myendpoint".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: No ARN type specified [empty arn type]");
        assert_eq!(format!("{}", error), "Invalid ARN: No ARN type specified")
    }

    /// path style can't be used with accelerate
    #[test]
    fn test_127() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("bucket!".to_string())
            .accelerate(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Path-style addressing cannot be used with S3 Accelerate [path style can't be used with accelerate]");
        assert_eq!(format!("{}", error), "Path-style addressing cannot be used with S3 Accelerate")
    }

    /// invalid region
    #[test]
    fn test_128() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2!".to_string())
            .bucket("bucket.subdomain".to_string())
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid region: region was not a valid DNS name. [invalid region]");
        assert_eq!(format!("{}", error), "Invalid region: region was not a valid DNS name.")
    }

    /// invalid region
    #[test]
    fn test_129() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2!".to_string())
            .bucket("bucket".to_string())
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid region: region was not a valid DNS name. [invalid region]");
        assert_eq!(format!("{}", error), "Invalid region: region was not a valid DNS name.")
    }

    /// empty arn type
    #[test]
    fn test_130() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("arn:aws:s3::123456789012:accesspoint:my_endpoint".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid Access Point Name [empty arn type]");
        assert_eq!(format!("{}", error), "Invalid Access Point Name")
    }

    /// empty arn type
    #[test]
    fn test_131() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("arn:aws:s3:cn-north-1:123456789012:accesspoint:my-endpoint".to_string())
            .use_arn_region(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Client was configured for partition `aws` but ARN (`arn:aws:s3:cn-north-1:123456789012:accesspoint:my-endpoint`) has `aws-cn` [empty arn type]");
        assert_eq!(
            format!("{}", error),
            "Client was configured for partition `aws` but ARN (`arn:aws:s3:cn-north-1:123456789012:accesspoint:my-endpoint`) has `aws-cn`"
        )
    }

    /// invalid arn region
    #[test]
    fn test_132() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("arn:aws:s3-object-lambda:us-east_2:123456789012:accesspoint:my-endpoint".to_string())
            .use_arn_region(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid region in ARN: `us-east_2` (invalid DNS name) [invalid arn region]");
        assert_eq!(format!("{}", error), "Invalid region in ARN: `us-east_2` (invalid DNS name)")
    }

    /// invalid ARN outpost
    #[test]
    fn test_133() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("arn:aws:s3-outposts:us-east-1:123456789012:outpost/op_01234567890123456/accesspoint/reports".to_string())
            .use_arn_region(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err(
            "expected error: Invalid ARN: The outpost Id may only contain a-z, A-Z, 0-9 and `-`. Found: `op_01234567890123456` [invalid ARN outpost]",
        );
        assert_eq!(
            format!("{}", error),
            "Invalid ARN: The outpost Id may only contain a-z, A-Z, 0-9 and `-`. Found: `op_01234567890123456`"
        )
    }

    /// invalid ARN
    #[test]
    fn test_134() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/reports".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: expected an access point name [invalid ARN]");
        assert_eq!(format!("{}", error), "Invalid ARN: expected an access point name")
    }

    /// invalid ARN
    #[test]
    fn test_135() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Expected a 4-component resource [invalid ARN]");
        assert_eq!(format!("{}", error), "Invalid ARN: Expected a 4-component resource")
    }

    /// invalid outpost type
    #[test]
    fn test_136() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/not-accesspoint/reports".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Expected an outpost type `accesspoint`, found not-accesspoint [invalid outpost type]");
        assert_eq!(format!("{}", error), "Expected an outpost type `accesspoint`, found not-accesspoint")
    }

    /// invalid outpost type
    #[test]
    fn test_137() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("arn:aws:s3-outposts:us-east_1:123456789012:outpost/op-01234567890123456/not-accesspoint/reports".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid region in ARN: `us-east_1` (invalid DNS name) [invalid outpost type]");
        assert_eq!(format!("{}", error), "Invalid region in ARN: `us-east_1` (invalid DNS name)")
    }

    /// invalid outpost type
    #[test]
    fn test_138() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("arn:aws:s3-outposts:us-east-1:12345_789012:outpost/op-01234567890123456/not-accesspoint/reports".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err(
            "expected error: Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `12345_789012` [invalid outpost type]",
        );
        assert_eq!(
            format!("{}", error),
            "Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `12345_789012`"
        )
    }

    /// invalid outpost type
    #[test]
    fn test_139() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("arn:aws:s3-outposts:us-east-1:12345789012:outpost".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: The Outpost Id was not set [invalid outpost type]");
        assert_eq!(format!("{}", error), "Invalid ARN: The Outpost Id was not set")
    }

    /// use global endpoint virtual addressing
    #[test]
    fn test_140() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("bucket".to_string())
            .endpoint("http://example.com".to_string())
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://bucket.example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://bucket.example.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingRegion".to_string(), "us-east-2".to_string().into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// global endpoint + ip address
    #[test]
    fn test_141() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("bucket".to_string())
            .endpoint("http://192.168.0.1".to_string())
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://192.168.0.1/bucket");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://192.168.0.1/bucket")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingRegion".to_string(), "us-east-2".to_string().into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// invalid outpost type
    #[test]
    fn test_142() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("bucket!".to_string())
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.us-east-2.amazonaws.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.us-east-2.amazonaws.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingRegion".to_string(), "us-east-2".to_string().into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// invalid outpost type
    #[test]
    fn test_143() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("bucket".to_string())
            .accelerate(true)
            .use_global_endpoint(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket.s3-accelerate.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket.s3-accelerate.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingRegion".to_string(), "us-east-2".to_string().into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// use global endpoint + custom endpoint
    #[test]
    fn test_144() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("bucket!".to_string())
            .use_global_endpoint(true)
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://foo.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://foo.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingRegion".to_string(), "us-east-2".to_string().into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// use global endpoint, not us-east-1, force path style
    #[test]
    fn test_145() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .bucket("bucket!".to_string())
            .use_global_endpoint(true)
            .force_path_style(true)
            .endpoint("http://foo.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://foo.com/bucket%21");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://foo.com/bucket%21")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingRegion".to_string(), "us-east-2".to_string().into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// vanilla virtual addressing@us-west-2
    #[test]
    fn test_146() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing + dualstack@us-west-2
    #[test]
    fn test_147() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("us-west-2".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3.dualstack.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3.dualstack.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// accelerate + dualstack@us-west-2
    #[test]
    fn test_148() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("us-west-2".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3-accelerate.dualstack.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3-accelerate.dualstack.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// accelerate (dualstack=false)@us-west-2
    #[test]
    fn test_149() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3-accelerate.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3-accelerate.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing + fips@us-west-2
    #[test]
    fn test_150() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3-fips.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3-fips.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing + dualstack + fips@us-west-2
    #[test]
    fn test_151() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("us-west-2".to_string())
            .use_dual_stack(true)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3-fips.dualstack.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3-fips.dualstack.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// accelerate + fips = error@us-west-2
    #[test]
    fn test_152() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Accelerate cannot be used with FIPS [accelerate + fips = error@us-west-2]");
        assert_eq!(format!("{}", error), "Accelerate cannot be used with FIPS")
    }

    /// vanilla virtual addressing@cn-north-1
    #[test]
    fn test_153() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3.cn-north-1.amazonaws.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3.cn-north-1.amazonaws.com.cn")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "cn-north-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing + dualstack@cn-north-1
    #[test]
    fn test_154() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("cn-north-1".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3.dualstack.cn-north-1.amazonaws.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3.dualstack.cn-north-1.amazonaws.com.cn")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "cn-north-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// accelerate (dualstack=false)@cn-north-1
    #[test]
    fn test_155() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3 Accelerate cannot be used in this region [accelerate (dualstack=false)@cn-north-1]");
        assert_eq!(format!("{}", error), "S3 Accelerate cannot be used in this region")
    }

    /// virtual addressing + fips@cn-north-1
    #[test]
    fn test_156() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Partition does not support FIPS [virtual addressing + fips@cn-north-1]");
        assert_eq!(format!("{}", error), "Partition does not support FIPS")
    }

    /// vanilla virtual addressing@af-south-1
    #[test]
    fn test_157() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3.af-south-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3.af-south-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing + dualstack@af-south-1
    #[test]
    fn test_158() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("af-south-1".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3.dualstack.af-south-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3.dualstack.af-south-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// accelerate + dualstack@af-south-1
    #[test]
    fn test_159() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("af-south-1".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3-accelerate.dualstack.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3-accelerate.dualstack.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// accelerate (dualstack=false)@af-south-1
    #[test]
    fn test_160() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3-accelerate.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3-accelerate.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing + fips@af-south-1
    #[test]
    fn test_161() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3-fips.af-south-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3-fips.af-south-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing + dualstack + fips@af-south-1
    #[test]
    fn test_162() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("af-south-1".to_string())
            .use_dual_stack(true)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.s3-fips.dualstack.af-south-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.s3-fips.dualstack.af-south-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// accelerate + fips = error@af-south-1
    #[test]
    fn test_163() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Accelerate cannot be used with FIPS [accelerate + fips = error@af-south-1]");
        assert_eq!(format!("{}", error), "Accelerate cannot be used with FIPS")
    }

    /// vanilla path style@us-west-2
    #[test]
    fn test_164() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.us-west-2.amazonaws.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.us-west-2.amazonaws.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// fips@us-gov-west-2, bucket is not S3-dns-compatible (subdomains)
    #[test]
    fn test_165() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket.with.dots".to_string())
            .region("us-gov-west-1".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.us-gov-west-1.amazonaws.com/bucket.with.dots");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.us-gov-west-1.amazonaws.com/bucket.with.dots")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-gov-west-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// path style + accelerate = error@us-west-2
    #[test]
    fn test_166() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Path-style addressing cannot be used with S3 Accelerate [path style + accelerate = error@us-west-2]");
        assert_eq!(format!("{}", error), "Path-style addressing cannot be used with S3 Accelerate")
    }

    /// path style + dualstack@us-west-2
    #[test]
    fn test_167() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .region("us-west-2".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.dualstack.us-west-2.amazonaws.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.dualstack.us-west-2.amazonaws.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// path style + arn is error@us-west-2
    #[test]
    fn test_168() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket".to_string())
            .force_path_style(true)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Path-style addressing cannot be used with ARN buckets [path style + arn is error@us-west-2]");
        assert_eq!(format!("{}", error), "Path-style addressing cannot be used with ARN buckets")
    }

    /// path style + invalid DNS name@us-west-2
    #[test]
    fn test_169() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("99a_b".to_string())
            .force_path_style(true)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.us-west-2.amazonaws.com/99a_b");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.us-west-2.amazonaws.com/99a_b")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// no path style + invalid DNS name@us-west-2
    #[test]
    fn test_170() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("99a_b".to_string())
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.us-west-2.amazonaws.com/99a_b");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.us-west-2.amazonaws.com/99a_b")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// vanilla path style@cn-north-1
    #[test]
    fn test_171() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.cn-north-1.amazonaws.com.cn/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.cn-north-1.amazonaws.com.cn/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "cn-north-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// path style + fips@cn-north-1
    #[test]
    fn test_172() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Partition does not support FIPS [path style + fips@cn-north-1]");
        assert_eq!(format!("{}", error), "Partition does not support FIPS")
    }

    /// path style + accelerate = error@cn-north-1
    #[test]
    fn test_173() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Path-style addressing cannot be used with S3 Accelerate [path style + accelerate = error@cn-north-1]");
        assert_eq!(format!("{}", error), "Path-style addressing cannot be used with S3 Accelerate")
    }

    /// path style + dualstack@cn-north-1
    #[test]
    fn test_174() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .region("cn-north-1".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.dualstack.cn-north-1.amazonaws.com.cn/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.dualstack.cn-north-1.amazonaws.com.cn/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "cn-north-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// path style + arn is error@cn-north-1
    #[test]
    fn test_175() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket".to_string())
            .force_path_style(true)
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Path-style addressing cannot be used with ARN buckets [path style + arn is error@cn-north-1]");
        assert_eq!(format!("{}", error), "Path-style addressing cannot be used with ARN buckets")
    }

    /// path style + invalid DNS name@cn-north-1
    #[test]
    fn test_176() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("99a_b".to_string())
            .force_path_style(true)
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.cn-north-1.amazonaws.com.cn/99a_b");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.cn-north-1.amazonaws.com.cn/99a_b")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "cn-north-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// no path style + invalid DNS name@cn-north-1
    #[test]
    fn test_177() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("99a_b".to_string())
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.cn-north-1.amazonaws.com.cn/99a_b");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.cn-north-1.amazonaws.com.cn/99a_b")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "cn-north-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// vanilla path style@af-south-1
    #[test]
    fn test_178() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.af-south-1.amazonaws.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.af-south-1.amazonaws.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// path style + fips@af-south-1
    #[test]
    fn test_179() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-fips.af-south-1.amazonaws.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-fips.af-south-1.amazonaws.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// path style + accelerate = error@af-south-1
    #[test]
    fn test_180() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Path-style addressing cannot be used with S3 Accelerate [path style + accelerate = error@af-south-1]");
        assert_eq!(format!("{}", error), "Path-style addressing cannot be used with S3 Accelerate")
    }

    /// path style + dualstack@af-south-1
    #[test]
    fn test_181() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .region("af-south-1".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.dualstack.af-south-1.amazonaws.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.dualstack.af-south-1.amazonaws.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// path style + arn is error@af-south-1
    #[test]
    fn test_182() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket".to_string())
            .force_path_style(true)
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Path-style addressing cannot be used with ARN buckets [path style + arn is error@af-south-1]");
        assert_eq!(format!("{}", error), "Path-style addressing cannot be used with ARN buckets")
    }

    /// path style + invalid DNS name@af-south-1
    #[test]
    fn test_183() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("99a_b".to_string())
            .force_path_style(true)
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.af-south-1.amazonaws.com/99a_b");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.af-south-1.amazonaws.com/99a_b")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// no path style + invalid DNS name@af-south-1
    #[test]
    fn test_184() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("99a_b".to_string())
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3.af-south-1.amazonaws.com/99a_b");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3.af-south-1.amazonaws.com/99a_b")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing + private link@us-west-2
    #[test]
    fn test_185() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .endpoint("http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// path style + private link@us-west-2
    #[test]
    fn test_186() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .endpoint("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// SDK::Host + FIPS@us-west-2
    #[test]
    fn test_187() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .endpoint("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: A custom endpoint cannot be combined with FIPS [SDK::Host + FIPS@us-west-2]");
        assert_eq!(format!("{}", error), "A custom endpoint cannot be combined with FIPS")
    }

    /// SDK::Host + DualStack@us-west-2
    #[test]
    fn test_188() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .endpoint("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("us-west-2".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [SDK::Host + DualStack@us-west-2]");
        assert_eq!(format!("{}", error), "Cannot set dual-stack in combination with a custom endpoint.")
    }

    /// SDK::HOST + accelerate@us-west-2
    #[test]
    fn test_189() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .endpoint("http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: A custom endpoint cannot be combined with S3 Accelerate [SDK::HOST + accelerate@us-west-2]");
        assert_eq!(format!("{}", error), "A custom endpoint cannot be combined with S3 Accelerate")
    }

    /// SDK::Host + access point ARN@us-west-2
    #[test]
    fn test_190() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .endpoint("https://beta.example.com".to_string())
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myendpoint-123456789012.beta.example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myendpoint-123456789012.beta.example.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing + private link@cn-north-1
    #[test]
    fn test_191() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .endpoint("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "cn-north-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// path style + private link@cn-north-1
    #[test]
    fn test_192() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .endpoint("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "cn-north-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// FIPS@cn-north-1
    #[test]
    fn test_193() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Partition does not support FIPS [FIPS@cn-north-1]");
        assert_eq!(format!("{}", error), "Partition does not support FIPS")
    }

    /// SDK::Host + DualStack@cn-north-1
    #[test]
    fn test_194() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .endpoint("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("cn-north-1".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [SDK::Host + DualStack@cn-north-1]");
        assert_eq!(format!("{}", error), "Cannot set dual-stack in combination with a custom endpoint.")
    }

    /// SDK::HOST + accelerate@cn-north-1
    #[test]
    fn test_195() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .endpoint("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: A custom endpoint cannot be combined with S3 Accelerate [SDK::HOST + accelerate@cn-north-1]");
        assert_eq!(format!("{}", error), "A custom endpoint cannot be combined with S3 Accelerate")
    }

    /// SDK::Host + access point ARN@cn-north-1
    #[test]
    fn test_196() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .endpoint("https://beta.example.com".to_string())
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myendpoint-123456789012.beta.example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myendpoint-123456789012.beta.example.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "cn-north-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// virtual addressing + private link@af-south-1
    #[test]
    fn test_197() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .endpoint("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// path style + private link@af-south-1
    #[test]
    fn test_198() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(true)
            .endpoint("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// SDK::Host + FIPS@af-south-1
    #[test]
    fn test_199() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .endpoint("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: A custom endpoint cannot be combined with FIPS [SDK::Host + FIPS@af-south-1]");
        assert_eq!(format!("{}", error), "A custom endpoint cannot be combined with FIPS")
    }

    /// SDK::Host + DualStack@af-south-1
    #[test]
    fn test_200() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .endpoint("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("af-south-1".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [SDK::Host + DualStack@af-south-1]");
        assert_eq!(format!("{}", error), "Cannot set dual-stack in combination with a custom endpoint.")
    }

    /// SDK::HOST + accelerate@af-south-1
    #[test]
    fn test_201() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("bucket-name".to_string())
            .force_path_style(false)
            .endpoint("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com".to_string())
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: A custom endpoint cannot be combined with S3 Accelerate [SDK::HOST + accelerate@af-south-1]");
        assert_eq!(format!("{}", error), "A custom endpoint cannot be combined with S3 Accelerate")
    }

    /// SDK::Host + access point ARN@af-south-1
    #[test]
    fn test_202() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .endpoint("https://beta.example.com".to_string())
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myendpoint-123456789012.beta.example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myendpoint-123456789012.beta.example.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// vanilla access point arn@us-west-2
    #[test]
    fn test_203() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// access point arn + FIPS@us-west-2
    #[test]
    fn test_204() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myendpoint-123456789012.s3-accesspoint-fips.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myendpoint-123456789012.s3-accesspoint-fips.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// access point arn + accelerate = error@us-west-2
    #[test]
    fn test_205() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Access Points do not support S3 Accelerate [access point arn + accelerate = error@us-west-2]");
        assert_eq!(format!("{}", error), "Access Points do not support S3 Accelerate")
    }

    /// access point arn + FIPS + DualStack@us-west-2
    #[test]
    fn test_206() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .region("us-west-2".to_string())
            .use_dual_stack(true)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// vanilla access point arn@cn-north-1
    #[test]
    fn test_207() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myendpoint-123456789012.s3-accesspoint.cn-north-1.amazonaws.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myendpoint-123456789012.s3-accesspoint.cn-north-1.amazonaws.com.cn")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "cn-north-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// access point arn + FIPS@cn-north-1
    #[test]
    fn test_208() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Partition does not support FIPS [access point arn + FIPS@cn-north-1]");
        assert_eq!(format!("{}", error), "Partition does not support FIPS")
    }

    /// access point arn + accelerate = error@cn-north-1
    #[test]
    fn test_209() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .region("cn-north-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Access Points do not support S3 Accelerate [access point arn + accelerate = error@cn-north-1]");
        assert_eq!(format!("{}", error), "Access Points do not support S3 Accelerate")
    }

    /// access point arn + FIPS + DualStack@cn-north-1
    #[test]
    fn test_210() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .region("cn-north-1".to_string())
            .use_dual_stack(true)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Partition does not support FIPS [access point arn + FIPS + DualStack@cn-north-1]");
        assert_eq!(format!("{}", error), "Partition does not support FIPS")
    }

    /// vanilla access point arn@af-south-1
    #[test]
    fn test_211() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myendpoint-123456789012.s3-accesspoint.af-south-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myendpoint-123456789012.s3-accesspoint.af-south-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// access point arn + FIPS@af-south-1
    #[test]
    fn test_212() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myendpoint-123456789012.s3-accesspoint-fips.af-south-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myendpoint-123456789012.s3-accesspoint-fips.af-south-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// access point arn + accelerate = error@af-south-1
    #[test]
    fn test_213() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .bucket("arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .region("af-south-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Access Points do not support S3 Accelerate [access point arn + accelerate = error@af-south-1]");
        assert_eq!(format!("{}", error), "Access Points do not support S3 Accelerate")
    }

    /// access point arn + FIPS + DualStack@af-south-1
    #[test]
    fn test_214() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint".to_string())
            .force_path_style(false)
            .region("af-south-1".to_string())
            .use_dual_stack(true)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.af-south-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.af-south-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "af-south-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// S3 outposts vanilla test
    #[test]
    fn test_215() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .bucket("arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://reports-123456789012.op-01234567890123456.s3-outposts.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://reports-123456789012.op-01234567890123456.s3-outposts.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4a".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegionSet".to_string(), vec!["*".to_string().into()].into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into(),
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into()
                    ]
                )
                .build()
        );
    }

    /// S3 outposts custom endpoint
    #[test]
    fn test_216() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .bucket("arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports".to_string())
            .endpoint("https://example.amazonaws.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://reports-123456789012.op-01234567890123456.example.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://reports-123456789012.op-01234567890123456.example.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4a".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegionSet".to_string(), vec!["*".to_string().into()].into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into(),
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into()
                    ]
                )
                .build()
        );
    }

    /// outposts arn with region mismatch and UseArnRegion=false
    #[test]
    fn test_217() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint".to_string())
            .force_path_style(false)
            .use_arn_region(false)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false` [outposts arn with region mismatch and UseArnRegion=false]");
        assert_eq!(
            format!("{}", error),
            "Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`"
        )
    }

    /// outposts arn with region mismatch, custom region and UseArnRegion=false
    #[test]
    fn test_218() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint".to_string())
            .endpoint("https://example.com".to_string())
            .force_path_style(false)
            .use_arn_region(false)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false` [outposts arn with region mismatch, custom region and UseArnRegion=false]");
        assert_eq!(
            format!("{}", error),
            "Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`"
        )
    }

    /// outposts arn with region mismatch and UseArnRegion=true
    #[test]
    fn test_219() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint".to_string())
            .force_path_style(false)
            .use_arn_region(true)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4a".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegionSet".to_string(), vec!["*".to_string().into()].into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into(),
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into()
                    ]
                )
                .build()
        );
    }

    /// outposts arn with region mismatch and UseArnRegion unset
    #[test]
    fn test_220() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint".to_string())
            .force_path_style(false)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4a".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegionSet".to_string(), vec!["*".to_string().into()].into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into(),
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into()
                    ]
                )
                .build()
        );
    }

    /// outposts arn with partition mismatch and UseArnRegion=true
    #[test]
    fn test_221() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint".to_string())
            .force_path_style(false)
            .use_arn_region(true)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Client was configured for partition `aws` but ARN (`arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint`) has `aws-cn` [outposts arn with partition mismatch and UseArnRegion=true]");
        assert_eq!(format!("{}", error), "Client was configured for partition `aws` but ARN (`arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint`) has `aws-cn`")
    }

    /// ARN with UseGlobalEndpoint and use-east-1 region uses the regional endpoint
    #[test]
    fn test_222() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_global_endpoint(true)
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .bucket("arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/accesspoint/reports".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://reports-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://reports-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4a".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegionSet".to_string(), vec!["*".to_string().into()].into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into(),
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into()
                    ]
                )
                .build()
        );
    }

    /// S3 outposts does not support dualstack
    #[test]
    fn test_223() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .accelerate(false)
            .bucket("arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3 Outposts does not support Dual-stack [S3 outposts does not support dualstack]");
        assert_eq!(format!("{}", error), "S3 Outposts does not support Dual-stack")
    }

    /// S3 outposts does not support fips
    #[test]
    fn test_224() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .bucket("arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3 Outposts does not support FIPS [S3 outposts does not support fips]");
        assert_eq!(format!("{}", error), "S3 Outposts does not support FIPS")
    }

    /// S3 outposts does not support accelerate
    #[test]
    fn test_225() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(true)
            .bucket("arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3 Outposts does not support S3 Accelerate [S3 outposts does not support accelerate]");
        assert_eq!(format!("{}", error), "S3 Outposts does not support S3 Accelerate")
    }

    /// validates against subresource
    #[test]
    fn test_226() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .bucket("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:mybucket:object:foo".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Invalid Arn: Outpost Access Point ARN contains sub resources [validates against subresource]");
        assert_eq!(format!("{}", error), "Invalid Arn: Outpost Access Point ARN contains sub resources")
    }

    /// object lambda @us-east-1
    #[test]
    fn test_227() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(false)
            .bucket("arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// object lambda @us-west-2
    #[test]
    fn test_228() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(false)
            .bucket("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// object lambda, colon resource deliminator @us-west-2
    #[test]
    fn test_229() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(false)
            .bucket("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// object lambda @us-east-1, client region us-west-2, useArnRegion=true
    #[test]
    fn test_230() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(true)
            .bucket("arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// object lambda @us-east-1, client region s3-external-1, useArnRegion=true
    #[test]
    fn test_231() {
        let params = crate::config::endpoint::Params::builder()
            .region("s3-external-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(true)
            .bucket("arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// object lambda @us-east-1, client region s3-external-1, useArnRegion=false
    #[test]
    fn test_232() {
        let params = crate::config::endpoint::Params::builder()
            .region("s3-external-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(false)
            .bucket("arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `s3-external-1` and UseArnRegion is `false` [object lambda @us-east-1, client region s3-external-1, useArnRegion=false]");
        assert_eq!(
            format!("{}", error),
            "Invalid configuration: region from ARN `us-east-1` does not match client region `s3-external-1` and UseArnRegion is `false`"
        )
    }

    /// object lambda @us-east-1, client region aws-global, useArnRegion=true
    #[test]
    fn test_233() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(true)
            .bucket("arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// object lambda @us-east-1, client region aws-global, useArnRegion=false
    #[test]
    fn test_234() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(false)
            .bucket("arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `aws-global` and UseArnRegion is `false` [object lambda @us-east-1, client region aws-global, useArnRegion=false]");
        assert_eq!(
            format!("{}", error),
            "Invalid configuration: region from ARN `us-east-1` does not match client region `aws-global` and UseArnRegion is `false`"
        )
    }

    /// object lambda @cn-north-1, client region us-west-2 (cross partition), useArnRegion=true
    #[test]
    fn test_235() {
        let params = crate::config::endpoint::Params::builder()
            .region("aws-global".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(true)
            .bucket("arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Client was configured for partition `aws` but ARN (`arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner`) has `aws-cn` [object lambda @cn-north-1, client region us-west-2 (cross partition), useArnRegion=true]");
        assert_eq!(format!("{}", error), "Client was configured for partition `aws` but ARN (`arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner`) has `aws-cn`")
    }

    /// object lambda with dualstack
    #[test]
    fn test_236() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .accelerate(false)
            .use_arn_region(false)
            .bucket("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3 Object Lambda does not support Dual-stack [object lambda with dualstack]");
        assert_eq!(format!("{}", error), "S3 Object Lambda does not support Dual-stack")
    }

    /// object lambda @us-gov-east-1
    #[test]
    fn test_237() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(false)
            .bucket("arn:aws-us-gov:s3-object-lambda:us-gov-east-1:123456789012:accesspoint/mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybanner-123456789012.s3-object-lambda.us-gov-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybanner-123456789012.s3-object-lambda.us-gov-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                        out.insert("signingRegion".to_string(), "us-gov-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// object lambda @us-gov-east-1, with fips
    #[test]
    fn test_238() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(false)
            .bucket("arn:aws-us-gov:s3-object-lambda:us-gov-east-1:123456789012:accesspoint/mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybanner-123456789012.s3-object-lambda-fips.us-gov-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybanner-123456789012.s3-object-lambda-fips.us-gov-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                        out.insert("signingRegion".to_string(), "us-gov-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// object lambda @cn-north-1, with fips
    #[test]
    fn test_239() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(false)
            .bucket("arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Partition does not support FIPS [object lambda @cn-north-1, with fips]");
        assert_eq!(format!("{}", error), "Partition does not support FIPS")
    }

    /// object lambda with accelerate
    #[test]
    fn test_240() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(true)
            .use_arn_region(false)
            .bucket("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3 Object Lambda does not support S3 Accelerate [object lambda with accelerate]");
        assert_eq!(format!("{}", error), "S3 Object Lambda does not support S3 Accelerate")
    }

    /// object lambda with invalid arn - bad service and someresource
    #[test]
    fn test_241() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(false)
            .bucket("arn:aws:sqs:us-west-2:123456789012:someresource".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Unrecognized format: arn:aws:sqs:us-west-2:123456789012:someresource (type: someresource) [object lambda with invalid arn - bad service and someresource]");
        assert_eq!(
            format!("{}", error),
            "Invalid ARN: Unrecognized format: arn:aws:sqs:us-west-2:123456789012:someresource (type: someresource)"
        )
    }

    /// object lambda with invalid arn - invalid resource
    #[test]
    fn test_242() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(false)
            .bucket("arn:aws:s3-object-lambda:us-west-2:123456789012:bucket_name:mybucket".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Object Lambda ARNs only support `accesspoint` arn types, but found: `bucket_name` [object lambda with invalid arn - invalid resource]");
        assert_eq!(
            format!("{}", error),
            "Invalid ARN: Object Lambda ARNs only support `accesspoint` arn types, but found: `bucket_name`"
        )
    }

    /// object lambda with invalid arn - missing region
    #[test]
    fn test_243() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(false)
            .bucket("arn:aws:s3-object-lambda::123456789012:accesspoint/mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Invalid ARN: bucket ARN is missing a region [object lambda with invalid arn - missing region]");
        assert_eq!(format!("{}", error), "Invalid ARN: bucket ARN is missing a region")
    }

    /// object lambda with invalid arn - missing account-id
    #[test]
    fn test_244() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(true)
            .bucket("arn:aws:s3-object-lambda:us-west-2::accesspoint/mybanner".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Missing account id [object lambda with invalid arn - missing account-id]");
        assert_eq!(format!("{}", error), "Invalid ARN: Missing account id")
    }

    /// object lambda with invalid arn - account id contains invalid characters
    #[test]
    fn test_245() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(true)
            .bucket("arn:aws:s3-object-lambda:us-west-2:123.45678.9012:accesspoint:mybucket".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123.45678.9012` [object lambda with invalid arn - account id contains invalid characters]");
        assert_eq!(
            format!("{}", error),
            "Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123.45678.9012`"
        )
    }

    /// object lambda with invalid arn - missing access point name
    #[test]
    fn test_246() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(true)
            .bucket("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided [object lambda with invalid arn - missing access point name]");
        assert_eq!(
            format!("{}", error),
            "Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided"
        )
    }

    /// object lambda with invalid arn - access point name contains invalid character: *
    #[test]
    fn test_247() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(true)
            .bucket("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:*".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `*` [object lambda with invalid arn - access point name contains invalid character: *]");
        assert_eq!(
            format!("{}", error),
            "Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `*`"
        )
    }

    /// object lambda with invalid arn - access point name contains invalid character: .
    #[test]
    fn test_248() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(true)
            .bucket("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:my.bucket".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `my.bucket` [object lambda with invalid arn - access point name contains invalid character: .]");
        assert_eq!(
            format!("{}", error),
            "Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `my.bucket`"
        )
    }

    /// object lambda with invalid arn - access point name contains sub resources
    #[test]
    fn test_249() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(true)
            .bucket("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:mybucket:object:foo".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: The ARN may only contain a single resource component after `accesspoint`. [object lambda with invalid arn - access point name contains sub resources]");
        assert_eq!(
            format!("{}", error),
            "Invalid ARN: The ARN may only contain a single resource component after `accesspoint`."
        )
    }

    /// object lambda with custom endpoint
    #[test]
    fn test_250() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_arn_region(false)
            .bucket("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner".to_string())
            .endpoint("https://my-endpoint.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybanner-123456789012.my-endpoint.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybanner-123456789012.my-endpoint.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// object lambda arn with region mismatch and UseArnRegion=false
    #[test]
    fn test_251() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .bucket("arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_string())
            .force_path_style(false)
            .use_arn_region(false)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false` [object lambda arn with region mismatch and UseArnRegion=false]");
        assert_eq!(
            format!("{}", error),
            "Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`"
        )
    }

    /// WriteGetObjectResponse @ us-west-2
    #[test]
    fn test_252() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .use_object_lambda_endpoint(true)
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-object-lambda.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-object-lambda.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// WriteGetObjectResponse with custom endpoint
    #[test]
    fn test_253() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .use_object_lambda_endpoint(true)
            .endpoint("https://my-endpoint.com".to_string())
            .region("us-west-2".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://my-endpoint.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://my-endpoint.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// WriteGetObjectResponse @ us-east-1
    #[test]
    fn test_254() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .use_object_lambda_endpoint(true)
            .region("us-east-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-object-lambda.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-object-lambda.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// WriteGetObjectResponse with fips
    #[test]
    fn test_255() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .use_object_lambda_endpoint(true)
            .region("us-east-1".to_string())
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-object-lambda-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-object-lambda-fips.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// WriteGetObjectResponse with dualstack
    #[test]
    fn test_256() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .use_object_lambda_endpoint(true)
            .region("us-east-1".to_string())
            .use_dual_stack(true)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3 Object Lambda does not support Dual-stack [WriteGetObjectResponse with dualstack]");
        assert_eq!(format!("{}", error), "S3 Object Lambda does not support Dual-stack")
    }

    /// WriteGetObjectResponse with accelerate
    #[test]
    fn test_257() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(true)
            .use_object_lambda_endpoint(true)
            .region("us-east-1".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3 Object Lambda does not support S3 Accelerate [WriteGetObjectResponse with accelerate]");
        assert_eq!(format!("{}", error), "S3 Object Lambda does not support S3 Accelerate")
    }

    /// WriteGetObjectResponse with fips in CN
    #[test]
    fn test_258() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .region("cn-north-1".to_string())
            .use_object_lambda_endpoint(true)
            .use_dual_stack(false)
            .use_fips(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Partition does not support FIPS [WriteGetObjectResponse with fips in CN]");
        assert_eq!(format!("{}", error), "Partition does not support FIPS")
    }

    /// WriteGetObjectResponse with invalid partition
    #[test]
    fn test_259() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .use_object_lambda_endpoint(true)
            .region("not a valid DNS name".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Invalid region: region was not a valid DNS name. [WriteGetObjectResponse with invalid partition]");
        assert_eq!(format!("{}", error), "Invalid region: region was not a valid DNS name.")
    }

    /// WriteGetObjectResponse with an unknown partition
    #[test]
    fn test_260() {
        let params = crate::config::endpoint::Params::builder()
            .accelerate(false)
            .use_object_lambda_endpoint(true)
            .region("us-east.special".to_string())
            .use_dual_stack(false)
            .use_fips(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3-object-lambda.us-east.special.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3-object-lambda.us-east.special.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out.insert("signingRegion".to_string(), "us-east.special".to_string().into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// S3 Outposts bucketAlias Real Outpost Prod us-west-1
    #[test]
    fn test_261() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-1".to_string())
            .bucket("test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.op-0b1d075431d83bebd.s3-outposts.us-west-1.amazonaws.com");
        assert_eq!(endpoint, ::aws_smithy_types::endpoint::Endpoint::builder().url("https://test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.op-0b1d075431d83bebd.s3-outposts.us-west-1.amazonaws.com")
    .property("authSchemes", vec![ {
        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
        out.insert("name".to_string(), "sigv4a".to_string().into());
        out.insert("signingName".to_string(), "s3-outposts".to_string().into());
        out.insert("signingRegionSet".to_string(), vec!["*".to_string().into()].into());
        out.insert("disableDoubleEncoding".to_string(), true.into());
        out
    }.into()
    , {
        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
        out.insert("name".to_string(), "sigv4".to_string().into());
        out.insert("signingName".to_string(), "s3-outposts".to_string().into());
        out.insert("signingRegion".to_string(), "us-west-1".to_string().into());
        out.insert("disableDoubleEncoding".to_string(), true.into());
        out
    }.into()])
    .build());
    }

    /// S3 Outposts bucketAlias Real Outpost Prod ap-east-1
    #[test]
    fn test_262() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-east-1".to_string())
            .bucket("test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.op-0b1d075431d83bebd.s3-outposts.ap-east-1.amazonaws.com");
        assert_eq!(endpoint, ::aws_smithy_types::endpoint::Endpoint::builder().url("https://test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.op-0b1d075431d83bebd.s3-outposts.ap-east-1.amazonaws.com")
    .property("authSchemes", vec![ {
        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
        out.insert("name".to_string(), "sigv4a".to_string().into());
        out.insert("signingName".to_string(), "s3-outposts".to_string().into());
        out.insert("signingRegionSet".to_string(), vec!["*".to_string().into()].into());
        out.insert("disableDoubleEncoding".to_string(), true.into());
        out
    }.into()
    , {
        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
        out.insert("name".to_string(), "sigv4".to_string().into());
        out.insert("signingName".to_string(), "s3-outposts".to_string().into());
        out.insert("signingRegion".to_string(), "ap-east-1".to_string().into());
        out.insert("disableDoubleEncoding".to_string(), true.into());
        out
    }.into()])
    .build());
    }

    /// S3 Outposts bucketAlias Ec2 Outpost Prod us-east-1
    #[test]
    fn test_263() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("test-accessp-e0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://test-accessp-e0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.ec2.s3-outposts.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://test-accessp-e0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.ec2.s3-outposts.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4a".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegionSet".to_string(), vec!["*".to_string().into()].into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into(),
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into()
                    ]
                )
                .build()
        );
    }

    /// S3 Outposts bucketAlias Ec2 Outpost Prod me-south-1
    #[test]
    fn test_264() {
        let params = crate::config::endpoint::Params::builder()
            .region("me-south-1".to_string())
            .bucket("test-accessp-e0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://test-accessp-e0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.ec2.s3-outposts.me-south-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://test-accessp-e0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.ec2.s3-outposts.me-south-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4a".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegionSet".to_string(), vec!["*".to_string().into()].into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into(),
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegion".to_string(), "me-south-1".to_string().into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into()
                    ]
                )
                .build()
        );
    }

    /// S3 Outposts bucketAlias Real Outpost Beta
    #[test]
    fn test_265() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kbeta0--op-s3".to_string())
            .endpoint("https://example.amazonaws.com".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kbeta0--op-s3.op-0b1d075431d83bebd.example.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kbeta0--op-s3.op-0b1d075431d83bebd.example.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4a".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegionSet".to_string(), vec!["*".to_string().into()].into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into(),
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into()
                    ]
                )
                .build()
        );
    }

    /// S3 Outposts bucketAlias Ec2 Outpost Beta
    #[test]
    fn test_266() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("161743052723-e00000136899934034jeahy1t8gpzpbwjj8kb7beta0--op-s3".to_string())
            .endpoint("https://example.amazonaws.com".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint
            .expect("Expected valid endpoint: https://161743052723-e00000136899934034jeahy1t8gpzpbwjj8kb7beta0--op-s3.ec2.example.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://161743052723-e00000136899934034jeahy1t8gpzpbwjj8kb7beta0--op-s3.ec2.example.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4a".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegionSet".to_string(), vec!["*".to_string().into()].into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into(),
                        {
                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                            out.insert("name".to_string(), "sigv4".to_string().into());
                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                            out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                            out.insert("disableDoubleEncoding".to_string(), true.into());
                            out
                        }
                        .into()
                    ]
                )
                .build()
        );
    }

    /// S3 Outposts bucketAlias - No endpoint set for beta
    #[test]
    fn test_267() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kbeta0--op-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err(
            "expected error: Expected a endpoint to be specified but no endpoint was found [S3 Outposts bucketAlias - No endpoint set for beta]",
        );
        assert_eq!(format!("{}", error), "Expected a endpoint to be specified but no endpoint was found")
    }

    /// S3 Outposts bucketAlias Invalid hardware type
    #[test]
    fn test_268() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("test-accessp-h0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err(
            "expected error: Unrecognized hardware type: \"Expected hardware type o or e but got h\" [S3 Outposts bucketAlias Invalid hardware type]",
        );
        assert_eq!(
            format!("{}", error),
            "Unrecognized hardware type: \"Expected hardware type o or e but got h\""
        )
    }

    /// S3 Outposts bucketAlias Special character in Outpost Arn
    #[test]
    fn test_269() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("test-accessp-o00000754%1d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`. [S3 Outposts bucketAlias Special character in Outpost Arn]");
        assert_eq!(
            format!("{}", error),
            "Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`."
        )
    }

    /// S3 Outposts bucketAlias - No endpoint set for beta
    #[test]
    fn test_270() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("test-accessp-e0b1d075431d83bebde8xz5w8ijx1qzlbp3i3ebeta0--op-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err(
            "expected error: Expected a endpoint to be specified but no endpoint was found [S3 Outposts bucketAlias - No endpoint set for beta]",
        );
        assert_eq!(format!("{}", error), "Expected a endpoint to be specified but no endpoint was found")
    }

    /// S3 Snow with bucket
    #[test]
    fn test_271() {
        let params = crate::config::endpoint::Params::builder()
            .region("snow".to_string())
            .bucket("bucketName".to_string())
            .endpoint("http://10.0.1.12:433".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://10.0.1.12:433/bucketName");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://10.0.1.12:433/bucketName")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "snow".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// S3 Snow without bucket
    #[test]
    fn test_272() {
        let params = crate::config::endpoint::Params::builder()
            .region("snow".to_string())
            .endpoint("https://10.0.1.12:433".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://10.0.1.12:433");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://10.0.1.12:433")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "snow".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// S3 Snow no port
    #[test]
    fn test_273() {
        let params = crate::config::endpoint::Params::builder()
            .region("snow".to_string())
            .bucket("bucketName".to_string())
            .endpoint("http://10.0.1.12".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: http://10.0.1.12/bucketName");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("http://10.0.1.12/bucketName")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "snow".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// S3 Snow dns endpoint
    #[test]
    fn test_274() {
        let params = crate::config::endpoint::Params::builder()
            .region("snow".to_string())
            .bucket("bucketName".to_string())
            .endpoint("https://amazonaws.com".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://amazonaws.com/bucketName");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://amazonaws.com/bucketName")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3".to_string().into());
                        out.insert("signingRegion".to_string(), "snow".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .build()
        );
    }

    /// Data Plane with short zone name
    #[test]
    fn test_275() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("mybucket--abcd-ab1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybucket--abcd-ab1--x-s3.s3express-abcd-ab1.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--abcd-ab1--x-s3.s3express-abcd-ab1.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with short zone name china region
    #[test]
    fn test_276() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .bucket("mybucket--abcd-ab1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybucket--abcd-ab1--x-s3.s3express-abcd-ab1.cn-north-1.amazonaws.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--abcd-ab1--x-s3.s3express-abcd-ab1.cn-north-1.amazonaws.com.cn")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "cn-north-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with short zone name with AP
    #[test]
    fn test_277() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("myaccesspoint--abcd-ab1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myaccesspoint--abcd-ab1--xa-s3.s3express-abcd-ab1.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--abcd-ab1--xa-s3.s3express-abcd-ab1.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with short zone name with AP china region
    #[test]
    fn test_278() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .bucket("myaccesspoint--abcd-ab1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myaccesspoint--abcd-ab1--xa-s3.s3express-abcd-ab1.cn-north-1.amazonaws.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--abcd-ab1--xa-s3.s3express-abcd-ab1.cn-north-1.amazonaws.com.cn")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "cn-north-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with short zone names (13 chars)
    #[test]
    fn test_279() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test-zone-ab1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://mybucket--test-zone-ab1--x-s3.s3express-test-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test-zone-ab1--x-s3.s3express-test-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with short zone names (13 chars) with AP
    #[test]
    fn test_280() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test-zone-ab1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myaccesspoint--test-zone-ab1--xa-s3.s3express-test-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test-zone-ab1--xa-s3.s3express-test-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with medium zone names (14 chars)
    #[test]
    fn test_281() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test1-zone-ab1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://mybucket--test1-zone-ab1--x-s3.s3express-test1-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test1-zone-ab1--x-s3.s3express-test1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with medium zone names (14 chars) with AP
    #[test]
    fn test_282() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test1-zone-ab1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myaccesspoint--test1-zone-ab1--xa-s3.s3express-test1-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test1-zone-ab1--xa-s3.s3express-test1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with long zone names (20 chars)
    #[test]
    fn test_283() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test1-long1-zone-ab1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint
            .expect("Expected valid endpoint: https://mybucket--test1-long1-zone-ab1--x-s3.s3express-test1-long1-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test1-long1-zone-ab1--x-s3.s3express-test1-long1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with long zone names (20 chars)
    #[test]
    fn test_284() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test1-long1-zone-ab1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect(
            "Expected valid endpoint: https://myaccesspoint--test1-long1-zone-ab1--xa-s3.s3express-test1-long1-zone-ab1.us-west-2.amazonaws.com",
        );
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test1-long1-zone-ab1--xa-s3.s3express-test1-long1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with short zone fips
    #[test]
    fn test_285() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("mybucket--test-ab1--x-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybucket--test-ab1--x-s3.s3express-fips-test-ab1.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test-ab1--x-s3.s3express-fips-test-ab1.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with short zone fips china region
    #[test]
    fn test_286() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .bucket("mybucket--test-ab1--x-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Partition does not support FIPS [Data Plane with short zone fips china region]");
        assert_eq!(format!("{}", error), "Partition does not support FIPS")
    }

    /// Data Plane with short zone fips with AP
    #[test]
    fn test_287() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("myaccesspoint--test-ab1--xa-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myaccesspoint--test-ab1--xa-s3.s3express-fips-test-ab1.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test-ab1--xa-s3.s3express-fips-test-ab1.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with short zone fips with AP china region
    #[test]
    fn test_288() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .bucket("myaccesspoint--test-ab1--xa-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Partition does not support FIPS [Data Plane with short zone fips with AP china region]");
        assert_eq!(format!("{}", error), "Partition does not support FIPS")
    }

    /// Data Plane with short zone (13 chars) fips
    #[test]
    fn test_289() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test-zone-ab1--x-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://mybucket--test-zone-ab1--x-s3.s3express-fips-test-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test-zone-ab1--x-s3.s3express-fips-test-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with short zone (13 chars) fips with AP
    #[test]
    fn test_290() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test-zone-ab1--xa-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint
            .expect("Expected valid endpoint: https://myaccesspoint--test-zone-ab1--xa-s3.s3express-fips-test-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test-zone-ab1--xa-s3.s3express-fips-test-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with medium zone (14 chars) fips
    #[test]
    fn test_291() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test1-zone-ab1--x-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://mybucket--test1-zone-ab1--x-s3.s3express-fips-test1-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test1-zone-ab1--x-s3.s3express-fips-test1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with medium zone (14 chars) fips with AP
    #[test]
    fn test_292() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test1-zone-ab1--xa-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint
            .expect("Expected valid endpoint: https://myaccesspoint--test1-zone-ab1--xa-s3.s3express-fips-test1-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test1-zone-ab1--xa-s3.s3express-fips-test1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with long zone (20 chars) fips
    #[test]
    fn test_293() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test1-long1-zone-ab1--x-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect(
            "Expected valid endpoint: https://mybucket--test1-long1-zone-ab1--x-s3.s3express-fips-test1-long1-zone-ab1.us-west-2.amazonaws.com",
        );
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test1-long1-zone-ab1--x-s3.s3express-fips-test1-long1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with long zone (20 chars) fips with AP
    #[test]
    fn test_294() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test1-long1-zone-ab1--xa-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect(
            "Expected valid endpoint: https://myaccesspoint--test1-long1-zone-ab1--xa-s3.s3express-fips-test1-long1-zone-ab1.us-west-2.amazonaws.com",
        );
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test1-long1-zone-ab1--xa-s3.s3express-fips-test1-long1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with long AZ
    #[test]
    fn test_295() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test1-az1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybucket--test1-az1--x-s3.s3express-test1-az1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test1-az1--x-s3.s3express-test1-az1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with long AZ with AP
    #[test]
    fn test_296() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test1-az1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myaccesspoint--test1-az1--xa-s3.s3express-test1-az1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test1-az1--xa-s3.s3express-test1-az1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with long AZ fips
    #[test]
    fn test_297() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test1-az1--x-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybucket--test1-az1--x-s3.s3express-fips-test1-az1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test1-az1--x-s3.s3express-fips-test1-az1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane with long AZ fips with AP
    #[test]
    fn test_298() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test1-az1--xa-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myaccesspoint--test1-az1--xa-s3.s3express-fips-test1-az1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test1-az1--xa-s3.s3express-fips-test1-az1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Control plane with short AZ bucket
    #[test]
    fn test_299() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("mybucket--test-ab1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(true)
            .disable_s3_express_session_auth(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3express-control.us-east-1.amazonaws.com/mybucket--test-ab1--x-s3");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3express-control.us-east-1.amazonaws.com/mybucket--test-ab1--x-s3")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Control plane with short AZ bucket china region
    #[test]
    fn test_300() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .bucket("mybucket--test-ab1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(true)
            .disable_s3_express_session_auth(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3express-control.cn-north-1.amazonaws.com.cn/mybucket--test-ab1--x-s3");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3express-control.cn-north-1.amazonaws.com.cn/mybucket--test-ab1--x-s3")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "cn-north-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Control plane with short AZ bucket and fips
    #[test]
    fn test_301() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("mybucket--test-ab1--x-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(true)
            .disable_s3_express_session_auth(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3express-control-fips.us-east-1.amazonaws.com/mybucket--test-ab1--x-s3");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3express-control-fips.us-east-1.amazonaws.com/mybucket--test-ab1--x-s3")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Control plane with short AZ bucket and fips china region
    #[test]
    fn test_302() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .bucket("mybucket--test-ab1--x-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(true)
            .disable_s3_express_session_auth(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Partition does not support FIPS [Control plane with short AZ bucket and fips china region]");
        assert_eq!(format!("{}", error), "Partition does not support FIPS")
    }

    /// Control plane without bucket
    #[test]
    fn test_303() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(true)
            .disable_s3_express_session_auth(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3express-control.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3express-control.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Control plane without bucket and fips
    #[test]
    fn test_304() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(true)
            .disable_s3_express_session_auth(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://s3express-control-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://s3express-control-fips.us-east-1.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with short AZ
    #[test]
    fn test_305() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--usw2-az1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybucket--usw2-az1--x-s3.s3express-usw2-az1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--usw2-az1--x-s3.s3express-usw2-az1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with short AZ with AP
    #[test]
    fn test_306() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--usw2-az1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myaccesspoint--usw2-az1--xa-s3.s3express-usw2-az1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--usw2-az1--xa-s3.s3express-usw2-az1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with short zone (13 chars)
    #[test]
    fn test_307() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test-zone-ab1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://mybucket--test-zone-ab1--x-s3.s3express-test-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test-zone-ab1--x-s3.s3express-test-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with short zone (13 chars) with AP
    #[test]
    fn test_308() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test-zone-ab1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myaccesspoint--test-zone-ab1--xa-s3.s3express-test-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test-zone-ab1--xa-s3.s3express-test-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with short AZ fips
    #[test]
    fn test_309() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--usw2-az1--x-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybucket--usw2-az1--x-s3.s3express-fips-usw2-az1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--usw2-az1--x-s3.s3express-fips-usw2-az1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with short AZ fips with AP
    #[test]
    fn test_310() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--usw2-az1--xa-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myaccesspoint--usw2-az1--xa-s3.s3express-fips-usw2-az1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--usw2-az1--xa-s3.s3express-fips-usw2-az1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with short zone (13 chars) fips
    #[test]
    fn test_311() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test-zone-ab1--x-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://mybucket--test-zone-ab1--x-s3.s3express-fips-test-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test-zone-ab1--x-s3.s3express-fips-test-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with short zone (13 chars) fips with AP
    #[test]
    fn test_312() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test-zone-ab1--xa-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint
            .expect("Expected valid endpoint: https://myaccesspoint--test-zone-ab1--xa-s3.s3express-fips-test-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test-zone-ab1--xa-s3.s3express-fips-test-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with long AZ
    #[test]
    fn test_313() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test1-az1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybucket--test1-az1--x-s3.s3express-test1-az1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test1-az1--x-s3.s3express-test1-az1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with long AZ with AP
    #[test]
    fn test_314() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test1-az1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myaccesspoint--test1-az1--xa-s3.s3express-test1-az1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test1-az1--xa-s3.s3express-test1-az1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with medium zone(14 chars)
    #[test]
    fn test_315() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test1-zone-ab1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://mybucket--test1-zone-ab1--x-s3.s3express-test1-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test1-zone-ab1--x-s3.s3express-test1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with medium zone(14 chars) with AP
    #[test]
    fn test_316() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test1-zone-ab1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myaccesspoint--test1-zone-ab1--xa-s3.s3express-test1-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test1-zone-ab1--xa-s3.s3express-test1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with long zone(20 chars)
    #[test]
    fn test_317() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test1-long1-zone-ab1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint
            .expect("Expected valid endpoint: https://mybucket--test1-long1-zone-ab1--x-s3.s3express-test1-long1-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test1-long1-zone-ab1--x-s3.s3express-test1-long1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with long zone(20 chars) with AP
    #[test]
    fn test_318() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test1-long1-zone-ab1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect(
            "Expected valid endpoint: https://myaccesspoint--test1-long1-zone-ab1--xa-s3.s3express-test1-long1-zone-ab1.us-west-2.amazonaws.com",
        );
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test1-long1-zone-ab1--xa-s3.s3express-test1-long1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with long AZ fips
    #[test]
    fn test_319() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test1-az1--x-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybucket--test1-az1--x-s3.s3express-fips-test1-az1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test1-az1--x-s3.s3express-fips-test1-az1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with long AZ fips with AP
    #[test]
    fn test_320() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test1-az1--xa-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://myaccesspoint--test1-az1--xa-s3.s3express-fips-test1-az1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test1-az1--xa-s3.s3express-fips-test1-az1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with medium zone (14 chars) fips
    #[test]
    fn test_321() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test1-zone-ab1--x-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint =
            endpoint.expect("Expected valid endpoint: https://mybucket--test1-zone-ab1--x-s3.s3express-fips-test1-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test1-zone-ab1--x-s3.s3express-fips-test1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with medium zone (14 chars) fips with AP
    #[test]
    fn test_322() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test1-zone-ab1--xa-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint
            .expect("Expected valid endpoint: https://myaccesspoint--test1-zone-ab1--xa-s3.s3express-fips-test1-zone-ab1.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test1-zone-ab1--xa-s3.s3express-fips-test1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with long zone (20 chars) fips
    #[test]
    fn test_323() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--test1-long1-zone-ab1--x-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect(
            "Expected valid endpoint: https://mybucket--test1-long1-zone-ab1--x-s3.s3express-fips-test1-long1-zone-ab1.us-west-2.amazonaws.com",
        );
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--test1-long1-zone-ab1--x-s3.s3express-fips-test1-long1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data Plane sigv4 auth with long zone (20 chars) fips with AP
    #[test]
    fn test_324() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--test1-long1-zone-ab1--xa-s3".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect(
            "Expected valid endpoint: https://myaccesspoint--test1-long1-zone-ab1--xa-s3.s3express-fips-test1-long1-zone-ab1.us-west-2.amazonaws.com",
        );
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--test1-long1-zone-ab1--xa-s3.s3express-fips-test1-long1-zone-ab1.us-west-2.amazonaws.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Control Plane host override
    #[test]
    fn test_325() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--usw2-az1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(true)
            .disable_s3_express_session_auth(true)
            .endpoint("https://custom.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybucket--usw2-az1--x-s3.custom.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--usw2-az1--x-s3.custom.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Control Plane host override with AP
    #[test]
    fn test_326() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--usw2-az1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(true)
            .disable_s3_express_session_auth(true)
            .endpoint("https://custom.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myaccesspoint--usw2-az1--xa-s3.custom.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--usw2-az1--xa-s3.custom.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Control Plane host override no bucket
    #[test]
    fn test_327() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(true)
            .disable_s3_express_session_auth(true)
            .endpoint("https://custom.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://custom.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://custom.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data plane host override non virtual session auth
    #[test]
    fn test_328() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--usw2-az1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .endpoint("https://10.0.0.1".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://10.0.0.1/mybucket--usw2-az1--x-s3");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://10.0.0.1/mybucket--usw2-az1--x-s3")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data plane host override non virtual session auth with AP
    #[test]
    fn test_329() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--usw2-az1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .endpoint("https://10.0.0.1".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://10.0.0.1/myaccesspoint--usw2-az1--xa-s3");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://10.0.0.1/myaccesspoint--usw2-az1--xa-s3")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Control Plane host override ip
    #[test]
    fn test_330() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--usw2-az1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(true)
            .disable_s3_express_session_auth(true)
            .endpoint("https://10.0.0.1".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://10.0.0.1/mybucket--usw2-az1--x-s3");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://10.0.0.1/mybucket--usw2-az1--x-s3")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Control Plane host override ip with AP
    #[test]
    fn test_331() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--usw2-az1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(true)
            .disable_s3_express_session_auth(true)
            .endpoint("https://10.0.0.1".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://10.0.0.1/myaccesspoint--usw2-az1--xa-s3");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://10.0.0.1/myaccesspoint--usw2-az1--xa-s3")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data plane host override
    #[test]
    fn test_332() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("mybucket--usw2-az1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .endpoint("https://custom.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://mybucket--usw2-az1--x-s3.custom.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://mybucket--usw2-az1--x-s3.custom.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// Data plane host override with AP
    #[test]
    fn test_333() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("myaccesspoint--usw2-az1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .endpoint("https://custom.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://myaccesspoint--usw2-az1--xa-s3.custom.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://myaccesspoint--usw2-az1--xa-s3.custom.com")
                .property(
                    "authSchemes",
                    vec![{
                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                        out.insert("signingName".to_string(), "s3express".to_string().into());
                        out.insert("signingRegion".to_string(), "us-west-2".to_string().into());
                        out.insert("disableDoubleEncoding".to_string(), true.into());
                        out
                    }
                    .into()]
                )
                .property("backend", "S3Express".to_string())
                .build()
        );
    }

    /// bad format error
    #[test]
    fn test_334() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("mybucket--usaz1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Unrecognized S3Express bucket name format. [bad format error]");
        assert_eq!(format!("{}", error), "Unrecognized S3Express bucket name format.")
    }

    /// bad AP format error
    #[test]
    fn test_335() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("myaccesspoint--usaz1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Unrecognized S3Express bucket name format. [bad AP format error]");
        assert_eq!(format!("{}", error), "Unrecognized S3Express bucket name format.")
    }

    /// bad format error no session auth
    #[test]
    fn test_336() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("mybucket--usaz1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Unrecognized S3Express bucket name format. [bad format error no session auth]");
        assert_eq!(format!("{}", error), "Unrecognized S3Express bucket name format.")
    }

    /// bad AP format error no session auth
    #[test]
    fn test_337() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("myaccesspoint--usaz1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Unrecognized S3Express bucket name format. [bad AP format error no session auth]");
        assert_eq!(format!("{}", error), "Unrecognized S3Express bucket name format.")
    }

    /// dual-stack error
    #[test]
    fn test_338() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("mybucket--test-ab1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3Express does not support Dual-stack. [dual-stack error]");
        assert_eq!(format!("{}", error), "S3Express does not support Dual-stack.")
    }

    /// dual-stack error with AP
    #[test]
    fn test_339() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("myaccesspoint--test-ab1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3Express does not support Dual-stack. [dual-stack error with AP]");
        assert_eq!(format!("{}", error), "S3Express does not support Dual-stack.")
    }

    /// accelerate error
    #[test]
    fn test_340() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("mybucket--test-ab1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(true)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3Express does not support S3 Accelerate. [accelerate error]");
        assert_eq!(format!("{}", error), "S3Express does not support S3 Accelerate.")
    }

    /// accelerate error with AP
    #[test]
    fn test_341() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("myaccesspoint--test-ab1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(true)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3Express does not support S3 Accelerate. [accelerate error with AP]");
        assert_eq!(format!("{}", error), "S3Express does not support S3 Accelerate.")
    }

    /// Data plane bucket format error
    #[test]
    fn test_342() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("my.bucket--test-ab1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: S3Express bucket name is not a valid virtual hostable name. [Data plane bucket format error]");
        assert_eq!(format!("{}", error), "S3Express bucket name is not a valid virtual hostable name.")
    }

    /// Data plane AP format error
    #[test]
    fn test_343() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .bucket("my.myaccesspoint--test-ab1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .use_s3_express_control_endpoint(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: S3Express bucket name is not a valid virtual hostable name. [Data plane AP format error]");
        assert_eq!(format!("{}", error), "S3Express bucket name is not a valid virtual hostable name.")
    }

    /// host override data plane bucket error session auth
    #[test]
    fn test_344() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("my.bucket--usw2-az1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .endpoint("https://custom.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err(
            "expected error: S3Express bucket name is not a valid virtual hostable name. [host override data plane bucket error session auth]",
        );
        assert_eq!(format!("{}", error), "S3Express bucket name is not a valid virtual hostable name.")
    }

    /// host override data plane AP error session auth
    #[test]
    fn test_345() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("my.myaccesspoint--usw2-az1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .endpoint("https://custom.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err(
            "expected error: S3Express bucket name is not a valid virtual hostable name. [host override data plane AP error session auth]",
        );
        assert_eq!(format!("{}", error), "S3Express bucket name is not a valid virtual hostable name.")
    }

    /// host override data plane bucket error
    #[test]
    fn test_346() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("my.bucket--usw2-az1--x-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .endpoint("https://custom.com".to_string())
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: S3Express bucket name is not a valid virtual hostable name. [host override data plane bucket error]");
        assert_eq!(format!("{}", error), "S3Express bucket name is not a valid virtual hostable name.")
    }

    /// host override data plane AP error
    #[test]
    fn test_347() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .bucket("my.myaccesspoint--usw2-az1--xa-s3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .accelerate(false)
            .endpoint("https://custom.com".to_string())
            .disable_s3_express_session_auth(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: S3Express bucket name is not a valid virtual hostable name. [host override data plane AP error]");
        assert_eq!(format!("{}", error), "S3Express bucket name is not a valid virtual hostable name.")
    }
}

/// Endpoint resolver trait specific to Amazon Simple Storage Service
pub trait ResolveEndpoint: ::std::marker::Send + ::std::marker::Sync + ::std::fmt::Debug {
    /// Resolve an endpoint with the given parameters
    fn resolve_endpoint<'a>(&'a self, params: &'a crate::config::endpoint::Params) -> ::aws_smithy_runtime_api::client::endpoint::EndpointFuture<'a>;

    /// Convert this service-specific resolver into a `SharedEndpointResolver`
    ///
    /// The resulting resolver will downcast `EndpointResolverParams` into `crate::config::endpoint::Params`.
    fn into_shared_resolver(self) -> ::aws_smithy_runtime_api::client::endpoint::SharedEndpointResolver
    where
        Self: Sized + 'static,
    {
        ::aws_smithy_runtime_api::client::endpoint::SharedEndpointResolver::new(DowncastParams(self))
    }
}

#[derive(Debug)]
struct DowncastParams<T>(T);
impl<T> ::aws_smithy_runtime_api::client::endpoint::ResolveEndpoint for DowncastParams<T>
where
    T: ResolveEndpoint,
{
    fn resolve_endpoint<'a>(
        &'a self,
        params: &'a ::aws_smithy_runtime_api::client::endpoint::EndpointResolverParams,
    ) -> ::aws_smithy_runtime_api::client::endpoint::EndpointFuture<'a> {
        let ep = match params.get::<crate::config::endpoint::Params>() {
            Some(params) => self.0.resolve_endpoint(params),
            None => ::aws_smithy_runtime_api::client::endpoint::EndpointFuture::ready(Err("params of expected type was not present".into())),
        };
        ep
    }
}

/// The default endpoint resolver
#[derive(Debug, Default)]
pub struct DefaultResolver {
    partition_resolver: crate::endpoint_lib::partition::PartitionResolver,
}

impl DefaultResolver {
    /// Create a new endpoint resolver with default settings
    pub fn new() -> Self {
        Self {
            partition_resolver: crate::endpoint_lib::DEFAULT_PARTITION_RESOLVER.clone(),
        }
    }

    fn resolve_endpoint(
        &self,
        params: &crate::config::endpoint::Params,
    ) -> ::std::result::Result<::aws_smithy_types::endpoint::Endpoint, ::aws_smithy_runtime_api::box_error::BoxError> {
        let mut diagnostic_collector = crate::endpoint_lib::diagnostic::DiagnosticCollector::new();
        Ok(
            crate::config::endpoint::internals::resolve_endpoint(params, &mut diagnostic_collector, &self.partition_resolver)
                .map_err(|err| err.with_source(diagnostic_collector.take_last_error()))?,
        )
    }
}

impl crate::config::endpoint::ResolveEndpoint for DefaultResolver {
    fn resolve_endpoint(&self, params: &crate::config::endpoint::Params) -> ::aws_smithy_runtime_api::client::endpoint::EndpointFuture {
        ::aws_smithy_runtime_api::client::endpoint::EndpointFuture::ready(self.resolve_endpoint(params))
    }
}

#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
/// Configuration parameters for resolving the correct endpoint
pub struct Params {
    /// The S3 bucket used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 bucket.
    pub(crate) bucket: ::std::option::Option<::std::string::String>,
    /// The AWS region used to dispatch the request.
    pub(crate) region: ::std::option::Option<::std::string::String>,
    /// When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
    pub(crate) use_fips: bool,
    /// When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
    pub(crate) use_dual_stack: bool,
    /// Override the endpoint used to send this request
    pub(crate) endpoint: ::std::option::Option<::std::string::String>,
    /// When true, force a path-style endpoint to be used where the bucket name is part of the path.
    pub(crate) force_path_style: bool,
    /// When true, use S3 Accelerate. NOTE: Not all regions support S3 accelerate.
    pub(crate) accelerate: bool,
    /// Whether the global endpoint should be used, rather then the regional endpoint for us-east-1.
    pub(crate) use_global_endpoint: bool,
    /// Internal parameter to use object lambda endpoint for an operation (eg: WriteGetObjectResponse)
    pub(crate) use_object_lambda_endpoint: ::std::option::Option<bool>,
    /// The S3 Key used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 Key.
    pub(crate) key: ::std::option::Option<::std::string::String>,
    /// The S3 Prefix used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 Prefix.
    pub(crate) prefix: ::std::option::Option<::std::string::String>,
    /// The Copy Source used for Copy Object request. This is an optional parameter that will be set automatically for operations that are scoped to Copy Source.
    pub(crate) copy_source: ::std::option::Option<::std::string::String>,
    /// Internal parameter to disable Access Point Buckets
    pub(crate) disable_access_points: ::std::option::Option<bool>,
    /// Whether multi-region access points (MRAP) should be disabled.
    pub(crate) disable_multi_region_access_points: bool,
    /// When an Access Point ARN is provided and this flag is enabled, the SDK MUST use the ARN's region when constructing the endpoint instead of the client's configured region.
    pub(crate) use_arn_region: ::std::option::Option<bool>,
    /// Internal parameter to indicate whether S3Express operation should use control plane, (ex. CreateBucket)
    pub(crate) use_s3_express_control_endpoint: ::std::option::Option<bool>,
    /// Parameter to indicate whether S3Express session auth should be disabled
    pub(crate) disable_s3_express_session_auth: ::std::option::Option<bool>,
}
impl Params {
    /// Create a builder for [`Params`]
    pub fn builder() -> crate::config::endpoint::ParamsBuilder {
        crate::config::endpoint::ParamsBuilder::default()
    }
    /// The S3 bucket used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 bucket.
    pub fn bucket(&self) -> ::std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// The AWS region used to dispatch the request.
    pub fn region(&self) -> ::std::option::Option<&str> {
        self.region.as_deref()
    }
    /// When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
    pub fn use_fips(&self) -> ::std::option::Option<bool> {
        Some(self.use_fips)
    }
    /// When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
    pub fn use_dual_stack(&self) -> ::std::option::Option<bool> {
        Some(self.use_dual_stack)
    }
    /// Override the endpoint used to send this request
    pub fn endpoint(&self) -> ::std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// When true, force a path-style endpoint to be used where the bucket name is part of the path.
    pub fn force_path_style(&self) -> ::std::option::Option<bool> {
        Some(self.force_path_style)
    }
    /// When true, use S3 Accelerate. NOTE: Not all regions support S3 accelerate.
    pub fn accelerate(&self) -> ::std::option::Option<bool> {
        Some(self.accelerate)
    }
    /// Whether the global endpoint should be used, rather then the regional endpoint for us-east-1.
    pub fn use_global_endpoint(&self) -> ::std::option::Option<bool> {
        Some(self.use_global_endpoint)
    }
    /// Internal parameter to use object lambda endpoint for an operation (eg: WriteGetObjectResponse)
    pub fn use_object_lambda_endpoint(&self) -> ::std::option::Option<bool> {
        self.use_object_lambda_endpoint
    }
    /// The S3 Key used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 Key.
    pub fn key(&self) -> ::std::option::Option<&str> {
        self.key.as_deref()
    }
    /// The S3 Prefix used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 Prefix.
    pub fn prefix(&self) -> ::std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// The Copy Source used for Copy Object request. This is an optional parameter that will be set automatically for operations that are scoped to Copy Source.
    pub fn copy_source(&self) -> ::std::option::Option<&str> {
        self.copy_source.as_deref()
    }
    /// Internal parameter to disable Access Point Buckets
    pub fn disable_access_points(&self) -> ::std::option::Option<bool> {
        self.disable_access_points
    }
    /// Whether multi-region access points (MRAP) should be disabled.
    pub fn disable_multi_region_access_points(&self) -> ::std::option::Option<bool> {
        Some(self.disable_multi_region_access_points)
    }
    /// When an Access Point ARN is provided and this flag is enabled, the SDK MUST use the ARN's region when constructing the endpoint instead of the client's configured region.
    pub fn use_arn_region(&self) -> ::std::option::Option<bool> {
        self.use_arn_region
    }
    /// Internal parameter to indicate whether S3Express operation should use control plane, (ex. CreateBucket)
    pub fn use_s3_express_control_endpoint(&self) -> ::std::option::Option<bool> {
        self.use_s3_express_control_endpoint
    }
    /// Parameter to indicate whether S3Express session auth should be disabled
    pub fn disable_s3_express_session_auth(&self) -> ::std::option::Option<bool> {
        self.disable_s3_express_session_auth
    }
}

/// Builder for [`Params`]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct ParamsBuilder {
    bucket: ::std::option::Option<::std::string::String>,
    region: ::std::option::Option<::std::string::String>,
    use_fips: ::std::option::Option<bool>,
    use_dual_stack: ::std::option::Option<bool>,
    endpoint: ::std::option::Option<::std::string::String>,
    force_path_style: ::std::option::Option<bool>,
    accelerate: ::std::option::Option<bool>,
    use_global_endpoint: ::std::option::Option<bool>,
    use_object_lambda_endpoint: ::std::option::Option<bool>,
    key: ::std::option::Option<::std::string::String>,
    prefix: ::std::option::Option<::std::string::String>,
    copy_source: ::std::option::Option<::std::string::String>,
    disable_access_points: ::std::option::Option<bool>,
    disable_multi_region_access_points: ::std::option::Option<bool>,
    use_arn_region: ::std::option::Option<bool>,
    use_s3_express_control_endpoint: ::std::option::Option<bool>,
    disable_s3_express_session_auth: ::std::option::Option<bool>,
}
impl ParamsBuilder {
    /// Consume this builder, creating [`Params`].
    pub fn build(self) -> ::std::result::Result<crate::config::endpoint::Params, crate::config::endpoint::InvalidParams> {
        Ok(
            #[allow(clippy::unnecessary_lazy_evaluations)]
            crate::config::endpoint::Params {
                bucket: self.bucket,
                region: self.region,
                use_fips: self
                    .use_fips
                    .or_else(|| Some(false))
                    .ok_or_else(|| crate::config::endpoint::InvalidParams::missing("use_fips"))?,
                use_dual_stack: self
                    .use_dual_stack
                    .or_else(|| Some(false))
                    .ok_or_else(|| crate::config::endpoint::InvalidParams::missing("use_dual_stack"))?,
                endpoint: self.endpoint,
                force_path_style: self
                    .force_path_style
                    .or_else(|| Some(false))
                    .ok_or_else(|| crate::config::endpoint::InvalidParams::missing("force_path_style"))?,
                accelerate: self
                    .accelerate
                    .or_else(|| Some(false))
                    .ok_or_else(|| crate::config::endpoint::InvalidParams::missing("accelerate"))?,
                use_global_endpoint: self
                    .use_global_endpoint
                    .or_else(|| Some(false))
                    .ok_or_else(|| crate::config::endpoint::InvalidParams::missing("use_global_endpoint"))?,
                use_object_lambda_endpoint: self.use_object_lambda_endpoint,
                key: self.key,
                prefix: self.prefix,
                copy_source: self.copy_source,
                disable_access_points: self.disable_access_points,
                disable_multi_region_access_points: self
                    .disable_multi_region_access_points
                    .or_else(|| Some(false))
                    .ok_or_else(|| crate::config::endpoint::InvalidParams::missing("disable_multi_region_access_points"))?,
                use_arn_region: self.use_arn_region,
                use_s3_express_control_endpoint: self.use_s3_express_control_endpoint,
                disable_s3_express_session_auth: self.disable_s3_express_session_auth,
            },
        )
    }
    /// Sets the value for bucket
    ///
    /// The S3 bucket used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 bucket.
    pub fn bucket(mut self, value: impl Into<::std::string::String>) -> Self {
        self.bucket = Some(value.into());
        self
    }

    /// Sets the value for bucket
    ///
    /// The S3 bucket used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 bucket.
    pub fn set_bucket(mut self, param: Option<::std::string::String>) -> Self {
        self.bucket = param;
        self
    }
    /// Sets the value for region
    ///
    /// The AWS region used to dispatch the request.
    pub fn region(mut self, value: impl Into<::std::string::String>) -> Self {
        self.region = Some(value.into());
        self
    }

    /// Sets the value for region
    ///
    /// The AWS region used to dispatch the request.
    pub fn set_region(mut self, param: Option<::std::string::String>) -> Self {
        self.region = param;
        self
    }
    /// Sets the value for use_fips
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
    pub fn use_fips(mut self, value: impl Into<bool>) -> Self {
        self.use_fips = Some(value.into());
        self
    }

    /// Sets the value for use_fips
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
    pub fn set_use_fips(mut self, param: Option<bool>) -> Self {
        self.use_fips = param;
        self
    }
    /// Sets the value for use_dual_stack
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
    pub fn use_dual_stack(mut self, value: impl Into<bool>) -> Self {
        self.use_dual_stack = Some(value.into());
        self
    }

    /// Sets the value for use_dual_stack
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
    pub fn set_use_dual_stack(mut self, param: Option<bool>) -> Self {
        self.use_dual_stack = param;
        self
    }
    /// Sets the value for endpoint
    ///
    /// Override the endpoint used to send this request
    pub fn endpoint(mut self, value: impl Into<::std::string::String>) -> Self {
        self.endpoint = Some(value.into());
        self
    }

    /// Sets the value for endpoint
    ///
    /// Override the endpoint used to send this request
    pub fn set_endpoint(mut self, param: Option<::std::string::String>) -> Self {
        self.endpoint = param;
        self
    }
    /// Sets the value for force_path_style
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, force a path-style endpoint to be used where the bucket name is part of the path.
    pub fn force_path_style(mut self, value: impl Into<bool>) -> Self {
        self.force_path_style = Some(value.into());
        self
    }

    /// Sets the value for force_path_style
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, force a path-style endpoint to be used where the bucket name is part of the path.
    pub fn set_force_path_style(mut self, param: Option<bool>) -> Self {
        self.force_path_style = param;
        self
    }
    /// Sets the value for accelerate
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, use S3 Accelerate. NOTE: Not all regions support S3 accelerate.
    pub fn accelerate(mut self, value: impl Into<bool>) -> Self {
        self.accelerate = Some(value.into());
        self
    }

    /// Sets the value for accelerate
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, use S3 Accelerate. NOTE: Not all regions support S3 accelerate.
    pub fn set_accelerate(mut self, param: Option<bool>) -> Self {
        self.accelerate = param;
        self
    }
    /// Sets the value for use_global_endpoint
    ///
    /// When unset, this parameter has a default value of `false`.
    /// Whether the global endpoint should be used, rather then the regional endpoint for us-east-1.
    pub fn use_global_endpoint(mut self, value: impl Into<bool>) -> Self {
        self.use_global_endpoint = Some(value.into());
        self
    }

    /// Sets the value for use_global_endpoint
    ///
    /// When unset, this parameter has a default value of `false`.
    /// Whether the global endpoint should be used, rather then the regional endpoint for us-east-1.
    pub fn set_use_global_endpoint(mut self, param: Option<bool>) -> Self {
        self.use_global_endpoint = param;
        self
    }
    /// Sets the value for use_object_lambda_endpoint
    ///
    /// Internal parameter to use object lambda endpoint for an operation (eg: WriteGetObjectResponse)
    pub fn use_object_lambda_endpoint(mut self, value: impl Into<bool>) -> Self {
        self.use_object_lambda_endpoint = Some(value.into());
        self
    }

    /// Sets the value for use_object_lambda_endpoint
    ///
    /// Internal parameter to use object lambda endpoint for an operation (eg: WriteGetObjectResponse)
    pub fn set_use_object_lambda_endpoint(mut self, param: Option<bool>) -> Self {
        self.use_object_lambda_endpoint = param;
        self
    }
    /// Sets the value for key
    ///
    /// The S3 Key used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 Key.
    pub fn key(mut self, value: impl Into<::std::string::String>) -> Self {
        self.key = Some(value.into());
        self
    }

    /// Sets the value for key
    ///
    /// The S3 Key used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 Key.
    pub fn set_key(mut self, param: Option<::std::string::String>) -> Self {
        self.key = param;
        self
    }
    /// Sets the value for prefix
    ///
    /// The S3 Prefix used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 Prefix.
    pub fn prefix(mut self, value: impl Into<::std::string::String>) -> Self {
        self.prefix = Some(value.into());
        self
    }

    /// Sets the value for prefix
    ///
    /// The S3 Prefix used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 Prefix.
    pub fn set_prefix(mut self, param: Option<::std::string::String>) -> Self {
        self.prefix = param;
        self
    }
    /// Sets the value for copy_source
    ///
    /// The Copy Source used for Copy Object request. This is an optional parameter that will be set automatically for operations that are scoped to Copy Source.
    pub fn copy_source(mut self, value: impl Into<::std::string::String>) -> Self {
        self.copy_source = Some(value.into());
        self
    }

    /// Sets the value for copy_source
    ///
    /// The Copy Source used for Copy Object request. This is an optional parameter that will be set automatically for operations that are scoped to Copy Source.
    pub fn set_copy_source(mut self, param: Option<::std::string::String>) -> Self {
        self.copy_source = param;
        self
    }
    /// Sets the value for disable_access_points
    ///
    /// Internal parameter to disable Access Point Buckets
    pub fn disable_access_points(mut self, value: impl Into<bool>) -> Self {
        self.disable_access_points = Some(value.into());
        self
    }

    /// Sets the value for disable_access_points
    ///
    /// Internal parameter to disable Access Point Buckets
    pub fn set_disable_access_points(mut self, param: Option<bool>) -> Self {
        self.disable_access_points = param;
        self
    }
    /// Sets the value for disable_multi_region_access_points
    ///
    /// When unset, this parameter has a default value of `false`.
    /// Whether multi-region access points (MRAP) should be disabled.
    pub fn disable_multi_region_access_points(mut self, value: impl Into<bool>) -> Self {
        self.disable_multi_region_access_points = Some(value.into());
        self
    }

    /// Sets the value for disable_multi_region_access_points
    ///
    /// When unset, this parameter has a default value of `false`.
    /// Whether multi-region access points (MRAP) should be disabled.
    pub fn set_disable_multi_region_access_points(mut self, param: Option<bool>) -> Self {
        self.disable_multi_region_access_points = param;
        self
    }
    /// Sets the value for use_arn_region
    ///
    /// When an Access Point ARN is provided and this flag is enabled, the SDK MUST use the ARN's region when constructing the endpoint instead of the client's configured region.
    pub fn use_arn_region(mut self, value: impl Into<bool>) -> Self {
        self.use_arn_region = Some(value.into());
        self
    }

    /// Sets the value for use_arn_region
    ///
    /// When an Access Point ARN is provided and this flag is enabled, the SDK MUST use the ARN's region when constructing the endpoint instead of the client's configured region.
    pub fn set_use_arn_region(mut self, param: Option<bool>) -> Self {
        self.use_arn_region = param;
        self
    }
    /// Sets the value for use_s3_express_control_endpoint
    ///
    /// Internal parameter to indicate whether S3Express operation should use control plane, (ex. CreateBucket)
    pub fn use_s3_express_control_endpoint(mut self, value: impl Into<bool>) -> Self {
        self.use_s3_express_control_endpoint = Some(value.into());
        self
    }

    /// Sets the value for use_s3_express_control_endpoint
    ///
    /// Internal parameter to indicate whether S3Express operation should use control plane, (ex. CreateBucket)
    pub fn set_use_s3_express_control_endpoint(mut self, param: Option<bool>) -> Self {
        self.use_s3_express_control_endpoint = param;
        self
    }
    /// Sets the value for disable_s3_express_session_auth
    ///
    /// Parameter to indicate whether S3Express session auth should be disabled
    pub fn disable_s3_express_session_auth(mut self, value: impl Into<bool>) -> Self {
        self.disable_s3_express_session_auth = Some(value.into());
        self
    }

    /// Sets the value for disable_s3_express_session_auth
    ///
    /// Parameter to indicate whether S3Express session auth should be disabled
    pub fn set_disable_s3_express_session_auth(mut self, param: Option<bool>) -> Self {
        self.disable_s3_express_session_auth = param;
        self
    }
}

/// An error that occurred during endpoint resolution
#[derive(Debug)]
pub struct InvalidParams {
    field: std::borrow::Cow<'static, str>,
}

impl InvalidParams {
    #[allow(dead_code)]
    fn missing(field: &'static str) -> Self {
        Self { field: field.into() }
    }
}

impl std::fmt::Display for InvalidParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "a required field was missing: `{}`", self.field)
    }
}

impl std::error::Error for InvalidParams {}

mod internals;
