
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTimeEdit.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QTimeEdit>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QCalendar>
#include <QCalendarWidget>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDate>
#include <QDateTime>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEnterEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLineEdit>
#include <QLocale>
#include <QMargins>
#include <QMetaMethod>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QPointF>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QScreen>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOptionSpinBox>
#include <QTabletEvent>
#include <QThread>
#include <QTime>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTimeEdit

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTimeEdit::staticMetaObject);
}


// static QString QTimeEdit::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QTimeEdit::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QTimeEdit () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QTimeEdit::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QDate > ("dateChanged(QDate)", "dateChanged", gsi::arg("date"), "@brief Signal declaration for QTimeEdit::dateChanged(QDate date)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QDateTime & > ("dateTimeChanged(const QDateTime &)", "dateTimeChanged", gsi::arg("dateTime"), "@brief Signal declaration for QTimeEdit::dateTimeChanged(const QDateTime &dateTime)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QTimeEdit::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("editingFinished()", "editingFinished", "@brief Signal declaration for QTimeEdit::editingFinished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QTimeEdit::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QTime > ("timeChanged(QTime)", "timeChanged", gsi::arg("time"), "@brief Signal declaration for QTimeEdit::timeChanged(QTime time)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QTime > ("userTimeChanged(QTime)", "userTimeChanged", gsi::arg("time"), "@brief Signal declaration for QTimeEdit::userTimeChanged(QTime time)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QTimeEdit::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QTimeEdit::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QTimeEdit::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTimeEdit::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QDateTimeEdit> &qtdecl_QDateTimeEdit ();

qt_gsi::QtNativeClass<QTimeEdit> decl_QTimeEdit (qtdecl_QDateTimeEdit (), "QtWidgets", "QTimeEdit_Native",
  methods_QTimeEdit (),
  "@hide\n@alias QTimeEdit");

GSI_QTWIDGETS_PUBLIC gsi::Class<QTimeEdit> &qtdecl_QTimeEdit () { return decl_QTimeEdit; }

}


class QTimeEdit_Adaptor : public QTimeEdit, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTimeEdit_Adaptor();

  //  [adaptor ctor] QTimeEdit::QTimeEdit(QWidget *parent)
  QTimeEdit_Adaptor() : QTimeEdit()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTimeEdit::QTimeEdit(QWidget *parent)
  QTimeEdit_Adaptor(QWidget *parent) : QTimeEdit(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTimeEdit::QTimeEdit(QTime time, QWidget *parent)
  QTimeEdit_Adaptor(QTime time) : QTimeEdit(time)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTimeEdit::QTimeEdit(QTime time, QWidget *parent)
  QTimeEdit_Adaptor(QTime time, QWidget *parent) : QTimeEdit(time, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QTimeEdit::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QTimeEdit_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QTimeEdit::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QTimeEdit::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QTimeEdit_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QTimeEdit::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QTimeEdit::focusNextChild()
  bool fp_QTimeEdit_focusNextChild_0 () {
    return QTimeEdit::focusNextChild();
  }

  //  [expose] bool QTimeEdit::focusPreviousChild()
  bool fp_QTimeEdit_focusPreviousChild_0 () {
    return QTimeEdit::focusPreviousChild();
  }

  //  [expose] bool QTimeEdit::isSignalConnected(const QMetaMethod &signal)
  bool fp_QTimeEdit_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QTimeEdit::isSignalConnected(signal);
  }

  //  [expose] QLineEdit *QTimeEdit::lineEdit()
  QLineEdit * fp_QTimeEdit_lineEdit_c0 () const {
    return QTimeEdit::lineEdit();
  }

  //  [expose] int QTimeEdit::receivers(const char *signal)
  int fp_QTimeEdit_receivers_c1731 (const char *signal) const {
    return QTimeEdit::receivers(signal);
  }

  //  [expose] QObject *QTimeEdit::sender()
  QObject * fp_QTimeEdit_sender_c0 () const {
    return QTimeEdit::sender();
  }

  //  [expose] int QTimeEdit::senderSignalIndex()
  int fp_QTimeEdit_senderSignalIndex_c0 () const {
    return QTimeEdit::senderSignalIndex();
  }

  //  [expose] void QTimeEdit::setLineEdit(QLineEdit *edit)
  void fp_QTimeEdit_setLineEdit_1485 (QLineEdit *edit) {
    QTimeEdit::setLineEdit(edit);
  }

  //  [expose] void QTimeEdit::updateMicroFocus(Qt::InputMethodQuery query)
  void fp_QTimeEdit_updateMicroFocus_2420 (const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) {
    QTimeEdit::updateMicroFocus(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  //  [adaptor impl] void QTimeEdit::clear()
  void cbs_clear_0_0()
  {
    QTimeEdit::clear();
  }

  virtual void clear()
  {
    if (cb_clear_0_0.can_issue()) {
      cb_clear_0_0.issue<QTimeEdit_Adaptor>(&QTimeEdit_Adaptor::cbs_clear_0_0);
    } else {
      QTimeEdit::clear();
    }
  }

  //  [emitter impl] void QTimeEdit::customContextMenuRequested(const QPoint &pos)
  void emitter_QTimeEdit_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QTimeEdit::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QTimeEdit::dateChanged(QDate date)
  void emitter_QTimeEdit_dateChanged_899(QDate date)
  {
    emit QTimeEdit::dateChanged(date);
  }

  //  [emitter impl] void QTimeEdit::dateTimeChanged(const QDateTime &dateTime)
  void emitter_QTimeEdit_dateTimeChanged_2175(const QDateTime &dateTime)
  {
    emit QTimeEdit::dateTimeChanged(dateTime);
  }

  //  [emitter impl] void QTimeEdit::destroyed(QObject *)
  void emitter_QTimeEdit_destroyed_1302(QObject *arg1)
  {
    emit QTimeEdit::destroyed(arg1);
  }

  //  [emitter impl] void QTimeEdit::editingFinished()
  void emitter_QTimeEdit_editingFinished_0()
  {
    emit QTimeEdit::editingFinished();
  }

  //  [adaptor impl] bool QTimeEdit::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QTimeEdit::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTimeEdit_Adaptor, bool, QEvent *>(&QTimeEdit_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QTimeEdit::event(_event);
    }
  }

  //  [adaptor impl] bool QTimeEdit::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QTimeEdit::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTimeEdit_Adaptor, bool, QObject *, QEvent *>(&QTimeEdit_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QTimeEdit::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QTimeEdit::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QTimeEdit::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QTimeEdit_Adaptor, bool>(&QTimeEdit_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QTimeEdit::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QTimeEdit::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QTimeEdit::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QTimeEdit_Adaptor, int, int>(&QTimeEdit_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QTimeEdit::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QTimeEdit::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QTimeEdit::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QTimeEdit_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QTimeEdit_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QTimeEdit::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QTimeEdit::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QTimeEdit::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QTimeEdit_Adaptor, QSize>(&QTimeEdit_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QTimeEdit::minimumSizeHint();
    }
  }

  //  [emitter impl] void QTimeEdit::objectNameChanged(const QString &objectName)
  void emitter_QTimeEdit_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QTimeEdit::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QPaintEngine *QTimeEdit::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QTimeEdit::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QTimeEdit_Adaptor, QPaintEngine *>(&QTimeEdit_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QTimeEdit::paintEngine();
    }
  }

  //  [adaptor impl] void QTimeEdit::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QTimeEdit::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QTimeEdit_Adaptor, bool>(&QTimeEdit_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QTimeEdit::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QTimeEdit::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QTimeEdit::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QTimeEdit_Adaptor, QSize>(&QTimeEdit_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QTimeEdit::sizeHint();
    }
  }

  //  [adaptor impl] void QTimeEdit::stepBy(int steps)
  void cbs_stepBy_767_0(int steps)
  {
    QTimeEdit::stepBy(steps);
  }

  virtual void stepBy(int steps)
  {
    if (cb_stepBy_767_0.can_issue()) {
      cb_stepBy_767_0.issue<QTimeEdit_Adaptor, int>(&QTimeEdit_Adaptor::cbs_stepBy_767_0, steps);
    } else {
      QTimeEdit::stepBy(steps);
    }
  }

  //  [emitter impl] void QTimeEdit::timeChanged(QTime time)
  void emitter_QTimeEdit_timeChanged_916(QTime time)
  {
    emit QTimeEdit::timeChanged(time);
  }

  //  [emitter impl] void QTimeEdit::userTimeChanged(QTime time)
  void emitter_QTimeEdit_userTimeChanged_916(QTime time)
  {
    emit QTimeEdit::userTimeChanged(time);
  }

  //  [emitter impl] void QTimeEdit::windowIconChanged(const QIcon &icon)
  void emitter_QTimeEdit_windowIconChanged_1787(const QIcon &icon)
  {
    emit QTimeEdit::windowIconChanged(icon);
  }

  //  [emitter impl] void QTimeEdit::windowIconTextChanged(const QString &iconText)
  void emitter_QTimeEdit_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QTimeEdit::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QTimeEdit::windowTitleChanged(const QString &title)
  void emitter_QTimeEdit_windowTitleChanged_2025(const QString &title)
  {
    emit QTimeEdit::windowTitleChanged(title);
  }

  //  [adaptor impl] void QTimeEdit::actionEvent(QActionEvent *event)
  void cbs_actionEvent_1823_0(QActionEvent *event)
  {
    QTimeEdit::actionEvent(event);
  }

  virtual void actionEvent(QActionEvent *event)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QTimeEdit_Adaptor, QActionEvent *>(&QTimeEdit_Adaptor::cbs_actionEvent_1823_0, event);
    } else {
      QTimeEdit::actionEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::changeEvent(QEvent *event)
  void cbs_changeEvent_1217_0(QEvent *event)
  {
    QTimeEdit::changeEvent(event);
  }

  virtual void changeEvent(QEvent *event)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QTimeEdit_Adaptor, QEvent *>(&QTimeEdit_Adaptor::cbs_changeEvent_1217_0, event);
    } else {
      QTimeEdit::changeEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QTimeEdit::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTimeEdit_Adaptor, QChildEvent *>(&QTimeEdit_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QTimeEdit::childEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QTimeEdit::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QTimeEdit_Adaptor, QCloseEvent *>(&QTimeEdit_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QTimeEdit::closeEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::contextMenuEvent(QContextMenuEvent *event)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *event)
  {
    QTimeEdit::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QTimeEdit_Adaptor, QContextMenuEvent *>(&QTimeEdit_Adaptor::cbs_contextMenuEvent_2363_0, event);
    } else {
      QTimeEdit::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QTimeEdit::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTimeEdit_Adaptor, QEvent *>(&QTimeEdit_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QTimeEdit::customEvent(event);
    }
  }

  //  [adaptor impl] QDateTime QTimeEdit::dateTimeFromText(const QString &text)
  QDateTime cbs_dateTimeFromText_c2025_0(const QString &text) const
  {
    return QTimeEdit::dateTimeFromText(text);
  }

  virtual QDateTime dateTimeFromText(const QString &text) const
  {
    if (cb_dateTimeFromText_c2025_0.can_issue()) {
      return cb_dateTimeFromText_c2025_0.issue<QTimeEdit_Adaptor, QDateTime, const QString &>(&QTimeEdit_Adaptor::cbs_dateTimeFromText_c2025_0, text);
    } else {
      return QTimeEdit::dateTimeFromText(text);
    }
  }

  //  [adaptor impl] void QTimeEdit::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QTimeEdit::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QTimeEdit_Adaptor, const QMetaMethod &>(&QTimeEdit_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QTimeEdit::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QTimeEdit::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QTimeEdit::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QTimeEdit_Adaptor, QDragEnterEvent *>(&QTimeEdit_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QTimeEdit::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QTimeEdit::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QTimeEdit_Adaptor, QDragLeaveEvent *>(&QTimeEdit_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QTimeEdit::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QTimeEdit::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QTimeEdit_Adaptor, QDragMoveEvent *>(&QTimeEdit_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QTimeEdit::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QTimeEdit::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QTimeEdit_Adaptor, QDropEvent *>(&QTimeEdit_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QTimeEdit::dropEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::enterEvent(QEnterEvent *event)
  void cbs_enterEvent_1727_0(QEnterEvent *event)
  {
    QTimeEdit::enterEvent(event);
  }

  virtual void enterEvent(QEnterEvent *event)
  {
    if (cb_enterEvent_1727_0.can_issue()) {
      cb_enterEvent_1727_0.issue<QTimeEdit_Adaptor, QEnterEvent *>(&QTimeEdit_Adaptor::cbs_enterEvent_1727_0, event);
    } else {
      QTimeEdit::enterEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::fixup(QString &input)
  void cbs_fixup_c1330_0(QString &input) const
  {
    QTimeEdit::fixup(input);
  }

  virtual void fixup(QString &input) const
  {
    if (cb_fixup_c1330_0.can_issue()) {
      cb_fixup_c1330_0.issue<QTimeEdit_Adaptor, QString &>(&QTimeEdit_Adaptor::cbs_fixup_c1330_0, input);
    } else {
      QTimeEdit::fixup(input);
    }
  }

  //  [adaptor impl] void QTimeEdit::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QTimeEdit::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QTimeEdit_Adaptor, QFocusEvent *>(&QTimeEdit_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QTimeEdit::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QTimeEdit::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QTimeEdit::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QTimeEdit_Adaptor, bool, bool>(&QTimeEdit_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QTimeEdit::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QTimeEdit::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QTimeEdit::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QTimeEdit_Adaptor, QFocusEvent *>(&QTimeEdit_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QTimeEdit::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QTimeEdit::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QTimeEdit_Adaptor, QHideEvent *>(&QTimeEdit_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QTimeEdit::hideEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QTimeEdit::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QTimeEdit_Adaptor, QPainter *>(&QTimeEdit_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QTimeEdit::initPainter(painter);
    }
  }

  //  [adaptor impl] void QTimeEdit::initStyleOption(QStyleOptionSpinBox *option)
  void cbs_initStyleOption_c2572_0(QStyleOptionSpinBox *option) const
  {
    QTimeEdit::initStyleOption(option);
  }

  virtual void initStyleOption(QStyleOptionSpinBox *option) const
  {
    if (cb_initStyleOption_c2572_0.can_issue()) {
      cb_initStyleOption_c2572_0.issue<QTimeEdit_Adaptor, QStyleOptionSpinBox *>(&QTimeEdit_Adaptor::cbs_initStyleOption_c2572_0, option);
    } else {
      QTimeEdit::initStyleOption(option);
    }
  }

  //  [adaptor impl] void QTimeEdit::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QTimeEdit::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QTimeEdit_Adaptor, QInputMethodEvent *>(&QTimeEdit_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QTimeEdit::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QTimeEdit::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QTimeEdit::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QTimeEdit_Adaptor, QKeyEvent *>(&QTimeEdit_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QTimeEdit::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QTimeEdit::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QTimeEdit_Adaptor, QKeyEvent *>(&QTimeEdit_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QTimeEdit::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::leaveEvent(QEvent *event)
  void cbs_leaveEvent_1217_0(QEvent *event)
  {
    QTimeEdit::leaveEvent(event);
  }

  virtual void leaveEvent(QEvent *event)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QTimeEdit_Adaptor, QEvent *>(&QTimeEdit_Adaptor::cbs_leaveEvent_1217_0, event);
    } else {
      QTimeEdit::leaveEvent(event);
    }
  }

  //  [adaptor impl] int QTimeEdit::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QTimeEdit::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QTimeEdit_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QTimeEdit_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QTimeEdit::metric(arg1);
    }
  }

  //  [adaptor impl] void QTimeEdit::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QTimeEdit::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QTimeEdit_Adaptor, QMouseEvent *>(&QTimeEdit_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QTimeEdit::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QTimeEdit::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QTimeEdit_Adaptor, QMouseEvent *>(&QTimeEdit_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QTimeEdit::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QTimeEdit::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QTimeEdit_Adaptor, QMouseEvent *>(&QTimeEdit_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QTimeEdit::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QTimeEdit::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QTimeEdit_Adaptor, QMouseEvent *>(&QTimeEdit_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QTimeEdit::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QTimeEdit::moveEvent(QMoveEvent *event)
  void cbs_moveEvent_1624_0(QMoveEvent *event)
  {
    QTimeEdit::moveEvent(event);
  }

  virtual void moveEvent(QMoveEvent *event)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QTimeEdit_Adaptor, QMoveEvent *>(&QTimeEdit_Adaptor::cbs_moveEvent_1624_0, event);
    } else {
      QTimeEdit::moveEvent(event);
    }
  }

  //  [adaptor impl] bool QTimeEdit::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  bool cbs_nativeEvent_6949_0(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    return QTimeEdit::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    if (cb_nativeEvent_6949_0.can_issue()) {
      return cb_nativeEvent_6949_0.issue<QTimeEdit_Adaptor, bool, const QByteArray &, void *, QIntegerForSizeof<void *>::Signed *>(&QTimeEdit_Adaptor::cbs_nativeEvent_6949_0, eventType, message, result);
    } else {
      return QTimeEdit::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QTimeEdit::paintEvent(QPaintEvent *event)
  void cbs_paintEvent_1725_0(QPaintEvent *event)
  {
    QTimeEdit::paintEvent(event);
  }

  virtual void paintEvent(QPaintEvent *event)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QTimeEdit_Adaptor, QPaintEvent *>(&QTimeEdit_Adaptor::cbs_paintEvent_1725_0, event);
    } else {
      QTimeEdit::paintEvent(event);
    }
  }

  //  [adaptor impl] QPaintDevice *QTimeEdit::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QTimeEdit::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QTimeEdit_Adaptor, QPaintDevice *, QPoint *>(&QTimeEdit_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QTimeEdit::redirected(offset);
    }
  }

  //  [adaptor impl] void QTimeEdit::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QTimeEdit::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QTimeEdit_Adaptor, QResizeEvent *>(&QTimeEdit_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QTimeEdit::resizeEvent(event);
    }
  }

  //  [adaptor impl] QPainter *QTimeEdit::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QTimeEdit::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QTimeEdit_Adaptor, QPainter *>(&QTimeEdit_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QTimeEdit::sharedPainter();
    }
  }

  //  [adaptor impl] void QTimeEdit::showEvent(QShowEvent *event)
  void cbs_showEvent_1634_0(QShowEvent *event)
  {
    QTimeEdit::showEvent(event);
  }

  virtual void showEvent(QShowEvent *event)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QTimeEdit_Adaptor, QShowEvent *>(&QTimeEdit_Adaptor::cbs_showEvent_1634_0, event);
    } else {
      QTimeEdit::showEvent(event);
    }
  }

  //  [adaptor impl] QFlags<QAbstractSpinBox::StepEnabledFlag> QTimeEdit::stepEnabled()
  QFlags<QAbstractSpinBox::StepEnabledFlag> cbs_stepEnabled_c0_0() const
  {
    return QTimeEdit::stepEnabled();
  }

  virtual QFlags<QAbstractSpinBox::StepEnabledFlag> stepEnabled() const
  {
    if (cb_stepEnabled_c0_0.can_issue()) {
      return cb_stepEnabled_c0_0.issue<QTimeEdit_Adaptor, QFlags<QAbstractSpinBox::StepEnabledFlag> >(&QTimeEdit_Adaptor::cbs_stepEnabled_c0_0);
    } else {
      return QTimeEdit::stepEnabled();
    }
  }

  //  [adaptor impl] void QTimeEdit::tabletEvent(QTabletEvent *event)
  void cbs_tabletEvent_1821_0(QTabletEvent *event)
  {
    QTimeEdit::tabletEvent(event);
  }

  virtual void tabletEvent(QTabletEvent *event)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QTimeEdit_Adaptor, QTabletEvent *>(&QTimeEdit_Adaptor::cbs_tabletEvent_1821_0, event);
    } else {
      QTimeEdit::tabletEvent(event);
    }
  }

  //  [adaptor impl] QString QTimeEdit::textFromDateTime(const QDateTime &dt)
  QString cbs_textFromDateTime_c2175_0(const QDateTime &dt) const
  {
    return QTimeEdit::textFromDateTime(dt);
  }

  virtual QString textFromDateTime(const QDateTime &dt) const
  {
    if (cb_textFromDateTime_c2175_0.can_issue()) {
      return cb_textFromDateTime_c2175_0.issue<QTimeEdit_Adaptor, QString, const QDateTime &>(&QTimeEdit_Adaptor::cbs_textFromDateTime_c2175_0, dt);
    } else {
      return QTimeEdit::textFromDateTime(dt);
    }
  }

  //  [adaptor impl] void QTimeEdit::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QTimeEdit::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTimeEdit_Adaptor, QTimerEvent *>(&QTimeEdit_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QTimeEdit::timerEvent(event);
    }
  }

  //  [adaptor impl] QValidator::State QTimeEdit::validate(QString &input, int &pos)
  qt_gsi::Converter<QValidator::State>::target_type cbs_validate_c2171_0(QString &input, int &pos) const
  {
    return qt_gsi::CppToQtAdaptor<QValidator::State>(QTimeEdit::validate(input, pos));
  }

  virtual QValidator::State validate(QString &input, int &pos) const
  {
    if (cb_validate_c2171_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QValidator::State>(cb_validate_c2171_0.issue<QTimeEdit_Adaptor, qt_gsi::Converter<QValidator::State>::target_type, QString &, int &>(&QTimeEdit_Adaptor::cbs_validate_c2171_0, input, pos)).cref();
    } else {
      return QTimeEdit::validate(input, pos);
    }
  }

  //  [adaptor impl] void QTimeEdit::wheelEvent(QWheelEvent *event)
  void cbs_wheelEvent_1718_0(QWheelEvent *event)
  {
    QTimeEdit::wheelEvent(event);
  }

  virtual void wheelEvent(QWheelEvent *event)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QTimeEdit_Adaptor, QWheelEvent *>(&QTimeEdit_Adaptor::cbs_wheelEvent_1718_0, event);
    } else {
      QTimeEdit::wheelEvent(event);
    }
  }

  gsi::Callback cb_clear_0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_stepBy_767_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_dateTimeFromText_c2025_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1727_0;
  gsi::Callback cb_fixup_c1330_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_initStyleOption_c2572_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_6949_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_stepEnabled_c0_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_textFromDateTime_c2175_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_validate_c2171_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QTimeEdit_Adaptor::~QTimeEdit_Adaptor() { }

//  Constructor QTimeEdit::QTimeEdit(QWidget *parent) (adaptor class)

static void _init_ctor_QTimeEdit_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QTimeEdit_Adaptor> ();
}

static void _call_ctor_QTimeEdit_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QTimeEdit_Adaptor *> (new QTimeEdit_Adaptor (arg1));
}


//  Constructor QTimeEdit::QTimeEdit(QTime time, QWidget *parent) (adaptor class)

static void _init_ctor_QTimeEdit_Adaptor_2123 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("time");
  decl->add_arg<QTime > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return_new<QTimeEdit_Adaptor> ();
}

static void _call_ctor_QTimeEdit_Adaptor_2123 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTime arg1 = gsi::arg_reader<QTime >() (args, heap);
  QWidget *arg2 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QTimeEdit_Adaptor *> (new QTimeEdit_Adaptor (arg1, arg2));
}


// void QTimeEdit::actionEvent(QActionEvent *event)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// void QTimeEdit::changeEvent(QEvent *event)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QTimeEdit::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QTimeEdit::clear()

static void _init_cbs_clear_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_clear_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_clear_0_0 ();
}

static void _set_callback_cbs_clear_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_clear_0_0 = cb;
}


// void QTimeEdit::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QTimeEdit::contextMenuEvent(QContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QTimeEdit::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->fp_QTimeEdit_create_2208 (arg1, arg2, arg3);
}


// emitter void QTimeEdit::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QTimeEdit_Adaptor *)cls)->emitter_QTimeEdit_customContextMenuRequested_1916 (arg1);
}


// void QTimeEdit::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QTimeEdit::dateChanged(QDate date)

static void _init_emitter_dateChanged_899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<QDate > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_dateChanged_899 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  ((QTimeEdit_Adaptor *)cls)->emitter_QTimeEdit_dateChanged_899 (arg1);
}


// emitter void QTimeEdit::dateTimeChanged(const QDateTime &dateTime)

static void _init_emitter_dateTimeChanged_2175 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dateTime");
  decl->add_arg<const QDateTime & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_dateTimeChanged_2175 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDateTime &arg1 = gsi::arg_reader<const QDateTime & >() (args, heap);
  ((QTimeEdit_Adaptor *)cls)->emitter_QTimeEdit_dateTimeChanged_2175 (arg1);
}


// QDateTime QTimeEdit::dateTimeFromText(const QString &text)

static void _init_cbs_dateTimeFromText_c2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QDateTime > ();
}

static void _call_cbs_dateTimeFromText_c2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QDateTime > ((QDateTime)((QTimeEdit_Adaptor *)cls)->cbs_dateTimeFromText_c2025_0 (arg1));
}

static void _set_callback_cbs_dateTimeFromText_c2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_dateTimeFromText_c2025_0 = cb;
}


// exposed void QTimeEdit::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->fp_QTimeEdit_destroy_1620 (arg1, arg2);
}


// emitter void QTimeEdit::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QTimeEdit_Adaptor *)cls)->emitter_QTimeEdit_destroyed_1302 (arg1);
}


// void QTimeEdit::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QTimeEdit::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QTimeEdit::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QTimeEdit::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QTimeEdit::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// emitter void QTimeEdit::editingFinished()

static void _init_emitter_editingFinished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_editingFinished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTimeEdit_Adaptor *)cls)->emitter_QTimeEdit_editingFinished_0 ();
}


// void QTimeEdit::enterEvent(QEnterEvent *event)

static void _init_cbs_enterEvent_1727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEnterEvent *arg1 = args.read<QEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_enterEvent_1727_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1727_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_enterEvent_1727_0 = cb;
}


// bool QTimeEdit::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTimeEdit_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QTimeEdit::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTimeEdit_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QTimeEdit::fixup(QString &input)

static void _init_cbs_fixup_c1330_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("input");
  decl->add_arg<QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fixup_c1330_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString &arg1 = args.read<QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_fixup_c1330_0 (arg1);
}

static void _set_callback_cbs_fixup_c1330_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_fixup_c1330_0 = cb;
}


// void QTimeEdit::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QTimeEdit::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTimeEdit_Adaptor *)cls)->fp_QTimeEdit_focusNextChild_0 ());
}


// bool QTimeEdit::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QTimeEdit_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QTimeEdit::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QTimeEdit::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTimeEdit_Adaptor *)cls)->fp_QTimeEdit_focusPreviousChild_0 ());
}


// bool QTimeEdit::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTimeEdit_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QTimeEdit::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QTimeEdit_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QTimeEdit::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QTimeEdit::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// void QTimeEdit::initStyleOption(QStyleOptionSpinBox *option)

static void _init_cbs_initStyleOption_c2572_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionSpinBox * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initStyleOption_c2572_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOptionSpinBox *arg1 = args.read<QStyleOptionSpinBox * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_initStyleOption_c2572_0 (arg1);
}

static void _set_callback_cbs_initStyleOption_c2572_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_initStyleOption_c2572_0 = cb;
}


// void QTimeEdit::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QTimeEdit::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QTimeEdit_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// exposed bool QTimeEdit::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QTimeEdit_Adaptor *)cls)->fp_QTimeEdit_isSignalConnected_c2394 (arg1));
}


// void QTimeEdit::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QTimeEdit::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QTimeEdit::leaveEvent(QEvent *event)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// exposed QLineEdit *QTimeEdit::lineEdit()

static void _init_fp_lineEdit_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLineEdit * > ();
}

static void _call_fp_lineEdit_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLineEdit * > ((QLineEdit *)((QTimeEdit_Adaptor *)cls)->fp_QTimeEdit_lineEdit_c0 ());
}


// int QTimeEdit::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QTimeEdit_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QTimeEdit::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTimeEdit_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QTimeEdit::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QTimeEdit::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QTimeEdit::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QTimeEdit::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QTimeEdit::moveEvent(QMoveEvent *event)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QTimeEdit::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)

static void _init_cbs_nativeEvent_6949_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<QIntegerForSizeof<void *>::Signed * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_6949_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  QIntegerForSizeof<void *>::Signed *arg3 = args.read<QIntegerForSizeof<void *>::Signed * > (heap);
  ret.write<bool > ((bool)((QTimeEdit_Adaptor *)cls)->cbs_nativeEvent_6949_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_6949_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_nativeEvent_6949_0 = cb;
}


// emitter void QTimeEdit::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QTimeEdit_Adaptor *)cls)->emitter_QTimeEdit_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QTimeEdit::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QTimeEdit_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QTimeEdit::paintEvent(QPaintEvent *event)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QTimeEdit::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QTimeEdit_Adaptor *)cls)->fp_QTimeEdit_receivers_c1731 (arg1));
}


// QPaintDevice *QTimeEdit::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QTimeEdit_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QTimeEdit::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QTimeEdit::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QTimeEdit_Adaptor *)cls)->fp_QTimeEdit_sender_c0 ());
}


// exposed int QTimeEdit::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTimeEdit_Adaptor *)cls)->fp_QTimeEdit_senderSignalIndex_c0 ());
}


// exposed void QTimeEdit::setLineEdit(QLineEdit *edit)

static void _init_fp_setLineEdit_1485 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("edit");
  decl->add_arg<QLineEdit * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setLineEdit_1485 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLineEdit *arg1 = gsi::arg_reader<QLineEdit * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->fp_QTimeEdit_setLineEdit_1485 (arg1);
}


// void QTimeEdit::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// QPainter *QTimeEdit::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QTimeEdit_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QTimeEdit::showEvent(QShowEvent *event)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QTimeEdit::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTimeEdit_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QTimeEdit::stepBy(int steps)

static void _init_cbs_stepBy_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_stepBy_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_stepBy_767_0 (arg1);
}

static void _set_callback_cbs_stepBy_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_stepBy_767_0 = cb;
}


// QFlags<QAbstractSpinBox::StepEnabledFlag> QTimeEdit::stepEnabled()

static void _init_cbs_stepEnabled_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QAbstractSpinBox::StepEnabledFlag> > ();
}

static void _call_cbs_stepEnabled_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QAbstractSpinBox::StepEnabledFlag> > ((QFlags<QAbstractSpinBox::StepEnabledFlag>)((QTimeEdit_Adaptor *)cls)->cbs_stepEnabled_c0_0 ());
}

static void _set_callback_cbs_stepEnabled_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_stepEnabled_c0_0 = cb;
}


// void QTimeEdit::tabletEvent(QTabletEvent *event)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// QString QTimeEdit::textFromDateTime(const QDateTime &dt)

static void _init_cbs_textFromDateTime_c2175_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dt");
  decl->add_arg<const QDateTime & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_cbs_textFromDateTime_c2175_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDateTime &arg1 = args.read<const QDateTime & > (heap);
  ret.write<QString > ((QString)((QTimeEdit_Adaptor *)cls)->cbs_textFromDateTime_c2175_0 (arg1));
}

static void _set_callback_cbs_textFromDateTime_c2175_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_textFromDateTime_c2175_0 = cb;
}


// emitter void QTimeEdit::timeChanged(QTime time)

static void _init_emitter_timeChanged_916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("time");
  decl->add_arg<QTime > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_timeChanged_916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTime arg1 = gsi::arg_reader<QTime >() (args, heap);
  ((QTimeEdit_Adaptor *)cls)->emitter_QTimeEdit_timeChanged_916 (arg1);
}


// void QTimeEdit::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QTimeEdit::updateMicroFocus(Qt::InputMethodQuery query)

static void _init_fp_updateMicroFocus_2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query", true, "Qt::ImQueryAll");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::InputMethodQuery>(heap, Qt::ImQueryAll), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->fp_QTimeEdit_updateMicroFocus_2420 (arg1);
}


// emitter void QTimeEdit::userTimeChanged(QTime time)

static void _init_emitter_userTimeChanged_916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("time");
  decl->add_arg<QTime > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_userTimeChanged_916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTime arg1 = gsi::arg_reader<QTime >() (args, heap);
  ((QTimeEdit_Adaptor *)cls)->emitter_QTimeEdit_userTimeChanged_916 (arg1);
}


// QValidator::State QTimeEdit::validate(QString &input, int &pos)

static void _init_cbs_validate_c2171_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("input");
  decl->add_arg<QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pos");
  decl->add_arg<int & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QValidator::State>::target_type > ();
}

static void _call_cbs_validate_c2171_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString &arg1 = args.read<QString & > (heap);
  int &arg2 = args.read<int & > (heap);
  ret.write<qt_gsi::Converter<QValidator::State>::target_type > ((qt_gsi::Converter<QValidator::State>::target_type)((QTimeEdit_Adaptor *)cls)->cbs_validate_c2171_0 (arg1, arg2));
}

static void _set_callback_cbs_validate_c2171_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_validate_c2171_0 = cb;
}


// void QTimeEdit::wheelEvent(QWheelEvent *event)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTimeEdit_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeEdit_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QTimeEdit::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QTimeEdit_Adaptor *)cls)->emitter_QTimeEdit_windowIconChanged_1787 (arg1);
}


// emitter void QTimeEdit::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QTimeEdit_Adaptor *)cls)->emitter_QTimeEdit_windowIconTextChanged_2025 (arg1);
}


// emitter void QTimeEdit::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QTimeEdit_Adaptor *)cls)->emitter_QTimeEdit_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QTimeEdit> &qtdecl_QTimeEdit ();

static gsi::Methods methods_QTimeEdit_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTimeEdit::QTimeEdit(QWidget *parent)\nThis method creates an object of class QTimeEdit.", &_init_ctor_QTimeEdit_Adaptor_1315, &_call_ctor_QTimeEdit_Adaptor_1315);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTimeEdit::QTimeEdit(QTime time, QWidget *parent)\nThis method creates an object of class QTimeEdit.", &_init_ctor_QTimeEdit_Adaptor_2123, &_call_ctor_QTimeEdit_Adaptor_2123);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QTimeEdit::actionEvent(QActionEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QTimeEdit::changeEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTimeEdit::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Virtual method void QTimeEdit::clear()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("clear", "@hide", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0, &_set_callback_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QTimeEdit::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QTimeEdit::contextMenuEvent(QContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*create|qt_create", "@brief Method void QTimeEdit::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QTimeEdit::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTimeEdit::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_dateChanged", "@brief Emitter for signal void QTimeEdit::dateChanged(QDate date)\nCall this method to emit this signal.", false, &_init_emitter_dateChanged_899, &_call_emitter_dateChanged_899);
  methods += new qt_gsi::GenericMethod ("emit_dateTimeChanged", "@brief Emitter for signal void QTimeEdit::dateTimeChanged(const QDateTime &dateTime)\nCall this method to emit this signal.", false, &_init_emitter_dateTimeChanged_2175, &_call_emitter_dateTimeChanged_2175);
  methods += new qt_gsi::GenericMethod ("*dateTimeFromText", "@brief Virtual method QDateTime QTimeEdit::dateTimeFromText(const QString &text)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_dateTimeFromText_c2025_0, &_call_cbs_dateTimeFromText_c2025_0);
  methods += new qt_gsi::GenericMethod ("*dateTimeFromText", "@hide", true, &_init_cbs_dateTimeFromText_c2025_0, &_call_cbs_dateTimeFromText_c2025_0, &_set_callback_cbs_dateTimeFromText_c2025_0);
  methods += new qt_gsi::GenericMethod ("*destroy|qt_destroy", "@brief Method void QTimeEdit::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QTimeEdit::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTimeEdit::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QTimeEdit::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QTimeEdit::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QTimeEdit::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QTimeEdit::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("emit_editingFinished", "@brief Emitter for signal void QTimeEdit::editingFinished()\nCall this method to emit this signal.", false, &_init_emitter_editingFinished_0, &_call_emitter_editingFinished_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QTimeEdit::enterEvent(QEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0, &_set_callback_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QTimeEdit::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QTimeEdit::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*fixup", "@brief Virtual method void QTimeEdit::fixup(QString &input)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_fixup_c1330_0, &_call_cbs_fixup_c1330_0);
  methods += new qt_gsi::GenericMethod ("*fixup", "@hide", true, &_init_cbs_fixup_c1330_0, &_call_cbs_fixup_c1330_0, &_set_callback_cbs_fixup_c1330_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QTimeEdit::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QTimeEdit::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QTimeEdit::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QTimeEdit::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QTimeEdit::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QTimeEdit::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QTimeEdit::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QTimeEdit::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QTimeEdit::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Virtual method void QTimeEdit::initStyleOption(QStyleOptionSpinBox *option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initStyleOption_c2572_0, &_call_cbs_initStyleOption_c2572_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@hide", true, &_init_cbs_initStyleOption_c2572_0, &_call_cbs_initStyleOption_c2572_0, &_set_callback_cbs_initStyleOption_c2572_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QTimeEdit::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QTimeEdit::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QTimeEdit::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QTimeEdit::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QTimeEdit::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QTimeEdit::leaveEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*lineEdit", "@brief Method QLineEdit *QTimeEdit::lineEdit()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_lineEdit_c0, &_call_fp_lineEdit_c0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QTimeEdit::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QTimeEdit::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QTimeEdit::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QTimeEdit::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QTimeEdit::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QTimeEdit::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QTimeEdit::moveEvent(QMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QTimeEdit::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0, &_set_callback_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QTimeEdit::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QTimeEdit::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QTimeEdit::paintEvent(QPaintEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QTimeEdit::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QTimeEdit::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QTimeEdit::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QTimeEdit::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QTimeEdit::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setLineEdit", "@brief Method void QTimeEdit::setLineEdit(QLineEdit *edit)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setLineEdit_1485, &_call_fp_setLineEdit_1485);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QTimeEdit::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QTimeEdit::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QTimeEdit::showEvent(QShowEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QTimeEdit::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("stepBy", "@brief Virtual method void QTimeEdit::stepBy(int steps)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_stepBy_767_0, &_call_cbs_stepBy_767_0);
  methods += new qt_gsi::GenericMethod ("stepBy", "@hide", false, &_init_cbs_stepBy_767_0, &_call_cbs_stepBy_767_0, &_set_callback_cbs_stepBy_767_0);
  methods += new qt_gsi::GenericMethod ("*stepEnabled", "@brief Virtual method QFlags<QAbstractSpinBox::StepEnabledFlag> QTimeEdit::stepEnabled()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_stepEnabled_c0_0, &_call_cbs_stepEnabled_c0_0);
  methods += new qt_gsi::GenericMethod ("*stepEnabled", "@hide", true, &_init_cbs_stepEnabled_c0_0, &_call_cbs_stepEnabled_c0_0, &_set_callback_cbs_stepEnabled_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QTimeEdit::tabletEvent(QTabletEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*textFromDateTime", "@brief Virtual method QString QTimeEdit::textFromDateTime(const QDateTime &dt)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_textFromDateTime_c2175_0, &_call_cbs_textFromDateTime_c2175_0);
  methods += new qt_gsi::GenericMethod ("*textFromDateTime", "@hide", true, &_init_cbs_textFromDateTime_c2175_0, &_call_cbs_textFromDateTime_c2175_0, &_set_callback_cbs_textFromDateTime_c2175_0);
  methods += new qt_gsi::GenericMethod ("emit_timeChanged", "@brief Emitter for signal void QTimeEdit::timeChanged(QTime time)\nCall this method to emit this signal.", false, &_init_emitter_timeChanged_916, &_call_emitter_timeChanged_916);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTimeEdit::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QTimeEdit::updateMicroFocus(Qt::InputMethodQuery query)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_2420, &_call_fp_updateMicroFocus_2420);
  methods += new qt_gsi::GenericMethod ("emit_userTimeChanged", "@brief Emitter for signal void QTimeEdit::userTimeChanged(QTime time)\nCall this method to emit this signal.", false, &_init_emitter_userTimeChanged_916, &_call_emitter_userTimeChanged_916);
  methods += new qt_gsi::GenericMethod ("*validate", "@brief Virtual method QValidator::State QTimeEdit::validate(QString &input, int &pos)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_validate_c2171_0, &_call_cbs_validate_c2171_0);
  methods += new qt_gsi::GenericMethod ("*validate", "@hide", true, &_init_cbs_validate_c2171_0, &_call_cbs_validate_c2171_0, &_set_callback_cbs_validate_c2171_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QTimeEdit::wheelEvent(QWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QTimeEdit::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QTimeEdit::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QTimeEdit::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QTimeEdit_Adaptor> decl_QTimeEdit_Adaptor (qtdecl_QTimeEdit (), "QtWidgets", "QTimeEdit",
  methods_QTimeEdit_Adaptor (),
  "@qt\n@brief Binding of QTimeEdit");

}

