/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Iterator;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeExhausted;
import org.assertj.core.error.ShouldHaveNext;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.VisibleForTesting;

public class Iterators {
    private static final Iterators INSTANCE = new Iterators();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Iterators instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Iterators() {
    }

    public void assertHasNext(AssertionInfo info, Iterator<?> actual) {
        Comparables.assertNotNull(info, actual);
        if (!actual.hasNext()) {
            throw this.failures.failure(info, ShouldHaveNext.shouldHaveNext());
        }
    }

    public void assertIsExhausted(AssertionInfo info, Iterator<?> actual) {
        Comparables.assertNotNull(info, actual);
        if (actual.hasNext()) {
            throw this.failures.failure(info, ShouldBeExhausted.shouldBeExhausted());
        }
    }
}

