/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.coverage.gnu.trove.TObjectIntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameEnumerator {
    private final TObjectIntHashMap<String> myNames = new TObjectIntHashMap();
    private int myNextNameId = 1;
    private final Object myNameLock = "NameLock";

    /*
     * WARNING - void declaration
     */
    int enumerate(String name) {
        Object object = this.myNameLock;
        synchronized (object) {
            void var3_4;
            void var1_1;
            int enumerated = this.myNames.get(name);
            if (enumerated != 0) {
                return enumerated;
            }
            int newId = this.myNextNameId++;
            this.updateDataIncrement(name, newId);
            this.myNames.put((String)var1_1, newId);
            return (int)var3_4;
        }
    }

    TObjectIntHashMap<String> getNamesMap() {
        return this.myNames;
    }

    protected void updateDataIncrement(String name, int id) {
    }

    /*
     * WARNING - void declaration
     */
    static int[] enumerate(String[] names, NameEnumerator enumerator) {
        void var2_2;
        int[] ids = new int[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            ids[i] = enumerator.enumerate(name);
        }
        return var2_2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Incremental
    extends NameEnumerator {
        private List<NameAndId> myDataIncrement = new ArrayList<NameAndId>();
        private final Object myDataIncrementLock = "DataIncrementLock";

        Incremental() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void updateDataIncrement(String name, int id) {
            Object object = this.myDataIncrementLock;
            synchronized (object) {
                void var2_3;
                void var1_1;
                this.myDataIncrement.add(new NameAndId((String)var1_1, (int)var2_3));
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        List<NameAndId> getAndClearDataIncrement() {
            Object object = this.myDataIncrementLock;
            synchronized (object) {
                void var2_2;
                List<NameAndId> dataIncrement = this.myDataIncrement;
                this.myDataIncrement = new ArrayList<NameAndId>();
                return var2_2;
            }
        }

        static final class NameAndId {
            private final String myName;
            private final int myId;

            /*
             * WARNING - void declaration
             */
            NameAndId(String myName, int myId) {
                void var2_2;
                void var1_1;
                this.myName = var1_1;
                this.myId = var2_2;
            }

            final String getName() {
                return this.myName;
            }

            final int getId() {
                return this.myId;
            }
        }
    }
}

