/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx.io;

import java.io.Reader;
import java.util.HashMap;
import net.loomchild.segment.srx.LanguageRule;
import net.loomchild.segment.srx.SrxDocument;
import net.loomchild.segment.srx.SrxParser;
import net.loomchild.segment.srx.io.bind.Body;
import net.loomchild.segment.srx.io.bind.Languagemap;
import net.loomchild.segment.srx.io.bind.Languagerule;
import net.loomchild.segment.srx.io.bind.Rule;
import net.loomchild.segment.srx.io.bind.Srx;
import net.loomchild.segment.util.Bind;
import net.loomchild.segment.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Srx2Parser
implements SrxParser {
    private static final Log log = LogFactory.getLog(Srx2Parser.class);
    private static final String CONTEXT = "net.loomchild.segment.srx.io.bind";
    private static final String SCHEMA = "net/loomchild/segment/res/xml/srx20.xsd";
    private static Bind bind = Srx2Parser.createBind();

    private static Bind createBind() {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(Srx2Parser.class.getClassLoader());
        }
        Bind bind = new Bind(Util.getContext(CONTEXT, Srx2Parser.class.getClassLoader()), Util.getSchema(Util.getReader(Util.getResourceStream(SCHEMA))));
        return bind;
    }

    @Override
    public SrxDocument parse(Reader reader) {
        LanguageRule languageRule;
        Srx srx = (Srx)bind.unmarshal(reader);
        SrxDocument document = new SrxDocument();
        document.setCascade("yes".equals(srx.getHeader().getCascade()));
        Body body = srx.getBody();
        HashMap<String, LanguageRule> languageRuleMap = new HashMap<String, LanguageRule>();
        for (Languagerule lr : body.getLanguagerules().getLanguagerule()) {
            languageRule = new LanguageRule(lr.getLanguagerulename());
            for (Rule r : lr.getRule()) {
                boolean breakRule = !"no".equals(r.getBreak());
                String before = r.getBeforebreak() != null ? r.getBeforebreak().getContent() : "";
                String after = r.getAfterbreak() != null ? r.getAfterbreak().getContent() : "";
                net.loomchild.segment.srx.Rule rule = new net.loomchild.segment.srx.Rule(breakRule, before, after);
                languageRule.addRule(rule);
            }
            languageRuleMap.put(languageRule.getName(), languageRule);
        }
        for (Languagemap lm : body.getMaprules().getLanguagemap()) {
            languageRule = (LanguageRule)languageRuleMap.get(lm.getLanguagerulename());
            if (languageRule == null) {
                log.warn((Object)("Language map \"" + lm.getLanguagepattern() + "\": language rule \"" + lm.getLanguagerulename() + "\" not found."));
                continue;
            }
            document.addLanguageMap(lm.getLanguagepattern(), languageRule);
        }
        return document;
    }
}

