/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructPermittedSubclassesAttribute
extends StructGeneralAttribute {
    List<String> classes;

    @Override
    public void initContent(DataInputFullStream data, ConstantPool pool) throws IOException {
        int numberOfClasses = data.readUnsignedShort();
        String[] classes = new String[numberOfClasses];
        for (int i = 0; i < numberOfClasses; ++i) {
            classes[i] = pool.getPrimitiveConstant(data.readUnsignedShort()).getString();
        }
        this.classes = Arrays.asList(classes);
    }

    public List<String> getClasses() {
        return this.classes;
    }
}

