/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.definition.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ext.definition.DefinitionItem;
import com.vladsch.flexmark.ext.definition.DefinitionList;
import com.vladsch.flexmark.ext.definition.DefinitionTerm;
import com.vladsch.flexmark.ext.definition.internal.DefinitionFormatOptions;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.RepeatedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefinitionNodeFormatter
implements NodeFormatter {
    private final DefinitionFormatOptions options;
    private final ListOptions listOptions;

    public DefinitionNodeFormatter(DataHolder options) {
        this.options = new DefinitionFormatOptions(options);
        this.listOptions = ListOptions.get(options);
    }

    @Override
    @Nullable
    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    @Override
    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler<DefinitionList>(DefinitionList.class, this::render), new NodeFormattingHandler<DefinitionTerm>(DefinitionTerm.class, this::render), new NodeFormattingHandler<DefinitionItem>(DefinitionItem.class, this::render)));
    }

    private void render(DefinitionList node, NodeFormatterContext context, MarkdownWriter markdown) {
        context.renderChildren(node);
    }

    private void render(DefinitionTerm node, NodeFormatterContext context, MarkdownWriter markdown) {
        context.renderChildren(node);
    }

    private void render(DefinitionItem node, NodeFormatterContext context, MarkdownWriter markdown) {
        Node child;
        BasedSequence openMarkerChars = node.getChars().prefixOf(node.getFirstChild().getChars());
        BasedSequence openMarker = openMarkerChars.subSequence(0, 1);
        BasedSequence openMarkerSpaces = (BasedSequence)openMarkerChars.subSequence(1);
        if (this.options.markerSpaces >= 1 && openMarkerSpaces.length() != this.options.markerSpaces) {
            CharSequence charSequence = RepeatedSequence.repeatOf(' ', this.options.markerSpaces);
            openMarkerSpaces = BasedSequence.of(charSequence);
        }
        switch (this.options.markerType) {
            case ANY: {
                break;
            }
            case COLON: {
                openMarker = BasedSequence.of(":").subSequence(0, ":".length());
                break;
            }
            case TILDE: {
                openMarker = BasedSequence.of("~").subSequence(0, "~".length());
            }
        }
        ((MarkdownWriter)((MarkdownWriter)markdown.line()).append(openMarker)).append(openMarkerSpaces);
        int count = context.getFormatterOptions().itemContentIndent ? openMarker.length() + openMarkerSpaces.length() : this.listOptions.getItemIndent();
        CharSequence prefix = RepeatedSequence.ofSpaces(count);
        ((MarkdownWriter)markdown.pushPrefix()).addPrefix(prefix);
        context.renderChildren(node);
        markdown.popPrefix();
        if (!Parser.BLANK_LINES_IN_AST.get(context.getOptions()).booleanValue() && (child = node.getLastChild()) instanceof Paragraph && ((Paragraph)child).isTrailingBlankLine()) {
            markdown.blankLine();
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        @Override
        @NotNull
        public NodeFormatter create(@NotNull DataHolder options) {
            return new DefinitionNodeFormatter(options);
        }
    }
}

