/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.smartcasts.MultipleSmartCasts;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\u0011\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0002J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SingleSmartCast;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/ExplicitSmartCasts;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "<init>", "(Lorg/jetbrains/kotlin/psi/Call;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getCall", "()Lorg/jetbrains/kotlin/psi/Call;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "defaultType", "getDefaultType", "plus", "smartCast", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "frontend"})
public final class SingleSmartCast
implements ExplicitSmartCasts {
    @Nullable
    private final Call call;
    @NotNull
    private final KotlinType type;

    public SingleSmartCast(@Nullable Call call2, @NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        this.call = call2;
        this.type = type2;
    }

    @Nullable
    public final Call getCall() {
        return this.call;
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public KotlinType type(@Nullable Call call2) {
        return Intrinsics.areEqual(call2, this.call) ? this.type : null;
    }

    @Override
    @NotNull
    public KotlinType getDefaultType() {
        return this.type;
    }

    @Override
    @NotNull
    public ExplicitSmartCasts plus(@NotNull SingleSmartCast smartCast) {
        ExplicitSmartCasts explicitSmartCasts;
        Intrinsics.checkNotNullParameter(smartCast, "smartCast");
        if (Intrinsics.areEqual(this, smartCast)) {
            explicitSmartCasts = this;
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to(this.call, this.type), TuplesKt.to(smartCast.call, smartCast.type)};
            explicitSmartCasts = new MultipleSmartCasts(MapsKt.mapOf(pairArray));
        }
        return explicitSmartCasts;
    }

    @Nullable
    public final Call component1() {
        return this.call;
    }

    @NotNull
    public final KotlinType component2() {
        return this.type;
    }

    @NotNull
    public final SingleSmartCast copy(@Nullable Call call2, @NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return new SingleSmartCast(call2, type2);
    }

    public static /* synthetic */ SingleSmartCast copy$default(SingleSmartCast singleSmartCast, Call call2, KotlinType kotlinType, int n, Object object) {
        if ((n & 1) != 0) {
            call2 = singleSmartCast.call;
        }
        if ((n & 2) != 0) {
            kotlinType = singleSmartCast.type;
        }
        return singleSmartCast.copy(call2, kotlinType);
    }

    @NotNull
    public String toString() {
        return "SingleSmartCast(call=" + this.call + ", type=" + this.type + ')';
    }

    public int hashCode() {
        int result2 = this.call == null ? 0 : this.call.hashCode();
        result2 = result2 * 31 + this.type.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SingleSmartCast)) {
            return false;
        }
        SingleSmartCast singleSmartCast = (SingleSmartCast)other;
        if (!Intrinsics.areEqual(this.call, singleSmartCast.call)) {
            return false;
        }
        return Intrinsics.areEqual(this.type, singleSmartCast.type);
    }
}

